(**
Module for handling dynamic libraries.
*)
MODULE OSDll;

IMPORT Windows IN API, SYSTEM;

TYPE
  HANDLE* = Windows.HMODULE;

CONST
  InvalidHandle* = Windows.INVALID_HANDLE_VALUE;
  Ext* = "dll";

PROCEDURE LoadModule*(name-: ARRAY OF CHAR): HANDLE;
BEGIN RETURN Windows.LoadLibraryA(SYSTEM.ADR(name[0]))
END LoadModule;

PROCEDURE GetProcAdr*(handle: HANDLE; name-: ARRAY OF CHAR): PROCEDURE;
BEGIN
    RETURN Windows.GetProcAddress(handle, SYSTEM.ADR(name[0]))
END GetProcAdr;

PROCEDURE FreeModule*(handle: HANDLE);
BEGIN IGNORE(Windows.FreeLibrary(handle))
END FreeModule;

END OSDll.