MODULE DBSQLite3Dll;

IMPORT SYSTEM,  OSDll;

(* Error codes *)
CONST
    OK* 		=  0;  (* Successful result *)
    ERROR* 		=  1;  (* Generic error *)

TYPE
    DB* = POINTER TO RECORD END;
    STMT* = POINTER TO RECORD END;
    INT = INTEGER;
    INT64 = SIGNED64;
    ADDRESS = SYSTEM.ADDRESS;
    PCHAR = POINTER TO ARRAY OF CHAR;
    VOID = POINTER TO RECORD END;

    sqlite3_libversion_number   = PROCEDURE () : INT;

VAR
    libversion_number*          : sqlite3_libversion_number;

PROCEDURE Initialize();
VAR
    dll : OSDll.HANDLE;
BEGIN
    IF OSDll.Ext = "dll" THEN
        dll := OSDll.LoadModule("sqlite3.dll");
    ELSE
        dll := OSDll.LoadModule("sqlite3.so");
    END;
    IF dll # OSDll.InvalidHandle THEN
        libversion_number   := SYSTEM.VAL(sqlite3_libversion_number,    OSDll.GetProcAdr(dll, "sqlite3_libversion_number"));
    END;
END Initialize;

BEGIN
    Initialize();
END DBSQLite3Dll.
