// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObCurves.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<Curves> s_inst;


Curves* Curves::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new Curves() );
	return s_inst.get();
}

void Curves::Dot(GraphicFrames::Frame f, int col, int x, int y)
{
	// BEGIN
	Curves* _this = _inst();
	if( (x >= f->X) && (x + 7 < f->X1) && (y >= f->Y) && (x + 7 < f->Y1) )
		Display::_inst()->Dot(col, x, y, Display::_inst()->replace);
	
	// END
}

void Curves::mark(GraphicFrames::Frame f, int col, int x, int y)
{
	// BEGIN
	Curves* _this = _inst();
	x -= 3;
	y -= 3;
	if( (x >= f->X) && (x + 7 < f->X1) && (y >= f->Y) && (y + 7 < f->Y1) )
	{
		if( col == Display::_inst()->black )
			Display::_inst()->ReplConst(Display::_inst()->black, x, y, 7, 7, Display::_inst()->replace);
		else
			Display::_inst()->CopyPattern(col, GraphicFrames::_inst()->tack, x, y, Display::_inst()->replace);

	}
	// END
}

void Curves::line(GraphicFrames::Frame f, int col, int x, int y, int w, int h, int d)
{
	// VAR
	int x1;
	int y1;
	int u;

	// BEGIN
	Curves* _this = _inst();
	if( h < w )
	{
		x1 = x + w;
		u = DIV((h - w),2);
		if( d == -1 )
			y += h;
		
		while( x < x1 )
		{
			_this->Dot(f, col, x, y);
			x++;
			if( u < 0 )
				u += h;
			else
			{
				u += h - w;
				y += d;
			}
		}
	}else
	{
		y1 = y + h;
		u = DIV((w - h),2);
		if( d == -1 )
			x += w;
		
		while( y < y1 )
		{
			_this->Dot(f, col, x, y);
			y++;
			if( u < 0 )
				u += w;
			else
			{
				u += w - h;
				x += d;
			}
		}
	}
	// END
}

void Curves::circle(GraphicFrames::Frame f, int col, int x0, int y0, int r)
{
	// VAR
	int x;
	int y;
	int u;

	// BEGIN
	Curves* _this = _inst();
	u = 1 - r;
	x = r;
	y = 0;
	while( y <= x )
	{
		_this->Dot(f, col, x0 + x, y0 + y);
		_this->Dot(f, col, x0 + y, y0 + x);
		_this->Dot(f, col, x0 - y, y0 + x);
		_this->Dot(f, col, x0 - x, y0 + y);
		_this->Dot(f, col, x0 - x, y0 - y);
		_this->Dot(f, col, x0 - y, y0 - x);
		_this->Dot(f, col, x0 + y, y0 - x);
		_this->Dot(f, col, x0 + x, y0 - y);
		if( u < 0 )
			u += 2 * y + 3;
		else
		{
			u += 2 * (y - x) + 5;
			x--;
		}
		y++;
	}
	// END
}

void Curves::ellipse(GraphicFrames::Frame f, int col, int x0, int y0, int a, int b)
{
	// VAR
	int x;
	int y;
	int y1;
	int aa;
	int bb;
	int d;
	int g;
	int h;

	// BEGIN
	Curves* _this = _inst();
	aa = a * a;
	bb = b * b;
	h = (DIV(aa,4)) - b * aa + bb;
	g = (DIV(9 * aa,4)) - 3 * b * aa + bb;
	x = 0;
	y = b;
	while( g < 0 )
	{
		_this->Dot(f, col, x0 + x, y0 + y);
		_this->Dot(f, col, x0 - x, y0 + y);
		_this->Dot(f, col, x0 - x, y0 - y);
		_this->Dot(f, col, x0 + x, y0 - y);
		if( h < 0 )
		{
			d = (2 * x + 3) * bb;
			g += d;
		}else
		{
			d = (2 * x + 3) * bb - 2 * (y - 1) * aa;
			g += d + 2 * aa;
			y--;
		}
		h += d;
		x++;
	}
	y1 = y;
	h = (DIV(bb,4)) - a * bb + aa;
	x = a;
	y = 0;
	while( y <= y1 )
	{
		_this->Dot(f, col, x0 + x, y0 + y);
		_this->Dot(f, col, x0 - x, y0 + y);
		_this->Dot(f, col, x0 - x, y0 - y);
		_this->Dot(f, col, x0 + x, y0 - y);
		if( h < 0 )
			h += (2 * y + 3) * aa;
		else
		{
			h += (2 * y + 3) * aa - 2 * (x - 1) * bb;
			x--;
		}
		y++;
	}
	// END
}

void Curves::New()
{
	// VAR
	Curve c;

	// BEGIN
	Curves* _this = _inst();
	c = new Curves::CurveDesc();
	c->do_ = _this->method;
	Graphics::_inst()->New(c);
	// END
}

void Curves::Copy(Graphics::Object src, Graphics::Object dst)
{
	// BEGIN
	Curves* _this = _inst();
	dst->x = src->x;
	dst->y = src->y;
	dst->w = src->w;
	dst->h = src->h;
	dst->col = src->col;
	dst->_to<Curve>()->kind = src->_to<Curve>()->kind;
	dst->_to<Curve>()->lw = src->_to<Curve>()->lw;
	// END
}

void Curves::Draw(Graphics::Object obj, Graphics::Msg& M)
{
	// VAR
	int x;
	int y;
	int w;
	int h;
	int col;
	GraphicFrames::Frame f;

	// BEGIN
	Curves* _this = _inst();
	if( dynamic_cast<>(M) != 0  ){
		x = obj->x + M.x;
		y = obj->y + M.y;
		w = obj->w;
		h = obj->h;
		f = M.f;
		if( M.col == Display::_inst()->black )
			col = obj->col;
		else
			col = M.col;

		if( (x < f->X1) && (f->X <= x + w) && (y < f->Y1) && (f->Y <= y + h) )
		{
			/* up-line */
			if( obj->_to<Curve>()->kind == 0 )
			{
				if( M.mode == 0 )
				{
					if( obj->selected )
						_this->mark(f, Display::_inst()->white, x, y);
					
					_this->line(f, col, x, y, w, h, 1);
				}else if( M.mode == 1 )
					_this->mark(f, Display::_inst()->white, x, y);
				else if( M.mode == 2 )
					_this->mark(f, f->col, x, y);
				else if( M.mode == 3 )
				{
					_this->mark(f, Display::_inst()->black, x, y);
					_this->line(f, Display::_inst()->black, x, y, w, h, 1);
				}
			}else if( obj->_to<Curve>()->kind == 1 )
			{
				/* down-line */
				if( M.mode == 0 )
				{
					if( obj->selected )
						_this->mark(f, Display::_inst()->white, x, y + h);
					
					_this->line(f, col, x, y, w, h, -1);
				}else if( M.mode == 1 )
					_this->mark(f, Display::_inst()->white, x, y + h);
				else if( M.mode == 2 )
					_this->mark(f, f->col, x, y + h);
				else if( M.mode == 3 )
				{
					_this->mark(f, Display::_inst()->black, x, y + h);
					_this->line(f, Display::_inst()->black, x, y, w, h, -1);
				}
			}else if( obj->_to<Curve>()->kind == 2 )
			{
				/* circle */
				w = DIV(w,2);
				if( M.mode == 0 )
				{
					if( obj->selected )
						_this->mark(f, Display::_inst()->white, x + w, y);
					
					_this->circle(f, col, x + w, y + w, w);
				}else if( M.mode == 1 )
					_this->mark(f, Display::_inst()->white, x + w, y);
				else if( M.mode == 2 )
					_this->mark(f, f->col, x + w, y);
				else if( M.mode == 3 )
				{
					_this->mark(f, Display::_inst()->black, x + w, y);
					_this->circle(f, Display::_inst()->black, x + w, y + w, w);
				}
			}else if( obj->_to<Curve>()->kind == 3 )
			{
				/* ellipse */
				w = DIV(w,2);
				h = DIV(h,2);
				if( M.mode == 0 )
				{
					if( obj->selected )
						_this->mark(f, Display::_inst()->white, x + w, y);
					
					_this->ellipse(f, col, x + w, y + h, w, h);
				}else if( M.mode == 1 )
					_this->mark(f, Display::_inst()->white, x + w, y);
				else if( M.mode == 2 )
					_this->mark(f, f->col, x + w, y);
				else if( M.mode == 3 )
				{
					_this->mark(f, Display::_inst()->black, x + w, y);
					_this->ellipse(f, Display::_inst()->black, x + w, y + h, w, h);
				}
			}
		}
	} 
	// END
}

bool Curves::Selectable(Graphics::Object obj, int x, int y)
{
	// VAR
	int xm;
	int y0;
	int w;
	int h;
	bool res;

	// BEGIN
	Curves* _this = _inst();
	/* line */
	if( obj->_to<Curve>()->kind <= 1 )
	{
		w = obj->w;
		h = obj->h;
		if( obj->_to<Curve>()->kind == 1 )
		{
			y0 = obj->y + h;
			h = -h;
		}else
			y0 = obj->y;

		res = (obj->x <= x) && (x < obj->x + w) && (ABS(y - y0) * w - (x - obj->x) * h < w * 4);
	}else
	{
		/* circle or ellipse */
		xm = DIV(obj->w,2) + obj->x;
		res = (xm - 4 <= x) && (x <= xm + 4) && (obj->y - 4 <= y) && (y <= obj->y + 4);
	}
	return res;
	// END
}

void Curves::Change(Graphics::Object obj, Graphics::Msg& M)
{
	// BEGIN
	Curves* _this = _inst();
	if( dynamic_cast<Graphics::ColorMsg>(M) != 0  )
		obj->col = M._to<Graphics::ColorMsg>().col;
	
	// END
}

void Curves::Read(Graphics::Object obj, Files::Rider& R, Graphics::Context& C)
{
	// VAR
	uint8_t len;

	// BEGIN
	Curves* _this = _inst();
	Files::_inst()->ReadByte(R, len);
	Files::_inst()->ReadByte(R, len);
	obj->_to<Curve>()->kind = len;
	Files::_inst()->ReadByte(R, len);
	obj->_to<Curve>()->lw = len;
	// END
}

void Curves::Write(Graphics::Object obj, int cno, Files::Rider& W, Graphics::Context& C)
{
	// BEGIN
	Curves* _this = _inst();
	Graphics::_inst()->WriteObj(W, cno, obj);
	Files::_inst()->WriteByte(W, 2);
	Files::_inst()->WriteByte(W, obj->_to<Curve>()->kind);
	Files::_inst()->WriteByte(W, obj->_to<Curve>()->lw);
	// END
}

/* command */
void Curves::MakeLine()
{
	// VAR
	int x0;
	int x1;
	int y0;
	int y1;
	Curve c;
	GraphicFrames::Frame G;

	// BEGIN
	Curves* _this = _inst();
	G = GraphicFrames::_inst()->Focus();
	if( (G != 0) && (G->mark.next != 0) )
	{
		GraphicFrames::_inst()->Deselect(G);
		x0 = G->mark.x;
		y0 = G->mark.y;
		x1 = G->mark.next->x;
		y1 = G->mark.next->y;
		c = new Curves::CurveDesc();
		c->col = Oberon::_inst()->CurCol;
		c->w = ABS(x1 - x0);
		c->h = ABS(y1 - y0);
		c->lw = Graphics::_inst()->width;
		if( x0 <= x1 )
		{
			c->x = x0;
			if( y0 <= y1 )
			{
				c->kind = 0;
				c->y = y0;
			}else
			{
				c->kind = 1;
				c->y = y1;
			}
		}else
		{
			c->x = x1;
			if( y1 < y0 )
			{
				c->kind = 0;
				c->y = y1;
			}else
			{
				c->kind = 1;
				c->y = y0;
			}
		}
		c->x -= G->x;
		c->y -= G->y;
		c->do_ = _this->method;
		Graphics::_inst()->Add(G->graph, c);
		GraphicFrames::_inst()->Defocus(G);
		GraphicFrames::_inst()->DrawObj(G, c);
	}
	// END
}

/* command */
void Curves::MakeCircle()
{
	// VAR
	int x0;
	int y0;
	int r;
	Curve c;
	GraphicFrames::Frame G;

	// BEGIN
	Curves* _this = _inst();
	G = GraphicFrames::_inst()->Focus();
	if( (G != 0) && (G->mark.next != 0) )
	{
		GraphicFrames::_inst()->Deselect(G);
		x0 = G->mark.x;
		y0 = G->mark.y;
		r = ABS(G->mark.next->x - x0);
		if( r > 4 )
		{
			c = new Curves::CurveDesc();
			c->x = x0 - r - G->x;
			c->y = y0 - r - G->y;
			c->w = 2 * r + 1;
			c->h = c->w;
			c->kind = 2;
			c->col = Oberon::_inst()->CurCol;
			c->lw = Graphics::_inst()->width;
			c->do_ = _this->method;
			Graphics::_inst()->Add(G->graph, c);
			GraphicFrames::_inst()->Defocus(G);
			GraphicFrames::_inst()->DrawObj(G, c);
		}
	}
	// END
}

/* command */
void Curves::MakeEllipse()
{
	// VAR
	int x0;
	int y0;
	int a;
	int b;
	Curve c;
	GraphicFrames::Frame G;

	// BEGIN
	Curves* _this = _inst();
	G = GraphicFrames::_inst()->Focus();
	if( (G != 0) && (G->mark.next != 0) && (G->mark.next->next != 0) )
	{
		GraphicFrames::_inst()->Deselect(G);
		x0 = G->mark.x;
		y0 = G->mark.y;
		a = ABS(G->mark.next->x - x0);
		b = ABS(G->mark.next->next->y - y0);
		if( (a > 4) && (b > 4) )
		{
			c = new Curves::CurveDesc();
			c->x = x0 - a - G->x;
			c->y = y0 - b - G->y;
			c->w = 2 * a + 1;
			c->h = 2 * b + 1;
			c->kind = 3;
			c->col = Oberon::_inst()->CurCol;
			c->lw = Graphics::_inst()->width;
			c->do_ = _this->method;
			Graphics::_inst()->Add(G->graph, c);
			GraphicFrames::_inst()->Defocus(G);
			GraphicFrames::_inst()->DrawObj(G, c);
		}
	}
	// END
}

Curves::Curves()
{
	// BEGIN
	method = new Graphics::MethodDesc();
	method->module = "Curves";
	method->allocator = "New";
	method->new_ = New;
	method->copy = Copy;
	method->draw = Draw;
	method->selectable = Selectable;
	method->change = Change;
	method->read = Read;
	method->write = Write;
	// END
}

Curves::~Curves()
{
	s_inst.release();
}

