// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObDisplay.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<Display> s_inst;

const int Display::black;
const int Display::white;
const int Display::replace;
const int Display::paint;
const int Display::invert;
const int Display::base;

Display* Display::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new Display() );
	return s_inst.get();
}

/* a pattern is an array of bytes; the first is its width (< 32), the second its height, the rest the raster */
void Display::Handle(Frame F, FrameMsg& M)
{
	// BEGIN
	Display* _this = _inst();
	if( (F != 0) && (F->handle != 0) )
		F->handle(F, M);
	
	// END
}

/*  raster ops  */
void Display::Dot(int col, int x, int y, int mode)
{
	// VAR
	int a;
	_Set u;
	_Set s;

	// BEGIN
	Display* _this = _inst();
	a = _this->base + (DIV(x,32)) * 4 + y * 128;
	s = ( _Set() + (MOD(x,32)) );
	SYSTEM::_inst()->GET(a, u);
	if( mode == _this->paint )
		SYSTEM::_inst()->PUT(a, u + s);
	else if( mode == _this->invert )
		SYSTEM::_inst()->PUT(a, u / s);
	else
	{
		/* mode = replace */
		if( col != _this->black )
			SYSTEM::_inst()->PUT(a, u + s);
		else
			SYSTEM::_inst()->PUT(a, u - s);

	}
	// END
}

void Display::ReplConst(int col, int x, int y, int w, int h, int mode)
{
	// VAR
	int al;
	int ar;
	int a0;
	int a1;
	_Set left;
	_Set right;
	_Set mid;
	_Set pix;
	_Set pixl;
	_Set pixr;

	// BEGIN
	Display* _this = _inst();
	al = _this->base + y * 128;
	ar = (DIV((x + w - 1),32)) * 4 + al;
	al = (DIV(x,32)) * 4 + al;
	if( ar == al )
	{
		mid = ( _Set() + _Set( (MOD(x,32)), (MOD((x + w - 1),32))) );
		for( a1 = al; 128 > 0 ? a1 <= al + (h - 1) * 128 : a1 >= al + (h - 1) * 128; a1 += 128 )
		{
			SYSTEM::_inst()->GET(a1, pix);
			if( mode == _this->invert )
				SYSTEM::_inst()->PUT(a1, pix / mid);
			else if( (mode == _this->replace) && (col == _this->black) )
				/* erase */
				SYSTEM::_inst()->PUT(a1, pix - mid);
			else
				/*  (mode = paint) OR (mode = replace) & (col # black)  */
				SYSTEM::_inst()->PUT(a1, pix + mid);

		}
	}else if( ar > al )
	{
		left = ( _Set() + _Set( (MOD(x,32)), 31) );
		right = ( _Set() + _Set( 0, (MOD((x + w - 1),32))) );
		for( a0 = al; 128 > 0 ? a0 <= al + (h - 1) * 128 : a0 >= al + (h - 1) * 128; a0 += 128 )
		{
			SYSTEM::_inst()->GET(a0, pixl);
			SYSTEM::_inst()->GET(ar, pixr);
			if( mode == _this->invert )
			{
				SYSTEM::_inst()->PUT(a0, pixl / left);
				for( a1 = a0 + 4; 4 > 0 ? a1 <= ar - 4 : a1 >= ar - 4; a1 += 4 )
				{
					SYSTEM::_inst()->GET(a1, pix);
					SYSTEM::_inst()->PUT(a1, -pix);
				}
				SYSTEM::_inst()->PUT(ar, pixr / right);
			}else if( (mode == _this->replace) && (col == _this->black) )
			{
				/* erase */
				SYSTEM::_inst()->PUT(a0, pixl - left);
				for( a1 = a0 + 4; 4 > 0 ? a1 <= ar - 4 : a1 >= ar - 4; a1 += 4 )
					SYSTEM::_inst()->PUT(a1, ( _Set() ));
				SYSTEM::_inst()->PUT(ar, pixr - right);
			}else
			{
				/*  (mode = paint) OR (mode = replace) & (col # black)  */
				SYSTEM::_inst()->PUT(a0, pixl + left);
				for( a1 = a0 + 4; 4 > 0 ? a1 <= ar - 4 : a1 >= ar - 4; a1 += 4 )
					SYSTEM::_inst()->PUT(a1, ( _Set() + _Set( 0, 31) ));
				SYSTEM::_inst()->PUT(ar, pixr + right);
			}
			ar += 128;
		}
	}
	// END
}

/* only for modes = paint, invert */
void Display::CopyPattern(int col, int patadr, int x, int y, int mode)
{
	// VAR
	int a;
	int a0;
	int pwd;
	uint8_t w;
	uint8_t h;
	uint8_t pbt;
	_Set pix;

	// BEGIN
	Display* _this = _inst();
	SYSTEM::_inst()->GET(patadr, w);
	SYSTEM::_inst()->GET(patadr + 1, h);
	patadr += 2;
	a = _this->base + (DIV(x,32)) * 4 + y * 128;
	for( a0 = a; 128 > 0 ? a0 <= a + (h - 1) * 128 : a0 >= a + (h - 1) * 128; a0 += 128 )
	{
		/* build pattern line; w < 32 */
		SYSTEM::_inst()->GET(patadr, pbt);
		patadr++;
		pwd = pbt;
		if( w > 8 )
		{
			SYSTEM::_inst()->GET(patadr, pbt);
			patadr++;
			pwd = pbt * 0x100 + pwd;
			if( w > 16 )
			{
				SYSTEM::_inst()->GET(patadr, pbt);
				patadr++;
				pwd = pbt * 0x10000 + pwd;
				if( w > 24 )
				{
					SYSTEM::_inst()->GET(patadr, pbt);
					patadr++;
					pwd = pbt * 0x1000000 + pwd;
				}
			}
		}
		SYSTEM::_inst()->GET(a0, pix);
		if( mode == _this->invert )
			SYSTEM::_inst()->PUT(a0, SYSTEM::_inst()->VAL(SET, LSL(pwd, MOD(x,32))) / pix);
		else
			SYSTEM::_inst()->PUT(a0, SYSTEM::_inst()->VAL(SET, LSL(pwd, MOD(x,32))) + pix);

		/* spill over */
		if( (MOD(x,32)) + w > 32 )
		{
			SYSTEM::_inst()->GET(a0 + 4, pix);
			if( mode == _this->invert )
				SYSTEM::_inst()->PUT(a0 + 4, SYSTEM::_inst()->VAL(SET, ASR(pwd, -(MOD(x,32)))) / pix);
			else
				SYSTEM::_inst()->PUT(a0 + 4, SYSTEM::_inst()->VAL(SET, ASR(pwd, -(MOD(x,32)))) + pix);

		}
	}
	// END
}

/* only for mode = replace */
void Display::CopyBlock(int sx, int sy, int w, int h, int dx, int dy, int mode)
{
	// VAR
	int sa;
	int da;
	int sa0;
	int sa1;
	int d;
	int len;
	int u0;
	int u1;
	int u2;
	int u3;
	int v0;
	int v1;
	int v2;
	int v3;
	int n;
	int end;
	int step;
	_Set src;
	_Set dst;
	_Set spill;
	_Set m0;
	_Set m1;
	_Set m2;
	_Set m3;

	// BEGIN
	Display* _this = _inst();
	u0 = DIV(sx,32);
	u1 = MOD(sx,32);
	u2 = DIV((sx + w),32);
	u3 = MOD((sx + w),32);
	v0 = DIV(dx,32);
	v1 = MOD(dx,32);
	v2 = DIV((dx + w),32);
	v3 = MOD((dx + w),32);
	sa = _this->base + u0 * 4 + sy * 128;
	da = _this->base + v0 * 4 + dy * 128;
	/* displacement in words and bits */
	d = da - sa;
	n = u1 - v1;
	len = (u2 - u0) * 4;
	m0 = ( _Set() + _Set( v1, 31) );
	m2 = ( _Set() + _Set( v3, 31) );
	m3 = m0 / m2;
	/* copy up, scan down */
	if( d >= 0 )
	{
		sa0 = sa + (h - 1) * 128;
		end = sa - 128;
		step = -128;
	}else
	{
		/* copy down, scan up */
		sa0 = sa;
		end = sa + h * 128;
		step = 128;
	}
	while( sa0 != end )
	{
		/* shift right */
		if( n >= 0 )
		{
			m1 = ( _Set() + _Set( n, 31) );
			if( v1 + w >= 32 )
			{
				SYSTEM::_inst()->GET(sa0 + len, src);
				src = ROR(src, n);
				SYSTEM::_inst()->GET(sa0 + len + d, dst);
				SYSTEM::_inst()->PUT(sa0 + len + d, (dst * m2) + (src - m2));
				spill = src - m1;
				for( sa1 = sa0 + len - 4; -4 > 0 ? sa1 <= sa0 + 4 : sa1 >= sa0 + 4; sa1 += -4 )
				{
					SYSTEM::_inst()->GET(sa1, src);
					src = ROR(src, n);
					SYSTEM::_inst()->PUT(sa1 + d, spill + (src * m1));
					spill = src - m1;
				}
				SYSTEM::_inst()->GET(sa0, src);
				src = ROR(src, n);
				SYSTEM::_inst()->GET(sa0 + d, dst);
				SYSTEM::_inst()->PUT(sa0 + d, (src * m0) + (dst - m0));
			}else
			{
				SYSTEM::_inst()->GET(sa0, src);
				src = ROR(src, n);
				SYSTEM::_inst()->GET(sa0 + d, dst);
				SYSTEM::_inst()->PUT(sa0 + d, (src * m3) + (dst - m3));
			}
		}else
		{
			/* shift left */
			m1 = ( _Set() + _Set( -n, 31) );
			SYSTEM::_inst()->GET(sa0, src);
			src = ROR(src, n);
			SYSTEM::_inst()->GET(sa0 + d, dst);
			if( v1 + w < 32 )
				SYSTEM::_inst()->PUT(sa0 + d, (dst - m3) + (src * m3));
			else
			{
				SYSTEM::_inst()->PUT(sa0 + d, (dst - m0) + (src * m0));
				spill = src - m1;
				for( sa1 = sa0 + 4; 4 > 0 ? sa1 <= sa0 + len - 4 : sa1 >= sa0 + len - 4; sa1 += 4 )
				{
					SYSTEM::_inst()->GET(sa1, src);
					src = ROR(src, n);
					SYSTEM::_inst()->PUT(sa1 + d, spill + (src * m1));
					spill = src - m1;
				}
				SYSTEM::_inst()->GET(sa0 + len, src);
				src = ROR(src, n);
				SYSTEM::_inst()->GET(sa0 + len + d, dst);
				SYSTEM::_inst()->PUT(sa0 + len + d, (src - m2) + (dst * m2));
			}
		}
		sa0 += step;
	}
	// END
}

void Display::ReplPattern(int col, int patadr, int x, int y, int w, int h, int mode)
{
	// VAR
	/*  pattern width = 32, fixed; pattern starts at patadr+4, for mode = invert only  */
	int al;
	int ar;
	int a0;
	int a1;
	/* pattern addresses */
	int pta0;
	int pta1;
	uint8_t ph;
	_Set left;
	_Set right;
	_Set mid;
	_Set pix;
	_Set pixl;
	_Set pixr;
	_Set ptw;

	// BEGIN
	Display* _this = _inst();
	al = _this->base + y * 128;
	SYSTEM::_inst()->GET(patadr + 1, ph);
	pta0 = patadr + 4;
	pta1 = ph * 4 + pta0;
	ar = (DIV((x + w - 1),32)) * 4 + al;
	al = (DIV(x,32)) * 4 + al;
	if( ar == al )
	{
		mid = ( _Set() + _Set( (MOD(x,32)), (MOD((x + w - 1),32))) );
		for( a1 = al; 128 > 0 ? a1 <= al + (h - 1) * 128 : a1 >= al + (h - 1) * 128; a1 += 128 )
		{
			SYSTEM::_inst()->GET(a1, pix);
			SYSTEM::_inst()->GET(pta0, ptw);
			SYSTEM::_inst()->PUT(a1, (pix - mid) + (pix / ptw * mid));
			pta0 += 4;
			if( pta0 == pta1 )
				pta0 = patadr + 4;
			
		}
	}else if( ar > al )
	{
		left = ( _Set() + _Set( (MOD(x,32)), 31) );
		right = ( _Set() + _Set( 0, (MOD((x + w - 1),32))) );
		for( a0 = al; 128 > 0 ? a0 <= al + (h - 1) * 128 : a0 >= al + (h - 1) * 128; a0 += 128 )
		{
			SYSTEM::_inst()->GET(a0, pixl);
			SYSTEM::_inst()->GET(pta0, ptw);
			SYSTEM::_inst()->PUT(a0, (pixl - left) + (pixl / ptw * left));
			for( a1 = a0 + 4; 4 > 0 ? a1 <= ar - 4 : a1 >= ar - 4; a1 += 4 )
			{
				SYSTEM::_inst()->GET(a1, pix);
				SYSTEM::_inst()->PUT(a1, pix / ptw);
			}
			SYSTEM::_inst()->GET(ar, pixr);
			SYSTEM::_inst()->PUT(ar, (pixr - right) + (pixr / ptw * right));
			pta0 += 4;
			ar += 128;
			if( pta0 == pta1 )
				pta0 = patadr + 4;
			
		}
	}
	// END
}

Display::Display()
{
	// BEGIN
	Base = base;
	Width = 1024;
	Height = 768;
	arrow = SYSTEM::_inst()->ADR("0F0F006000700038001C000E00078003C101E30077003F001F003F007F00FF00");
	star = SYSTEM::_inst()->ADR("0F0F80008220841088089004A002C0017F7FC001A00290048808841082208000");
	hook = SYSTEM::_inst()->ADR("0C0C070F8707C703E701F7007F003F001F000F000700030001");
	updown = SYSTEM::_inst()->ADR("080E183C7EFF181818181818FF7E3C18");
	block = SYSTEM::_inst()->ADR("0808FFFFC3C3C3C3FFFF");
	cross = SYSTEM::_inst()->ADR("0F0F014002200410080810042002400100004001200210040808041002200140");
	grey = SYSTEM::_inst()->ADR("2002000055555555AAAAAAAA");
	// END
}

Display::~Display()
{
	s_inst.release();
}

