// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObEdit.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<Edit> s_inst;

const char Edit::CR;
const int Edit::maxlen;
const _ValArray<char> Edit::StandardMenu;

Edit* Edit::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new Edit() );
	return s_inst.get();
}

int Edit::Max(int i, int j)
{
	// VAR
	int m;

	// BEGIN
	Edit* _this = _inst();
	if( i >= j )
		m = i;
	else
		m = j;

	return m;
	// END
}

void Edit::Open()
{
	// VAR
	Texts::Text T;
	Texts::Scanner S;
	Viewers::Viewer V;
	int X;
	int Y;
	int beg;
	int end;
	int time;

	// BEGIN
	Edit* _this = _inst();
	Texts::_inst()->OpenScanner(S, Oberon::_inst()->Par.text, Oberon::_inst()->Par.pos);
	Texts::_inst()->Scan(S);
	if( (S.class_ == Texts::_inst()->Char) && (S.c == '^') || (S.line != 0) )
	{
		Oberon::_inst()->GetSelection(T, beg, end, time);
		if( time >= 0 )
		{
			Texts::_inst()->OpenScanner(S, T, beg);
			Texts::_inst()->Scan(S);
		}
	}
	if( S.class_ == Texts::_inst()->Name )
	{
		Oberon::_inst()->AllocateUserViewer(Oberon::_inst()->Par.vwr->X, X, Y);
		V = MenuViewers::_inst()->New(TextFrames::_inst()->NewMenu(S.s, _this->StandardMenu), TextFrames::_inst()->NewText(TextFrames::_inst()->Text(S.s), 0), TextFrames::_inst()->menuH, X, Y);
	}
	// END
}

void Edit::Store()
{
	// VAR
	Viewers::Viewer V;
	TextFrames::Frame Text;
	Texts::Text T;
	Texts::Scanner S;
	Files::File f;
	Files::Rider R;
	int beg;
	int end;
	int time;
	int len;

	// BEGIN
	Edit* _this = _inst();
	Texts::_inst()->WriteString(_this->W, "Edit.Store ");
	if( Oberon::_inst()->Par.frame == Oberon::_inst()->Par.vwr->dsc )
	{
		V = Oberon::_inst()->Par.vwr;
		Texts::_inst()->OpenScanner(S, V->dsc->_to<TextFrames::Frame>()->text, 0);
	}else
	{
		V = Oberon::_inst()->MarkedViewer();
		Texts::_inst()->OpenScanner(S, Oberon::_inst()->Par.text, Oberon::_inst()->Par.pos);
	}
	Texts::_inst()->Scan(S);
	if( (S.class_ == Texts::_inst()->Char) && (S.c == '^') )
	{
		Oberon::_inst()->GetSelection(T, beg, end, time);
		if( time >= 0 )
		{
			Texts::_inst()->OpenScanner(S, T, beg);
			Texts::_inst()->Scan(S);
		}
	}
	if( (S.class_ == Texts::_inst()->Name) && (V->dsc != 0) && (dynamic_cast<TextFrames::Frame>(V->dsc->next) != 0 ) )
	{
		Text = V->dsc->next->_to<TextFrames::Frame>();
		Texts::_inst()->WriteString(_this->W, S.s);
		Texts::_inst()->WriteInt(_this->W, Text->text->len, 8);
		Texts::_inst()->WriteLn(_this->W);
		Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
		Backup(S.s);
		Texts::_inst()->Close(Text->text, S.s);
	}
	// END
}

void Edit::CopyLooks()
{
	// VAR
	Texts::Text T;
	TextFrames::Frame F;
	Viewers::Viewer v;
	int beg;
	int end;
	int time;
	Fonts::Font fnt;
	int col;
	int voff;

	// BEGIN
	Edit* _this = _inst();
	Oberon::_inst()->GetSelection(T, beg, end, time);
	if( time >= 0 )
	{
		v = Oberon::_inst()->FocusViewer;
		if( (v != 0) && (v->dsc != 0) && (dynamic_cast<TextFrames::Frame>(v->dsc->next) != 0 ) )
		{
			F = v->dsc->next->_to<TextFrames::Frame>();
			Texts::_inst()->Attributes(F->text, F->carloc.pos, fnt, col, voff);
			Texts::_inst()->ChangeLooks(T, beg, end, ( _Set() + (0) + (1) + (2) ), fnt, col, voff);
		}
	}
	// END
}

void Edit::ChangeFont()
{
	// VAR
	Texts::Scanner S;
	Texts::Text T;
	int beg;
	int end;

	// BEGIN
	Edit* _this = _inst();
	Oberon::_inst()->GetSelection(T, beg, end, _this->time);
	if( _this->time >= 0 )
	{
		Texts::_inst()->OpenScanner(S, Oberon::_inst()->Par.text, Oberon::_inst()->Par.pos);
		Texts::_inst()->Scan(S);
		if( S.class_ == Texts::_inst()->Name )
			Texts::_inst()->ChangeLooks(T, beg, end, ( _Set() + (0) ), Fonts::_inst()->This(S.s), 0, 0);
		
	}
	// END
}

void Edit::ChangeColor()
{
	// VAR
	Texts::Scanner S;
	Texts::Text T;
	int col;
	int beg;
	int end;
	int time;

	// BEGIN
	Edit* _this = _inst();
	Texts::_inst()->OpenScanner(S, Oberon::_inst()->Par.text, Oberon::_inst()->Par.pos);
	Texts::_inst()->Scan(S);
	if( S.class_ == Texts::_inst()->Int )
	{
		col = S.i;
		Oberon::_inst()->GetSelection(T, beg, end, time);
		if( time >= 0 )
			Texts::_inst()->ChangeLooks(T, beg, end, ( _Set() + (1) ), 0, col, 0);
		
	}
	// END
}

void Edit::ChangeOffset()
{
	// VAR
	Texts::Scanner S;
	Texts::Text T;
	int voff;
	char ch;
	int beg;
	int end;
	int time;

	// BEGIN
	Edit* _this = _inst();
	Texts::_inst()->OpenScanner(S, Oberon::_inst()->Par.text, Oberon::_inst()->Par.pos);
	Texts::_inst()->Scan(S);
	if( S.class_ == Texts::_inst()->Int )
	{
		voff = S.i;
		Oberon::_inst()->GetSelection(T, beg, end, time);
		if( time >= 0 )
			Texts::_inst()->ChangeLooks(T, beg, end, ( _Set() + (2) ), 0, voff, 0);
		
	}
	// END
}

/* uses global variables M, pat, d for Boyer-Moore search */
void Edit::Search()
{
	// VAR
	TextFrames::Frame Text;
	Viewers::Viewer V;
	Texts::Reader R;
	Texts::Text T;
	int pos;
	int beg;
	int end;
	int prevTime;
	int len;
	int n;
	int i;
	int j;
	_FxArray<char,32> buf;

	// BEGIN
	Edit* _this = _inst();
	V = Oberon::_inst()->Par.vwr;
	if( Oberon::_inst()->Par.frame != V->dsc )
		V = Oberon::_inst()->FocusViewer;
	
	if( (V->dsc != 0) && (dynamic_cast<TextFrames::Frame>(V->dsc->next) != 0 ) )
	{
		Text = V->dsc->next->_to<TextFrames::Frame>();
		prevTime = _this->time;
		Oberon::_inst()->GetSelection(T, beg, end, _this->time);
		if( _this->time > prevTime )
		{
			Texts::_inst()->OpenReader(R, T, beg);
			i = 0;
			pos = beg;
			do 
			{
				Texts::_inst()->Read(R, _this->pat[i]);
				i++;
				pos++;
			} while( !( (i == _this->maxlen) || (pos == end) ) );
			_this->M = i;
			j = 0;
			while( j != 256 )
			{
				_this->d[j] = _this->M;
				j++;
			}
			j = 0;
			while( j != _this->M - 1 )
			{
				_this->d[int( _this->pat[j] )] = _this->M - 1 - j;
				j++;
			}
		}
		if( Text->hasCar )
			pos = Text->carloc.pos;
		else
			pos = 0;

		len = Text->text->len;
		Texts::_inst()->OpenReader(R, Text->text, pos);
		Forward(_this->M, R, buf);
		pos = pos + _this->M;
		j = _this->M;
		do 
		{
			j--;
		} while( !( (j < 0) || (buf[j] != _this->pat[j]) ) );
		while( (j >= 0) && (pos < len) )
		{
			n = _this->d[int( buf[_this->M - 1] )];
			Forward(n, R, buf);
			pos += n;
			j = _this->M;
			do 
			{
				j--;
			} while( !( (j < 0) || (buf[j] != _this->pat[j]) ) );
		}
		if( j < 0 )
		{
			TextFrames::_inst()->RemoveSelection(Text);
			TextFrames::_inst()->RemoveCaret(Text);
			Oberon::_inst()->RemoveMarks(Text->X, Text->Y, Text->W, Text->H);
			TextFrames::_inst()->Show(Text, pos - 300);
			Oberon::_inst()->PassFocus(V);
			TextFrames::_inst()->SetCaret(Text, pos);
		}
	}
	// END
}

void Edit::Locate()
{
	// VAR
	TextFrames::Frame Text;
	Texts::Text T;
	Texts::Scanner S;
	Viewers::Viewer V;
	int beg;
	int end;
	int time;

	// BEGIN
	Edit* _this = _inst();
	V = Oberon::_inst()->FocusViewer;
	if( (V->dsc != 0) && (dynamic_cast<TextFrames::Frame>(V->dsc->next) != 0 ) )
	{
		Text = V->dsc->next->_to<TextFrames::Frame>();
		Oberon::_inst()->GetSelection(T, beg, end, time);
		if( time >= 0 )
		{
			Texts::_inst()->OpenScanner(S, T, beg);
			/* skip names */
			do 
			{
				Texts::_inst()->Scan(S);
			} while( !( (S.class_ >= Texts::_inst()->Int) ) );
			if( S.class_ == Texts::_inst()->Int )
			{
				TextFrames::_inst()->RemoveSelection(Text);
				TextFrames::_inst()->RemoveCaret(Text);
				Oberon::_inst()->RemoveMarks(Text->X, Text->Y, Text->W, Text->H);
				TextFrames::_inst()->Show(Text, _this->Max(0, S.i - 200));
				Oberon::_inst()->PassFocus(V);
				TextFrames::_inst()->SetCaret(Text, S.i);
			}
		}
	}
	// END
}

void Edit::Recall()
{
	// VAR
	Display::Frame Menu;
	Display::Frame Main;
	Texts::Buffer buf;
	Viewers::Viewer V;
	int pos;
	TextFrames::Frame M;

	// BEGIN
	Edit* _this = _inst();
	V = Oberon::_inst()->FocusViewer;
	if( (V != 0) && (dynamic_cast<MenuViewers::Viewer>(V) != 0 ) )
	{
		Menu = V->dsc;
		Main = V->dsc->next;
		if( dynamic_cast<TextFrames::Frame>(Main) != 0  )
		{
			M = Main->_to<TextFrames::Frame>();
			if( M->hasCar )
			{
				TextFrames::_inst()->Recall(buf);
				pos = M->carloc.pos + buf->len;
				Texts::_inst()->Insert(M->text, M->carloc.pos, buf);
				TextFrames::_inst()->SetCaret(M, pos);
			}
		}else if( dynamic_cast<TextFrames::Frame>(Menu) != 0  )
		{
			M = Menu->_to<TextFrames::Frame>();
			if( M->hasCar )
			{
				TextFrames::_inst()->Recall(buf);
				pos = M->carloc.pos + buf->len;
				Texts::_inst()->Insert(M->text, M->carloc.pos, buf);
				TextFrames::_inst()->SetCaret(M, pos);
			}
		}
	}
	// END
}

Edit::Edit()
{
	// BEGIN
	Texts::_inst()->OpenWriter(W);
	// END
}

Edit::~Edit()
{
	s_inst.release();
}

