// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObFileDir.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<FileDir> s_inst;

const int FileDir::FnLength;
const int FileDir::SecTabSize;
const int FileDir::ExTabSize;
const int FileDir::SectorSize;
const int FileDir::IndexSize;
const int FileDir::HeaderSize;
const int FileDir::DirRootAdr;
const int FileDir::DirPgSize;
const int FileDir::N;
const int FileDir::DirMark;
const int FileDir::HeaderMark;
const int FileDir::FillerSize;

FileDir* FileDir::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new FileDir() );
	return s_inst.get();
}

/* sec no of left descendant in directory */
/* Exported procedures: Search, Insert, Delete, Enumerate, Init */
void FileDir::Search(_ValArray<char> name, DiskAdr& A)
{
	// VAR
	int i;
	int L;
	int R;
	DiskAdr dadr;
	DirPage a;

	// BEGIN
	FileDir* _this = _inst();
	dadr = _this->DirRootAdr;
	A = 0;
	do 
	{
		Kernel::_inst()->GetSector(dadr, a);
		ASSERT(a.mark == _this->DirMark);
		/* binary search */
		L = 0;
		R = a.m;
		while( L < R )
		{
			i = DIV((L + R),2);
			if( name <= a.e[i].name )
				R = i;
			else
				L = i + 1;

		}
		/* found */
		if( (R < a.m) && (name == a.e[R].name) )
			A = a.e[R].adr;
		else if( R == 0 )
			dadr = a.p0;
		else
			dadr = a.e[R - 1].p;

	} while( !( (dadr == 0) || (A != 0) ) );
	// END
}

void FileDir::insert(_ValArray<char> name, DiskAdr dpg0, bool& h, DirEntry& v, DiskAdr fad)
{
	// VAR
	/* h = "tree has become higher and v is ascending element" */
	char ch;
	int i;
	int j;
	int L;
	int R;
	DiskAdr dpg1;
	DirEntry u;
	DirPage a;

	// BEGIN
	FileDir* _this = _inst();
	/* ~h */
	Kernel::_inst()->GetSector(dpg0, a);
	ASSERT(a.mark == _this->DirMark);
	/* binary search */
	L = 0;
	R = a.m;
	while( L < R )
	{
		i = DIV((L + R),2);
		if( name <= a.e[i].name )
			R = i;
		else
			L = i + 1;

	}
	if( (R < a.m) && (name == a.e[R].name) )
	{
		/* replace */
		a.e[R].adr = fad;
		Kernel::_inst()->PutSector(dpg0, a);
	}else
	{
		/* not on this page */
		if( R == 0 )
			dpg1 = a.p0;
		else
			dpg1 = a.e[R - 1].p;

		/* not in tree, insert */
		if( dpg1 == 0 )
		{
			u.adr = fad;
			u.p = 0;
			h = TRUE;
			j = 0;
			do 
			{
				ch = name[j];
				u.name[j] = ch;
				j++;
			} while( !( ch == 0x0 ) );
			while( j < _this->FnLength )
			{
				u.name[j] = 0x0;
				j++;
			}
		}else
			_this->insert(name, dpg1, h, u, fad);

		/* insert u to the left of e[R] */
		if( h )
		{
			if( a.m < _this->DirPgSize )
			{
				h = FALSE;
				i = a.m;
				while( i > R )
				{
					i--;
					a.e[i + 1] = a.e[i];
				}
				a.e[R] = u;
				a.m++;
			}else
			{
				/* split page and assign the middle element to v */
				a.m = _this->N;
				a.mark = _this->DirMark;
				/* insert in left half */
				if( R < _this->N )
				{
					v = a.e[_this->N - 1];
					i = _this->N - 1;
					while( i > R )
					{
						i--;
						a.e[i + 1] = a.e[i];
					}
					a.e[R] = u;
					Kernel::_inst()->PutSector(dpg0, a);
					Kernel::_inst()->AllocSector(dpg0, dpg0);
					i = 0;
					while( i < _this->N )
					{
						a.e[i] = a.e[i + _this->N];
						i++;
					}
				}else
				{
					/* insert in right half */
					Kernel::_inst()->PutSector(dpg0, a);
					Kernel::_inst()->AllocSector(dpg0, dpg0);
					R -= _this->N;
					i = 0;
					if( R == 0 )
						v = u;
					else
					{
						v = a.e[_this->N];
						while( i < R - 1 )
						{
							a.e[i] = a.e[_this->N + 1 + i];
							i++;
						}
						a.e[i] = u;
						i++;
					}
					while( i < _this->N )
					{
						a.e[i] = a.e[_this->N + i];
						i++;
					}
				}
				a.p0 = v.p;
				v.p = dpg0;
			}
			Kernel::_inst()->PutSector(dpg0, a);
		}
	}
	// END
}

void FileDir::Insert(_ValArray<char> name, DiskAdr fad)
{
	// VAR
	DiskAdr oldroot;
	bool h;
	DirEntry U;
	DirPage a;

	// BEGIN
	FileDir* _this = _inst();
	h = FALSE;
	_this->insert(name, _this->DirRootAdr, h, U, fad);
	/* root overflow */
	if( h )
	{
		Kernel::_inst()->GetSector(_this->DirRootAdr, a);
		ASSERT(a.mark == _this->DirMark);
		Kernel::_inst()->AllocSector(_this->DirRootAdr, oldroot);
		Kernel::_inst()->PutSector(oldroot, a);
		a.mark = _this->DirMark;
		a.m = 1;
		a.p0 = oldroot;
		a.e[0] = U;
		Kernel::_inst()->PutSector(_this->DirRootAdr, a);
	}
	// END
}

/* ancestor page */
void FileDir::underflow(DirPage& c, DiskAdr dpg0, int s, bool& h)
{
	// VAR
	/* insertion point in c */
	/* c undersize */
	int i;
	int k;
	DiskAdr dpg1;
	/* a := underflowing page, b := neighbouring page */
	DirPage a;
	DirPage b;

	// BEGIN
	FileDir* _this = _inst();
	Kernel::_inst()->GetSector(dpg0, a);
	ASSERT(a.mark == _this->DirMark);
	/* h & a.m = N-1 & dpg0 = c.e[s-1].p */
	/* b := page to the right of a */
	if( s < c.m )
	{
		dpg1 = c.e[s].p;
		Kernel::_inst()->GetSector(dpg1, b);
		ASSERT(b.mark == _this->DirMark);
		/* k = no. of items available on page b */
		k = DIV((b.m - _this->N + 1),2);
		a.e[_this->N - 1] = c.e[s];
		a.e[_this->N - 1].p = b.p0;
		if( k > 0 )
		{
			/* move k-1 items from b to a, one to c */
			i = 0;
			while( i < k - 1 )
			{
				a.e[i + _this->N] = b.e[i];
				i++;
			}
			c.e[s] = b.e[i];
			b.p0 = c.e[s].p;
			c.e[s].p = dpg1;
			b.m = b.m - k;
			i = 0;
			while( i < b.m )
			{
				b.e[i] = b.e[i + k];
				i++;
			}
			Kernel::_inst()->PutSector(dpg1, b);
			a.m = _this->N - 1 + k;
			h = FALSE;
		}else
		{
			/* merge pages a and b, discard b */
			i = 0;
			while( i < _this->N )
			{
				a.e[i + _this->N] = b.e[i];
				i++;
			}
			i = s;
			c.m--;
			while( i < c.m )
			{
				c.e[i] = c.e[i + 1];
				i++;
			}
			a.m = 2 * _this->N;
			h = c.m < _this->N;
		}
		Kernel::_inst()->PutSector(dpg0, a);
	}else
	{
		/* b := page to the left of a */
		s--;
		if( s == 0 )
			dpg1 = c.p0;
		else
			dpg1 = c.e[s - 1].p;

		Kernel::_inst()->GetSector(dpg1, b);
		ASSERT(b.mark == _this->DirMark);
		/* k = no. of items available on page b */
		k = DIV((b.m - _this->N + 1),2);
		if( k > 0 )
		{
			i = _this->N - 1;
			while( i > 0 )
			{
				i--;
				a.e[i + k] = a.e[i];
			}
			i = k - 1;
			a.e[i] = c.e[s];
			a.e[i].p = a.p0;
			/* move k-1 items from b to a, one to c */
			b.m = b.m - k;
			while( i > 0 )
			{
				i--;
				a.e[i] = b.e[i + b.m + 1];
			}
			c.e[s] = b.e[b.m];
			a.p0 = c.e[s].p;
			c.e[s].p = dpg0;
			a.m = _this->N - 1 + k;
			h = FALSE;
			Kernel::_inst()->PutSector(dpg0, a);
		}else
		{
			/* merge pages a and b, discard a */
			c.e[s].p = a.p0;
			b.e[_this->N] = c.e[s];
			i = 0;
			while( i < _this->N - 1 )
			{
				b.e[i + _this->N + 1] = a.e[i];
				i++;
			}
			b.m = 2 * _this->N;
			c.m--;
			h = c.m < _this->N;
		}
		Kernel::_inst()->PutSector(dpg1, b);
	}
	// END
}

void FileDir::delete_(_ValArray<char> name, DiskAdr dpg0, bool& h, DiskAdr& fad)
{
	// VAR
	/* search and delete entry with key name; if a page underflow arises,
    balance with adjacent page or merge; h := "page dpg0 is undersize" */
	int i;
	int L;
	int R;
	DiskAdr dpg1;
	DirPage a;

	// BEGIN
	FileDir* _this = _inst();
	/* global: a, R */
	/* ~h */
	Kernel::_inst()->GetSector(dpg0, a);
	ASSERT(a.mark == _this->DirMark);
	/* binary search */
	L = 0;
	R = a.m;
	while( L < R )
	{
		i = DIV((L + R),2);
		if( name <= a.e[i].name )
			R = i;
		else
			L = i + 1;

	}
	if( R == 0 )
		dpg1 = a.p0;
	else
		dpg1 = a.e[R - 1].p;

	if( (R < a.m) && (name == a.e[R].name) )
	{
		/* found, now delete */
		fad = a.e[R].adr;
		/* a is a leaf page */
		if( dpg1 == 0 )
		{
			a.m--;
			h = a.m < _this->N;
			i = R;
			while( i < a.m )
			{
				a.e[i] = a.e[i + 1];
				i++;
			}
		}else
		{
			del(a, R, dpg1, h);
			if( h )
				_this->underflow(a, dpg1, R, h);
			
		}
		Kernel::_inst()->PutSector(dpg0, a);
	}else if( dpg1 != 0 )
	{
		_this->delete_(name, dpg1, h, fad);
		if( h )
		{
			_this->underflow(a, dpg1, R, h);
			Kernel::_inst()->PutSector(dpg0, a);
		}
	}else
		/* not in tree */
		fad = 0;

	// END
}

void FileDir::Delete(_ValArray<char> name, DiskAdr& fad)
{
	// VAR
	bool h;
	DiskAdr newroot_;
	DirPage a;

	// BEGIN
	FileDir* _this = _inst();
	h = FALSE;
	_this->delete_(name, _this->DirRootAdr, h, fad);
	/* root underflow */
	if( h )
	{
		Kernel::_inst()->GetSector(_this->DirRootAdr, a);
		ASSERT(a.mark == _this->DirMark);
		if( (a.m == 0) && (a.p0 != 0) )
		{
			newroot_ = a.p0;
			Kernel::_inst()->GetSector(newroot_, a);
			ASSERT(a.mark == _this->DirMark);
			/* discard newroot */
			Kernel::_inst()->PutSector(_this->DirRootAdr, a);
		}
	}
	// END
}

void FileDir::enumerate_(_ValArray<char> prefix, DiskAdr dpg, EntryHandler proc, bool& continue_)
{
	// VAR
	int i;
	int j;
	char pfx;
	char nmx;
	DiskAdr dpg1;
	DirPage a;

	// BEGIN
	FileDir* _this = _inst();
	Kernel::_inst()->GetSector(dpg, a);
	ASSERT(a.mark == _this->DirMark);
	i = 0;
	while( (i < a.m) && continue_ )
	{
		j = 0;
		do 
		{
			pfx = prefix[j];
			nmx = a.e[i].name[j];
			j++;
		} while( !( (nmx != pfx) || (pfx == 0x0) ) );
		if( nmx >= pfx )
		{
			if( i == 0 )
				dpg1 = a.p0;
			else
				dpg1 = a.e[i - 1].p;

			if( dpg1 != 0 )
				_this->enumerate_(prefix, dpg1, proc, continue_);
			
			if( pfx == 0x0 )
			{
				if( continue_ )
					proc(a.e[i].name, a.e[i].adr, continue_);
				
			}else
				continue_ = FALSE;

		}
		i++;
	}
	if( continue_ && (i > 0) && (a.e[i - 1].p != 0) )
		_this->enumerate_(prefix, a.e[i - 1].p, proc, continue_);
	
	// END
}

void FileDir::Enumerate(_ValArray<char> prefix, EntryHandler proc)
{
	// VAR
	bool b;

	// BEGIN
	FileDir* _this = _inst();
	b = TRUE;
	_this->enumerate_(prefix, _this->DirRootAdr, proc, b);
	// END
}

/*  ----- initialization -----  */
void FileDir::Init()
{
	// VAR
	int k;
	_FxArray<DiskAdr,2000> A;

	// BEGIN
	FileDir* _this = _inst();
	/* heapsort */
	/* index sector */
	k = 0;
	TraverseDir(A, k, _this->DirRootAdr);
	MarkSectors(A, k);
	// END
}

FileDir::FileDir()
{
	; // empty statement
}

FileDir::~FileDir()
{
	s_inst.release();
}

