#ifndef __ObFileDir_H__
#define __ObFileDir_H__

// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17

#include <OberonSystem/Ob_Global.h>
#include <OberonSystem/ObSYSTEM.h>
#include <OberonSystem/ObKernel.h>

namespace Ob
{
	class FileDir : public _Root
	{
	public:
		/* NW 12.1.86 / 23.8.90 / 15.8.2013 */
		static FileDir* _inst();
		FileDir();
		~FileDir();

		// CONST
		/* File Directory is a B-tree with its root page at DirRootAdr.
    Each entry contains a file name and the disk address of the file's head sector */
		static const int FnLength = 32;
		static const int SecTabSize = 64;
		static const int ExTabSize = 12;
		static const int SectorSize = 1024;
		static const int IndexSize = DIV(SectorSize,4);
		static const int HeaderSize = 352;
		static const int DirRootAdr = 29;
		static const int DirPgSize = 24;
		static const int N = DIV(DirPgSize,2);
		static const int DirMark = 0x9B1EA38D;
		static const int HeaderMark = 0x9BA71D86;
		static const int FillerSize = 52;

		// TYPE
		struct FileHeader;
		struct DirEntry;
		struct DirPage;

		typedef int DiskAdr;
		typedef _FxArray<char,FnLength> FileName;
		typedef _FxArray<DiskAdr,SecTabSize> SectorTable;
		typedef _FxArray<DiskAdr,ExTabSize> ExtensionTable;
		typedef /* ProcType not supported here */ EntryHandler;
		struct FileHeader : public _Root {
			int aleng;
			int bleng;
			int date;
			ExtensionTable ext;
			_FxArray<uint8_t,SectorSize - HeaderSize> fill;
			int mark;
			FileName name;
			SectorTable sec;
		};
		/* first page of each file on disk */
		typedef FileHeader* FileHd;
		typedef _FxArray<DiskAdr,IndexSize> IndexSector;
		typedef _FxArray<uint8_t,SectorSize> DataSector;
		/* B-tree node */
		struct DirEntry : public _Root {
			DiskAdr adr;
			FileName name;
			DiskAdr p;
		};
		/* sec no of file header */
		/* sec no of descendant in directory */
		struct DirPage : public _Root {
			_FxArray<DirEntry,DirPgSize> e;
			_FxArray<uint8_t,FillerSize> fill;
			int m;
			int mark;
			DiskAdr p0;
		};

		// PROC
		static void Search(_ValArray<char> name, DiskAdr& A);
		static void insert(_ValArray<char> name, DiskAdr dpg0, bool& h, DirEntry& v, DiskAdr fad);
		static void Insert(_ValArray<char> name, DiskAdr fad);
		static void underflow(DirPage& c, DiskAdr dpg0, int s, bool& h);
		static void delete_(_ValArray<char> name, DiskAdr dpg0, bool& h, DiskAdr& fad);
		static void Delete(_ValArray<char> name, DiskAdr& fad);
		static void enumerate_(_ValArray<char> prefix, DiskAdr dpg, EntryHandler proc, bool& continue_);
		static void Enumerate(_ValArray<char> prefix, EntryHandler proc);
		static void Init();

	};
}

#endif // __ObFileDir_H__