// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObFiles.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<Files> s_inst;

const int Files::MaxBufs;
const int Files::HS;
const int Files::SS;
const int Files::STS;
const int Files::XS;

Files* Files::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new Files() );
	return s_inst.get();
}

void Files::Check(_ValArray<char> s, _VarArray<char> name, int& res)
{
	// VAR
	int i;
	char ch;

	// BEGIN
	Files* _this = _inst();
	ch = s[0];
	i = 0;
	if( (ch >= 'A') && (ch <= 'Z') || (ch >= 'a') && (ch <= 'z') )
	{
		do 
		{
			name[i] = ch;
			i++;
			ch = s[i];
		} while( !( !((ch >= '0') && (ch <= '9') || (ch >= 'A') && (ch <= 'Z') || (ch >= 'a') && (ch <= 'z') || (ch == '.')) || (i == FileDir::_inst()->FnLength) ) );
		if( i == FileDir::_inst()->FnLength )
			res = 4;
		else if( ch == 0x0 )
		{
			res = 0;
			while( i < FileDir::_inst()->FnLength )
			{
				name[i] = 0x0;
				i++;
			}
		}else
			res = 5;

	}else if( ch == 0x0 )
	{
		name[0] = 0x0;
		res = -1;
	}else
		res = 3;

	// END
}

Files::File Files::Old(_ValArray<char> name)
{
	// VAR
	int i;
	int k;
	int res;
	File f;
	DiskAdr header;
	Buffer buf;
	FileDir::FileHd F;
	FileDir::FileName namebuf;
	Index inxpg;

	// BEGIN
	Files* _this = _inst();
	f = 0;
	_this->Check(name, namebuf, res);
	if( res == 0 )
	{
		FileDir::_inst()->Search(namebuf, header);
		if( header != 0 )
		{
			f = SYSTEM::_inst()->VAL(_this->File, _this->root);
			while( (f != 0) && (f->sec[0] != header) )
				f = SYSTEM::_inst()->VAL(_this->File, f->next);
			
			/* file not yet present */
			if( f == 0 )
			{
				buf = new Files::BufferRecord();
				buf->apos = 0;
				buf->next = buf;
				buf->mod = FALSE;
				F = SYSTEM::_inst()->VAL(FileDir::_inst()->FileHd, SYSTEM::_inst()->ADR(buf->data));
				Kernel::_inst()->GetSector(header, buf->data);
				ASSERT(F->mark == FileDir::_inst()->HeaderMark);
				f = new Files::FileDesc();
				f->aleng = F->aleng;
				f->bleng = F->bleng;
				f->date = F->date;
				if( f->aleng == 0 )
					buf->lim = f->bleng;
				else
					buf->lim = _this->SS;

				f->firstbuf = buf;
				f->nofbufs = 1;
				f->name = namebuf;
				f->registered_ = TRUE;
				f->sec = F->sec;
				k = DIV((f->aleng + (_this->XS - _this->STS)),_this->XS);
				i = 0;
				while( i < k )
				{
					inxpg = new Files::IndexRecord();
					inxpg->adr = F->ext[i];
					inxpg->mod = FALSE;
					Kernel::_inst()->GetSector(inxpg->adr, inxpg->sec);
					f->ext[i] = inxpg;
					i++;
				}
				while( i < FileDir::_inst()->ExTabSize )
				{
					f->ext[i] = 0;
					i++;
				}
				f->sechint = header;
				f->modH = FALSE;
				f->next = _this->root;
				_this->root = SYSTEM::_inst()->VAL(INTEGER, f);
			}
		}
	}
	return f;
	// END
}

Files::File Files::New(_ValArray<char> name)
{
	// VAR
	int i;
	int res;
	File f;
	Buffer buf;
	FileDir::FileHd F;
	FileDir::FileName namebuf;

	// BEGIN
	Files* _this = _inst();
	f = 0;
	_this->Check(name, namebuf, res);
	if( res <= 0 )
	{
		buf = new Files::BufferRecord();
		buf->apos = 0;
		buf->mod = TRUE;
		buf->lim = _this->HS;
		buf->next = buf;
		F = SYSTEM::_inst()->VAL(FileDir::_inst()->FileHd, SYSTEM::_inst()->ADR(buf->data));
		F->mark = FileDir::_inst()->HeaderMark;
		F->aleng = 0;
		F->bleng = _this->HS;
		F->name = namebuf;
		F->date = Kernel::_inst()->Clock();
		f = new Files::FileDesc();
		f->aleng = 0;
		f->bleng = _this->HS;
		f->modH = TRUE;
		f->registered_ = FALSE;
		f->date = F->date;
		f->firstbuf = buf;
		f->nofbufs = 1;
		f->name = namebuf;
		f->sechint = 0;
		i = 0;
		do 
		{
			f->ext[i] = 0;
			F->ext[i] = 0;
			i++;
		} while( !( i == FileDir::_inst()->ExTabSize ) );
		i = 0;
		do 
		{
			f->sec[i] = 0;
			F->sec[i] = 0;
			i++;
		} while( !( i == _this->STS ) );
	}
	return f;
	// END
}

void Files::UpdateHeader(File f, FileDir::FileHeader& F)
{
	// VAR
	int k;

	// BEGIN
	Files* _this = _inst();
	F.aleng = f->aleng;
	F.bleng = f->bleng;
	F.sec = f->sec;
	k = DIV((f->aleng + (_this->XS - _this->STS)),_this->XS);
	while( k > 0 )
	{
		k--;
		F.ext[k] = f->ext[k].adr;
	}
	// END
}

void Files::ReadBuf(File f, Buffer buf, int pos)
{
	// VAR
	DiskAdr sec;

	// BEGIN
	Files* _this = _inst();
	if( pos < _this->STS )
		sec = f->sec[pos];
	else
		sec = f->ext[DIV((pos - _this->STS),_this->XS)].sec[MOD((pos - _this->STS),_this->XS)];

	Kernel::_inst()->GetSector(sec, buf->data);
	if( pos < f->aleng )
		buf->lim = _this->SS;
	else
		buf->lim = f->bleng;

	buf->apos = pos;
	buf->mod = FALSE;
	// END
}

void Files::WriteBuf(File f, Buffer buf)
{
	// VAR
	int i;
	int k;
	DiskAdr secadr;
	Index inx;

	// BEGIN
	Files* _this = _inst();
	if( buf->apos < _this->STS )
	{
		secadr = f->sec[buf->apos];
		if( secadr == 0 )
		{
			Kernel::_inst()->AllocSector(f->sechint, secadr);
			f->modH = TRUE;
			f->sec[buf->apos] = secadr;
			f->sechint = secadr;
		}
		if( buf->apos == 0 )
		{
			_this->UpdateHeader(f, SYSTEM::_inst()->VAL(FileDir::_inst()->FileHeader, buf->data));
			f->modH = FALSE;
		}
	}else
	{
		i = DIV((buf->apos - _this->STS),_this->XS);
		inx = f->ext[i];
		if( inx == 0 )
		{
			inx = new Files::IndexRecord();
			inx->adr = 0;
			inx->sec[0] = 0;
			f->ext[i] = inx;
			f->modH = TRUE;
		}
		k = MOD((buf->apos - _this->STS),_this->XS);
		secadr = inx->sec[k];
		if( secadr == 0 )
		{
			Kernel::_inst()->AllocSector(f->sechint, secadr);
			f->modH = TRUE;
			inx->mod = TRUE;
			inx->sec[k] = secadr;
			f->sechint = secadr;
		}
	}
	Kernel::_inst()->PutSector(secadr, buf->data);
	buf->mod = FALSE;
	// END
}

Files::Buffer Files::Buf(File f, int pos)
{
	// VAR
	Buffer buf;

	// BEGIN
	Files* _this = _inst();
	buf = f->firstbuf;
	while( (buf->apos != pos) && (buf->next != f->firstbuf) )
		buf = buf->next;
	
	if( buf->apos != pos )
		buf = 0;
	
	return buf;
	// END
}

Files::Buffer Files::GetBuf(File f, int pos)
{
	// VAR
	Buffer buf;

	// BEGIN
	Files* _this = _inst();
	buf = f->firstbuf;
	while( (buf->apos != pos) && (buf->next != f->firstbuf) )
		buf = buf->next;
	
	if( buf->apos != pos )
	{
		/* allocate new buffer */
		if( f->nofbufs < _this->MaxBufs )
		{
			buf = new Files::BufferRecord();
			buf->next = f->firstbuf->next;
			f->firstbuf->next = buf;
			f->nofbufs++;
		}else
		{
			/* reuse a buffer */
			f->firstbuf = buf;
			if( buf->mod )
				_this->WriteBuf(f, buf);
			
		}
		if( pos <= f->aleng )
			_this->ReadBuf(f, buf, pos);
		else
		{
			buf->apos = pos;
			buf->lim = 0;
			buf->mod = FALSE;
		}
	}
	return buf;
	// END
}

void Files::Unbuffer(File f)
{
	// VAR
	int i;
	int k;
	Buffer buf;
	Index inx;
	FileDir::FileHeader head;

	// BEGIN
	Files* _this = _inst();
	buf = f->firstbuf;
	do 
	{
		if( buf->mod )
			_this->WriteBuf(f, buf);
		
		buf = buf->next;
	} while( !( buf == f->firstbuf ) );
	k = DIV((f->aleng + (_this->XS - _this->STS)),_this->XS);
	i = 0;
	while( i < k )
	{
		inx = f->ext[i];
		i++;
		if( inx->mod )
		{
			if( inx->adr == 0 )
			{
				Kernel::_inst()->AllocSector(f->sechint, inx->adr);
				f->sechint = inx->adr;
				f->modH = TRUE;
			}
			Kernel::_inst()->PutSector(inx->adr, inx->sec);
			inx->mod = FALSE;
		}
	}
	if( f->modH )
	{
		Kernel::_inst()->GetSector(f->sec[0], head);
		_this->UpdateHeader(f, head);
		Kernel::_inst()->PutSector(f->sec[0], head);
		f->modH = FALSE;
	}
	// END
}

void Files::Register(File f)
{
	// BEGIN
	Files* _this = _inst();
	if( (f != 0) && (f->name[0] != 0x0) )
	{
		_this->Unbuffer(f);
		if( !f->registered_ )
		{
			FileDir::_inst()->Insert(f->name, f->sec[0]);
			f->registered_ = TRUE;
			f->next = _this->root;
			_this->root = SYSTEM::_inst()->VAL(INTEGER, f);
		}
	}
	// END
}

void Files::Close(File f)
{
	// BEGIN
	Files* _this = _inst();
	if( f != 0 )
		_this->Unbuffer(f);
	
	// END
}

void Files::Purge(File f)
{
	// VAR
	int a;
	int i;
	int j;
	int k;
	FileDir::IndexSector ind;

	// BEGIN
	Files* _this = _inst();
	if( f != 0 )
	{
		a = f->aleng + 1;
		f->aleng = 0;
		f->bleng = _this->HS;
		if( a <= _this->STS )
			i = a;
		else
		{
			i = _this->STS;
			a -= i;
			j = MOD((a - 1),_this->XS);
			k = DIV((a - 1),_this->XS);
			while( k >= 0 )
			{
				Kernel::_inst()->GetSector(f->ext[k].adr, ind);
				do 
				{
					j--;
					Kernel::_inst()->FreeSector(ind[j]);
				} while( !( j == 0 ) );
				Kernel::_inst()->FreeSector(f->ext[k].adr);
				j = _this->XS;
				k--;
			}
		}
		do 
		{
			i--;
			Kernel::_inst()->FreeSector(f->sec[i]);
		} while( !( i == 0 ) );
	}
	// END
}

void Files::Delete(_ValArray<char> name, int& res)
{
	// VAR
	DiskAdr adr;
	FileDir::FileName namebuf;

	// BEGIN
	Files* _this = _inst();
	_this->Check(name, namebuf, res);
	if( res == 0 )
	{
		FileDir::_inst()->Delete(namebuf, adr);
		if( adr == 0 )
			res = 2;
		
	}
	// END
}

void Files::Rename(_ValArray<char> old, _ValArray<char> new_, int& res)
{
	// VAR
	DiskAdr adr;
	FileDir::FileName oldbuf;
	FileDir::FileName newbuf_;
	FileDir::FileHeader head;

	// BEGIN
	Files* _this = _inst();
	_this->Check(old, oldbuf, res);
	if( res == 0 )
	{
		_this->Check(new_, newbuf_, res);
		if( res == 0 )
		{
			FileDir::_inst()->Delete(oldbuf, adr);
			if( adr != 0 )
			{
				FileDir::_inst()->Insert(newbuf_, adr);
				Kernel::_inst()->GetSector(adr, head);
				head.name = newbuf_;
				Kernel::_inst()->PutSector(adr, head);
			}else
				res = 2;

		}
	}
	// END
}

int Files::Length(File f)
{
	// BEGIN
	Files* _this = _inst();
	return f->aleng * _this->SS + f->bleng - _this->HS;
	// END
}

int Files::Date(File f)
{
	// BEGIN
	Files* _this = _inst();
	return f->date;
	// END
}

/* ---------------------------Read--------------------------- */
void Files::Set(Rider& r, File f, int pos)
{
	// VAR
	int a;
	int b;

	// BEGIN
	Files* _this = _inst();
	r.eof = FALSE;
	r.res = 0;
	if( f != 0 )
	{
		if( pos < 0 )
		{
			a = 0;
			b = _this->HS;
		}else if( pos < f->aleng * _this->SS + f->bleng - _this->HS )
		{
			a = DIV((pos + _this->HS),_this->SS);
			b = MOD((pos + _this->HS),_this->SS);
		}else
		{
			a = f->aleng;
			b = f->bleng;
		}
		r.file = f;
		r.apos = a;
		r.bpos = b;
		r.buf = f->firstbuf;
	}else
		r.file = 0;

	// END
}

int Files::Pos(Rider& r)
{
	// BEGIN
	Files* _this = _inst();
	return r.apos * _this->SS + r.bpos - _this->HS;
	// END
}

Files::File Files::Base(Rider& r)
{
	// BEGIN
	Files* _this = _inst();
	return r.file;
	// END
}

void Files::ReadByte(Rider& r, uint8_t& x)
{
	// VAR
	Buffer buf;

	// BEGIN
	Files* _this = _inst();
	if( r.apos != r.buf->apos )
		r.buf = _this->GetBuf(r.file, r.apos);
	
	if( r.bpos < r.buf->lim )
	{
		x = r.buf->data[r.bpos];
		r.bpos++;
	}else if( r.apos < r.file->aleng )
	{
		r.apos++;
		buf = _this->Buf(r.file, r.apos);
		if( buf == 0 )
		{
			if( r.buf->mod )
				_this->WriteBuf(r.file, r.buf);
			
			_this->ReadBuf(r.file, r.buf, r.apos);
		}else
			r.buf = buf;

		x = r.buf->data[0];
		r.bpos = 1;
	}else
	{
		x = 0;
		r.eof = TRUE;
	}
	// END
}

void Files::ReadBytes(Rider& r, _VarArray<uint8_t> x, int n)
{
	// VAR
	int i;

	// BEGIN
	Files* _this = _inst();
	/* this implementation is to be improved */
	i = 0;
	while( i < n )
	{
		_this->ReadByte(r, x[i]);
		i++;
	}
	// END
}

void Files::Read(Rider& r, char& ch)
{
	// VAR
	/* same as ReadByte */
	Buffer buf;

	// BEGIN
	Files* _this = _inst();
	if( r.apos != r.buf->apos )
		r.buf = _this->GetBuf(r.file, r.apos);
	
	if( r.bpos < r.buf->lim )
	{
		ch = char( r.buf->data[r.bpos] );
		r.bpos++;
	}else if( r.apos < r.file->aleng )
	{
		r.apos++;
		buf = _this->Buf(r.file, r.apos);
		if( buf == 0 )
		{
			if( r.buf->mod )
				_this->WriteBuf(r.file, r.buf);
			
			_this->ReadBuf(r.file, r.buf, r.apos);
		}else
			r.buf = buf;

		ch = char( r.buf->data[0] );
		r.bpos = 1;
	}else
	{
		ch = 0x0;
		r.eof = TRUE;
	}
	// END
}

void Files::ReadInt(Rider& R, int& x)
{
	// VAR
	uint8_t x0;
	uint8_t x1;
	uint8_t x2;
	uint8_t x3;

	// BEGIN
	Files* _this = _inst();
	_this->ReadByte(R, x0);
	_this->ReadByte(R, x1);
	_this->ReadByte(R, x2);
	_this->ReadByte(R, x3);
	x = ((x3 * 0x100 + x2) * 0x100 + x1) * 0x100 + x0;
	// END
}

void Files::ReadSet(Rider& R, _Set& s)
{
	// VAR
	int n;

	// BEGIN
	Files* _this = _inst();
	_this->ReadInt(R, SYSTEM::_inst()->VAL(INTEGER, s));
	// END
}

void Files::ReadReal(Rider& R, float& x)
{
	// VAR
	int n;

	// BEGIN
	Files* _this = _inst();
	_this->ReadInt(R, SYSTEM::_inst()->VAL(INTEGER, x));
	// END
}

void Files::ReadString(Rider& R, _VarArray<char> x)
{
	// VAR
	int i;
	char ch;

	// BEGIN
	Files* _this = _inst();
	i = 0;
	_this->Read(R, ch);
	while( ch != 0x0 )
	{
		if( i < LEN(x) - 1 )
		{
			x[i] = ch;
			i++;
		}
		_this->Read(R, ch);
	}
	x[i] = 0x0;
	// END
}

void Files::ReadNum(Rider& R, int& x)
{
	// VAR
	int n;
	int y;
	uint8_t b;

	// BEGIN
	Files* _this = _inst();
	n = 32;
	y = 0;
	_this->ReadByte(R, b);
	while( b >= 0x80 )
	{
		y = ROR(y + b - 0x80, 7);
		n -= 7;
		_this->ReadByte(R, b);
	}
	if( n <= 4 )
		x = ROR(y + MOD(b,0x10), 4);
	else
		x = ASR(ROR(y + b, 7), n - 7);

	// END
}

/* ---------------------------Write--------------------------- */
void Files::NewExt(File f)
{
	// VAR
	int i;
	int k;
	Index ext;

	// BEGIN
	Files* _this = _inst();
	k = DIV((f->aleng - _this->STS),_this->XS);
	ext = new Files::IndexRecord();
	ext->adr = 0;
	ext->mod = TRUE;
	f->ext[k] = ext;
	i = _this->XS;
	do 
	{
		i--;
		ext->sec[i] = 0;
	} while( !( i == 0 ) );
	// END
}

void Files::WriteByte(Rider& r, uint8_t x)
{
	// VAR
	File f;
	Buffer buf;

	// BEGIN
	Files* _this = _inst();
	if( r.apos != r.buf->apos )
		r.buf = _this->GetBuf(r.file, r.apos);
	
	if( r.bpos >= r.buf->lim )
	{
		if( r.bpos < _this->SS )
		{
			r.buf->lim++;
			r.file->bleng++;
			r.file->modH = TRUE;
		}else
		{
			f = r.file;
			_this->WriteBuf(f, r.buf);
			r.apos++;
			buf = _this->Buf(r.file, r.apos);
			if( buf == 0 )
			{
				if( r.apos <= f->aleng )
					_this->ReadBuf(f, r.buf, r.apos);
				else
				{
					r.buf->apos = r.apos;
					r.buf->lim = 1;
					f->aleng = f->aleng + 1;
					f->bleng = 1;
					f->modH = TRUE;
					if( MOD((f->aleng - _this->STS),_this->XS) == 0 )
						_this->NewExt(f);
					
				}
			}else
				r.buf = buf;

			r.bpos = 0;
		}
	}
	r.buf->data[r.bpos] = x;
	r.bpos++;
	r.buf->mod = TRUE;
	// END
}

void Files::WriteBytes(Rider& r, _ValArray<uint8_t> x, int n)
{
	// VAR
	int i;

	// BEGIN
	Files* _this = _inst();
	/* this implementation is to be improed */
	i = 0;
	while( i < n )
	{
		_this->WriteByte(r, x[i]);
		i++;
	}
	// END
}

void Files::Write(Rider& r, char ch)
{
	// VAR
	File f;
	Buffer buf;

	// BEGIN
	Files* _this = _inst();
	/* same as WriteByte */
	if( r.apos != r.buf->apos )
		r.buf = _this->GetBuf(r.file, r.apos);
	
	if( r.bpos >= r.buf->lim )
	{
		if( r.bpos < _this->SS )
		{
			r.buf->lim++;
			r.file->bleng++;
			r.file->modH = TRUE;
		}else
		{
			f = r.file;
			_this->WriteBuf(f, r.buf);
			r.apos++;
			buf = _this->Buf(r.file, r.apos);
			if( buf == 0 )
			{
				if( r.apos <= f->aleng )
					_this->ReadBuf(f, r.buf, r.apos);
				else
				{
					r.buf->apos = r.apos;
					r.buf->lim = 1;
					f->aleng = f->aleng + 1;
					f->bleng = 1;
					f->modH = TRUE;
					if( MOD((f->aleng - _this->STS),_this->XS) == 0 )
						_this->NewExt(f);
					
				}
			}else
				r.buf = buf;

			r.bpos = 0;
		}
	}
	r.buf->data[r.bpos] = int( ch );
	r.bpos++;
	r.buf->mod = TRUE;
	// END
}

void Files::WriteInt(Rider& R, int x)
{
	// BEGIN
	Files* _this = _inst();
	_this->WriteByte(R, MOD(x,0x100));
	_this->WriteByte(R, MOD(DIV(x,0x100),0x100));
	_this->WriteByte(R, MOD(DIV(x,0x10000),0x100));
	_this->WriteByte(R, MOD(DIV(x,0x1000000),0x100));
	// END
}

void Files::WriteSet(Rider& R, _Set s)
{
	// BEGIN
	Files* _this = _inst();
	_this->WriteInt(R, int( s ));
	// END
}

void Files::WriteReal(Rider& R, float x)
{
	// BEGIN
	Files* _this = _inst();
	_this->WriteInt(R, int( x ));
	// END
}

void Files::WriteString(Rider& R, _ValArray<char> x)
{
	// VAR
	int i;
	char ch;

	// BEGIN
	Files* _this = _inst();
	i = 0;
	do 
	{
		ch = x[i];
		_this->Write(R, ch);
		i++;
	} while( !( ch == 0x0 ) );
	// END
}

void Files::WriteNum(Rider& R, int x)
{
	// BEGIN
	Files* _this = _inst();
	while( (x < -0x40) || (x >= 0x40) )
	{
		_this->WriteByte(R, MOD(x,0x80) + 0x80);
		x = ASR(x, 7);
	}
	_this->WriteByte(R, MOD(x,0x80));
	// END
}

/* ---------------------------System use--------------------------- */
void Files::Init()
{
	// BEGIN
	Files* _this = _inst();
	_this->root = 0;
	Kernel::_inst()->Init();
	FileDir::_inst()->Init();
	// END
}

/* after mark phase of garbage collection */
void Files::RestoreList()
{
	// VAR
	int f;
	int f0;

	// BEGIN
	Files* _this = _inst();
	/* field "next" has offset 0 */
	while( mark(_this->root) == 0 )
		SYSTEM::_inst()->GET(_this->root, _this->root);
	
	f = _this->root;
	while( f != 0 )
	{
		f0 = f;
		do 
		{
			SYSTEM::_inst()->GET(f0, f0);
		} while( !( mark(f0) != 0 ) );
		SYSTEM::_inst()->PUT(f, f0);
		f = f0;
	}
	// END
}

Files::Files()
{
	; // empty statement
}

Files::~Files()
{
	s_inst.release();
}

