#ifndef __ObFiles_H__
#define __ObFiles_H__

// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17

#include <OberonSystem/Ob_Global.h>
#include <OberonSystem/ObSYSTEM.h>
#include <OberonSystem/ObKernel.h>
#include <OberonSystem/ObFileDir.h>

namespace Ob
{
	class Files : public _Root
	{
	public:
		/* NW 11.1.86 / 22.9.93 / 25.5.95 / 25.12.95 / 15.8.2013 */
		static Files* _inst();
		Files();
		~Files();

		// CONST
		/* A file consists of a sequence of pages. The first page
    contains the header. Part of the header is the page table, an array
    of disk addresses to the pages. A file is referenced through riders.
    A rider indicates a current position and refers to a file */
		static const int MaxBufs = 4;
		static const int HS = FileDir::_inst()->HeaderSize;
		static const int SS = FileDir::_inst()->SectorSize;
		static const int STS = FileDir::_inst()->SecTabSize;
		static const int XS = FileDir::_inst()->IndexSize;

		// TYPE
		struct Rider;
		struct FileDesc;
		struct BufferRecord;
		struct IndexRecord;

		typedef int DiskAdr;
		typedef FileDesc* File;
		typedef BufferRecord* Buffer;
		typedef IndexRecord* Index;
		struct Rider : public _Root {
			int apos;
			int bpos;
			Buffer buf;
			bool eof;
			File file;
			int res;
		};
		struct FileDesc : public _Root {
			int aleng;
			int bleng;
			int date;
			_FxArray<Index,FileDir::_inst()->ExTabSize> ext;
			Buffer firstbuf;
			bool modH;
			FileDir::FileName name;
			int next;
			int nofbufs;
			bool registered_;
			FileDir::SectorTable sec;
			DiskAdr sechint;
		};
		/* list of files invisible to the GC */
		struct BufferRecord : public _Root {
			int apos;
			FileDir::DataSector data;
			int lim;
			bool mod;
			Buffer next;
		};
		struct IndexRecord : public _Root {
			DiskAdr adr;
			bool mod;
			FileDir::IndexSector sec;
		};

		// VAR
		/* aleng * SS + bleng = length (including header)
      apos * SS + bpos = current position
      0 <= bpos <= lim <= SS
      0 <= apos <= aleng < PgTabSize
      (apos < aleng) & (lim = SS) OR (apos = aleng)  */
		/* File */
		/* list of open files */
		int root;

		// PROC
		static void Check(_ValArray<char> s, _VarArray<char> name, int& res);
		File Old(_ValArray<char> name);
		File New(_ValArray<char> name);
		static void UpdateHeader(File f, FileDir::FileHeader& F);
		static void ReadBuf(File f, Buffer buf, int pos);
		static void WriteBuf(File f, Buffer buf);
		Buffer Buf(File f, int pos);
		Buffer GetBuf(File f, int pos);
		static void Unbuffer(File f);
		static void Register(File f);
		static void Close(File f);
		static void Purge(File f);
		static void Delete(_ValArray<char> name, int& res);
		static void Rename(_ValArray<char> old, _ValArray<char> new_, int& res);
		int Length(File f);
		int Date(File f);
		static void Set(Rider& r, File f, int pos);
		int Pos(Rider& r);
		File Base(Rider& r);
		static void ReadByte(Rider& r, uint8_t& x);
		static void ReadBytes(Rider& r, _VarArray<uint8_t> x, int n);
		static void Read(Rider& r, char& ch);
		static void ReadInt(Rider& R, int& x);
		static void ReadSet(Rider& R, _Set& s);
		static void ReadReal(Rider& R, float& x);
		static void ReadString(Rider& R, _VarArray<char> x);
		static void ReadNum(Rider& R, int& x);
		static void NewExt(File f);
		static void WriteByte(Rider& r, uint8_t x);
		static void WriteBytes(Rider& r, _ValArray<uint8_t> x, int n);
		static void Write(Rider& r, char ch);
		static void WriteInt(Rider& R, int x);
		static void WriteSet(Rider& R, _Set s);
		static void WriteReal(Rider& R, float x);
		static void WriteString(Rider& R, _ValArray<char> x);
		static void WriteNum(Rider& R, int x);
		static void Init();
		static void RestoreList();

	};
}

#endif // __ObFiles_H__