// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObFonts.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<Fonts> s_inst;

const int Fonts::FontFileId;

Fonts* Fonts::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new Fonts() );
	return s_inst.get();
}

void Fonts::GetPat(Font fnt, char ch, int& dx, int& x, int& y, int& w, int& h, int& patadr)
{
	// VAR
	int pa;
	uint8_t dxb;
	uint8_t xb;
	uint8_t yb;
	uint8_t wb;
	uint8_t hb;

	// BEGIN
	Fonts* _this = _inst();
	pa = fnt->T[MOD(int( ch ),0x80)];
	patadr = pa;
	SYSTEM::_inst()->GET(pa - 3, dxb);
	SYSTEM::_inst()->GET(pa - 2, xb);
	SYSTEM::_inst()->GET(pa - 1, yb);
	SYSTEM::_inst()->GET(pa, wb);
	SYSTEM::_inst()->GET(pa + 1, hb);
	dx = dxb;
	x = xb;
	y = yb;
	w = wb;
	h = hb;
	if( yb < 128 )
		y = yb;
	else
		y = yb - 256;

	// END
}

Fonts::Font Fonts::This(_ValArray<char> name)
{
	// TYPE
	struct RunRec;
	struct BoxRec;

	struct RunRec : public _Root {
		uint8_t beg;
		uint8_t end;
	};
	struct BoxRec : public _Root {
		uint8_t dx;
		uint8_t h;
		uint8_t w;
		uint8_t x;
		uint8_t y;
	};

	// VAR
	Font F;
	LargeFont LF;
	Files::File f;
	Files::Rider R;
	uint8_t NofRuns;
	uint8_t NofBoxes;
	int NofBytes;
	uint8_t height;
	uint8_t minX;
	uint8_t maxX;
	uint8_t minY;
	uint8_t maxY;
	int i;
	int j;
	int k;
	int m;
	int n;
	int a;
	int a0;
	uint8_t b;
	uint8_t beg;
	uint8_t end;
	_FxArray<RunRec,16> run;
	_FxArray<BoxRec,512> box;

	// BEGIN
	Fonts* _this = _inst();
	F = _this->root;
	while( (F != 0) && (name != F->name) )
		F = F->next;
	
	if( F == 0 )
	{
		f = Files::_inst()->Old(name);
		if( f != 0 )
		{
			Files::_inst()->Set(R, f, 0);
			Files::_inst()->ReadByte(R, b);
			if( b == _this->FontFileId )
			{
				/* abstraction */
				Files::_inst()->ReadByte(R, b);
				/* family */
				Files::_inst()->ReadByte(R, b);
				/* variant */
				Files::_inst()->ReadByte(R, b);
				F = new Fonts::FontDesc();
				F->name = name;
				RdInt16(R, height);
				RdInt16(R, minX);
				RdInt16(R, maxX);
				RdInt16(R, minY);
				RdInt16(R, maxY);
				RdInt16(R, NofRuns);
				NofBoxes = 0;
				k = 0;
				while( k != NofRuns )
				{
					RdInt16(R, beg);
					run[k].beg = beg;
					RdInt16(R, end);
					run[k].end = end;
					NofBoxes = NofBoxes + end - beg;
					k++;
				}
				NofBytes = 5;
				j = 0;
				while( j != NofBoxes )
				{
					RdInt16(R, box[j].dx);
					RdInt16(R, box[j].x);
					RdInt16(R, box[j].y);
					RdInt16(R, box[j].w);
					RdInt16(R, box[j].h);
					NofBytes = NofBytes + 5 + DIV((box[j].w + 7),8) * box[j].h;
					j++;
				}
				if( NofBytes < 2300 )
					F = new Fonts::FontDesc();
				else
				{
					LF = new Fonts::LargeFontDesc();
					F = LF;
				}
				F->name = name;
				F->height = height;
				F->minX = minX;
				F->maxX = maxX;
				F->maxY = maxY;
				if( minY >= 0x80 )
					F->minY = minY - 0x100;
				else
					F->minY = minY;

				a0 = SYSTEM::_inst()->ADR(F->raster);
				SYSTEM::_inst()->PUT(a0, 0x0);
				SYSTEM::_inst()->PUT(a0 + 1, 0x0);
				SYSTEM::_inst()->PUT(a0 + 2, 0x0);
				SYSTEM::_inst()->PUT(a0 + 3, 0x0);
				SYSTEM::_inst()->PUT(a0 + 4, 0x0);
				/* null pattern for characters not in a run */
				a0 += 2;
				a = a0 + 3;
				j = 0;
				k = 0;
				m = 0;
				while( k < NofRuns )
				{
					while( (m < run[k].beg) && (m < 128) )
					{
						F->T[m] = a0;
						m++;
					}
					while( (m < run[k].end) && (m < 128) )
					{
						F->T[m] = a + 3;
						SYSTEM::_inst()->PUT(a, box[j].dx);
						SYSTEM::_inst()->PUT(a + 1, box[j].x);
						SYSTEM::_inst()->PUT(a + 2, box[j].y);
						SYSTEM::_inst()->PUT(a + 3, box[j].w);
						SYSTEM::_inst()->PUT(a + 4, box[j].h);
						a += 5;
						n = DIV((box[j].w + 7),8) * box[j].h;
						while( n != 0 )
						{
							n--;
							Files::_inst()->ReadByte(R, b);
							SYSTEM::_inst()->PUT(a, b);
							a++;
						}
						j++;
						m++;
					}
					k++;
				}
				while( m < 128 )
				{
					F->T[m] = a0;
					m++;
				}
				F->next = _this->root;
				_this->root = F;
			}else
				/* bad file id */
				F = _this->Default;

		}else
			/* font file not available */
			F = _this->Default;

	}
	return F;
	// END
}

/* remove all but first two from font list */
void Fonts::Free()
{
	// VAR
	Font f;

	// BEGIN
	Fonts* _this = _inst();
	f = _this->root->next;
	if( f != 0 )
		f = f->next;
	
	f->next = 0;
	// END
}

Fonts::Fonts()
{
	// BEGIN
	root = 0;
	Default = This("Oberon10.Scn.Fnt");
	// END
}

Fonts::~Fonts()
{
	s_inst.release();
}

