// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObGraphicFrames.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<GraphicFrames> s_inst;

const int GraphicFrames::drawobj;
const int GraphicFrames::drawobjs;
const int GraphicFrames::drawobjd;
const int GraphicFrames::drawnorm;
const int GraphicFrames::drawsel;
const int GraphicFrames::drawdel;
const int GraphicFrames::markW;

GraphicFrames* GraphicFrames::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new GraphicFrames() );
	return s_inst.get();
}

/* Exported procedures:
    Restore, Focus, Selected, This, Draw, DrawNorm, Erase,
    DrawObj, EraseObj, Change, Defocus, Deselect, Macro, Open */
/* set mark in corner of frame */
void GraphicFrames::SetChangeMark(Frame F, int col)
{
	// BEGIN
	GraphicFrames* _this = _inst();
	if( F->H > 16 )
	{
		if( col == 0 )
			Display::_inst()->ReplConst(Display::_inst()->black, F->X + F->W - 12, F->Y + F->H - 12, 8, 8, Display::_inst()->replace);
		else
			Display::_inst()->CopyPattern(Display::_inst()->white, Display::_inst()->block, F->X + F->W - 12, F->Y + F->H - 12, Display::_inst()->paint);

	}
	// END
}

void GraphicFrames::Restore(Frame F)
{
	// VAR
	int x;
	int x0;
	int y;
	DrawMsg M;

	// BEGIN
	GraphicFrames* _this = _inst();
	F->X1 = F->X + F->W;
	F->Y1 = F->Y + F->H;
	F->x = DIV((F->X + F->Xg),16) * 16;
	F->y = DIV((F->Y + F->Yg),16) * 16;
	F->marked = FALSE;
	F->mark.next = 0;
	Oberon::_inst()->RemoveMarks(F->X, F->Y, F->W, F->H);
	Display::_inst()->ReplConst(F->col, F->X, F->Y, F->W, F->H, 0);
	if( F->ticked )
	{
		x0 = DIV((F->X + 15),16) * 16;
		y = DIV((F->Y + 15),16) * 16;
		while( y < F->Y1 )
		{
			x = x0;
			while( x < F->X1 )
			{
				Display::_inst()->Dot(Display::_inst()->white, x, y, Display::_inst()->replace);
				x += 16;
			}
			y += 16;
		}
	}
	M.f = F;
	M.x = F->x;
	M.y = F->y;
	M.col = 0;
	M.mode = 0;
	Graphics::_inst()->Draw(F->graph, M);
	if( F->graph->changed )
		_this->SetChangeMark(F, 1);
	
	// END
}

void GraphicFrames::FlipCross(int X, int Y)
{
	// BEGIN
	GraphicFrames* _this = _inst();
	if( X < _this->CL )
	{
		if( X < 7 )
			X = 7;
		else if( X > _this->DW - 7 )
			X = _this->DW - 7;
		
	}else
	{
		if( X < _this->CL + 7 )
			X = _this->CL + 7;
		else if( X > _this->CL + _this->DW - 7 )
			X = _this->CL + _this->DW - 7;
		
	}
	if( Y < 7 )
		Y = 7;
	else if( Y > _this->DH )
		Y = _this->DH - 7;
	
	Display::_inst()->CopyPattern(Display::_inst()->white, Display::_inst()->cross, X - 7, Y - 7, Display::_inst()->invert);
	// END
}

GraphicFrames::Frame GraphicFrames::Focus()
{
	// VAR
	FocusQuery FQ;

	// BEGIN
	GraphicFrames* _this = _inst();
	FQ.f = 0;
	Viewers::_inst()->Broadcast(FQ);
	return FQ.f;
	// END
}

GraphicFrames::Frame GraphicFrames::Selected()
{
	// VAR
	SelQuery SQ;

	// BEGIN
	GraphicFrames* _this = _inst();
	SQ.f = 0;
	SQ.time = 0;
	Viewers::_inst()->Broadcast(SQ);
	return SQ.f;
	// END
}

GraphicFrames::Frame GraphicFrames::This(int x, int y)
{
	// VAR
	PosQuery PQ;

	// BEGIN
	GraphicFrames* _this = _inst();
	PQ.f = 0;
	PQ.x = x;
	PQ.y = y;
	Viewers::_inst()->Broadcast(PQ);
	return PQ.f;
	// END
}

void GraphicFrames::Mark(Frame F, int mode)
{
	// VAR
	ChangedMsg CM;

	// BEGIN
	GraphicFrames* _this = _inst();
	CM.f = F;
	CM.graph = F->graph;
	CM.mode = mode;
	Viewers::_inst()->Broadcast(CM);
	// END
}

void GraphicFrames::Draw(Frame F)
{
	// VAR
	UpdateMsg UM;

	// BEGIN
	GraphicFrames* _this = _inst();
	UM.id = _this->drawsel;
	UM.graph = F->graph;
	Viewers::_inst()->Broadcast(UM);
	// END
}

void GraphicFrames::DrawNorm(Frame F)
{
	// VAR
	UpdateMsg UM;

	// BEGIN
	GraphicFrames* _this = _inst();
	UM.id = _this->drawnorm;
	UM.graph = F->graph;
	Viewers::_inst()->Broadcast(UM);
	// END
}

void GraphicFrames::Erase(Frame F)
{
	// VAR
	UpdateMsg UM;

	// BEGIN
	GraphicFrames* _this = _inst();
	UM.id = _this->drawdel;
	UM.graph = F->graph;
	Viewers::_inst()->Broadcast(UM);
	_this->Mark(F, 1);
	// END
}

void GraphicFrames::DrawObj(Frame F, Graphics::Object obj)
{
	// VAR
	UpdateMsg UM;

	// BEGIN
	GraphicFrames* _this = _inst();
	UM.id = _this->drawobj;
	UM.graph = F->graph;
	UM.obj = obj;
	Viewers::_inst()->Broadcast(UM);
	// END
}

void GraphicFrames::EraseObj(Frame F, Graphics::Object obj)
{
	// VAR
	UpdateMsg UM;

	// BEGIN
	GraphicFrames* _this = _inst();
	UM.id = _this->drawobjd;
	UM.graph = F->graph;
	UM.obj = obj;
	Viewers::_inst()->Broadcast(UM);
	// END
}

void GraphicFrames::Change(Frame F, Graphics::Msg& msg)
{
	// BEGIN
	GraphicFrames* _this = _inst();
	if( F != 0 )
	{
		_this->Erase(F);
		Graphics::_inst()->Change(F->graph, msg);
		_this->Draw(F);
	}
	// END
}

void GraphicFrames::FlipMark(int x, int y)
{
	// BEGIN
	GraphicFrames* _this = _inst();
	Display::_inst()->ReplConst(Display::_inst()->white, x - 7, y, 15, 1, 2);
	Display::_inst()->ReplConst(Display::_inst()->white, x, y - 7, 1, 15, 2);
	// END
}

void GraphicFrames::Defocus(Frame F)
{
	// VAR
	Location m;

	// BEGIN
	GraphicFrames* _this = _inst();
	_this->newcap_ = 0;
	if( F->marked )
	{
		_this->FlipMark(F->mark.x, F->mark.y);
		m = F->mark.next;
		while( m != 0 )
		{
			_this->FlipMark(m->x, m->y);
			m = m->next;
		}
		F->marked = FALSE;
		F->mark.next = 0;
	}
	// END
}

void GraphicFrames::Deselect(Frame F)
{
	// VAR
	UpdateMsg UM;

	// BEGIN
	GraphicFrames* _this = _inst();
	if( F != 0 )
	{
		UM.id = _this->drawnorm;
		UM.graph = F->graph;
		Viewers::_inst()->Broadcast(UM);
		Graphics::_inst()->Deselect(F->graph);
	}
	// END
}

void GraphicFrames::Macro(_ValArray<char> Lname, _ValArray<char> Mname)
{
	// VAR
	int x;
	int y;
	Frame F;
	Graphics::Macro mac;
	Graphics::MacHead mh;
	Graphics::Library L;

	// BEGIN
	GraphicFrames* _this = _inst();
	F = _this->Focus();
	if( F != 0 )
	{
		x = F->mark.x - F->x;
		y = F->mark.y - F->y;
		Graphics::_inst()->GetLib(Lname, FALSE, L);
		if( L != 0 )
		{
			mh = Graphics::_inst()->ThisMac(L, Mname);
			if( mh != 0 )
			{
				_this->Deselect(F);
				_this->Defocus(F);
				mac = new Graphics::MacroDesc();
				mac->x = x;
				mac->y = y;
				mac->w = mh->w;
				mac->h = mh->h;
				mac->mac = mh;
				mac->do_ = Graphics::_inst()->MacMethod;
				mac->col = Oberon::_inst()->CurCol;
				Graphics::_inst()->Add(F->graph, mac);
				_this->DrawObj(F, mac);
				_this->Mark(F, 1);
			}
		}else
		{
			Texts::_inst()->WriteString(_this->W, Lname);
			Texts::_inst()->WriteString(_this->W, " not available");
			Texts::_inst()->WriteLn(_this->W);
			Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
		}
	}
	// END
}

Graphics::Caption GraphicFrames::CaptionCopy(Frame F, int x1, int y1, Texts::Text T, int beg, int end)
{
	// VAR
	char ch;
	int dx;
	int w;
	int x2;
	int y2;
	int w1;
	int h1;
	Graphics::Caption cap;
	int pat;
	Texts::Reader R;

	// BEGIN
	GraphicFrames* _this = _inst();
	Texts::_inst()->Write(_this->W, 0x0D);
	cap = new Graphics::CaptionDesc();
	cap->len = end - beg;
	cap->pos = Graphics::_inst()->T->len + 1;
	cap->do_ = Graphics::_inst()->CapMethod;
	Texts::_inst()->OpenReader(R, T, beg);
	Texts::_inst()->Read(R, ch);
	_this->W.fnt = R.fnt;
	_this->W.col = R.col;
	w = 0;
	cap->x = x1 - F->x;
	cap->y = y1 - F->y + R.fnt->minY;
	while( beg < end )
	{
		Fonts::_inst()->GetPat(R.fnt, ch, dx, x2, y2, w1, h1, pat);
		w += dx;
		beg++;
		Texts::_inst()->Write(_this->W, ch);
		Texts::_inst()->Read(R, ch);
	}
	cap->w = w;
	cap->h = _this->W.fnt->height;
	cap->col = _this->W.col;
	Texts::_inst()->Append(Graphics::_inst()->T, _this->W.buf);
	Graphics::_inst()->Add(F->graph, cap);
	_this->Mark(F, 1);
	return cap;
	// END
}

void GraphicFrames::NewLine(Frame F, Graphics::Graph G, int x, int y, int w, int h)
{
	// VAR
	Graphics::Line line;

	// BEGIN
	GraphicFrames* _this = _inst();
	line = new Graphics::LineDesc();
	line->col = Oberon::_inst()->CurCol;
	line->x = x - F->x;
	line->y = y - F->y;
	line->w = w;
	line->h = h;
	line->do_ = Graphics::_inst()->LineMethod;
	Graphics::_inst()->Add(G, line);
	_this->Mark(F, 1);
	// END
}

void GraphicFrames::Edit(Frame F, int x0, int y0, _Set k0)
{
	// VAR
	Graphics::Object obj;
	int x1;
	int y1;
	int w;
	int h;
	int t;
	int beg;
	int end;
	int time;
	_Set k1;
	_Set k2;
	Location mark;
	Location newmark_;
	Texts::Text T;
	Frame Fd;
	Graphics::Graph G;

	// BEGIN
	GraphicFrames* _this = _inst();
	k1 = k0;
	G = F->graph;
	do 
	{
		Input::_inst()->Mouse(k2, x1, y1);
		k1 = k1 + k2;
		x1 -= MOD((x1 - F->x),4);
		y1 -= MOD((y1 - F->y),4);
		Oberon::_inst()->DrawMouse(_this->Crosshair, x1, y1);
	} while( !( k2 == ( _Set() ) ) );
	Oberon::_inst()->FadeMouse();
	/* left key */
	if( k0 == ( _Set() + (2) ) )
	{
		w = ABS(x1 - x0);
		h = ABS(y1 - y0);
		if( k1 == ( _Set() + (2) ) )
		{
			/* set mark */
			if( (w < 7) && (h < 7) )
			{
				if( (x1 - _this->markW >= F->X) && (x1 + _this->markW < F->X1) && (y1 - _this->markW >= F->Y) && (y1 + _this->markW < F->Y1) )
				{
					_this->Defocus(F);
					Oberon::_inst()->PassFocus(Viewers::_inst()->This(F->X, F->Y));
					F->mark.x = x1;
					F->mark.y = y1;
					F->marked = TRUE;
					_this->FlipMark(x1, y1);
				}
			}else
			{
				/* draw line */
				_this->Deselect(F);
				if( w < h )
				{
					if( y1 < y0 )
						y0 = y1;
					
					_this->NewLine(F, G, x0, y0, Graphics::_inst()->width, h);
				}else
				{
					if( x1 < x0 )
						x0 = x1;
					
					_this->NewLine(F, G, x0, y0, w, Graphics::_inst()->width);
				}
				_this->Draw(F);
			}
		}else if( k1 == ( _Set() + (2) + (1) ) )
		{
			/* copy text selection to mark */
			_this->Deselect(F);
			Oberon::_inst()->GetSelection(T, beg, end, time);
			if( time >= 0 )
			{
				_this->DrawObj(F, _this->CaptionCopy(F, x1, y1, T, beg, end));
				_this->Mark(F, 1);
			}
		}else if( k1 == ( _Set() + (2) + (0) ) )
		{
			/* set secondary mark */
			if( F->marked )
			{
				newmark_ = new GraphicFrames::LocDesc();
				newmark_->x = x1;
				newmark_->y = y1;
				newmark_->next = 0;
				_this->FlipMark(x1, y1);
				mark = F->mark.next;
				if( mark == 0 )
					F->mark.next = newmark_;
				else
				{
					while( mark->next != 0 )
						mark = mark->next;
					
					mark->next = newmark_;
				}
			}
		}
	}else if( k0 == ( _Set() + (1) ) )
	{
		/* middle key */
		/* move */
		if( k1 == ( _Set() + (1) ) )
		{
			if( (x0 != x1) || (y0 != y1) )
			{
				Fd = _this->This(x1, y1);
				_this->Erase(F);
				if( Fd == F )
					Graphics::_inst()->Move(G, x1 - x0, y1 - y0);
				else if( (Fd != 0) && (Fd->graph == G) )
					Graphics::_inst()->Move(G, DIV((x1 - Fd->x - x0 + F->x),4) * 4, DIV((y1 - Fd->y - y0 + F->y),4) * 4);
				
				_this->Draw(F);
				_this->Mark(F, 1);
			}
		}else if( k1 == ( _Set() + (1) + (2) ) )
		{
			/* copy */
			Fd = _this->This(x1, y1);
			if( Fd != 0 )
			{
				_this->DrawNorm(F);
				if( Fd == F )
					Graphics::_inst()->Copy(G, G, x1 - x0, y1 - y0);
				else
				{
					_this->Deselect(Fd);
					Graphics::_inst()->Copy(G, Fd->graph, DIV((x1 - Fd->x - x0 + F->x),4) * 4, DIV((y1 - Fd->y - y0 + F->y),4) * 4);
				}
				_this->Draw(Fd);
				_this->Mark(F, 1);
			}
		}else if( k1 == ( _Set() + (1) + (0) ) )
		{
			/* shift graph */
			F->Xg += x1 - x0;
			F->Yg += y1 - y0;
			_this->Restore(F);
		}
	}else if( k0 == ( _Set() + (0) ) )
	{
		/* right key: select */
		_this->newcap_ = 0;
		if( k1 == ( _Set() + (0) ) )
			_this->Deselect(F);
		
		if( (ABS(x0 - x1) < 7) && (ABS(y0 - y1) < 7) )
		{
			obj = Graphics::_inst()->ThisObj(G, x1 - F->x, y1 - F->y);
			if( obj != 0 )
			{
				Graphics::_inst()->SelectObj(G, obj);
				_this->DrawObj(F, obj);
			}
		}else
		{
			if( x1 < x0 )
			{
				t = x0;
				x0 = x1;
				x1 = t;
			}
			if( y1 < y0 )
			{
				t = y0;
				y0 = y1;
				y1 = t;
			}
			Graphics::_inst()->SelectArea(G, x0 - F->x, y0 - F->y, x1 - F->x, y1 - F->y);
			_this->Draw(F);
		}
	}
	// END
}

void GraphicFrames::NewCaption(Frame F, int col, Fonts::Font font)
{
	// BEGIN
	GraphicFrames* _this = _inst();
	Texts::_inst()->Write(_this->W, 0x0D);
	_this->newcap_ = new Graphics::CaptionDesc();
	_this->newcap_->x = F->mark.x - F->x;
	_this->newcap_->y = F->mark.y - F->y + font->minY;
	_this->newcap_->w = 0;
	_this->newcap_->h = font->height;
	_this->newcap_->col = col;
	_this->newcap_->pos = Graphics::_inst()->T->len + 1;
	_this->newcap_->len = 0;
	_this->newcap_->do_ = Graphics::_inst()->CapMethod;
	Graphics::_inst()->Add(F->graph, _this->newcap_);
	_this->W.fnt = font;
	_this->Mark(F, 1);
	// END
}

void GraphicFrames::InsertChar(Frame F, char ch)
{
	// VAR
	int w1;
	int h1;
	DispMsg DM;

	// BEGIN
	GraphicFrames* _this = _inst();
	DM.graph = F->graph;
	Fonts::_inst()->GetPat(_this->W.fnt, ch, DM.w, DM.x1, DM.y1, w1, h1, DM.pat);
	DM.y1 -= _this->W.fnt->minY;
	if( _this->newcap_->x + _this->newcap_->w + DM.w + F->x < F->X1 )
	{
		Viewers::_inst()->Broadcast(DM);
		_this->newcap_->w += DM.w;
		_this->newcap_->len++;
		Texts::_inst()->Write(_this->W, ch);
	}
	Texts::_inst()->Append(Graphics::_inst()->T, _this->W.buf);
	// END
}

void GraphicFrames::DeleteChar(Frame F)
{
	// VAR
	int w1;
	int h1;
	char ch;
	int pos;
	DispMsg DM;
	Texts::Reader R;

	// BEGIN
	GraphicFrames* _this = _inst();
	DM.graph = F->graph;
	if( _this->newcap_->len > 0 )
	{
		/* backspace */
		pos = Graphics::_inst()->T->len;
		Texts::_inst()->OpenReader(R, Graphics::_inst()->T, pos - 1);
		Texts::_inst()->Read(R, ch);
		if( ch >= ' ' )
		{
			Fonts::_inst()->GetPat(R.fnt, ch, DM.w, DM.x1, DM.y1, w1, h1, DM.pat);
			_this->newcap_->w -= DM.w;
			_this->newcap_->len--;
			DM.y1 -= R.fnt->minY;
			Viewers::_inst()->Broadcast(DM);
			Texts::_inst()->Delete(Graphics::_inst()->T, pos - 1, pos, _this->TBuf);
		}
	}
	// END
}

void GraphicFrames::GetSelection(Frame F, Texts::Text& text, int& beg, int& end, int& time)
{
	// VAR
	Graphics::Object obj;

	// BEGIN
	GraphicFrames* _this = _inst();
	obj = F->graph->sel;
	if( (obj != 0) && (F->graph->time >= time) )
	{
		if( dynamic_cast<>(obj) != 0  ){
			beg = obj.pos;
			end = obj.pos + obj.len;
			text = Graphics::_inst()->T;
			time = F->graph->time;
		} 
	}
	// END
}

void GraphicFrames::Handle(Display::Frame G, Display::FrameMsg& M)
{
	// VAR
	int x;
	int y;
	int h;
	DispMsg DM;
	DrawMsg dM;
	Frame G1;

	// BEGIN
	GraphicFrames* _this = _inst();
	if( dynamic_cast<>(G) != 0  ){
		if( dynamic_cast<>(M) != 0  ){
			if( M.id == Oberon::_inst()->track )
			{
				x = M.X - MOD((M.X - G.x),4);
				y = M.Y - MOD((M.Y - G.y),4);
				if( M.keys != ( _Set() ) )
					_this->Edit(G, x, y, M.keys);
				else
					Oberon::_inst()->DrawMouse(_this->Crosshair, x, y);

			}else if( M.id == Oberon::_inst()->consume )
			{
				/* DEL */
				if( M.ch == 0x7F )
				{
					_this->Erase(G);
					Graphics::_inst()->Delete(G.graph);
					_this->Mark(G, 1);
				}else if( (M.ch >= 0x20) && (M.ch < 0x7F) )
				{
					if( _this->newcap_ != 0 )
					{
						_this->InsertChar(G, M.ch);
						_this->Mark(G, 1);
					}else if( G.marked )
					{
						_this->Defocus(G);
						_this->Deselect(G);
						_this->NewCaption(G, M.col, M.fnt);
						_this->InsertChar(G, M.ch);
					}
				}else if( (M.ch == 0x8) && (_this->newcap_ != 0) )
				{
					_this->DeleteChar(G);
					_this->Mark(G, 1);
				}
			}
		} else if( dynamic_cast<>(M) != 0  ){
			if( M.graph == G.graph )
			{
				dM.f = G;
				dM.x = G.x;
				dM.y = G.y;
				dM.col = 0;
				if( M.id == _this->drawobj )
				{
					dM.mode = 0;
					M.obj->do_->draw(M.obj, dM);
				}else if( M.id == _this->drawobjs )
				{
					dM.mode = 1;
					M.obj->do_->draw(M.obj, dM);
				}else if( M.id == _this->drawobjd )
				{
					dM.mode = 3;
					M.obj->do_->draw(M.obj, dM);
				}else if( M.id == _this->drawsel )
				{
					dM.mode = 0;
					Graphics::_inst()->DrawSel(G.graph, dM);
				}else if( M.id == _this->drawnorm )
				{
					dM.mode = 2;
					Graphics::_inst()->DrawSel(G.graph, dM);
				}else if( M.id == _this->drawdel )
				{
					dM.mode = 3;
					Graphics::_inst()->DrawSel(G.graph, dM);
				}
			}
		} else if( dynamic_cast<>(M) != 0  ){
			if( M.graph == G.graph )
				_this->SetChangeMark(G, M.mode);
			
		} else if( dynamic_cast<>(M) != 0  ){
			if( (G.graph->sel != 0) && (M.time < G.graph->time) )
			{
				M.f = G._to<Frame>();
				M.time = G.graph->time;
			}
		} else if( dynamic_cast<>(M) != 0  ){
			if( G.marked )
				M.f = G;
			
		} else if( dynamic_cast<>(M) != 0  ){
			if( (G.X <= M.x) && (M.x < G.X1) && (G.Y <= M.y) && (M.y < G.Y1) )
				M.f = G;
			
		} else if( dynamic_cast<>(M) != 0  ){
			DM = M;
			x = G.x + _this->newcap_->x + _this->newcap_->w;
			y = G.y + _this->newcap_->y;
			if( (DM.graph == G.graph) && (x >= G.X) && (x + DM.w < G.X1) && (y >= G.Y) && (y < G.Y1) )
			{
				Display::_inst()->CopyPattern(Oberon::_inst()->CurCol, DM.pat, x + DM.x1, y + DM.y1, 2);
				Display::_inst()->ReplConst(Display::_inst()->white, x, y, DM.w, _this->newcap_->h, 2);
			}
		} else if( dynamic_cast<>(M) != 0  ){
			if( M.id == Oberon::_inst()->neutralize )
			{
				Oberon::_inst()->RemoveMarks(G.X, G.Y, G.W, G.H);
				_this->Defocus(G);
				_this->DrawNorm(G);
				Graphics::_inst()->Deselect(G.graph);
			}else if( M.id == Oberon::_inst()->defocus )
				_this->Defocus(G);
			
		} else if( dynamic_cast<>(M) != 0  ){
			_this->GetSelection(G, M.text, M.beg, M.end, M.time);
		} else if( dynamic_cast<>(M) != 0  ){
			Oberon::_inst()->RemoveMarks(G.X, G.Y, G.W, G.H);
			_this->Defocus(G);
			G1 = new GraphicFrames::FrameDesc();
			G1 = G;
			M.F = G1;
		} else if( dynamic_cast<>(M) != 0  ){
			G.Y = M.Y;
			G.H = M.H;
			_this->Restore(G);
		} 
	} 
	// END
}

void GraphicFrames::Store(Frame F, _ValArray<char> name)
{
	// BEGIN
	GraphicFrames* _this = _inst();
	_this->Mark(F, 0);
	Graphics::_inst()->WriteFile(F->graph, name);
	// END
}

/* ------------------- Draw Methods ----------------------- */
void GraphicFrames::ReplConst(Frame F, int col, int x, int y, int w, int h, int mode)
{
	// BEGIN
	GraphicFrames* _this = _inst();
	if( x < F->X )
	{
		w -= F->X - x;
		x = F->X;
	}
	if( x + w >= F->X1 )
		w = F->X1 - x;
	
	if( y < F->Y )
	{
		h -= F->Y - y;
		y = F->Y;
	}
	if( y + h >= F->Y1 )
		h = F->Y1 - y;
	
	Display::_inst()->ReplConst(col, x, y, w, h, mode);
	// END
}

void GraphicFrames::ReplPattern(Frame F, int col, int patadr, int x, int y, int w, int h, int mode)
{
	// BEGIN
	GraphicFrames* _this = _inst();
	if( x < F->X )
	{
		w -= F->X - x;
		x = F->X;
	}
	if( x + w >= F->X1 )
		w = F->X1 - x;
	
	if( y < F->Y )
	{
		h -= F->Y - y;
		y = F->Y;
	}
	if( y + h >= F->Y1 )
		h = F->Y1 - y;
	
	Display::_inst()->ReplPattern(col, patadr, x, y, w, h, mode);
	// END
}

void GraphicFrames::DrawLine(Graphics::Object obj, Graphics::Msg& M)
{
	// VAR
	/* M.mode = 0: draw according to state,
        = 1: normal -> selected,
        = 2: selected -> normal,
        = 3: erase */
	int x;
	int y;
	int w;
	int h;
	int col;
	Frame f;

	// BEGIN
	GraphicFrames* _this = _inst();
	if( dynamic_cast<>(M) != 0  ){
		x = obj->x + M.x;
		y = obj->y + M.y;
		w = obj->w;
		h = obj->h;
		f = M.f;
		if( (x + w > f->X) && (x < f->X1) && (y + h > f->Y) && (y < f->Y1) )
		{
			col = obj->col;
			if( (M.mode == 0) && obj->selected || (M.mode == 1) )
				_this->ReplPattern(f, col, Display::_inst()->grey, x, y, w, h, Display::_inst()->replace);
			else if( ( _Set() + (0) + (2) ).contains( M.mode ) )
				_this->ReplConst(f, col, x, y, w, h, Display::_inst()->replace);
			else if( M.mode == 3 )
				/* erase */
				_this->ReplConst(f, Display::_inst()->black, x, y, w, h, Display::_inst()->replace);
			
		}
	} 
	// END
}

void GraphicFrames::DrawCaption(Graphics::Object obj, Graphics::Msg& M)
{
	// VAR
	int x;
	int y;
	int dx;
	int x0;
	int x1;
	int y0;
	int y1;
	int w;
	int h;
	int w1;
	int h1;
	int col;
	Frame f;
	char ch;
	int pat;
	Fonts::Font fnt;
	Texts::Reader R;

	// BEGIN
	GraphicFrames* _this = _inst();
	if( dynamic_cast<>(M) != 0  ){
		x = obj->x + M.x;
		y = obj->y + M.y;
		w = obj->w;
		h = obj->h;
		f = M.f;
		if( (f->X <= x) && (x <= f->X1) && (f->Y <= y) && (y + h <= f->Y1) )
		{
			if( x + w > f->X1 )
				w = f->X1 - x;
			
			Texts::_inst()->OpenReader(R, Graphics::_inst()->T, obj->_to<Graphics::Caption>()->pos);
			Texts::_inst()->Read(R, ch);
			if( M.mode == 0 )
			{
				if( ch >= ' ' )
				{
					fnt = R.fnt;
					x0 = x;
					y0 = y - fnt->minY;
					col = obj->col;
					do 
					{
						Fonts::_inst()->GetPat(fnt, ch, dx, x1, y1, w1, h1, pat);
						if( x0 + x1 + w1 <= f->X1 )
						{
							Display::_inst()->CopyPattern(col, pat, x0 + x1, y0 + y1, Display::_inst()->paint);
							x0 += dx;
							Texts::_inst()->Read(R, ch);
						}else
							ch = 0x0;

					} while( !( ch < ' ' ) );
					if( obj->selected )
						_this->ReplConst(f, Display::_inst()->white, x, y, w, h, Display::_inst()->invert);
					
				}
			}else if( ( _Set() + (1) + (2) ).contains( M.mode ) )
				_this->ReplConst(f, Display::_inst()->white, x, y, w, h, Display::_inst()->invert);
			else if( M.mode == 3 )
				_this->ReplConst(f, Display::_inst()->black, x, y, w, h, Display::_inst()->replace);
			
		}
	} 
	// END
}

void GraphicFrames::DrawMacro(Graphics::Object obj, Graphics::Msg& M)
{
	// VAR
	int x;
	int y;
	int w;
	int h;
	Frame f;
	DrawMsg M1;

	// BEGIN
	GraphicFrames* _this = _inst();
	if( dynamic_cast<>(M) != 0  ){
		x = obj->x + M.x;
		y = obj->y + M.y;
		w = obj->w;
		h = obj->h;
		f = M.f;
		if( (x + w > f->X) && (x < f->X1) && (y + h > f->Y) && (y < f->Y1) )
		{
			M1.x = x;
			M1.y = y;
			if( M.mode == 0 )
			{
				M1.f = f;
				M1.col = obj->col;
				M1.mode = 0;
				Graphics::_inst()->DrawMac(obj->_to<Graphics::Macro>()->mac, M1);
				if( obj->selected )
					_this->ReplPattern(f, Display::_inst()->white, _this->dotted_, x, y, w, h, Display::_inst()->invert);
				
			}else if( ( _Set() + (1) + (2) ).contains( M.mode ) )
				_this->ReplPattern(f, Display::_inst()->white, _this->dotted_, x, y, w, h, Display::_inst()->invert);
			else if( M.mode == 3 )
				_this->ReplConst(f, Display::_inst()->black, x, y, w, h, Display::_inst()->replace);
			
		}
	} 
	// END
}

/* --------------------------------------------------------------- */
void GraphicFrames::Open(Frame G, Graphics::Graph graph)
{
	// BEGIN
	GraphicFrames* _this = _inst();
	G->graph = graph;
	G->Xg = 0;
	G->Yg = 0;
	G->x = G->X;
	G->y = G->Y;
	G->col = Display::_inst()->black;
	G->marked = FALSE;
	G->mark.next = 0;
	G->ticked = TRUE;
	G->handle = _this->Handle;
	// END
}

GraphicFrames::GraphicFrames()
{
	// BEGIN
	DW = Display::_inst()->Width - 8;
	DH = Display::_inst()->Height - 8;
	CL = 0;
	Texts::_inst()->OpenWriter(W);
	tack = SYSTEM::_inst()->ADR("07074122140814224100");
	dotted_ = SYSTEM::_inst()->ADR("2004000011111111000000000000000000000000");
	dotted1_ = SYSTEM::_inst()->ADR("2004000011111111000000004444444400000000");
	Crosshair.Fade = FlipCross;
	Crosshair.Draw = FlipCross;
	Graphics::_inst()->InstallDrawMethods(DrawLine, DrawCaption, DrawMacro);
	// END
}

GraphicFrames::~GraphicFrames()
{
	s_inst.release();
}

