#ifndef __ObGraphicFrames_H__
#define __ObGraphicFrames_H__

// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17

#include <OberonSystem/Ob_Global.h>
#include <OberonSystem/ObSYSTEM.h>
#include <OberonSystem/ObDisplay.h>
#include <OberonSystem/ObViewers.h>
#include <OberonSystem/ObInput.h>
#include <OberonSystem/ObFonts.h>
#include <OberonSystem/ObTexts.h>
#include <OberonSystem/ObGraphics.h>
#include <OberonSystem/ObOberon.h>
#include <OberonSystem/ObMenuViewers.h>

namespace Ob
{
	class GraphicFrames : public _Root
	{
	public:
		/* NW 18.4.88 / 18.11.2013 / 27.8.2018 */
		static GraphicFrames* _inst();
		GraphicFrames();
		~GraphicFrames();

		// CONST
		/* update message ids */
		static const int drawobj = 1;
		static const int drawobjs = 2;
		static const int drawobjd = 3;
		static const int drawnorm = 4;
		static const int drawsel = 5;
		static const int drawdel = 6;
		static const int markW = 5;

		// TYPE
		struct LocDesc;
		struct FrameDesc;
		struct DrawMsg;
		struct UpdateMsg;
		struct ChangedMsg;
		struct SelQuery;
		struct FocusQuery;
		struct PosQuery;
		struct DispMsg;

		typedef FrameDesc* Frame;
		typedef LocDesc* Location;
		struct LocDesc : public _Root {
			Location next;
			int x;
			int y;
		};
		struct FrameDesc : public Display::FrameDesc {
			int X1;
			int Xg;
			int Y1;
			int Yg;
			int col;
			Graphics::Graph graph;
			LocDesc mark;
			bool marked;
			bool ticked;
			int x;
			int y;
		};
		/* pos rel to graph origin */
		/* right and upper margins */
		/* x = X + Xg, y = Y + Yg */
		struct DrawMsg : public Graphics::Msg {
			int col;
			Frame f;
			int mode;
			int x;
			int y;
		};
		struct UpdateMsg : public Display::FrameMsg {
			Graphics::Graph graph;
			int id;
			Graphics::Object obj;
		};
		struct ChangedMsg : public Display::FrameMsg {
			Frame f;
			Graphics::Graph graph;
			int mode;
		};
		struct SelQuery : public Display::FrameMsg {
			Frame f;
			int time;
		};
		struct FocusQuery : public Display::FrameMsg {
			Frame f;
		};
		struct PosQuery : public Display::FrameMsg {
			Frame f;
			int x;
			int y;
		};
		struct DispMsg : public Display::FrameMsg {
			Graphics::Graph graph;
			int pat;
			int w;
			int x1;
			int y1;
		};

		// VAR
		Oberon::Marker Crosshair;
		/* patterns */
		int tack;
		int dotted_;
		int dotted1_;
		Graphics::Caption newcap_;
		Texts::Buffer TBuf;
		int DW;
		int DH;
		int CL;
		Texts::Writer W;

		// PROC
		static void SetChangeMark(Frame F, int col);
		static void Restore(Frame F);
		static void FlipCross(int X, int Y);
		Frame Focus();
		Frame Selected();
		Frame This(int x, int y);
		static void Mark(Frame F, int mode);
		static void Draw(Frame F);
		static void DrawNorm(Frame F);
		static void Erase(Frame F);
		static void DrawObj(Frame F, Graphics::Object obj);
		static void EraseObj(Frame F, Graphics::Object obj);
		static void Change(Frame F, Graphics::Msg& msg);
		static void FlipMark(int x, int y);
		static void Defocus(Frame F);
		static void Deselect(Frame F);
		static void Macro(_ValArray<char> Lname, _ValArray<char> Mname);
		Graphics::Caption CaptionCopy(Frame F, int x1, int y1, Texts::Text T, int beg, int end);
		static void NewLine(Frame F, Graphics::Graph G, int x, int y, int w, int h);
		static void Edit(Frame F, int x0, int y0, _Set k0);
		static void NewCaption(Frame F, int col, Fonts::Font font);
		static void InsertChar(Frame F, char ch);
		static void DeleteChar(Frame F);
		static void GetSelection(Frame F, Texts::Text& text, int& beg, int& end, int& time);
		static void Handle(Display::Frame G, Display::FrameMsg& M);
		static void Store(Frame F, _ValArray<char> name);
		static void ReplConst(Frame F, int col, int x, int y, int w, int h, int mode);
		static void ReplPattern(Frame F, int col, int patadr, int x, int y, int w, int h, int mode);
		static void DrawLine(Graphics::Object obj, Graphics::Msg& M);
		static void DrawCaption(Graphics::Object obj, Graphics::Msg& M);
		static void DrawMacro(Graphics::Object obj, Graphics::Msg& M);
		static void Open(Frame G, Graphics::Graph graph);

	};
}

#endif // __ObGraphicFrames_H__