// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObGraphics.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<Graphics> s_inst;

const int Graphics::NameLen;
const char Graphics::GraphFileId;
const char Graphics::LibFileId;

Graphics* Graphics::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new Graphics() );
	return s_inst.get();
}

void Graphics::New(Object obj)
{
	// BEGIN
	Graphics* _this = _inst();
	_this->new_ = obj;
	// END
}

void Graphics::Add(Graph G, Object obj)
{
	// BEGIN
	Graphics* _this = _inst();
	obj->marked = FALSE;
	obj->selected = TRUE;
	obj->next = G->first;
	G->first = obj;
	G->sel = obj;
	G->time = Oberon::_inst()->Time();
	G->changed = TRUE;
	// END
}

Graphics::Object Graphics::ThisObj(Graph G, int x, int y)
{
	// VAR
	Object obj;

	// BEGIN
	Graphics* _this = _inst();
	obj = G->first;
	while( (obj != 0) && !obj->do_->selectable(obj, x, y) )
		obj = obj->next;
	
	return obj;
	// END
}

void Graphics::SelectObj(Graph G, Object obj)
{
	// BEGIN
	Graphics* _this = _inst();
	if( obj != 0 )
	{
		obj->selected = TRUE;
		G->sel = obj;
		G->time = Oberon::_inst()->Time();
	}
	// END
}

void Graphics::SelectArea(Graph G, int x0, int y0, int x1, int y1)
{
	// VAR
	Object obj;
	int t;

	// BEGIN
	Graphics* _this = _inst();
	obj = G->first;
	if( x1 < x0 )
	{
		t = x0;
		x0 = x1;
		x1 = t;
	}
	if( y1 < y0 )
	{
		t = y0;
		y0 = y1;
		y1 = t;
	}
	while( obj != 0 )
	{
		if( (x0 <= obj->x) && (obj->x + obj->w <= x1) && (y0 <= obj->y) && (obj->y + obj->h <= y1) )
		{
			obj->selected = TRUE;
			G->sel = obj;
		}
		obj = obj->next;
	}
	if( G->sel != 0 )
		G->time = Oberon::_inst()->Time();
	
	// END
}

void Graphics::Draw(Graph G, Msg& M)
{
	// VAR
	Object obj;

	// BEGIN
	Graphics* _this = _inst();
	obj = G->first;
	while( obj != 0 )
	{
		obj->do_->draw(obj, M);
		obj = obj->next;
	}
	// END
}

void Graphics::List(Graph G)
{
	// VAR
	Object obj;
	int tag;

	// BEGIN
	Graphics* _this = _inst();
	obj = G->first;
	while( obj != 0 )
	{
		Texts::_inst()->Write(_this->XW, 0x9);
		Texts::_inst()->WriteHex(_this->XW, int( obj ));
		Texts::_inst()->Write(_this->XW, 0x9);
		Texts::_inst()->WriteInt(_this->XW, obj->x, 5);
		Texts::_inst()->WriteInt(_this->XW, obj->y, 5);
		Texts::_inst()->WriteInt(_this->XW, obj->w, 5);
		Texts::_inst()->WriteInt(_this->XW, obj->h, 5);
		Texts::_inst()->Write(_this->XW, '/');
		SYSTEM::_inst()->GET(int( obj ) - 8, tag);
		Texts::_inst()->WriteHex(_this->XW, tag);
		SYSTEM::_inst()->GET(int( obj ) - 4, tag);
		Texts::_inst()->WriteHex(_this->XW, tag);
		Texts::_inst()->WriteLn(_this->XW);
		obj = obj->next;
	}
	Texts::_inst()->Append(Oberon::_inst()->Log, _this->XW.buf);
	// END
}

/* ----------------procedures operating on selection ------------------- */
void Graphics::Deselect(Graph G)
{
	// VAR
	Object obj;

	// BEGIN
	Graphics* _this = _inst();
	obj = G->first;
	G->sel = 0;
	G->time = 0;
	while( obj != 0 )
	{
		obj->selected = FALSE;
		obj = obj->next;
	}
	// END
}

void Graphics::DrawSel(Graph G, Msg& M)
{
	// VAR
	Object obj;

	// BEGIN
	Graphics* _this = _inst();
	obj = G->first;
	while( obj != 0 )
	{
		if( obj->selected )
			obj->do_->draw(obj, M);
		
		obj = obj->next;
	}
	// END
}

void Graphics::Change(Graph G, Msg& M)
{
	// VAR
	Object obj;

	// BEGIN
	Graphics* _this = _inst();
	obj = G->first;
	G->changed = TRUE;
	while( obj != 0 )
	{
		if( obj->selected )
			obj->do_->change(obj, M);
		
		obj = obj->next;
	}
	// END
}

void Graphics::Move(Graph G, int dx, int dy)
{
	// VAR
	Object obj;
	Object ob0;
	int x0;
	int x1;
	int y0;
	int y1;

	// BEGIN
	Graphics* _this = _inst();
	obj = G->first;
	G->changed = TRUE;
	while( obj != 0 )
	{
		if( obj->selected && !(dynamic_cast<Caption>(obj) != 0 ) )
		{
			x0 = obj->x;
			x1 = obj->w + x0;
			y0 = obj->y;
			y1 = obj->h + y0;
			/* vertical move */
			if( dx == 0 )
			{
				ob0 = G->first;
				while( ob0 != 0 )
				{
					if( !ob0->selected && (dynamic_cast<Line>(ob0) != 0 ) && (x0 <= ob0->x) && (ob0->x <= x1) && (ob0->w < ob0->h) )
					{
						if( (y0 <= ob0->y) && (ob0->y <= y1) )
						{
							ob0->y += dy;
							ob0->h -= dy;
							ob0->marked = TRUE;
						}else if( (y0 <= ob0->y + ob0->h) && (ob0->y + ob0->h <= y1) )
						{
							ob0->h += dy;
							ob0->marked = TRUE;
						}
					}
					ob0 = ob0->next;
				}
			}else if( dy == 0 )
			{
				/* horizontal move */
				ob0 = G->first;
				while( ob0 != 0 )
				{
					if( !ob0->selected && (dynamic_cast<Line>(ob0) != 0 ) && (y0 <= ob0->y) && (ob0->y <= y1) && (ob0->h < ob0->w) )
					{
						if( (x0 <= ob0->x) && (ob0->x <= x1) )
						{
							ob0->x += dx;
							ob0->w -= dx;
							ob0->marked = TRUE;
						}else if( (x0 <= ob0->x + ob0->w) && (ob0->x + ob0->w <= x1) )
						{
							ob0->w += dx;
							ob0->marked = TRUE;
						}
					}
					ob0 = ob0->next;
				}
			}
		}
		obj = obj->next;
	}
	/* now move */
	obj = G->first;
	while( obj != 0 )
	{
		if( obj->selected )
		{
			obj->x += dx;
			obj->y += dy;
		}
		obj->marked = FALSE;
		obj = obj->next;
	}
	// END
}

void Graphics::Copy(Graph Gs, Graph Gd, int dx, int dy)
{
	// VAR
	Object obj;

	// BEGIN
	Graphics* _this = _inst();
	obj = Gs->first;
	Gd->changed = TRUE;
	while( obj != 0 )
	{
		if( obj->selected )
		{
			obj->do_->new_;
			obj->do_->copy(obj, _this->new_);
			_this->new_->x += dx;
			_this->new_->y += dy;
			obj->selected = FALSE;
			_this->Add(Gd, _this->new_);
		}
		obj = obj->next;
	}
	_this->new_ = 0;
	// END
}

void Graphics::Delete(Graph G)
{
	// VAR
	Object obj;
	Object pred;

	// BEGIN
	Graphics* _this = _inst();
	G->sel = 0;
	G->changed = TRUE;
	obj = G->first;
	while( (obj != 0) && obj->selected )
		obj = obj->next;
	
	G->first = obj;
	if( obj != 0 )
	{
		pred = obj;
		obj = obj->next;
		while( obj != 0 )
		{
			if( obj->selected )
				pred->next = obj->next;
			else
				pred = obj;

			obj = obj->next;
		}
	}
	// END
}

/*  ---------------------- Storing -----------------------  */
void Graphics::WMsg(_ValArray<char> s0, _ValArray<char> s1)
{
	// BEGIN
	Graphics* _this = _inst();
	Texts::_inst()->WriteString(_this->W, s0);
	Texts::_inst()->WriteString(_this->W, s1);
	Texts::_inst()->WriteLn(_this->W);
	Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
	// END
}

void Graphics::InitContext(Context& C)
{
	// BEGIN
	Graphics* _this = _inst();
	C.nofonts = 0;
	C.noflibs = 0;
	C.nofclasses = 4;
	C.class_[1] = _this->LineMethod->new_;
	C.class_[2] = _this->CapMethod->new_;
	C.class_[3] = _this->MacMethod->new_;
	// END
}

int Graphics::FontNo(Files::Rider& W, Context& C, Fonts::Font fnt)
{
	// VAR
	int fno;

	// BEGIN
	Graphics* _this = _inst();
	fno = 0;
	while( (fno < C.nofonts) && (C.font[fno] != fnt) )
		fno++;
	
	if( fno == C.nofonts )
	{
		Files::_inst()->WriteByte(W, 0);
		Files::_inst()->WriteByte(W, 0);
		Files::_inst()->WriteByte(W, fno);
		Files::_inst()->WriteString(W, fnt->name);
		C.font[fno] = fnt;
		C.nofonts++;
	}
	return fno;
	// END
}

void Graphics::StoreElems(Files::Rider& W, Context& C, Object obj)
{
	// VAR
	int cno;

	// BEGIN
	Graphics* _this = _inst();
	while( obj != 0 )
	{
		cno = 1;
		while( (cno < C.nofclasses) && (obj->do_->new_ != C.class_[cno]) )
			cno++;
		
		if( cno == C.nofclasses )
		{
			Files::_inst()->WriteByte(W, 0);
			Files::_inst()->WriteByte(W, 2);
			Files::_inst()->WriteByte(W, cno);
			Files::_inst()->WriteString(W, obj->do_->module);
			Files::_inst()->WriteString(W, obj->do_->allocator);
			C.class_[cno] = obj->do_->new_;
			C.nofclasses++;
		}
		obj->do_->write(obj, cno, W, C);
		obj = obj->next;
	}
	Files::_inst()->WriteByte(W, 255);
	// END
}

void Graphics::Store(Graph G, Files::Rider& W)
{
	// VAR
	Context C;

	// BEGIN
	Graphics* _this = _inst();
	_this->InitContext(C);
	_this->StoreElems(W, C, G->first);
	G->changed = FALSE;
	// END
}

void Graphics::WriteObj(Files::Rider& W, int cno, Object obj)
{
	// BEGIN
	Graphics* _this = _inst();
	Files::_inst()->WriteByte(W, cno);
	Files::_inst()->WriteInt(W, obj->y * 0x10000 + obj->x);
	Files::_inst()->WriteInt(W, obj->h * 0x10000 + obj->w);
	Files::_inst()->WriteByte(W, obj->col);
	// END
}

void Graphics::WriteFile(Graph G, _ValArray<char> name)
{
	// VAR
	Files::File F;
	Files::Rider W;
	Context C;

	// BEGIN
	Graphics* _this = _inst();
	F = Files::_inst()->New(name);
	Files::_inst()->Set(W, F, 0);
	Files::_inst()->Write(W, _this->GraphFileId);
	_this->InitContext(C);
	_this->StoreElems(W, C, G->first);
	Files::_inst()->Register(F);
	// END
}

void Graphics::Print(Graph G, int x0, int y0)
{
	// VAR
	Object obj;

	// BEGIN
	Graphics* _this = _inst();
	obj = G->first;
	while( obj != 0 )
	{
		obj->do_->print(obj, x0, y0);
		obj = obj->next;
	}
	// END
}

/*  ---------------------- Loading ------------------------  */
void Graphics::GetClass(_ValArray<char> module, _ValArray<char> allocator, Modules::Command& com)
{
	// VAR
	Modules::Module mod;

	// BEGIN
	Graphics* _this = _inst();
	Modules::_inst()->Load(module, mod);
	if( mod != 0 )
	{
		com = Modules::_inst()->ThisCommand(mod, allocator);
		if( com == 0 )
			_this->WMsg(allocator, " unknown");
		
	}else
	{
		_this->WMsg(module, " not available");
		com = 0;
	}
	// END
}

Fonts::Font Graphics::Font(Files::Rider& R, Context& C)
{
	// VAR
	uint8_t fno;

	// BEGIN
	Graphics* _this = _inst();
	Files::_inst()->ReadByte(R, fno);
	return C.font[fno];
	// END
}

void Graphics::ReadObj(Files::Rider& R, Object obj)
{
	// VAR
	int xy;
	int wh;
	uint8_t dmy;

	// BEGIN
	Graphics* _this = _inst();
	Files::_inst()->ReadInt(R, xy);
	obj->y = DIV(xy,0x10000);
	obj->x = DIV(xy * 0x10000,0x10000);
	Files::_inst()->ReadInt(R, wh);
	obj->h = DIV(wh,0x10000);
	obj->w = DIV(wh * 0x10000,0x10000);
	Files::_inst()->ReadByte(R, obj->col);
	// END
}

void Graphics::LoadElems(Files::Rider& R, Context& C, Object& fobj)
{
	// VAR
	uint8_t cno;
	uint8_t m;
	uint8_t n;
	uint8_t len;
	int pos;
	Object obj;
	Fonts::Font fnt;
	_FxArray<char,32> name;
	_FxArray<char,32> name1;

	// BEGIN
	Graphics* _this = _inst();
	obj = 0;
	Files::_inst()->ReadByte(R, cno);
	while( !R.eof && (cno < 255) )
	{
		if( cno == 0 )
		{
			Files::_inst()->ReadByte(R, m);
			Files::_inst()->ReadByte(R, n);
			Files::_inst()->ReadString(R, name);
			if( m == 0 )
			{
				fnt = Fonts::_inst()->This(name);
				C.font[n] = fnt;
			}else if( m == 1 )
				_this->GetLib0(name, FALSE, C.lib[n]);
			else if( m == 2 )
			{
				Files::_inst()->ReadString(R, name1);
				_this->GetClass(name, name1, C.class_[n]);
			}
		}else if( C.class_[cno] != 0 )
		{
			C.class_[cno];
			_this->ReadObj(R, _this->new_);
			_this->new_->selected = FALSE;
			_this->new_->marked = FALSE;
			_this->new_->next = obj;
			obj = _this->new_;
			_this->new_->do_->read(_this->new_, R, C);
		}else
		{
			_this->ReadObj(R, _this->new_);
			Files::_inst()->ReadByte(R, len);
			pos = Files::_inst()->Pos(R);
			Files::_inst()->Set(R, Files::_inst()->Base(R), pos + len);
		}
		Files::_inst()->ReadByte(R, cno);
	}
	_this->new_ = 0;
	fobj = obj;
	// END
}

void Graphics::Load(Graph G, Files::Rider& R)
{
	// VAR
	Context C;

	// BEGIN
	Graphics* _this = _inst();
	G->sel = 0;
	_this->InitContext(C);
	_this->LoadElems(R, C, G->first);
	// END
}

void Graphics::Open(Graph G, _ValArray<char> name)
{
	// VAR
	char tag;
	Files::File F;
	Files::Rider R;
	Context C;

	// BEGIN
	Graphics* _this = _inst();
	G->first = 0;
	G->sel = 0;
	G->time = 0;
	G->changed = FALSE;
	F = Files::_inst()->Old(name);
	if( F != 0 )
	{
		Files::_inst()->Set(R, F, 0);
		Files::_inst()->Read(R, tag);
		if( tag == _this->GraphFileId )
		{
			_this->InitContext(C);
			_this->LoadElems(R, C, G->first);
			_this->res = 0;
		}else
			_this->res = 1;

	}else
		_this->res = 2;

	// END
}

void Graphics::SetWidth(int w)
{
	// BEGIN
	Graphics* _this = _inst();
	_this->width = w;
	// END
}

/*  --------------------- Macros / Libraries -----------------------  */
void Graphics::GetLib(_ValArray<char> name, bool replace, Library& Lib)
{
	// VAR
	int i;
	int wh;
	char ch;
	Library L;
	MacHead mh;
	Object obj;
	Files::File F;
	Files::Rider R;
	Context C;
	_FxArray<char,32> Lname;
	_FxArray<char,32> Fname;

	// BEGIN
	Graphics* _this = _inst();
	L = _this->FirstLib;
	i = 0;
	while( (L != 0) && (L->name != name) )
		L = L->next;
	
	if( L == 0 )
	{
		/* load library from file */
		i = 0;
		while( name[i] > 0x0 )
		{
			Fname[i] = name[i];
			i++;
		}
		Fname[i] = '.';
		Fname[i + 1] = 'L';
		Fname[i + 2] = 'i';
		Fname[i + 3] = 'b';
		Fname[i + 4] = 0x0;
		F = Files::_inst()->Old(Fname);
		if( F != 0 )
		{
			_this->WMsg("loading ", Fname);
			Files::_inst()->Set(R, F, 0);
			Files::_inst()->Read(R, ch);
			if( ch == _this->LibFileId )
			{
				if( L == 0 )
				{
					L = new Graphics::LibraryDesc();
					L->name = name;
					L->next = _this->FirstLib;
					_this->FirstLib = L;
				}
				L->first = 0;
				_this->InitContext(C);
				_this->LoadElems(R, C, obj);
				while( obj != 0 )
				{
					mh = new Graphics::MacHeadDesc();
					mh->first = obj;
					Files::_inst()->ReadInt(R, wh);
					mh->h = MOD(DIV(wh,0x10000),0x10000);
					mh->w = MOD(wh,0x10000);
					Files::_inst()->ReadString(R, mh->name);
					mh->lib = L;
					mh->next = L->first;
					L->first = mh;
					_this->LoadElems(R, C, obj);
				}
			}else
				L = 0;

		}else
			L = 0;

	}
	Lib = L;
	// END
}

Graphics::Library Graphics::NewLib(_ValArray<char> Lname)
{
	// VAR
	Library L;

	// BEGIN
	Graphics* _this = _inst();
	L = new Graphics::LibraryDesc();
	L->name = Lname;
	L->first = 0;
	L->next = _this->FirstLib;
	_this->FirstLib = L;
	return L;
	// END
}

void Graphics::StoreLib(Library L, _ValArray<char> Fname)
{
	// VAR
	int i;
	MacHead mh;
	Files::File F;
	Files::Rider W;
	Context C;
	_FxArray<char,32> Gname;

	// BEGIN
	Graphics* _this = _inst();
	L = _this->FirstLib;
	while( (L != 0) && (L->name != Fname) )
		L = L->next;
	
	if( L != 0 )
	{
		i = 0;
		while( Fname[i] > 0x0 )
		{
			Gname[i] = Fname[i];
			i++;
		}
		Gname[i] = '.';
		Gname[i + 1] = 'L';
		Gname[i + 2] = 'i';
		Gname[i + 3] = 'b';
		Gname[i + 4] = 0x0;
		F = Files::_inst()->New(Gname);
		Files::_inst()->Set(W, F, 0);
		Files::_inst()->Write(W, _this->LibFileId);
		_this->InitContext(C);
		mh = L->first;
		while( mh != 0 )
		{
			_this->StoreElems(W, C, mh->first);
			Files::_inst()->WriteInt(W, mh->h * 0x10000 + mh->w);
			Files::_inst()->WriteString(W, mh->name);
			mh = mh->next;
		}
		Files::_inst()->WriteByte(W, 255);
		Files::_inst()->Register(F);
	}else
	{
		Texts::_inst()->WriteString(_this->TW, Fname);
		Texts::_inst()->WriteString(_this->TW, " not found");
		Texts::_inst()->WriteLn(_this->TW);
		Texts::_inst()->Append(Oberon::_inst()->Log, _this->TW.buf);
	}
	// END
}

void Graphics::RemoveLibraries()
{
	// BEGIN
	Graphics* _this = _inst();
	_this->FirstLib = 0;
	// END
}

Graphics::MacHead Graphics::ThisMac(Library L, _ValArray<char> Mname)
{
	// VAR
	MacHead mh;

	// BEGIN
	Graphics* _this = _inst();
	mh = L->first;
	while( (mh != 0) && (mh->name != Mname) )
		mh = mh->next;
	
	return mh;
	// END
}

void Graphics::DrawMac(MacHead mh, Msg& M)
{
	// VAR
	Object elem;

	// BEGIN
	Graphics* _this = _inst();
	elem = mh->first;
	while( elem != 0 )
	{
		elem->do_->draw(elem, M);
		elem = elem->next;
	}
	// END
}

/*  -------------------- Procedures for designing macros--------------------- */
void Graphics::OpenMac(MacHead mh, Graph G, int x, int y)
{
	// VAR
	Object obj;

	// BEGIN
	Graphics* _this = _inst();
	obj = mh->first;
	while( obj != 0 )
	{
		obj->do_->new_;
		obj->do_->copy(obj, _this->new_);
		_this->new_->x += x;
		_this->new_->y += y;
		_this->new_->selected = TRUE;
		_this->Add(G, _this->new_);
		obj = obj->next;
	}
	_this->new_ = 0;
	// END
}

void Graphics::MakeMac(Graph G, MacHead& head)
{
	// VAR
	int x0;
	int y0;
	int x1;
	int y1;
	Object obj;
	Object last;
	MacHead mh;

	// BEGIN
	Graphics* _this = _inst();
	obj = G->first;
	last = 0;
	x0 = 1024;
	x1 = 0;
	y0 = 1024;
	y1 = 0;
	while( obj != 0 )
	{
		if( obj->selected )
		{
			obj->do_->new_;
			obj->do_->copy(obj, _this->new_);
			_this->new_->next = last;
			_this->new_->selected = FALSE;
			last = _this->new_;
			if( obj->x < x0 )
				x0 = obj->x;
			
			if( obj->x + obj->w > x1 )
				x1 = obj->x + obj->w;
			
			if( obj->y < y0 )
				y0 = obj->y;
			
			if( obj->y + obj->h > y1 )
				y1 = obj->y + obj->h;
			
		}
		obj = obj->next;
	}
	obj = last;
	while( obj != 0 )
	{
		obj->x = obj->x - x0;
		obj->y = obj->y - y0;
		obj = obj->next;
	}
	mh = new Graphics::MacHeadDesc();
	mh->w = x1 - x0;
	mh->h = y1 - y0;
	mh->first = last;
	mh->ext = 0;
	_this->new_ = 0;
	head = mh;
	// END
}

void Graphics::InsertMac(MacHead mh, Library L, bool& new_)
{
	// VAR
	MacHead mh1;

	// BEGIN
	Graphics* _this = _inst();
	mh->lib = L;
	mh1 = L->first;
	while( (mh1 != 0) && (mh1->name != mh->name) )
		mh1 = mh1->next;
	
	if( mh1 == 0 )
	{
		new_ = TRUE;
		mh->next = L->first;
		L->first = mh;
	}else
	{
		new_ = FALSE;
		mh1->w = mh->w;
		mh1->h = mh->h;
		mh1->first = mh->first;
	}
	// END
}

/*  ---------------------------- Line Methods ----------------------------- */
void Graphics::NewLine()
{
	// VAR
	Line line;

	// BEGIN
	Graphics* _this = _inst();
	line = new Graphics::LineDesc();
	_this->new_ = line;
	line->do_ = _this->LineMethod;
	// END
}

void Graphics::CopyLine(Object src, Object dst)
{
	// BEGIN
	Graphics* _this = _inst();
	dst->x = src->x;
	dst->y = src->y;
	dst->w = src->w;
	dst->h = src->h;
	dst->col = src->col;
	// END
}

void Graphics::ChangeLine(Object obj, Msg& M)
{
	// BEGIN
	Graphics* _this = _inst();
	if( dynamic_cast<>(M) != 0  ){
		if( obj->w < obj->h )
		{
			if( obj->w <= 7 )
				obj->w = M.w;
			
		}else if( obj->h <= 7 )
			obj->h = M.w;
		
	} else if( dynamic_cast<>(M) != 0  ){
		obj->col = M.col;
	} 
	// END
}

bool Graphics::LineSelectable(Object obj, int x, int y)
{
	// BEGIN
	Graphics* _this = _inst();
	return (obj->x <= x) && (x < obj->x + obj->w) && (obj->y <= y) && (y < obj->y + obj->h);
	// END
}

void Graphics::ReadLine(Object obj, Files::Rider& R, Context& C)
{
	; // empty statement
}

void Graphics::WriteLine(Object obj, int cno, Files::Rider& W, Context& C)
{
	// BEGIN
	Graphics* _this = _inst();
	_this->WriteObj(W, cno, obj);
	// END
}

/* PROCEDURE PrintLine(obj: Object; x, y: INTEGER);
    VAR w, h: INTEGER;
  BEGIN w := obj.w * 2; h := obj.h * 2;
    IF w < h THEN h := 2*h ELSE w := 2*w END ;
    Printer.ReplConst(obj.x * 4 + x, obj.y *4 + y, w, h)
  END PrintLine;  */
/*  ---------------------- Caption Methods ------------------------  */
void Graphics::NewCaption()
{
	// VAR
	Caption cap;

	// BEGIN
	Graphics* _this = _inst();
	cap = new Graphics::CaptionDesc();
	_this->new_ = cap;
	cap->do_ = _this->CapMethod;
	// END
}

void Graphics::CopyCaption(Object src, Object dst)
{
	// VAR
	char ch;
	Texts::Reader R;

	// BEGIN
	Graphics* _this = _inst();
	dst->x = src->x;
	dst->y = src->y;
	dst->w = src->w;
	dst->h = src->h;
	dst->col = src->col;
	dst->_to<Caption>()->pos = _this->T->len + 1;
	dst->_to<Caption>()->len = src->_to<Caption>()->len;
	Texts::_inst()->Write(_this->TW, 0x0D);
	Texts::_inst()->OpenReader(R, _this->T, src->_to<Caption>()->pos);
	Texts::_inst()->Read(R, ch);
	_this->TW.fnt = R.fnt;
	while( ch > 0x0D )
	{
		Texts::_inst()->Write(_this->TW, ch);
		Texts::_inst()->Read(R, ch);
	}
	Texts::_inst()->Append(_this->T, _this->TW.buf);
	// END
}

void Graphics::ChangeCaption(Object obj, Msg& M)
{
	// VAR
	int dx;
	int x1;
	int dy;
	int y1;
	int w;
	int w1;
	int h1;
	int len;
	int pos;
	char ch;
	int patadr;
	Fonts::Font fnt;
	Texts::Reader R;

	// BEGIN
	Graphics* _this = _inst();
	if( dynamic_cast<>(M) != 0  ){
		fnt = M._to<FontMsg>().fnt;
		w = 0;
		len = 0;
		pos = obj->_to<Caption>()->pos;
		Texts::_inst()->OpenReader(R, _this->T, pos);
		Texts::_inst()->Read(R, ch);
		dy = R.fnt->minY;
		while( ch > 0x0D )
		{
			Fonts::_inst()->GetPat(fnt, ch, dx, x1, y1, w1, h1, patadr);
			w += dx;
			len++;
			Texts::_inst()->Read(R, ch);
		}
		obj->y += fnt->minY - dy;
		obj->w = w;
		obj->h = fnt->height;
		Texts::_inst()->ChangeLooks(_this->T, pos, pos + len, ( _Set() + (0) ), fnt, 0, 0);
	} else if( dynamic_cast<>(M) != 0  ){
		obj->col = M._to<ColorMsg>().col;
	} 
	// END
}

bool Graphics::CaptionSelectable(Object obj, int x, int y)
{
	// BEGIN
	Graphics* _this = _inst();
	return (obj->x <= x) && (x < obj->x + obj->w) && (obj->y <= y) && (y < obj->y + obj->h);
	// END
}

void Graphics::ReadCaption(Object obj, Files::Rider& R, Context& C)
{
	// VAR
	char ch;
	uint8_t fno;
	int len;

	// BEGIN
	Graphics* _this = _inst();
	obj->_to<Caption>()->pos = _this->T->len + 1;
	Texts::_inst()->Write(_this->TW, 0x0D);
	Files::_inst()->ReadByte(R, fno);
	_this->TW.fnt = C.font[fno];
	len = 0;
	Files::_inst()->Read(R, ch);
	while( ch > 0x0D )
	{
		Texts::_inst()->Write(_this->TW, ch);
		len++;
		Files::_inst()->Read(R, ch);
	}
	obj->_to<Caption>()->len = len;
	Texts::_inst()->Append(_this->T, _this->TW.buf);
	// END
}

void Graphics::WriteCaption(Object obj, int cno, Files::Rider& W, Context& C)
{
	// VAR
	char ch;
	uint8_t fno;
	Texts::Reader TR;

	// BEGIN
	Graphics* _this = _inst();
	if( obj->_to<Caption>()->len > 0 )
	{
		Texts::_inst()->OpenReader(TR, _this->T, obj->_to<Caption>()->pos);
		Texts::_inst()->Read(TR, ch);
		fno = _this->FontNo(W, C, TR.fnt);
		_this->WriteObj(W, cno, obj);
		Files::_inst()->WriteByte(W, fno);
		while( ch > 0x0D )
		{
			Files::_inst()->Write(W, ch);
			Texts::_inst()->Read(TR, ch);
		}
		Files::_inst()->Write(W, 0x0);
	}
	// END
}

/*   PROCEDURE PrintCaption(obj: Object; x, y: INTEGER);
    VAR fnt: Fonts.Font;
      i: INTEGER; ch: CHAR;
      R: Texts.Reader;
      s: ARRAY 128 OF CHAR;
  BEGIN
    IF obj(Caption).len > 0 THEN
      Texts.OpenReader(R, T, obj(Caption).pos); Texts.Read(R, ch);
      fnt := R.fnt; DEC(y, fnt.minY*4); i := 0;
      WHILE ch >= " " DO s[i] := ch; INC(i); Texts.Read(R, ch) END ;
      s[i] := 0X;
      IF i > 0 THEN Printer.String(obj.x*4 + x, obj.y*4 + y, s, fnt.name) END
    END
  END PrintCaption;  */
/*  ---------------------- Macro Methods ------------------------  */
void Graphics::NewMacro()
{
	// VAR
	Macro mac;

	// BEGIN
	Graphics* _this = _inst();
	mac = new Graphics::MacroDesc();
	_this->new_ = mac;
	mac->do_ = _this->MacMethod;
	// END
}

void Graphics::CopyMacro(Object src, Object dst)
{
	// BEGIN
	Graphics* _this = _inst();
	dst->x = src->x;
	dst->y = src->y;
	dst->w = src->w;
	dst->h = src->h;
	dst->col = src->col;
	dst->_to<Macro>()->mac = src->_to<Macro>()->mac;
	// END
}

void Graphics::ChangeMacro(Object obj, Msg& M)
{
	// BEGIN
	Graphics* _this = _inst();
	if( dynamic_cast<>(M) != 0  ){
		obj->col = M.col;
	} 
	// END
}

bool Graphics::MacroSelectable(Object obj, int x, int y)
{
	// BEGIN
	Graphics* _this = _inst();
	return (obj->x <= x) && (x <= obj->x + 8) && (obj->y <= y) && (y <= obj->y + 8);
	// END
}

void Graphics::ReadMacro(Object obj, Files::Rider& R, Context& C)
{
	// VAR
	uint8_t lno;
	_FxArray<char,32> name;

	// BEGIN
	Graphics* _this = _inst();
	Files::_inst()->ReadByte(R, lno);
	Files::_inst()->ReadString(R, name);
	obj->_to<Macro>()->mac = _this->ThisMac(C.lib[lno], name);
	// END
}

void Graphics::WriteMacro(Object obj, int cno, Files::Rider& W1, Context& C)
{
	// VAR
	int lno;

	// BEGIN
	Graphics* _this = _inst();
	lno = 0;
	while( (lno < C.noflibs) && (obj->_to<Macro>()->mac->lib != C.lib[lno]) )
		lno++;
	
	if( lno == C.noflibs )
	{
		Files::_inst()->WriteByte(W1, 0);
		Files::_inst()->WriteByte(W1, 1);
		Files::_inst()->WriteByte(W1, lno);
		Files::_inst()->WriteString(W1, obj->_to<Macro>()->mac->lib->name);
		C.lib[lno] = obj->_to<Macro>()->mac->lib;
		C.noflibs++;
	}
	_this->WriteObj(W1, cno, obj);
	Files::_inst()->WriteByte(W1, lno);
	Files::_inst()->WriteString(W1, obj->_to<Macro>()->mac->name);
	// END
}

/*   PROCEDURE PrintMacro(obj: Object; x, y: INTEGER);
    VAR elem: Object; mh: MacHead;
  BEGIN mh := obj(Macro).mac;
    IF mh # NIL THEN elem := mh.first;
      WHILE elem # NIL DO elem.do.print(elem, obj.x*4 + x, obj.y*4 + y); elem := elem.next END
    END
  END PrintMacro;  */
void Graphics::Notify(Texts::Text T, int op, int beg, int end)
{
	; // empty statement
}

/*  FIX RK: use qualident type instead of direct declaration  */
void Graphics::InstallDrawMethods(DrawMethod drawLine, DrawMethod drawCaption, DrawMethod drawMacro)
{
	// BEGIN
	Graphics* _this = _inst();
	_this->LineMethod->draw = drawLine;
	_this->CapMethod->draw = drawCaption;
	_this->MacMethod->draw = drawMacro;
	// END
}

Graphics::Graphics()
{
	// BEGIN
	Texts::_inst()->OpenWriter(W);
	Texts::_inst()->OpenWriter(TW);
	Texts::_inst()->OpenWriter(XW);
	width = 1;
	GetLib0 = GetLib;
	T = new Texts::TextDesc();
	Texts::_inst()->Open(T, "");
	T->notify_ = Notify;
	LineMethod = new MethodDesc();
	LineMethod->new_ = NewLine;
	LineMethod->copy = CopyLine;
	LineMethod->selectable = LineSelectable;
	LineMethod->change = ChangeLine;
	/* LineMethod.print := PrintLine; */
	LineMethod->read = ReadLine;
	LineMethod->write = WriteLine;
	CapMethod = new MethodDesc();
	CapMethod->new_ = NewCaption;
	CapMethod->copy = CopyCaption;
	CapMethod->selectable = CaptionSelectable;
	CapMethod->change = ChangeCaption;
	/* CapMethod.print := PrintCaption; */
	CapMethod->read = ReadCaption;
	CapMethod->write = WriteCaption;
	MacMethod = new MethodDesc();
	MacMethod->new_ = NewMacro;
	MacMethod->copy = CopyMacro;
	MacMethod->selectable = MacroSelectable;
	MacMethod->change = ChangeMacro;
	/* MacMethod.print := PrintMacro */
	MacMethod->read = ReadMacro;
	MacMethod->write = WriteMacro;
	// END
}

Graphics::~Graphics()
{
	s_inst.release();
}

