#ifndef __ObGraphics_H__
#define __ObGraphics_H__

// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17

#include <OberonSystem/Ob_Global.h>
#include <OberonSystem/ObSYSTEM.h>
#include <OberonSystem/ObFiles.h>
#include <OberonSystem/ObModules.h>
#include <OberonSystem/ObFonts.h>
#include <OberonSystem/ObTexts.h>
#include <OberonSystem/ObOberon.h>

namespace Ob
{
	class Graphics : public _Root
	{
	public:
		/* NW 21.12.89 / 18.11.201 / 8.4.2016 */
		static Graphics* _inst();
		Graphics();
		~Graphics();

		// CONST
		/* Printer, */
		static const int NameLen = 32;
		static const char GraphFileId = 0x0FA;
		static const char LibFileId = 0x0FB;

		// TYPE
		struct ObjectDesc;
		struct Msg;
		struct WidMsg;
		struct ColorMsg;
		struct FontMsg;
		struct GraphDesc;
		struct MacHeadDesc;
		struct LibraryDesc;
		struct MacExtDesc;
		struct Context;
		struct MethodDesc;
		struct LineDesc;
		struct CaptionDesc;
		struct MacroDesc;

		typedef GraphDesc* Graph;
		typedef ObjectDesc* Object;
		typedef MethodDesc* Method;
		typedef LineDesc* Line;
		typedef CaptionDesc* Caption;
		typedef MacroDesc* Macro;
		struct ObjectDesc : public _Root {
			uint8_t col;
			Method do_;
			int h;
			bool marked;
			Object next;
			bool selected;
			int w;
			int x;
			int y;
		};
		struct Msg : public _Root {
		};
		struct WidMsg : public Msg {
			int w;
		};
		struct ColorMsg : public Msg {
			int col;
		};
		struct FontMsg : public Msg {
			Fonts::Font fnt;
		};
		typedef _FxArray<char,NameLen> Name;
		struct GraphDesc : public _Root {
			bool changed;
			Object first;
			Object sel;
			int time;
		};
		typedef MacHeadDesc* MacHead;
		typedef MacExtDesc* MacExt;
		typedef LibraryDesc* Library;
		struct MacHeadDesc : public _Root {
			MacExt ext;
			Object first;
			int h;
			Library lib;
			Name name;
			MacHead next;
			int w;
		};
		struct LibraryDesc : public _Root {
			MacHead first;
			Name name;
			Library next;
		};
		struct MacExtDesc : public _Root {
		};
		struct Context : public _Root {
			_FxArray<Modules::Command,6> class_;
			_FxArray<Fonts::Font,10> font;
			_FxArray<Library,4> lib;
			int nofclasses;
			int noflibs;
			int nofonts;
		};
		struct MethodDesc : public _Root {
			Name allocator;
			void (*change)(Object,Msg&);
			void (*copy)(Object,Object);
			void (*draw)(Object,Msg&);
			Name module;
			Modules::Command new_;
			void (*print)(Object,int,int);
			void (*read)(Object,Files::Rider&,Context&);
			bool (*selectable)(Object,int,int);
			void (*write)(Object,int,Files::Rider&,Context&);
		};
		struct LineDesc : public ObjectDesc {
			int unused;
		};
		struct CaptionDesc : public ObjectDesc {
			int len;
			int pos;
		};
		struct MacroDesc : public ObjectDesc {
			MacHead mac;
		};
		/*  FIX RK  */
		typedef /* ProcType not supported here */ DrawMethod;

		// VAR
		int width;
		int res;
		Object new_;
		/* captions */
		Texts::Text T;
		Method LineMethod;
		Method CapMethod;
		Method MacMethod;
		void (*GetLib0)(_FxArray<char,0>,bool,Library&);
		Library FirstLib;
		Texts::Writer W;
		Texts::Writer TW;
		Texts::Writer XW;

		// PROC
		static void New(Object obj);
		static void Add(Graph G, Object obj);
		Object ThisObj(Graph G, int x, int y);
		static void SelectObj(Graph G, Object obj);
		static void SelectArea(Graph G, int x0, int y0, int x1, int y1);
		static void Draw(Graph G, Msg& M);
		static void List(Graph G);
		static void Deselect(Graph G);
		static void DrawSel(Graph G, Msg& M);
		static void Change(Graph G, Msg& M);
		static void Move(Graph G, int dx, int dy);
		static void Copy(Graph Gs, Graph Gd, int dx, int dy);
		static void Delete(Graph G);
		static void WMsg(_ValArray<char> s0, _ValArray<char> s1);
		static void InitContext(Context& C);
		int FontNo(Files::Rider& W, Context& C, Fonts::Font fnt);
		static void StoreElems(Files::Rider& W, Context& C, Object obj);
		static void Store(Graph G, Files::Rider& W);
		static void WriteObj(Files::Rider& W, int cno, Object obj);
		static void WriteFile(Graph G, _ValArray<char> name);
		static void Print(Graph G, int x0, int y0);
		static void GetClass(_ValArray<char> module, _ValArray<char> allocator, Modules::Command& com);
		Fonts::Font Font(Files::Rider& R, Context& C);
		static void ReadObj(Files::Rider& R, Object obj);
		static void LoadElems(Files::Rider& R, Context& C, Object& fobj);
		static void Load(Graph G, Files::Rider& R);
		static void Open(Graph G, _ValArray<char> name);
		static void SetWidth(int w);
		static void GetLib(_ValArray<char> name, bool replace, Library& Lib);
		Library NewLib(_ValArray<char> Lname);
		static void StoreLib(Library L, _ValArray<char> Fname);
		static void RemoveLibraries();
		MacHead ThisMac(Library L, _ValArray<char> Mname);
		static void DrawMac(MacHead mh, Msg& M);
		static void OpenMac(MacHead mh, Graph G, int x, int y);
		static void MakeMac(Graph G, MacHead& head);
		static void InsertMac(MacHead mh, Library L, bool& new_);
		static void NewLine();
		static void CopyLine(Object src, Object dst);
		static void ChangeLine(Object obj, Msg& M);
		bool LineSelectable(Object obj, int x, int y);
		static void ReadLine(Object obj, Files::Rider& R, Context& C);
		static void WriteLine(Object obj, int cno, Files::Rider& W, Context& C);
		static void NewCaption();
		static void CopyCaption(Object src, Object dst);
		static void ChangeCaption(Object obj, Msg& M);
		bool CaptionSelectable(Object obj, int x, int y);
		static void ReadCaption(Object obj, Files::Rider& R, Context& C);
		static void WriteCaption(Object obj, int cno, Files::Rider& W, Context& C);
		static void NewMacro();
		static void CopyMacro(Object src, Object dst);
		static void ChangeMacro(Object obj, Msg& M);
		bool MacroSelectable(Object obj, int x, int y);
		static void ReadMacro(Object obj, Files::Rider& R, Context& C);
		static void WriteMacro(Object obj, int cno, Files::Rider& W1, Context& C);
		static void Notify(Texts::Text T, int op, int beg, int end);
		static void InstallDrawMethods(DrawMethod drawLine, DrawMethod drawCaption, DrawMethod drawMacro);

	};
}

#endif // __ObGraphics_H__