// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObInput.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<Input> s_inst;

const int Input::msAdr;
const int Input::kbdAdr;

Input* Input::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new Input() );
	return s_inst.get();
}

/* FIFO implemented in hardware, because every read must be handled,
  including tracking the state of the Shift and Ctrl keys */
void Input::Peek()
{
	// BEGIN
	Input* _this = _inst();
	if( SYSTEM::_inst()->BIT(_this->msAdr, 28) )
	{
		SYSTEM::_inst()->GET(_this->kbdAdr, _this->kbdCode);
		if( _this->kbdCode == 0x0F0 )
			_this->Up = TRUE;
		else if( _this->kbdCode == 0x0E0 )
			_this->Ext = TRUE;
		else
		{
			/* shift */
			if( (_this->kbdCode == 0x12) || (_this->kbdCode == 0x59) )
				_this->Shift = !_this->Up;
			else if( _this->kbdCode == 0x14 )
				/* ctrl */
				_this->Ctrl = !_this->Up;
			else if( !_this->Up )
				/* real key going down */
				_this->Recd = TRUE;
			
			_this->Up = FALSE;
			_this->Ext = FALSE;
		}
	}
	// END
}

int Input::Available()
{
	// BEGIN
	Input* _this = _inst();
	_this->Peek();
	return int( _this->Recd );
	// END
}

void Input::Read(char& ch)
{
	// BEGIN
	Input* _this = _inst();
	while( !_this->Recd )
		_this->Peek();
	
	/* ctrl implies shift */
	if( _this->Shift || _this->Ctrl )
		_this->kbdCode += 0x80;
	
	/*  ch := kbdTab[kbdCode];  */
	SYSTEM::_inst()->GET(_this->KTabAdr + _this->kbdCode, ch);
	if( _this->Ctrl )
		ch = char( MOD(int( ch ),0x20) );
	
	_this->Recd = FALSE;
	// END
}

void Input::Mouse(_Set& keys, int& x, int& y)
{
	// VAR
	int w;

	// BEGIN
	Input* _this = _inst();
	SYSTEM::_inst()->GET(_this->msAdr, w);
	keys = SYSTEM::_inst()->VAL(SET, MOD(DIV(w,0x1000000),8));
	x = MOD(w,0x400);
	y = MOD((DIV(w,0x1000)),0x400);
	if( y >= _this->MH )
		y = _this->MH - 1;
	
	// END
}

void Input::SetMouseLimits(int w, int h)
{
	// BEGIN
	Input* _this = _inst();
	_this->MW = w;
	_this->MH = h;
	// END
}

void Input::Init()
{
	// BEGIN
	Input* _this = _inst();
	_this->Up = FALSE;
	_this->Shift = FALSE;
	_this->Ctrl = FALSE;
	_this->Recd = FALSE;
	_this->KTabAdr = SYSTEM::_inst()->ADR("00000000001A00000000000000096000000000000071310000007A736177320000637864653433000020766674723500006E62686779360000006D6A75373800002C6B696F303900002E2F6C3B702D00000027005B3D000000000D5D005C000000000000000008000000000000000000007F000000001B00000000000000000000000000000000000000000000097E00000000000051210000005A534157400000435844452423000020564654522500004E424847595E0000004D4A55262A00003C4B494F292800003E3F4C3A505F00000022007B2B000000000D7D007C000000000000000008000000000000000000007F000000001B000000000000000000");
	// END
}

Input::Input()
{
	// BEGIN
	Init();
	// END
}

Input::~Input()
{
	s_inst.release();
}

