// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObKernel.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<Kernel> s_inst;

const int Kernel::SectorLength;
const int Kernel::timer;
const int Kernel::spiData;
const int Kernel::spiCtrl;
const int Kernel::CARD0;
const int Kernel::SPIFAST;
const int Kernel::FSoffset;
const int Kernel::mapsize;

Kernel* Kernel::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new Kernel() );
	return s_inst.get();
}

/*  ---------- New: heap allocation ---------- */
void Kernel::GetBlock(int& p, int len)
{
	// VAR
	/* len is multiple of 256 */
	int q0;
	int q1;
	int q2;
	int size;
	bool done_;

	// BEGIN
	Kernel* _this = _inst();
	q0 = 0;
	q1 = _this->list0;
	done_ = FALSE;
	while( !done_ && (q1 != 0) )
	{
		SYSTEM::_inst()->GET(q1, size);
		SYSTEM::_inst()->GET(q1 + 8, q2);
		/* no fit */
		if( size < len )
		{
			q0 = q1;
			q1 = q2;
		}else if( size == len )
		{
			/* extract -> p */
			done_ = TRUE;
			p = q1;
			if( q0 != 0 )
				SYSTEM::_inst()->PUT(q0 + 8, q2);
			else
				_this->list0 = q2;

		}else
		{
			/* reduce size */
			done_ = TRUE;
			p = q1;
			q1 = q1 + len;
			SYSTEM::_inst()->PUT(q1, size - len);
			SYSTEM::_inst()->PUT(q1 + 4, -1);
			SYSTEM::_inst()->PUT(q1 + 8, q2);
			if( q0 != 0 )
				SYSTEM::_inst()->PUT(q0 + 8, q1);
			else
				_this->list0 = q1;

		}
	}
	if( !done_ )
		p = 0;
	
	// END
}

void Kernel::GetBlock128(int& p)
{
	// VAR
	int q;

	// BEGIN
	Kernel* _this = _inst();
	if( _this->list1 != 0 )
	{
		p = _this->list1;
		SYSTEM::_inst()->GET(_this->list1 + 8, _this->list1);
	}else
	{
		_this->GetBlock(q, 256);
		SYSTEM::_inst()->PUT(q + 128, 128);
		SYSTEM::_inst()->PUT(q + 132, -1);
		SYSTEM::_inst()->PUT(q + 136, _this->list1);
		_this->list1 = q + 128;
		p = q;
	}
	// END
}

void Kernel::GetBlock64(int& p)
{
	// VAR
	int q;

	// BEGIN
	Kernel* _this = _inst();
	if( _this->list2 != 0 )
	{
		p = _this->list2;
		SYSTEM::_inst()->GET(_this->list2 + 8, _this->list2);
	}else
	{
		_this->GetBlock128(q);
		SYSTEM::_inst()->PUT(q + 64, 64);
		SYSTEM::_inst()->PUT(q + 68, -1);
		SYSTEM::_inst()->PUT(q + 72, _this->list2);
		_this->list2 = q + 64;
		p = q;
	}
	// END
}

void Kernel::GetBlock32(int& p)
{
	// VAR
	int q;

	// BEGIN
	Kernel* _this = _inst();
	if( _this->list3 != 0 )
	{
		p = _this->list3;
		SYSTEM::_inst()->GET(_this->list3 + 8, _this->list3);
	}else
	{
		_this->GetBlock64(q);
		SYSTEM::_inst()->PUT(q + 32, 32);
		SYSTEM::_inst()->PUT(q + 36, -1);
		SYSTEM::_inst()->PUT(q + 40, _this->list3);
		_this->list3 = q + 32;
		p = q;
	}
	// END
}

void Kernel::New(int& ptr, int tag)
{
	// VAR
	/* called by NEW via MT[0]; ptr and tag are pointers */
	int p;
	int size;
	int lim;

	// BEGIN
	Kernel* _this = _inst();
	SYSTEM::_inst()->GET(tag, size);
	if( size == 32 )
		_this->GetBlock32(p);
	else if( size == 64 )
		_this->GetBlock64(p);
	else if( size == 128 )
		_this->GetBlock128(p);
	else
		_this->GetBlock(p, DIV((size + 255),256) * 256);

	if( p == 0 )
		ptr = 0;
	else
	{
		ptr = p + 8;
		SYSTEM::_inst()->PUT(p, tag);
		lim = p + size;
		p += 4;
		_this->allocated += size;
		while( p < lim )
		{
			SYSTEM::_inst()->PUT(p, 0);
			p += 4;
		}
	}
	// END
}

/*  ---------- Garbage collector ---------- */
void Kernel::Mark(int pref)
{
	// VAR
	int pvadr;
	int offadr;
	int offset;
	int tag;
	int p;
	int q;
	int r;

	// BEGIN
	Kernel* _this = _inst();
	/* pointers < heapOrg considered NIL */
	SYSTEM::_inst()->GET(pref, pvadr);
	while( pvadr != 0 )
	{
		SYSTEM::_inst()->GET(pvadr, p);
		SYSTEM::_inst()->GET(p - 4, offadr);
		/* mark elements in data structure with root p */
		if( (p >= _this->heapOrg) && (offadr == 0) )
		{
			q = p;
			do 
			{
				SYSTEM::_inst()->GET(p - 4, offadr);
				if( offadr == 0 )
				{
					SYSTEM::_inst()->GET(p - 8, tag);
					offadr = tag + 16;
				}else
					offadr += 4;

				SYSTEM::_inst()->PUT(p - 4, offadr);
				SYSTEM::_inst()->GET(offadr, offset);
				/* down */
				if( offset != -1 )
				{
					SYSTEM::_inst()->GET(p + offset, r);
					SYSTEM::_inst()->GET(r - 4, offadr);
					if( (r >= _this->heapOrg) && (offadr == 0) )
					{
						SYSTEM::_inst()->PUT(p + offset, q);
						q = p;
						p = r;
					}
				}else
				{
					/* up */
					SYSTEM::_inst()->GET(q - 4, offadr);
					SYSTEM::_inst()->GET(offadr, offset);
					if( p != q )
					{
						SYSTEM::_inst()->GET(q + offset, r);
						SYSTEM::_inst()->PUT(q + offset, p);
						p = q;
						q = r;
					}
				}
			} while( !( (p == q) && (offset == -1) ) );
		}
		pref += 4;
		SYSTEM::_inst()->GET(pref, pvadr);
	}
	// END
}

void Kernel::Scan()
{
	// VAR
	int p;
	int q;
	int mark;
	int tag;
	int size;

	// BEGIN
	Kernel* _this = _inst();
	p = _this->heapOrg;
	do 
	{
		SYSTEM::_inst()->GET(p + 4, mark);
		q = p;
		while( mark == 0 )
		{
			SYSTEM::_inst()->GET(p, tag);
			SYSTEM::_inst()->GET(tag, size);
			p += size;
			SYSTEM::_inst()->GET(p + 4, mark);
		}
		/* size of free block */
		size = p - q;
		_this->allocated -= size;
		if( size > 0 )
		{
			if( MOD(size,64) != 0 )
			{
				SYSTEM::_inst()->PUT(q, 32);
				SYSTEM::_inst()->PUT(q + 4, -1);
				SYSTEM::_inst()->PUT(q + 8, _this->list3);
				_this->list3 = q;
				q += 32;
				size -= 32;
			}
			if( MOD(size,128) != 0 )
			{
				SYSTEM::_inst()->PUT(q, 64);
				SYSTEM::_inst()->PUT(q + 4, -1);
				SYSTEM::_inst()->PUT(q + 8, _this->list2);
				_this->list2 = q;
				q += 64;
				size -= 64;
			}
			if( MOD(size,256) != 0 )
			{
				SYSTEM::_inst()->PUT(q, 128);
				SYSTEM::_inst()->PUT(q + 4, -1);
				SYSTEM::_inst()->PUT(q + 8, _this->list1);
				_this->list1 = q;
				q += 128;
				size -= 128;
			}
			if( size > 0 )
			{
				SYSTEM::_inst()->PUT(q, size);
				SYSTEM::_inst()->PUT(q + 4, -1);
				SYSTEM::_inst()->PUT(q + 8, _this->list0);
				_this->list0 = q;
				q += size;
			}
		}
		if( mark > 0 )
		{
			SYSTEM::_inst()->GET(p, tag);
			SYSTEM::_inst()->GET(tag, size);
			SYSTEM::_inst()->PUT(p + 4, 0);
			p += size;
		}else
		{
			/* free */
			SYSTEM::_inst()->GET(p, size);
			p += size;
		}
	} while( !( p >= _this->heapLim ) );
	// END
}

/*  ---------- Disk storage management ---------- */
/* send n FFs slowly with no card selected */
void Kernel::SPIIdle(int n)
{
	// BEGIN
	Kernel* _this = _inst();
	SYSTEM::_inst()->PUT(_this->spiCtrl, 0);
	while( n > 0 )
	{
		n--;
		SYSTEM::_inst()->PUT(_this->spiData, -1);
		do 
		{
			; // empty statement
		} while( !( SYSTEM::_inst()->BIT(_this->spiCtrl, 0) ) );
		SYSTEM::_inst()->GET(_this->spiData, _this->data);
	}
	// END
}

/* send&rcv byte slowly with card selected */
void Kernel::SPI(int n)
{
	// BEGIN
	Kernel* _this = _inst();
	SYSTEM::_inst()->PUT(_this->spiCtrl, _this->CARD0);
	SYSTEM::_inst()->PUT(_this->spiData, n);
	do 
	{
		; // empty statement
	} while( !( SYSTEM::_inst()->BIT(_this->spiCtrl, 0) ) );
	SYSTEM::_inst()->GET(_this->spiData, _this->data);
	// END
}

void Kernel::SPICmd(int n, int arg)
{
	// VAR
	int i;
	int crc;

	// BEGIN
	Kernel* _this = _inst();
	/* send cmd */
	/* flush while unselected */
	do 
	{
		_this->SPIIdle(1);
	} while( !( _this->data == 255 ) );
	/* flush while selected */
	do 
	{
		_this->SPI(255);
	} while( !( _this->data == 255 ) );
	if( n == 8 )
		crc = 135;
	else if( n == 0 )
		crc = 149;
	else
		crc = 255;

	/* send command */
	_this->SPI(MOD(n,64) + 64);
	/* send arg */
	for( i = 24; -8 > 0 ? i <= 0 : i >= 0; i += -8 )
		_this->SPI(ROR(arg, i));
	_this->SPI(crc);
	i = 32;
	do 
	{
		_this->SPI(255);
		i--;
	} while( !( (_this->data < 0x80) || (i == 0) ) );
	// END
}

void Kernel::SDShift(int& n)
{
	// VAR
	int data;

	// BEGIN
	Kernel* _this = _inst();
	/* CMD58 get card capacity bit */
	_this->SPICmd(58, 0);
	SYSTEM::_inst()->GET(_this->spiData, data);
	_this->SPI(-1);
	/* non-SDHC card */
	if( (data != 0) || !SYSTEM::_inst()->BIT(_this->spiData, 6) )
		n = n * 512;
	
	/* flush response */
	_this->SPI(-1);
	_this->SPI(-1);
	_this->SPIIdle(1);
	// END
}

void Kernel::ReadSD(int src, int dst)
{
	// VAR
	int i;

	// BEGIN
	Kernel* _this = _inst();
	/* CMD17 read one block */
	_this->SDShift(src);
	_this->SPICmd(17, src);
	ASSERT(_this->data == 0);
	/* wait for start data marker */
	i = 0;
	do 
	{
		_this->SPI(-1);
		i++;
	} while( !( _this->data == 254 ) );
	SYSTEM::_inst()->PUT(_this->spiCtrl, _this->SPIFAST + _this->CARD0);
	for( i = 0; 4 > 0 ? i <= 508 : i >= 508; i += 4 )
	{
		SYSTEM::_inst()->PUT(_this->spiData, -1);
		do 
		{
			; // empty statement
		} while( !( SYSTEM::_inst()->BIT(_this->spiCtrl, 0) ) );
		SYSTEM::_inst()->GET(_this->spiData, _this->data);
		SYSTEM::_inst()->PUT(dst, _this->data);
		dst += 4;
	}
	/* may be a checksum; deselect card */
	_this->SPI(255);
	_this->SPI(255);
	_this->SPIIdle(1);
	// END
}

void Kernel::WriteSD(int dst, int src)
{
	// VAR
	int i;
	int n;
	uint8_t x;

	// BEGIN
	Kernel* _this = _inst();
	/* CMD24 write one block */
	_this->SDShift(dst);
	_this->SPICmd(24, dst);
	ASSERT(_this->data == 0);
	/* write start data marker */
	_this->SPI(254);
	SYSTEM::_inst()->PUT(_this->spiCtrl, _this->SPIFAST + _this->CARD0);
	for( i = 0; 4 > 0 ? i <= 508 : i >= 508; i += 4 )
	{
		SYSTEM::_inst()->GET(src, n);
		src += 4;
		SYSTEM::_inst()->PUT(_this->spiData, n);
		do 
		{
			; // empty statement
		} while( !( SYSTEM::_inst()->BIT(_this->spiCtrl, 0) ) );
	}
	/* dummy checksum */
	_this->SPI(255);
	_this->SPI(255);
	i = 0;
	do 
	{
		_this->SPI(-1);
		i++;
	} while( !( (MOD(_this->data,32) == 5) || (i == 10000) ) );
	/* deselect card */
	ASSERT(MOD(_this->data,32) == 5);
	_this->SPIIdle(1);
	// END
}

void Kernel::InitSecMap()
{
	// VAR
	int i;

	// BEGIN
	Kernel* _this = _inst();
	_this->NofSectors = 0;
	_this->sectorMap[0] = ( _Set() + _Set( 0, 31) );
	_this->sectorMap[1] = ( _Set() + _Set( 0, 31) );
	for( i = 2; i <= DIV(_this->mapsize,32) - 1; i++ )
		_this->sectorMap[i] = ( _Set() );
	// END
}

void Kernel::MarkSector(int sec)
{
	// BEGIN
	Kernel* _this = _inst();
	sec = DIV(sec,29);
	ASSERT(SYSTEM::_inst()->H(0) == 0);
	INCL(_this->sectorMap[DIV(sec,32)], MOD(sec,32));
	_this->NofSectors++;
	// END
}

void Kernel::FreeSector(int sec)
{
	// BEGIN
	Kernel* _this = _inst();
	sec = DIV(sec,29);
	ASSERT(SYSTEM::_inst()->H(0) == 0);
	EXCL(_this->sectorMap[DIV(sec,32)], MOD(sec,32));
	_this->NofSectors--;
	// END
}

void Kernel::AllocSector(int hint, int& sec)
{
	// VAR
	int s;

	// BEGIN
	Kernel* _this = _inst();
	/* find free sector, starting after hint */
	hint = DIV(hint,29);
	ASSERT(SYSTEM::_inst()->H(0) == 0);
	s = hint;
	do 
	{
		s++;
		if( s == _this->mapsize )
			s = 1;
		
	} while( !( !(_this->sectorMap[DIV(s,32)].contains( MOD(s,32) )) ) );
	INCL(_this->sectorMap[DIV(s,32)], MOD(s,32));
	_this->NofSectors++;
	sec = s * 29;
	// END
}

void Kernel::GetSector(int src, _VarArray<uint8_t> dst)
{
	// BEGIN
	Kernel* _this = _inst();
	src = DIV(src,29);
	ASSERT(SYSTEM::_inst()->H(0) == 0);
	src = src * 2 + _this->FSoffset;
	_this->ReadSD(src, SYSTEM::_inst()->ADR(dst));
	_this->ReadSD(src + 1, SYSTEM::_inst()->ADR(dst) + 512);
	// END
}

void Kernel::PutSector(int dst, _VarArray<uint8_t> src)
{
	// BEGIN
	Kernel* _this = _inst();
	dst = DIV(dst,29);
	ASSERT(SYSTEM::_inst()->H(0) == 0);
	dst = dst * 2 + _this->FSoffset;
	_this->WriteSD(dst, SYSTEM::_inst()->ADR(src));
	_this->WriteSD(dst + 1, SYSTEM::_inst()->ADR(src) + 512);
	// END
}

/* -------- Miscellaneous procedures---------- */
int Kernel::Time()
{
	// VAR
	int t;

	// BEGIN
	Kernel* _this = _inst();
	SYSTEM::_inst()->GET(_this->timer, t);
	return t;
	// END
}

int Kernel::Clock()
{
	// BEGIN
	Kernel* _this = _inst();
	return _this->clock;
	// END
}

void Kernel::SetClock(int dt)
{
	// BEGIN
	Kernel* _this = _inst();
	_this->clock = dt;
	// END
}

void Kernel::Install(int Padr, int at)
{
	// BEGIN
	Kernel* _this = _inst();
	SYSTEM::_inst()->PUT(at, 0x0E7000000 + DIV((Padr - at),4) - 1);
	// END
}

void Kernel::Trap(int& a, int b)
{
	// VAR
	int u;
	int v;
	int w;

	// BEGIN
	Kernel* _this = _inst();
	/* trap number */
	u = SYSTEM::_inst()->REG(15);
	SYSTEM::_inst()->GET(u - 4, v);
	w = MOD(DIV(v,0x10),0x10);
	if( w == 0 )
		_this->New(a, b);
	else
	{
		/* stop */
		LED(w + 192);
		do 
		{
			; // empty statement
		} while( !( FALSE ) );
	}
	// END
}

void Kernel::Init()
{
	// BEGIN
	Kernel* _this = _inst();
	/* install temporary trap */
	_this->Install(SYSTEM::_inst()->ADR(_this->Trap), 0x20);
	SYSTEM::_inst()->GET(12, _this->MemLim);
	SYSTEM::_inst()->GET(24, _this->heapOrg);
	_this->stackOrg = _this->heapOrg;
	_this->stackSize = 0x8000;
	_this->heapLim = _this->MemLim;
	_this->list1 = 0;
	_this->list2 = 0;
	_this->list3 = 0;
	_this->list0 = _this->heapOrg;
	SYSTEM::_inst()->PUT(_this->list0, _this->heapLim - _this->heapOrg);
	SYSTEM::_inst()->PUT(_this->list0 + 4, -1);
	SYSTEM::_inst()->PUT(_this->list0 + 8, 0);
	_this->allocated = 0;
	_this->clock = 0;
	_this->InitSecMap();
	// END
}

Kernel::Kernel()
{
	; // empty statement
}

Kernel::~Kernel()
{
	s_inst.release();
}

