#ifndef __ObKernel_H__
#define __ObKernel_H__

// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17

#include <OberonSystem/Ob_Global.h>
#include <OberonSystem/ObSYSTEM.h>

namespace Ob
{
	class Kernel : public _Root
	{
	public:
		/* NW/PR  11.4.86 / 27.12.95 / 4.2.2014 */
		static Kernel* _inst();
		Kernel();
		~Kernel();

		// CONST
		static const int SectorLength = 1024;
		static const int timer = -64;
		static const int spiData = -48;
		static const int spiCtrl = -44;
		static const int CARD0 = 1;
		static const int SPIFAST = 4;
		/* 256MB in 512-byte blocks */
		static const int FSoffset = 0x80000;
		/* 1K sectors, 64MB */
		static const int mapsize = 0x10000;

		// TYPE
		typedef _FxArray<uint8_t,SectorLength> Sector;

		// VAR
		int allocated;
		int NofSectors;
		int heapOrg;
		int heapLim;
		int stackOrg;
		int stackSize;
		int MemLim;
		int clock;
		/* lists of free blocks of size n*256, 128, 64, 32 bytes */
		int list0;
		int list1;
		int list2;
		int list3;
		/* SPI data in */
		int data;
		_FxArray<_Set,DIV(mapsize,32)> sectorMap;

		// PROC
		static void GetBlock(int& p, int len);
		static void GetBlock128(int& p);
		static void GetBlock64(int& p);
		static void GetBlock32(int& p);
		static void New(int& ptr, int tag);
		static void Mark(int pref);
		static void Scan();
		static void SPIIdle(int n);
		static void SPI(int n);
		static void SPICmd(int n, int arg);
		static void SDShift(int& n);
		static void ReadSD(int src, int dst);
		static void WriteSD(int dst, int src);
		static void InitSecMap();
		static void MarkSector(int sec);
		static void FreeSector(int sec);
		static void AllocSector(int hint, int& sec);
		static void GetSector(int src, _VarArray<uint8_t> dst);
		static void PutSector(int dst, _VarArray<uint8_t> src);
		int Time();
		int Clock();
		static void SetClock(int dt);
		static void Install(int Padr, int at);
		static void Trap(int& a, int b);
		static void Init();

	};
}

#endif // __ObKernel_H__