// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObNet.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<Net> s_inst;

const int Net::PakSize;
const int Net::T0;
const int Net::T1;
const int Net::ACK;
const int Net::NAK;
const int Net::NPR;
const int Net::NRQ;
const int Net::NRS;
const int Net::SND;
const int Net::REC;
const int Net::MSG;
const int Net::TRQ;
const int Net::TIM;

Net* Net::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new Net() );
	return s_inst.get();
}

void Net::SetPartner(_ValArray<char> name)
{
	// BEGIN
	Net* _this = _inst();
	_this->head0.dadr = _this->head1.sadr;
	_this->partner = name;
	// END
}

void Net::Send(uint8_t t, int L, _ValArray<uint8_t> data)
{
	// BEGIN
	Net* _this = _inst();
	_this->head0.typ = t;
	_this->head0.len = L;
	SCC::_inst()->SendPacket(_this->head0, data);
	// END
}

void Net::ReceiveHead(int timeout)
{
	// VAR
	int time;

	// BEGIN
	Net* _this = _inst();
	time = Oberon::_inst()->Time() + timeout;
	do 
	{
		SCC::_inst()->ReceiveHead(_this->head1);
		if( _this->head1.valid && (_this->head1.sadr != _this->head0.dadr) )
		{
			SCC::_inst()->Skip(_this->head1.len);
			_this->head1.valid = FALSE;
		}
		if( !_this->head1.valid && (Oberon::_inst()->Time() >= time) )
			_this->head1.typ = 0x0FF;
		
	} while( !( _this->head1.valid || (_this->head1.typ == 0x0FF) ) );
	// END
}

void Net::FindPartner(_ValArray<char> name, int& res)
{
	// VAR
	int time;
	int k;
	_FxArray<char,8> Id;
	_FxArray<uint8_t,8> IdB;

	// BEGIN
	Net* _this = _inst();
	SCC::_inst()->Skip(SCC::_inst()->Available());
	res = 0;
	k = 0;
	while( (k < 7) && (name[k] != 0x0) )
	{
		Id[k] = name[k];
		IdB[k] = int( Id[k] );
		k++;
	}
	/*  <-- also terminate IdB  */
	Id[k] = 0x0;
	IdB[k] = 0;
	if( Id != _this->partner )
	{
		_this->head0.dadr = 0x0FF;
		_this->Send(_this->NRQ, k + 1, IdB);
		time = Oberon::_inst()->Time() + _this->T1;
		do 
		{
			SCC::_inst()->ReceiveHead(_this->head1);
			if( _this->head1.valid )
			{
				if( _this->head1.typ == _this->NRS )
					_this->SetPartner(Id);
				else
				{
					SCC::_inst()->Skip(_this->head1.len);
					_this->head1.valid = FALSE;
				}
			}else if( Oberon::_inst()->Time() >= time )
			{
				res = 1;
				_this->partner[0] = 0x0;
			}
		} while( !( _this->head1.valid || (res != 0) ) );
	}
	// END
}

void Net::AppendS(_ValArray<char> s, _VarArray<uint8_t> d, int& k)
{
	// VAR
	int i;
	char ch;

	// BEGIN
	Net* _this = _inst();
	i = 0;
	do 
	{
		ch = s[i];
		d[k] = int( ch );
		i++;
		k++;
	} while( !( ch == 0x0 ) );
	// END
}

void Net::AppendW(int s, _VarArray<uint8_t> d, int n, int& k)
{
	// VAR
	int i;

	// BEGIN
	Net* _this = _inst();
	i = 0;
	do 
	{
		d[k] = MOD(s,0x100);
		s = DIV(s,0x100);
		i++;
		k++;
	} while( !( i == n ) );
	// END
}

void Net::PickS(_VarArray<char> s)
{
	// VAR
	int i;
	uint8_t x;

	// BEGIN
	Net* _this = _inst();
	i = 0;
	do 
	{
		SCC::_inst()->Receive(x);
		s[i] = char( x );
		i++;
	} while( !( x == 0 ) );
	// END
}

void Net::PickQ(int& w)
{
	// VAR
	uint8_t x0;
	uint8_t x1;
	uint8_t x2;
	uint8_t x3;

	// BEGIN
	Net* _this = _inst();
	SCC::_inst()->Receive(x0);
	SCC::_inst()->Receive(x1);
	SCC::_inst()->Receive(x2);
	SCC::_inst()->Receive(x3);
	w = x0 + 0x100 * (x1 + 0x100 * (x2 + 0x100 * x3));
	// END
}

void Net::SendData(Files::File F)
{
	// VAR
	int k;
	int seqno;
	uint8_t x;
	int len;
	Files::Rider R;
	_FxArray<uint8_t,_this->PakSize> buf;

	// BEGIN
	Net* _this = _inst();
	Files::_inst()->Set(R, F, 0);
	len = 0;
	seqno = 0;
	do 
	{
		k = 0;
		do 
		{
			Files::_inst()->ReadByte(R, x);
			if( !R.eof )
			{
				buf[k] = x;
				k++;
			}
		} while( !( R.eof || (k == _this->PakSize) ) );
		do 
		{
			_this->Send(seqno, k, buf);
			_this->ReceiveHead(_this->T1);
		} while( !( _this->head1.typ != seqno + _this->ACK ) );
		seqno = MOD((seqno + 1),8);
		len = len + k;
		if( _this->head1.typ != seqno + _this->ACK )
		{
			Texts::_inst()->WriteString(_this->W, " failed");
			k = 0;
		}
	} while( !( k < _this->PakSize ) );
	Texts::_inst()->WriteInt(_this->W, len, 7);
	// END
}

void Net::ReceiveData(Files::File F, bool& done_)
{
	// VAR
	int k;
	int retry;
	int seqno;
	uint8_t x;
	int len;
	Files::Rider R;

	// BEGIN
	Net* _this = _inst();
	Files::_inst()->Set(R, F, 0);
	seqno = 0;
	len = 0;
	retry = 2;
	k = _this->PakSize;
	do 
	{
		if( _this->head1.typ == seqno )
		{
			seqno = MOD((seqno + 1),8);
			len = len + _this->head1.len;
			retry = 2;
			_this->Send(seqno + _this->ACK, 0, _this->dmy);
			k = 0;
			while( k < _this->head1.len )
			{
				SCC::_inst()->Receive(x);
				Files::_inst()->WriteByte(R, x);
				k++;
			}
			if( k < _this->PakSize )
				done_ = TRUE;
			
		}else
		{
			retry--;
			if( retry == 0 )
			{
				Texts::_inst()->WriteString(_this->W, " failed");
				done_ = FALSE;
				k = 0;
			}
			_this->Send(seqno + _this->ACK, 0, _this->dmy);
		}
		_this->ReceiveHead(_this->T0);
	} while( !( k < _this->PakSize ) );
	Texts::_inst()->WriteInt(_this->W, len, 7);
	// END
}

void Net::reply(int msg)
{
	// BEGIN
	Net* _this = _inst();
	if( msg == 1 )
		Texts::_inst()->WriteString(_this->W, " no link");
	else if( msg == 2 )
		Texts::_inst()->WriteString(_this->W, " no permission");
	else if( msg == 3 )
		Texts::_inst()->WriteString(_this->W, " not done");
	else if( msg == 4 )
		Texts::_inst()->WriteString(_this->W, " not found");
	else if( msg == 5 )
		Texts::_inst()->WriteString(_this->W, " no response");
	else if( msg == 6 )
		Texts::_inst()->WriteString(_this->W, " time set");
	
	Texts::_inst()->WriteLn(_this->W);
	Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
	// END
}

void Net::Serve()
{
	// VAR
	int i;
	bool done_;
	uint8_t x;
	Files::File F;
	int pw;
	int clock;
	int newclock_;
	_FxArray<char,8> Id;
	_FxArray<uint8_t,8> IdB;
	_FxArray<char,32> FileName;

	// BEGIN
	Net* _this = _inst();
	SCC::_inst()->ReceiveHead(_this->head1);
	if( _this->head1.valid )
	{
		if( _this->head1.typ == _this->SND )
		{
			_this->PickS(Id);
			_this->PickQ(pw);
			_this->PickS(FileName);
			Texts::_inst()->WriteString(_this->W, Id);
			Texts::_inst()->Write(_this->W, ' ');
			Texts::_inst()->WriteString(_this->W, FileName);
			F = Files::_inst()->Old(FileName);
			if( F != 0 )
			{
				Texts::_inst()->WriteString(_this->W, " sending");
				_this->SetPartner(Id);
				Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
				_this->SendData(F);
			}else
			{
				_this->Send(_this->NAK, 0, _this->dmy);
				Texts::_inst()->Write(_this->W, '~');
			}
			_this->reply(0);
		}else if( _this->head1.typ == _this->REC )
		{
			_this->PickS(Id);
			_this->PickQ(pw);
			_this->PickS(FileName);
			if( !_this->protected_ )
			{
				Texts::_inst()->WriteString(_this->W, Id);
				Texts::_inst()->Write(_this->W, ' ');
				Texts::_inst()->WriteString(_this->W, FileName);
				F = Files::_inst()->New(FileName);
				if( F != 0 )
				{
					Texts::_inst()->WriteString(_this->W, " receiving");
					_this->SetPartner(Id);
					Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
					_this->Send(_this->ACK, 0, _this->dmy);
					_this->ReceiveHead(_this->T0);
					_this->ReceiveData(F, done_);
					if( done_ )
						Files::_inst()->Register(F);
					
				}else
				{
					_this->Send(_this->NAK, 0, _this->dmy);
					Texts::_inst()->Write(_this->W, '~');
				}
				_this->reply(0);
			}else
				_this->Send(_this->NPR, 0, _this->dmy);

		}else if( _this->head1.typ == _this->MSG )
		{
			i = 0;
			while( i < _this->head1.len )
			{
				SCC::_inst()->Receive(x);
				Texts::_inst()->Write(_this->W, char( x ));
				i++;
			}
			_this->Send(_this->ACK, 0, _this->dmy);
			_this->reply(0);
		}else if( _this->head1.typ == _this->TRQ )
		{
			i = 0;
			_this->AppendW(Oberon::_inst()->Clock(), IdB, 4, i);
			_this->Send(_this->TIM, 4, IdB);
		}else if( _this->head1.typ == _this->TIM )
		{
			_this->PickQ(newclock_);
			_this->PickS(Id);
			_this->PickQ(pw);
			clock = Oberon::_inst()->Clock();
			if( !_this->protected_ && (Id[0] != 0x0) && (ABS(pw - clock) > 10) )
			{
				Oberon::_inst()->SetClock(newclock_);
				/*  RK: original ist Zeilenumbruch im String nach changed  */
				Texts::_inst()->WriteString(_this->W, Id);
				Texts::_inst()->WriteString(_this->W, " changed System.Date");
				Texts::_inst()->WriteClock(_this->W, newclock_);
				_this->reply(0);
			}
		}else if( _this->head1.typ == _this->NRQ )
		{
			i = 0;
			do 
			{
				SCC::_inst()->Receive(x);
				Id[i] = char( x );
				i++;
				if( i == 7 )
				{
					Id[7] = 0x0;
					x = 0;
				}
			} while( !( x == 0 ) );
			while( i < _this->head1.len )
			{
				SCC::_inst()->Receive(x);
				i++;
			}
			if( Id == Oberon::_inst()->User )
			{
				_this->SetPartner(Id);
				_this->Send(_this->NRS, 0, _this->dmy);
			}
		}else
			SCC::_inst()->Skip(_this->head1.len);

	}
	// END
}

void Net::GetPar1(Texts::Scanner& S)
{
	// BEGIN
	Net* _this = _inst();
	Texts::_inst()->OpenScanner(S, Oberon::_inst()->Par.text, Oberon::_inst()->Par.pos);
	Texts::_inst()->Scan(S);
	// END
}

void Net::GetPar(Texts::Scanner& S, int& end)
{
	// VAR
	Texts::Text T;
	int beg;
	int tm;

	// BEGIN
	Net* _this = _inst();
	Texts::_inst()->Scan(S);
	if( (S.class_ == Texts::_inst()->Char) && (S.c == '^') )
	{
		Oberon::_inst()->GetSelection(T, beg, end, tm);
		if( tm >= 0 )
		{
			Texts::_inst()->OpenScanner(S, T, beg);
			Texts::_inst()->Scan(S);
		}
	}else
		end = Oberon::_inst()->Par.text->len;

	// END
}

void Net::SendFiles()
{
	// VAR
	int k;
	int end;
	Texts::Scanner S;
	Files::File F;
	_FxArray<uint8_t,64> buf;

	// BEGIN
	Net* _this = _inst();
	_this->GetPar1(S);
	if( S.class_ == Texts::_inst()->Name )
	{
		_this->FindPartner(S.s, k);
		if( k == 0 )
		{
			_this->GetPar(S, end);
			while( (Texts::_inst()->Pos(S) < end) && (S.class_ == Texts::_inst()->Name) )
			{
				Texts::_inst()->WriteString(_this->W, S.s);
				k = 0;
				_this->AppendS(Oberon::_inst()->User, buf, k);
				_this->AppendW(Oberon::_inst()->Password, buf, 4, k);
				_this->AppendS(S.s, buf, k);
				/* prefix */
				if( S.nextCh == ':' )
				{
					Texts::_inst()->Scan(S);
					Texts::_inst()->Scan(S);
					if( S.class_ == Texts::_inst()->Name )
					{
						buf[k - 1] = int( '.' );
						_this->AppendS(S.s, buf, k);
						Texts::_inst()->Write(_this->W, ':');
						Texts::_inst()->WriteString(_this->W, S.s);
					}
				}
				F = Files::_inst()->Old(S.s);
				if( F != 0 )
				{
					_this->Send(_this->REC, k, buf);
					_this->ReceiveHead(_this->T0);
					if( _this->head1.typ == _this->ACK )
					{
						Texts::_inst()->WriteString(_this->W, " sending");
						Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
						_this->SendData(F);
						_this->reply(0);
					}else if( _this->head1.typ == _this->NPR )
					{
						_this->reply(2);
						end = 0;
					}else if( _this->head1.typ == _this->NAK )
					{
						_this->reply(3);
						end = 0;
					}else
					{
						_this->reply(5);
						end = 0;
					}
				}else
					_this->reply(4);

				Texts::_inst()->Scan(S);
			}
		}else
			_this->reply(1);

	}
	// END
}

void Net::ReceiveFiles()
{
	// VAR
	int k;
	bool done_;
	int end;
	Texts::Scanner S;
	Files::File F;
	_FxArray<uint8_t,64> buf;

	// BEGIN
	Net* _this = _inst();
	_this->GetPar1(S);
	if( S.class_ == Texts::_inst()->Name )
	{
		_this->FindPartner(S.s, k);
		if( k == 0 )
		{
			_this->GetPar(S, end);
			while( (Texts::_inst()->Pos(S) < end) && (S.class_ == Texts::_inst()->Name) )
			{
				Texts::_inst()->WriteString(_this->W, S.s);
				k = 0;
				_this->AppendS(Oberon::_inst()->User, buf, k);
				_this->AppendW(Oberon::_inst()->Password, buf, 4, k);
				_this->AppendS(S.s, buf, k);
				/* prefix */
				if( S.nextCh == ':' )
				{
					Texts::_inst()->Scan(S);
					Texts::_inst()->Scan(S);
					if( S.class_ == Texts::_inst()->Name )
					{
						buf[k - 1] = int( '.' );
						_this->AppendS(S.s, buf, k);
						Texts::_inst()->Write(_this->W, ':');
						Texts::_inst()->WriteString(_this->W, S.s);
					}
				}
				_this->Send(_this->SND, k, buf);
				Texts::_inst()->WriteString(_this->W, " receiving");
				Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
				_this->ReceiveHead(_this->T1);
				if( _this->head1.typ == 0 )
				{
					F = Files::_inst()->New(S.s);
					if( F != 0 )
					{
						_this->ReceiveData(F, done_);
						if( done_ )
						{
							Files::_inst()->Register(F);
							_this->reply(0);
						}else
							end = 0;

					}else
					{
						_this->reply(3);
						_this->Send(_this->NAK, 0, _this->dmy);
					}
				}else if( _this->head1.typ == _this->NAK )
					_this->reply(4);
				else if( _this->head1.typ == _this->NPR )
				{
					_this->reply(2);
					end = 0;
				}else
				{
					_this->reply(5);
					end = 0;
				}
				Texts::_inst()->Scan(S);
			}
		}else
			_this->reply(1);

	}
	// END
}

void Net::SendMsg()
{
	// VAR
	int i;
	char ch;
	Texts::Scanner S;
	_FxArray<uint8_t,64> msg;

	// BEGIN
	Net* _this = _inst();
	_this->GetPar1(S);
	if( S.class_ == Texts::_inst()->Name )
	{
		_this->FindPartner(S.s, i);
		if( i == 0 )
		{
			Texts::_inst()->Read(S, ch);
			while( (ch >= ' ') && (i < 64) )
			{
				msg[i] = int( ch );
				i++;
				Texts::_inst()->Read(S, ch);
			}
			_this->Send(_this->MSG, i, msg);
			_this->ReceiveHead(_this->T0);
			if( _this->head1.typ != _this->ACK )
				_this->reply(3);
			
		}else
			_this->reply(1);

	}
	// END
}

void Net::GetTime()
{
	// VAR
	int dt;
	int res;
	Texts::Scanner S;

	// BEGIN
	Net* _this = _inst();
	_this->GetPar1(S);
	if( S.class_ == Texts::_inst()->Name )
	{
		_this->FindPartner(S.s, res);
		if( res == 0 )
		{
			_this->Send(_this->TRQ, 0, _this->dmy);
			_this->ReceiveHead(_this->T1);
			if( _this->head1.typ == _this->TIM )
			{
				_this->PickQ(dt);
				Oberon::_inst()->SetClock(dt);
				_this->reply(6);
			}
		}else
			_this->reply(1);

	}
	// END
}

void Net::StartServer()
{
	// BEGIN
	Net* _this = _inst();
	_this->protected_ = TRUE;
	_this->partner[0] = 0x0;
	SCC::_inst()->Start(TRUE);
	Oberon::_inst()->Remove(_this->Server);
	Oberon::_inst()->Install(_this->Server);
	Texts::_inst()->WriteString(_this->W, " Server started as ");
	Texts::_inst()->WriteString(_this->W, Oberon::_inst()->User);
	Texts::_inst()->WriteLn(_this->W);
	Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
	// END
}

void Net::Unprotect()
{
	// BEGIN
	Net* _this = _inst();
	_this->protected_ = FALSE;
	// END
}

void Net::WProtect()
{
	// BEGIN
	Net* _this = _inst();
	_this->protected_ = TRUE;
	// END
}

void Net::Reset()
{
	// BEGIN
	Net* _this = _inst();
	SCC::_inst()->Start(TRUE);
	// END
}

void Net::StopServer()
{
	// BEGIN
	Net* _this = _inst();
	Oberon::_inst()->Remove(_this->Server);
	Texts::_inst()->WriteString(_this->W, " Server stopped");
	Texts::_inst()->WriteLn(_this->W);
	Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
	// END
}

void Net::SCCStatus()
{
	// BEGIN
	Net* _this = _inst();
	Texts::_inst()->WriteString(_this->W, "SCC.Available() ");
	Texts::_inst()->WriteInt(_this->W, SCC::_inst()->Available(), 1);
	Texts::_inst()->WriteLn(_this->W);
	Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
	// END
}

Net::Net()
{
	// BEGIN
	Texts::_inst()->OpenWriter(W);
	Server = Oberon::_inst()->NewTask(Serve, 500);
	// END
}

Net::~Net()
{
	s_inst.release();
}

