// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObORB.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<ORB> s_inst;

const int ORB::versionkey;
const int ORB::maxTypTab;
const int ORB::Head;
const int ORB::Const;
const int ORB::Var;
const int ORB::Par;
const int ORB::Fld;
const int ORB::Typ;
const int ORB::SProc;
const int ORB::SFunc;
const int ORB::Mod;
const int ORB::Byte;
const int ORB::Bool;
const int ORB::Char;
const int ORB::Int;
const int ORB::Real;
const int ORB::Set;
const int ORB::Pointer;
const int ORB::NilTyp;
const int ORB::NoTyp;
const int ORB::Proc;
const int ORB::String;
const int ORB::Array;
const int ORB::Record;

ORB* ORB::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new ORB() );
	return s_inst.get();
}

/* insert new Object with name id */
void ORB::NewObj(Object& obj, _ValArray<char> id, int class_)
{
	// VAR
	Object new_;
	Object x;

	// BEGIN
	ORB* _this = _inst();
	x = _this->topScope;
	while( (x->next != 0) && (x->next->name != id) )
		x = x->next;
	
	if( x->next == 0 )
	{
		new_ = new ORB::ObjDesc();
		new_->name = id;
		new_->class_ = class_;
		new_->next = 0;
		new_->rdo = FALSE;
		new_->dsc = 0;
		x->next = new_;
		obj = new_;
	}else
	{
		obj = x->next;
		ORS::_inst()->Mark("mult def");
	}
	// END
}

ORB::Object ORB::thisObj_()
{
	// VAR
	Object s;
	Object x;

	// BEGIN
	ORB* _this = _inst();
	s = _this->topScope;
	do 
	{
		x = s->next;
		while( (x != 0) && (x->name != ORS::_inst()->id) )
			x = x->next;
		
		s = s->dsc;
	} while( !( (x != 0) || (s == 0) ) );
	return x;
	// END
}

ORB::Object ORB::thisimport_(Object mod)
{
	// VAR
	Object obj;

	// BEGIN
	ORB* _this = _inst();
	if( mod->rdo )
	{
		if( mod->name[0] != 0x0 )
		{
			obj = mod->dsc;
			while( (obj != 0) && (obj->name != ORS::_inst()->id) )
				obj = obj->next;
			
		}else
			obj = 0;

	}else
		obj = 0;

	return obj;
	// END
}

ORB::Object ORB::thisfield_(Type rec)
{
	// VAR
	Object fld;

	// BEGIN
	ORB* _this = _inst();
	fld = rec->dsc;
	while( (fld != 0) && (fld->name != ORS::_inst()->id) )
		fld = fld->next;
	
	return fld;
	// END
}

void ORB::OpenScope()
{
	// VAR
	Object s;

	// BEGIN
	ORB* _this = _inst();
	s = new ORB::ObjDesc();
	s->class_ = _this->Head;
	s->dsc = _this->topScope;
	s->next = 0;
	_this->topScope = s;
	// END
}

void ORB::CloseScope()
{
	// BEGIN
	ORB* _this = _inst();
	_this->topScope = _this->topScope->dsc;
	// END
}

/* ------------------------------- Import --------------------------------- */
void ORB::MakeFileName(_VarArray<char> FName, _ValArray<char> name, _ValArray<char> ext)
{
	// VAR
	int i;
	int j;

	// BEGIN
	ORB* _this = _inst();
	/* assume name suffix less than 4 characters */
	i = 0;
	j = 0;
	while( (i < ORS::_inst()->IdLen - 5) && (name[i] > 0x0) )
	{
		FName[i] = name[i];
		i++;
	}
	do 
	{
		FName[i] = ext[j];
		i++;
		j++;
	} while( !( ext[j] == 0x0 ) );
	FName[i] = 0x0;
	// END
}

ORB::Object ORB::ThisModule(_ValArray<char> name, _ValArray<char> orgname_, bool non, int key)
{
	// VAR
	Module mod;
	Object obj;
	Object obj1;

	// BEGIN
	ORB* _this = _inst();
	/* search for module */
	obj1 = _this->topScope;
	obj = obj1->next;
	while( (obj != 0) && (obj->name != name) )
	{
		obj1 = obj;
		obj = obj1->next;
	}
	/* insert new module */
	if( obj == 0 )
	{
		mod = new ORB::ModDesc();
		mod->class_ = _this->Mod;
		mod->rdo = FALSE;
		mod->name = name;
		mod->orgname_ = orgname_;
		mod->val = key;
		mod->lev = _this->nofmod;
		_this->nofmod++;
		mod->type = _this->noType;
		mod->dsc = 0;
		mod->next = 0;
		obj1->next = mod;
		obj = mod;
	}else
	{
		/* module already present */
		if( non )
			ORS::_inst()->Mark("invalid import order");
		
	}
	return obj;
	// END
}

void ORB::Read(Files::Rider& R, int& x)
{
	// VAR
	uint8_t b;

	// BEGIN
	ORB* _this = _inst();
	Files::_inst()->ReadByte(R, b);
	if( b < 0x80 )
		x = b;
	else
		x = b - 0x100;

	// END
}

void ORB::InType(Files::Rider& R, Object thismod_, Type& T)
{
	// VAR
	int key;
	int ref;
	int class_;
	int form_;
	int np;
	int readonly;
	Object fld;
	Object par;
	Object obj;
	Object mod;
	Type t;
	ORS::Ident name;
	ORS::Ident modname;

	// BEGIN
	ORB* _this = _inst();
	_this->Read(R, ref);
	/* already read */
	if( ref < 0 )
		T = _this->typtab[-ref];
	else
	{
		t = new ORB::TypeDesc();
		T = t;
		_this->typtab[ref] = t;
		t->mno = thismod_->lev;
		_this->Read(R, form_);
		t->form_ = form_;
		if( form_ == _this->Pointer )
		{
			_this->InType(R, thismod_, t->base);
			t->size = 4;
		}else if( form_ == _this->Array )
		{
			_this->InType(R, thismod_, t->base);
			Files::_inst()->ReadNum(R, t->len);
			Files::_inst()->ReadNum(R, t->size);
		}else if( form_ == _this->Record )
		{
			_this->InType(R, thismod_, t->base);
			if( t->base->form_ == _this->NoTyp )
			{
				t->base = 0;
				obj = 0;
			}else
				obj = t->base->dsc;

			/* TD adr/exno */
			Files::_inst()->ReadNum(R, t->len);
			/* ext level */
			Files::_inst()->ReadNum(R, t->nofpar);
			Files::_inst()->ReadNum(R, t->size);
			_this->Read(R, class_);
			/* fields */
			while( class_ != 0 )
			{
				fld = new ORB::ObjDesc();
				fld->class_ = class_;
				Files::_inst()->ReadString(R, fld->name);
				if( fld->name[0] != 0x0 )
				{
					fld->expo = TRUE;
					_this->InType(R, thismod_, fld->type);
				}else
				{
					fld->expo = FALSE;
					fld->type = _this->nilType;
				}
				Files::_inst()->ReadNum(R, fld->val);
				fld->next = obj;
				obj = fld;
				_this->Read(R, class_);
			}
			t->dsc = obj;
		}else if( form_ == _this->Proc )
		{
			_this->InType(R, thismod_, t->base);
			obj = 0;
			np = 0;
			_this->Read(R, class_);
			/* parameters */
			while( class_ != 0 )
			{
				par = new ORB::ObjDesc();
				par->class_ = class_;
				_this->Read(R, readonly);
				par->rdo = readonly == 1;
				_this->InType(R, thismod_, par->type);
				par->next = obj;
				obj = par;
				np++;
				_this->Read(R, class_);
			}
			t->dsc = obj;
			t->nofpar = np;
			t->size = 4;
		}
		Files::_inst()->ReadString(R, modname);
		/* re-import */
		if( modname[0] != 0x0 )
		{
			Files::_inst()->ReadInt(R, key);
			Files::_inst()->ReadString(R, name);
			mod = _this->ThisModule(modname, modname, FALSE, key);
			/* search type */
			obj = mod->dsc;
			while( (obj != 0) && (obj->name != name) )
				obj = obj->next;
			
			/* type object found in object list of mod */
			if( obj != 0 )
				T = obj->type;
			else
			{
				/* insert new type object in object list of mod */
				obj = new ORB::ObjDesc();
				obj->name = name;
				obj->class_ = _this->Typ;
				obj->next = mod->dsc;
				mod->dsc = obj;
				obj->type = t;
				t->mno = mod->lev;
				t->typobj = obj;
				T = t;
			}
			_this->typtab[ref] = T;
		}
	}
	// END
}

void ORB::Import(_VarArray<char> modid, _VarArray<char> modid1)
{
	// VAR
	int key;
	int class_;
	int k;
	Object obj;
	Type t;
	Object thismod_;
	ORS::Ident modname;
	ORS::Ident fname;
	Files::File F;
	Files::Rider R;

	// BEGIN
	ORB* _this = _inst();
	if( modid1 == "SYSTEM" )
	{
		thismod_ = _this->ThisModule(modid, modid1, TRUE, key);
		_this->nofmod--;
		thismod_->lev = 0;
		thismod_->dsc = _this->system;
		thismod_->rdo = TRUE;
	}else
	{
		_this->MakeFileName(fname, modid1, ".smb");
		F = Files::_inst()->Old(fname);
		if( F != 0 )
		{
			Files::_inst()->Set(R, F, 0);
			Files::_inst()->ReadInt(R, key);
			Files::_inst()->ReadInt(R, key);
			Files::_inst()->ReadString(R, modname);
			thismod_ = _this->ThisModule(modid, modid1, TRUE, key);
			thismod_->rdo = TRUE;
			/* version key */
			_this->Read(R, class_);
			if( class_ != _this->versionkey )
				ORS::_inst()->Mark("wrong version");
			
			_this->Read(R, class_);
			while( class_ != 0 )
			{
				obj = new ORB::ObjDesc();
				obj->class_ = class_;
				Files::_inst()->ReadString(R, obj->name);
				_this->InType(R, thismod_, obj->type);
				obj->lev = -thismod_->lev;
				if( class_ == _this->Typ )
				{
					/* fixup bases of previously declared pointer types */
					t = obj->type;
					t->typobj = obj;
					_this->Read(R, k);
					while( k != 0 )
					{
						_this->typtab[k].base = t;
						_this->Read(R, k);
					}
				}else
				{
					if( class_ == _this->Const )
					{
						if( obj->type->form_ == _this->Real )
							Files::_inst()->ReadInt(R, obj->val);
						else
							Files::_inst()->ReadNum(R, obj->val);

					}else if( class_ == _this->Var )
					{
						Files::_inst()->ReadNum(R, obj->val);
						obj->rdo = TRUE;
					}
				}
				obj->next = thismod_->dsc;
				thismod_->dsc = obj;
				_this->Read(R, class_);
			}
		}else
			ORS::_inst()->Mark("import not available");

	}
	// END
}

/* -------------------------------- Export --------------------------------- */
void ORB::Write(Files::Rider& R, int x)
{
	// BEGIN
	ORB* _this = _inst();
	Files::_inst()->WriteByte(R, x);
	// END
}

void ORB::OutPar(Files::Rider& R, Object par, int n)
{
	// VAR
	int cl;

	// BEGIN
	ORB* _this = _inst();
	if( n > 0 )
	{
		_this->OutPar(R, par->next, n - 1);
		cl = par->class_;
		_this->Write(R, cl);
		if( par->rdo )
			_this->Write(R, 1);
		else
			_this->Write(R, 0);

		_this->OutType(R, par->type);
	}
	// END
}

void ORB::FindHiddenPointers(Files::Rider& R, Type typ, int offset)
{
	// VAR
	Object fld;
	int i;
	int n;

	// BEGIN
	ORB* _this = _inst();
	if( (typ->form_ == _this->Pointer) || (typ->form_ == _this->NilTyp) )
	{
		_this->Write(R, _this->Fld);
		_this->Write(R, 0);
		Files::_inst()->WriteNum(R, offset);
	}else if( typ->form_ == _this->Record )
	{
		fld = typ->dsc;
		while( fld != 0 )
		{
			_this->FindHiddenPointers(R, fld->type, fld->val + offset);
			fld = fld->next;
		}
	}else if( typ->form_ == _this->Array )
	{
		i = 0;
		n = typ->len;
		while( i < n )
		{
			_this->FindHiddenPointers(R, typ->base, typ->base->size * i + offset);
			i++;
		}
	}
	// END
}

void ORB::OutType(Files::Rider& R, Type t)
{
	// VAR
	Object obj;
	Object mod;
	Object fld;

	// BEGIN
	ORB* _this = _inst();
	/* type was already output */
	if( t->ref > 0 )
		_this->Write(R, -t->ref);
	else
	{
		obj = t->typobj;
		/* anonymous */
		if( obj != 0 )
		{
			_this->Write(R, _this->Ref);
			t->ref = _this->Ref;
			_this->Ref++;
		}else
			_this->Write(R, 0);

		_this->Write(R, t->form_);
		if( t->form_ == _this->Pointer )
			_this->OutType(R, t->base);
		else if( t->form_ == _this->Array )
		{
			_this->OutType(R, t->base);
			Files::_inst()->WriteNum(R, t->len);
			Files::_inst()->WriteNum(R, t->size);
		}else if( t->form_ == _this->Record )
		{
			if( t->base != 0 )
				_this->OutType(R, t->base);
			else
				_this->OutType(R, _this->noType);

			if( obj != 0 )
				Files::_inst()->WriteNum(R, obj->exno);
			else
				_this->Write(R, 0);

			Files::_inst()->WriteNum(R, t->nofpar);
			Files::_inst()->WriteNum(R, t->size);
			fld = t->dsc;
			/* fields */
			while( fld != 0 )
			{
				if( fld->expo )
				{
					/* offset */
					_this->Write(R, _this->Fld);
					Files::_inst()->WriteString(R, fld->name);
					_this->OutType(R, fld->type);
					Files::_inst()->WriteNum(R, fld->val);
				}else
					_this->FindHiddenPointers(R, fld->type, fld->val);

				fld = fld->next;
			}
			_this->Write(R, 0);
		}else if( t->form_ == _this->Proc )
		{
			_this->OutType(R, t->base);
			_this->OutPar(R, t->dsc, t->nofpar);
			_this->Write(R, 0);
		}
		/* re-export, output name */
		if( (t->mno > 0) && (obj != 0) )
		{
			mod = _this->topScope->next;
			while( (mod != 0) && (mod->lev != t->mno) )
				mod = mod->next;
			
			if( mod != 0 )
			{
				Files::_inst()->WriteString(R, mod->_to<Module>()->orgname_);
				Files::_inst()->WriteInt(R, mod->val);
				Files::_inst()->WriteString(R, obj->name);
			}else
			{
				ORS::_inst()->Mark("re-export not found");
				_this->Write(R, 0);
			}
		}else
			_this->Write(R, 0);

	}
	// END
}

void ORB::Export(_VarArray<char> modid, bool& newSF_, int& key)
{
	// VAR
	int x;
	int sum;
	int oldkey;
	Object obj;
	Object obj0;
	ORS::Ident filename;
	Files::File F;
	Files::File F1;
	Files::Rider R;
	Files::Rider R1;

	// BEGIN
	ORB* _this = _inst();
	_this->Ref = _this->Record + 1;
	_this->MakeFileName(filename, modid, ".smb");
	F = Files::_inst()->New(filename);
	Files::_inst()->Set(R, F, 0);
	/* placeholder */
	Files::_inst()->WriteInt(R, 0);
	/* placeholder for key to be inserted at the end */
	Files::_inst()->WriteInt(R, 0);
	Files::_inst()->WriteString(R, modid);
	_this->Write(R, _this->versionkey);
	obj = _this->topScope->next;
	while( obj != 0 )
	{
		if( obj->expo )
		{
			_this->Write(R, obj->class_);
			Files::_inst()->WriteString(R, obj->name);
			_this->OutType(R, obj->type);
			if( obj->class_ == _this->Typ )
			{
				if( obj->type->form_ == _this->Record )
				{
					/* check whether this is base of previously declared pointer types */
					obj0 = _this->topScope->next;
					while( obj0 != obj )
					{
						if( (obj0->type->form_ == _this->Pointer) && (obj0->type->base == obj->type) && (obj0->type->ref > 0) )
							_this->Write(R, obj0->type->ref);
						
						obj0 = obj0->next;
					}
				}
				_this->Write(R, 0);
			}else if( obj->class_ == _this->Const )
			{
				if( obj->type->form_ == _this->Proc )
					Files::_inst()->WriteNum(R, obj->exno);
				else if( obj->type->form_ == _this->Real )
					Files::_inst()->WriteInt(R, obj->val);
				else
					Files::_inst()->WriteNum(R, obj->val);

			}else if( obj->class_ == _this->Var )
				Files::_inst()->WriteNum(R, obj->exno);
			
		}
		obj = obj->next;
	}
	do 
	{
		_this->Write(R, 0);
	} while( !( MOD(Files::_inst()->Length(F),4) == 0 ) );
	for( Ref = _this->Record + 1; Ref <= _this->maxTypTab - 1; Ref++ )
		_this->typtab[_this->Ref] = 0;
	/*  compute key (checksum)  */
	Files::_inst()->Set(R, F, 0);
	sum = 0;
	Files::_inst()->ReadInt(R, x);
	while( !R.eof )
	{
		sum = sum + x;
		Files::_inst()->ReadInt(R, x);
	}
	/* sum is new key */
	F1 = Files::_inst()->Old(filename);
	if( F1 != 0 )
	{
		Files::_inst()->Set(R1, F1, 4);
		Files::_inst()->ReadInt(R1, oldkey);
	}else
		oldkey = sum + 1;

	if( sum != oldkey )
	{
		if( newSF_ || (F1 == 0) )
		{
			/* insert checksum */
			key = sum;
			newSF_ = TRUE;
			Files::_inst()->Set(R, F, 4);
			Files::_inst()->WriteInt(R, sum);
			Files::_inst()->Register(F);
		}else
			ORS::_inst()->Mark("new symbol file inhibited");

	}else
	{
		newSF_ = FALSE;
		key = sum;
	}
	// END
}

void ORB::Init()
{
	// BEGIN
	ORB* _this = _inst();
	_this->topScope = _this->universe;
	_this->nofmod = 1;
	// END
}

ORB::Type ORB::type(int ref, int form_, int size)
{
	// VAR
	Type tp;

	// BEGIN
	ORB* _this = _inst();
	tp = new ORB::TypeDesc();
	tp->form_ = form_;
	tp->size = size;
	tp->ref = ref;
	tp->base = 0;
	_this->typtab[ref] = tp;
	return tp;
	// END
}

void ORB::enter(_ValArray<char> name, int cl, Type type, int n)
{
	// VAR
	Object obj;

	// BEGIN
	ORB* _this = _inst();
	obj = new ORB::ObjDesc();
	obj->name = name;
	obj->class_ = cl;
	obj->type = type;
	obj->val = n;
	obj->dsc = 0;
	if( cl == _this->Typ )
		type->typobj = obj;
	
	obj->next = _this->system;
	_this->system = obj;
	// END
}

ORB::ORB()
{
	// BEGIN
	byteType = type(Byte, Int, 1);
	boolType_ = type(Bool, Bool, 1);
	charType_ = type(Char, Char, 1);
	intType_ = type(Int, Int, 4);
	realType = type(Real, Real, 4);
	setType = type(Set, Set, 4);
	nilType = type(NilTyp, NilTyp, 4);
	noType = type(NoTyp, NoTyp, 4);
	strType = type(String, String, 8);
	/* initialize universe with data types and in-line procedures;
    INTEGER is synonym to INTEGER, LONGREAL to REAL.
    LED, ADC, SBC; LDPSR, LDREG, REG, COND are not in language definition */
	/* n = procno*10 + nofpar */
	system = 0;
	/* functions */
	enter("UML", SFunc, intType_, 132);
	enter("SBC", SFunc, intType_, 122);
	enter("ADC", SFunc, intType_, 112);
	enter("ROR", SFunc, intType_, 92);
	enter("ASR", SFunc, intType_, 82);
	enter("LSL", SFunc, intType_, 72);
	enter("LEN", SFunc, intType_, 61);
	enter("CHR", SFunc, charType_, 51);
	enter("ORD", SFunc, intType_, 41);
	enter("FLT", SFunc, realType, 31);
	enter("FLOOR", SFunc, intType_, 21);
	enter("ODD", SFunc, boolType_, 11);
	enter("ABS", SFunc, intType_, 1);
	/* procedures */
	enter("LED", SProc, noType, 81);
	enter("UNPK", SProc, noType, 72);
	enter("PACK", SProc, noType, 62);
	enter("NEW", SProc, noType, 51);
	enter("ASSERT", SProc, noType, 41);
	enter("EXCL", SProc, noType, 32);
	enter("INCL", SProc, noType, 22);
	enter("DEC", SProc, noType, 11);
	enter("INC", SProc, noType, 1);
	/* types */
	enter("SET", Typ, setType, 0);
	enter("BOOLEAN", Typ, boolType_, 0);
	enter("BYTE", Typ, byteType, 0);
	enter("CHAR", Typ, charType_, 0);
	enter("LONGREAL", Typ, realType, 0);
	enter("REAL", Typ, realType, 0);
	enter("INTEGER", Typ, intType_, 0);
	enter("INTEGER", Typ, intType_, 0);
	topScope = 0;
	OpenScope();
	topScope->next = system;
	universe = topScope;
	/*  initialize "unsafe" pseudo-module SYSTEM */
	system = 0;
	/* functions */
	enter('H', SFunc, intType_, 201);
	enter("COND", SFunc, boolType_, 191);
	enter("SIZE", SFunc, intType_, 181);
	enter("ADR", SFunc, intType_, 171);
	enter("VAL", SFunc, intType_, 162);
	enter("REG", SFunc, intType_, 151);
	enter("BIT", SFunc, boolType_, 142);
	/* procedures */
	enter("LDREG", SProc, noType, 142);
	enter("LDPSR", SProc, noType, 131);
	enter("COPY", SProc, noType, 123);
	enter("PUT", SProc, noType, 112);
	enter("GET", SProc, noType, 102);
	// END
}

ORB::~ORB()
{
	s_inst.release();
}

