#ifndef __ObORB_H__
#define __ObORB_H__

// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17

#include <OberonSystem/Ob_Global.h>
#include <OberonSystem/ObFiles.h>
#include <OberonSystem/ObORS.h>

namespace Ob
{
	class ORB : public _Root
	{
	public:
		/* NW 25.6.2014  / 17.9.2018  in Oberon-07 */
		static ORB* _inst();
		ORB();
		~ORB();

		// CONST
		/* Definition of data types Object and Type, which together form the data structure
    called "symbol table". Contains procedures for creation of Objects, and for search:
    NewObj, this, thisimport, thisfield (and OpenScope, CloseScope).
    Handling of import and export, i.e. reading and writing of "symbol files" is done by procedures
    Import and Export. This module contains the list of standard identifiers, with which
    the symbol table (universe), and that of the pseudo-module SYSTEM are initialized.  */
		static const int versionkey = 1;
		static const int maxTypTab = 64;
		/*  class values */
		static const int Head = 0;
		static const int Const = 1;
		static const int Var = 2;
		static const int Par = 3;
		static const int Fld = 4;
		static const int Typ = 5;
		static const int SProc = 6;
		static const int SFunc = 7;
		static const int Mod = 8;
		/*  form values */
		static const int Byte = 1;
		static const int Bool = 2;
		static const int Char = 3;
		static const int Int = 4;
		static const int Real = 5;
		static const int Set = 6;
		static const int Pointer = 7;
		static const int NilTyp = 8;
		static const int NoTyp = 9;
		static const int Proc = 10;
		static const int String = 11;
		static const int Array = 12;
		static const int Record = 13;

		// TYPE
		struct ObjDesc;
		struct ModDesc;
		struct TypeDesc;

		typedef ObjDesc* Object;
		typedef ModDesc* Module;
		typedef TypeDesc* Type;
		struct ObjDesc : public _Root {
			uint8_t class_;
			Object dsc;
			uint8_t exno;
			bool expo;
			int lev;
			ORS::Ident name;
			Object next;
			bool rdo;
			Type type;
			int val;
		};
		/* exported / read-only */
		struct ModDesc : public ObjDesc {
			ORS::Ident orgname_;
		};
		struct TypeDesc : public _Root {
			Type base;
			Object dsc;
			int form_;
			int len;
			int mno;
			int nofpar;
			int ref;
			int size;
			Object typobj;
		};

		// VAR
		/* ref is only used for import/export */
		/* for procedures, extension level for records */
		/* for arrays, len < 0 => open array; for records: adr of descriptor */
		/* for arrays, records, pointers */
		/* in bytes; always multiple of 4, except for Byte, Bool and Char */
		/*  Object classes and the meaning of "val":
    class    val
    ----------
    Var      address
    Par      address
    Const    value
    Fld      offset
    Typ      type descriptor (TD) address
    SProc    inline code number
    SFunc    inline code number
    Mod      key

  Type forms and the meaning of "dsc" and "base":
    form     dsc      base
    ------------------------
    Pointer  -        type of dereferenced object
    Proc     params   result type
    Array    -        type of elements
    Record   fields   extension  */
		Object topScope;
		Object universe;
		Object system;
		Type byteType;
		Type boolType_;
		Type charType_;
		Type intType_;
		Type realType;
		Type setType;
		Type nilType;
		Type noType;
		Type strType;
		int nofmod;
		int Ref;
		_FxArray<Type,maxTypTab> typtab;

		// PROC
		static void NewObj(Object& obj, _ValArray<char> id, int class_);
		Object thisObj_();
		Object thisimport_(Object mod);
		Object thisfield_(Type rec);
		static void OpenScope();
		static void CloseScope();
		static void MakeFileName(_VarArray<char> FName, _ValArray<char> name, _ValArray<char> ext);
		Object ThisModule(_ValArray<char> name, _ValArray<char> orgname_, bool non, int key);
		static void Read(Files::Rider& R, int& x);
		static void InType(Files::Rider& R, Object thismod_, Type& T);
		static void Import(_VarArray<char> modid, _VarArray<char> modid1);
		static void Write(Files::Rider& R, int x);
		static void OutPar(Files::Rider& R, Object par, int n);
		static void FindHiddenPointers(Files::Rider& R, Type typ, int offset);
		static void OutType(Files::Rider& R, Type t);
		static void Export(_VarArray<char> modid, bool& newSF_, int& key);
		static void Init();
		Type type(int ref, int form_, int size);
		static void enter(_ValArray<char> name, int cl, Type type, int n);

	};
}

#endif // __ObORB_H__