// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObORG.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<ORG> s_inst;

const int ORG::WordSize;
const int ORG::StkOrg0;
const int ORG::VarOrg0;
const int ORG::MT;
const int ORG::SP;
const int ORG::LNK;
const int ORG::maxCode;
const int ORG::maxStrx;
const int ORG::maxTD;
const int ORG::C24;
const int ORG::Reg;
const int ORG::RegI;
const int ORG::Cond;
const int ORG::U;
const int ORG::V;
const int ORG::Mov;
const int ORG::Lsl;
const int ORG::Asr;
const int ORG::Ror;
const int ORG::And;
const int ORG::Ann;
const int ORG::Ior;
const int ORG::Xor;
const int ORG::Add;
const int ORG::Sub;
const int ORG::Cmp;
const int ORG::Mul;
const int ORG::Div;
const int ORG::Fad;
const int ORG::Fsb;
const int ORG::Fml;
const int ORG::Fdv;
const int ORG::Ldr;
const int ORG::Str;
const int ORG::BR;
const int ORG::BLR;
const int ORG::BC;
const int ORG::BL;
const int ORG::MI;
const int ORG::PL;
const int ORG::EQ;
const int ORG::NE;
const int ORG::LT;
const int ORG::GE;
const int ORG::LE;
const int ORG::GT;

ORG* ORG::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new ORG() );
	return s_inst.get();
}

/* instruction assemblers according to formats */
void ORG::Put0(int op, int a, int b, int c)
{
	// BEGIN
	ORG* _this = _inst();
	/* emit format-0 instruction */
	_this->code[_this->pc] = ((a * 0x10 + b) * 0x10 + op) * 0x10000 + c;
	_this->pc++;
	// END
}

void ORG::Put1(int op, int a, int b, int im)
{
	// BEGIN
	ORG* _this = _inst();
	/* emit format-1 instruction,  -10000H <= im < 10000H */
	if( im < 0 )
		op += _this->V;
	
	_this->code[_this->pc] = (((a + 0x40) * 0x10 + b) * 0x10 + op) * 0x10000 + (MOD(im,0x10000));
	_this->pc++;
	// END
}

void ORG::Put1a(int op, int a, int b, int im)
{
	// BEGIN
	ORG* _this = _inst();
	/* same as Put1, but with range test  -10000H <= im < 10000H */
	if( (im >= -0x10000) && (im <= 0x0FFFF) )
		_this->Put1(op, a, b, im);
	else
	{
		_this->Put1(_this->Mov + _this->U, _this->RH, 0, DIV(im,0x10000));
		if( MOD(im,0x10000) != 0 )
			_this->Put1(_this->Ior, _this->RH, _this->RH, MOD(im,0x10000));
		
		_this->Put0(op, a, b, _this->RH);
	}
	// END
}

void ORG::Put2(int op, int a, int b, int off)
{
	// BEGIN
	ORG* _this = _inst();
	/* emit load/store instruction */
	_this->code[_this->pc] = ((op * 0x10 + a) * 0x10 + b) * 0x100000 + (MOD(off,0x100000));
	_this->pc++;
	// END
}

void ORG::Put3(int op, int cond, int off)
{
	// BEGIN
	ORG* _this = _inst();
	/* emit branch instruction */
	_this->code[_this->pc] = ((op + 12) * 0x10 + cond) * 0x1000000 + (MOD(off,0x1000000));
	_this->pc++;
	// END
}

void ORG::incR()
{
	// BEGIN
	ORG* _this = _inst();
	if( _this->RH < _this->MT - 1 )
		_this->RH++;
	else
		ORS::_inst()->Mark("register stack overflow");

	// END
}

void ORG::CheckRegs()
{
	// BEGIN
	ORG* _this = _inst();
	if( _this->RH != 0 )
	{
		ORS::_inst()->Mark("Reg Stack");
		_this->RH = 0;
	}
	if( _this->pc >= _this->maxCode - 40 )
		ORS::_inst()->Mark("program too long");
	
	if( _this->frame != 0 )
	{
		ORS::_inst()->Mark("frame error");
		_this->frame = 0;
	}
	// END
}

void ORG::SetCC(Item& x, int n)
{
	// BEGIN
	ORG* _this = _inst();
	x.mode = _this->Cond;
	x.a = 0;
	x.b = 0;
	x.r = n;
	// END
}

void ORG::Trap(int cond, int num)
{
	// BEGIN
	ORG* _this = _inst();
	_this->Put3(_this->BLR, cond, ORS::_inst()->Pos() * 0x100 + num * 0x10 + _this->MT);
	// END
}

/* handling of forward reference, fixups of branch addresses and constant tables */
int ORG::negated(int cond)
{
	// BEGIN
	ORG* _this = _inst();
	if( cond < 8 )
		cond = cond + 8;
	else
		cond = cond - 8;

	return cond;
	// END
}

void ORG::fix(int at, int with)
{
	// BEGIN
	ORG* _this = _inst();
	_this->code[at] = DIV(_this->code[at],_this->C24) * _this->C24 + (MOD(with,_this->C24));
	// END
}

void ORG::FixOne(int at)
{
	// BEGIN
	ORG* _this = _inst();
	_this->fix(at, _this->pc - at - 1);
	// END
}

void ORG::FixLink(int L)
{
	// VAR
	int L1;

	// BEGIN
	ORG* _this = _inst();
	while( L != 0 )
	{
		L1 = MOD(_this->code[L],0x40000);
		_this->fix(L, _this->pc - L - 1);
		L = L1;
	}
	// END
}

void ORG::FixLinkWith(int L0, int dst)
{
	// VAR
	int L1;

	// BEGIN
	ORG* _this = _inst();
	while( L0 != 0 )
	{
		L1 = MOD(_this->code[L0],_this->C24);
		_this->code[L0] = DIV(_this->code[L0],_this->C24) * _this->C24 + (MOD((dst - L0 - 1),_this->C24));
		L0 = L1;
	}
	// END
}

int ORG::merged(int L0, int L1)
{
	// VAR
	int L2;
	int L3;

	// BEGIN
	ORG* _this = _inst();
	if( L0 != 0 )
	{
		L3 = L0;
		do 
		{
			L2 = L3;
			L3 = MOD(_this->code[L2],0x40000);
		} while( !( L3 == 0 ) );
		_this->code[L2] = _this->code[L2] + L1;
		L1 = L0;
	}
	return L1;
	// END
}

/*  loading of operands and addresses into registers  */
void ORG::GetSB(int base)
{
	// BEGIN
	ORG* _this = _inst();
	if( _this->version == 0 )
		_this->Put1(_this->Mov, _this->RH, 0, _this->VarOrg0);
	else
	{
		_this->Put2(_this->Ldr, _this->RH, -base, _this->pc - _this->fixorgD);
		_this->fixorgD = _this->pc - 1;
	}
	// END
}

void ORG::NilCheck()
{
	// BEGIN
	ORG* _this = _inst();
	if( _this->check )
		_this->Trap(_this->EQ, 4);
	
	// END
}

void ORG::load(Item& x)
{
	// VAR
	int op;

	// BEGIN
	ORG* _this = _inst();
	if( x.type->size == 1 )
		op = _this->Ldr + 1;
	else
		op = _this->Ldr;

	if( x.mode != _this->Reg )
	{
		if( x.mode == ORB::_inst()->Const )
		{
			if( x.type->form_ == ORB::_inst()->Proc )
			{
				if( x.r > 0 )
					ORS::_inst()->Mark("not allowed");
				else if( x.r == 0 )
				{
					_this->Put3(_this->BL, 7, 0);
					_this->Put1a(_this->Sub, _this->RH, _this->LNK, _this->pc * 4 - x.a);
				}else
				{
					/* mark as progbase-relative */
					_this->GetSB(x.r);
					_this->Put1(_this->Add, _this->RH, _this->RH, x.a + 0x100);
				}
			}else if( (x.a <= 0x0FFFF) && (x.a >= -0x10000) )
				_this->Put1(_this->Mov, _this->RH, 0, x.a);
			else
			{
				_this->Put1(_this->Mov + _this->U, _this->RH, 0, MOD(DIV(x.a,0x10000),0x10000));
				if( MOD(x.a,0x10000) != 0 )
					_this->Put1(_this->Ior, _this->RH, _this->RH, MOD(x.a,0x10000));
				
			}
			x.r = _this->RH;
			_this->incR();
		}else if( x.mode == ORB::_inst()->Var )
		{
			/* local */
			if( x.r > 0 )
				_this->Put2(op, _this->RH, _this->SP, x.a + _this->frame);
			else
			{
				_this->GetSB(x.r);
				_this->Put2(op, _this->RH, _this->RH, x.a);
			}
			x.r = _this->RH;
			_this->incR();
		}else if( x.mode == ORB::_inst()->Par )
		{
			_this->Put2(_this->Ldr, _this->RH, _this->SP, x.a + _this->frame);
			_this->Put2(op, _this->RH, _this->RH, x.b);
			x.r = _this->RH;
			_this->incR();
		}else if( x.mode == _this->RegI )
			_this->Put2(op, x.r, x.r, x.a);
		else if( x.mode == _this->Cond )
		{
			_this->Put3(_this->BC, _this->negated(x.r), 2);
			_this->FixLink(x.b);
			_this->Put1(_this->Mov, _this->RH, 0, 1);
			_this->Put3(_this->BC, 7, 1);
			_this->FixLink(x.a);
			_this->Put1(_this->Mov, _this->RH, 0, 0);
			x.r = _this->RH;
			_this->incR();
		}
		x.mode = _this->Reg;
	}
	// END
}

void ORG::loadAdr(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	if( x.mode == ORB::_inst()->Var )
	{
		/* local */
		if( x.r > 0 )
			_this->Put1a(_this->Add, _this->RH, _this->SP, x.a + _this->frame);
		else
		{
			_this->GetSB(x.r);
			_this->Put1a(_this->Add, _this->RH, _this->RH, x.a);
		}
		x.r = _this->RH;
		_this->incR();
	}else if( x.mode == ORB::_inst()->Par )
	{
		_this->Put2(_this->Ldr, _this->RH, _this->SP, x.a + _this->frame);
		if( x.b != 0 )
			_this->Put1a(_this->Add, _this->RH, _this->RH, x.b);
		
		x.r = _this->RH;
		_this->incR();
	}else if( x.mode == _this->RegI )
	{
		if( x.a != 0 )
			_this->Put1a(_this->Add, x.r, x.r, x.a);
		
	}else
		ORS::_inst()->Mark("address error");

	x.mode = _this->Reg;
	// END
}

void ORG::loadCond(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	if( x.type->form_ == ORB::_inst()->Bool )
	{
		if( x.mode == ORB::_inst()->Const )
			x.r = 15 - x.a * 8;
		else
		{
			_this->load(x);
			if( DIV(_this->code[_this->pc - 1],0x40000000) != -2 )
				_this->Put1(_this->Cmp, x.r, x.r, 0);
			
			x.r = _this->NE;
			_this->RH--;
		}
		x.mode = _this->Cond;
		x.a = 0;
		x.b = 0;
	}else
		ORS::_inst()->Mark("not Boolean?");

	// END
}

void ORG::loadTypTagAdr(ORB::Type T)
{
	// VAR
	Item x;

	// BEGIN
	ORG* _this = _inst();
	x.mode = ORB::_inst()->Var;
	x.a = T->len;
	x.r = -T->mno;
	_this->loadAdr(x);
	// END
}

void ORG::loadStringAdr(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	_this->GetSB(0);
	_this->Put1a(_this->Add, _this->RH, _this->RH, _this->varsize + x.a);
	x.mode = _this->Reg;
	x.r = _this->RH;
	_this->incR();
	// END
}

/*  Items: Conversion from constants or from Objects on the Heap to Items on the Stack */
void ORG::MakeConstItem(Item& x, ORB::Type typ, int val)
{
	// BEGIN
	ORG* _this = _inst();
	x.mode = ORB::_inst()->Const;
	x.type = typ;
	x.a = val;
	// END
}

void ORG::MakeRealItem(Item& x, float val)
{
	// BEGIN
	ORG* _this = _inst();
	x.mode = ORB::_inst()->Const;
	x.type = ORB::_inst()->realType;
	x.a = SYSTEM::_inst()->VAL(INTEGER, val);
	// END
}

/* copies string from ORS-buffer to ORG-string array */
void ORG::MakeStringItem(Item& x, int len)
{
	// VAR
	int i;

	// BEGIN
	ORG* _this = _inst();
	x.mode = ORB::_inst()->Const;
	x.type = ORB::_inst()->strType;
	x.a = _this->strx;
	x.b = len;
	i = 0;
	if( _this->strx + len + 4 < _this->maxStrx )
	{
		while( len > 0 )
		{
			_this->str[_this->strx] = ORS::_inst()->str[i];
			_this->strx++;
			i++;
			len--;
		}
		while( MOD(_this->strx,4) != 0 )
		{
			_this->str[_this->strx] = 0x0;
			_this->strx++;
		}
	}else
		ORS::_inst()->Mark("too many strings");

	// END
}

void ORG::MakeItem(Item& x, ORB::Object y, int curlev)
{
	// BEGIN
	ORG* _this = _inst();
	x.mode = y->class_;
	x.type = y->type;
	x.a = y->val;
	x.rdo = y->rdo;
	if( y->class_ == ORB::_inst()->Par )
		x.b = 0;
	else if( (y->class_ == ORB::_inst()->Const) && (y->type->form_ == ORB::_inst()->String) )
		/* len */
		x.b = y->lev;
	else
		x.r = y->lev;

	if( (y->lev > 0) && (y->lev != curlev) && (y->class_ != ORB::_inst()->Const) )
		ORS::_inst()->Mark("not accessible ");
	
	// END
}

/*  Code generation for Selectors, Variables, Constants  */
/*  x := x.y  */
void ORG::Field(Item& x, ORB::Object y)
{
	// BEGIN
	ORG* _this = _inst();
	if( x.mode == ORB::_inst()->Var )
	{
		if( x.r >= 0 )
			x.a = x.a + y->val;
		else
		{
			_this->loadAdr(x);
			x.mode = _this->RegI;
			x.a = y->val;
		}
	}else if( x.mode == _this->RegI )
		x.a = x.a + y->val;
	else if( x.mode == ORB::_inst()->Par )
		x.b = x.b + y->val;
	
	// END
}

/*  x := x[y]  */
void ORG::Index(Item& x, Item& y)
{
	// VAR
	int s;
	int lim;

	// BEGIN
	ORG* _this = _inst();
	s = x.type->base->size;
	lim = x.type->len;
	if( (y.mode == ORB::_inst()->Const) && (lim >= 0) )
	{
		if( (y.a < 0) || (y.a >= lim) )
			ORS::_inst()->Mark("bad index");
		
		if( ( _Set() + (ORB::_inst()->Var) + (_this->RegI) ).contains( x.mode ) )
			x.a = y.a * s + x.a;
		else if( x.mode == ORB::_inst()->Par )
			x.b = y.a * s + x.b;
		
	}else
	{
		_this->load(y);
		/* check array bounds */
		if( _this->check )
		{
			if( lim >= 0 )
				_this->Put1a(_this->Cmp, _this->RH, y.r, lim);
			else
			{
				/* open array */
				if( ( _Set() + (ORB::_inst()->Var) + (ORB::_inst()->Par) ).contains( x.mode ) )
				{
					_this->Put2(_this->Ldr, _this->RH, _this->SP, x.a + 4 + _this->frame);
					_this->Put0(_this->Cmp, _this->RH, y.r, _this->RH);
				}else
					ORS::_inst()->Mark("error in Index");

			}
			/* BCC */
			_this->Trap(10, 1);
		}
		if( s == 4 )
			_this->Put1(_this->Lsl, y.r, y.r, 2);
		else if( s > 1 )
			_this->Put1a(_this->Mul, y.r, y.r, s);
		
		if( x.mode == ORB::_inst()->Var )
		{
			if( x.r > 0 )
			{
				_this->Put0(_this->Add, y.r, _this->SP, y.r);
				x.a += _this->frame;
			}else
			{
				_this->GetSB(x.r);
				if( x.r == 0 )
					_this->Put0(_this->Add, y.r, _this->RH, y.r);
				else
				{
					_this->Put1a(_this->Add, _this->RH, _this->RH, x.a);
					_this->Put0(_this->Add, y.r, _this->RH, y.r);
					x.a = 0;
				}
			}
			x.r = y.r;
			x.mode = _this->RegI;
		}else if( x.mode == ORB::_inst()->Par )
		{
			_this->Put2(_this->Ldr, _this->RH, _this->SP, x.a + _this->frame);
			_this->Put0(_this->Add, y.r, _this->RH, y.r);
			x.mode = _this->RegI;
			x.r = y.r;
			x.a = x.b;
		}else if( x.mode == _this->RegI )
		{
			_this->Put0(_this->Add, x.r, x.r, y.r);
			_this->RH--;
		}
	}
	// END
}

void ORG::DeRef(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	if( x.mode == ORB::_inst()->Var )
	{
		/* local */
		if( x.r > 0 )
			_this->Put2(_this->Ldr, _this->RH, _this->SP, x.a + _this->frame);
		else
		{
			_this->GetSB(x.r);
			_this->Put2(_this->Ldr, _this->RH, _this->RH, x.a);
		}
		_this->NilCheck();
		x.r = _this->RH;
		_this->incR();
	}else if( x.mode == ORB::_inst()->Par )
	{
		_this->Put2(_this->Ldr, _this->RH, _this->SP, x.a + _this->frame);
		_this->Put2(_this->Ldr, _this->RH, _this->RH, x.b);
		_this->NilCheck();
		x.r = _this->RH;
		_this->incR();
	}else if( x.mode == _this->RegI )
	{
		_this->Put2(_this->Ldr, x.r, x.r, x.a);
		_this->NilCheck();
	}else if( x.mode != _this->Reg )
		ORS::_inst()->Mark("bad mode in DeRef");
	
	x.mode = _this->RegI;
	x.a = 0;
	x.b = 0;
	// END
}

void ORG::Q(ORB::Type T, int& dcw)
{
	// BEGIN
	ORG* _this = _inst();
	/* one entry of type descriptor extension table */
	if( T->base != 0 )
	{
		_this->Q(T->base, dcw);
		_this->data[dcw] = (T->mno * 0x1000 + T->len) * 0x1000 + dcw - _this->fixorgT;
		_this->fixorgT = dcw;
		dcw++;
	}
	// END
}

void ORG::FindPtrFlds(ORB::Type typ, int off, int& dcw)
{
	// VAR
	ORB::Object fld;
	int i;
	int s;

	// BEGIN
	ORG* _this = _inst();
	if( (typ->form_ == ORB::_inst()->Pointer) || (typ->form_ == ORB::_inst()->NilTyp) )
	{
		_this->data[dcw] = off;
		dcw++;
	}else if( typ->form_ == ORB::_inst()->Record )
	{
		fld = typ->dsc;
		while( fld != 0 )
		{
			_this->FindPtrFlds(fld->type, fld->val + off, dcw);
			fld = fld->next;
		}
	}else if( typ->form_ == ORB::_inst()->Array )
	{
		s = typ->base->size;
		for( i = 0; i <= typ->len - 1; i++ )
			_this->FindPtrFlds(typ->base, i * s + off, dcw);
	}
	// END
}

void ORG::BuildTD(ORB::Type T, int& dc)
{
	// VAR
	/* dcw = word address */
	int dcw;
	int k;
	int s;

	// BEGIN
	ORG* _this = _inst();
	/* convert size for heap allocation */
	dcw = DIV(dc,4);
	s = T->size;
	if( s <= 24 )
		s = 32;
	else if( s <= 56 )
		s = 64;
	else if( s <= 120 )
		s = 128;
	else
		s = DIV((s + 263),256) * 256;

	/* len used as address */
	T->len = dc;
	_this->data[dcw] = s;
	dcw++;
	/* extension level! */
	k = T->nofpar;
	if( k > 3 )
		ORS::_inst()->Mark("ext level too large");
	else
	{
		_this->Q(T, dcw);
		while( k < 3 )
		{
			_this->data[dcw] = -1;
			dcw++;
			k++;
		}
	}
	_this->FindPtrFlds(T, 0, dcw);
	_this->data[dcw] = -1;
	dcw++;
	_this->tdx = dcw;
	dc = dcw * 4;
	if( _this->tdx >= _this->maxTD )
	{
		ORS::_inst()->Mark("too many record types");
		_this->tdx = 0;
	}
	// END
}

void ORG::TypeTest(Item& x, ORB::Type T, bool varpar, bool isguard)
{
	// VAR
	int pc0;

	// BEGIN
	ORG* _this = _inst();
	/* fetch tag into RH */
	if( varpar )
		_this->Put2(_this->Ldr, _this->RH, _this->SP, x.a + 4 + _this->frame);
	else
	{
		_this->load(x);
		/* NIL belongs to every pointer type */
		pc0 = _this->pc;
		_this->Put3(_this->BC, _this->EQ, 0);
		_this->Put2(_this->Ldr, _this->RH, x.r, -8);
	}
	_this->Put2(_this->Ldr, _this->RH, _this->RH, T->nofpar * 4);
	_this->incR();
	/* tag of T */
	_this->loadTypTagAdr(T);
	_this->Put0(_this->Cmp, _this->RH - 1, _this->RH - 1, _this->RH - 2);
	_this->RH -= 2;
	if( !varpar )
		_this->fix(pc0, _this->pc - pc0 - 1);
	
	if( isguard )
	{
		if( _this->check )
			_this->Trap(_this->NE, 2);
		
	}else
	{
		_this->SetCC(x, _this->EQ);
		if( !varpar )
			_this->RH--;
		
	}
	// END
}

/*  Code generation for Boolean operators  */
/*  x := ~x  */
void ORG::Not(Item& x)
{
	// VAR
	int t;

	// BEGIN
	ORG* _this = _inst();
	if( x.mode != _this->Cond )
		_this->loadCond(x);
	
	x.r = _this->negated(x.r);
	t = x.a;
	x.a = x.b;
	x.b = t;
	// END
}

/*  x := x &  */
void ORG::And1(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	if( x.mode != _this->Cond )
		_this->loadCond(x);
	
	_this->Put3(_this->BC, _this->negated(x.r), x.a);
	x.a = _this->pc - 1;
	_this->FixLink(x.b);
	x.b = 0;
	// END
}

void ORG::And2(Item& x, Item& y)
{
	// BEGIN
	ORG* _this = _inst();
	if( y.mode != _this->Cond )
		_this->loadCond(y);
	
	x.a = _this->merged(y.a, x.a);
	x.b = y.b;
	x.r = y.r;
	// END
}

/*  x := x OR  */
void ORG::Or1(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	if( x.mode != _this->Cond )
		_this->loadCond(x);
	
	_this->Put3(_this->BC, x.r, x.b);
	x.b = _this->pc - 1;
	_this->FixLink(x.a);
	x.a = 0;
	// END
}

void ORG::Or2(Item& x, Item& y)
{
	// BEGIN
	ORG* _this = _inst();
	if( y.mode != _this->Cond )
		_this->loadCond(y);
	
	x.a = y.a;
	x.b = _this->merged(y.b, x.b);
	x.r = y.r;
	// END
}

/*  Code generation for arithmetic operators  */
/*  x := -x  */
void ORG::Neg(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	if( x.type->form_ == ORB::_inst()->Int )
	{
		if( x.mode == ORB::_inst()->Const )
			x.a = -x.a;
		else
		{
			_this->load(x);
			_this->Put1(_this->Mov, _this->RH, 0, 0);
			_this->Put0(_this->Sub, x.r, _this->RH, x.r);
		}
	}else if( x.type->form_ == ORB::_inst()->Real )
	{
		if( x.mode == ORB::_inst()->Const )
			x.a = x.a + 0x7FFFFFFF + 1;
		else
		{
			_this->load(x);
			_this->Put1(_this->Mov, _this->RH, 0, 0);
			_this->Put0(_this->Fsb, x.r, _this->RH, x.r);
		}
	}else
	{
		/* form = Set */
		if( x.mode == ORB::_inst()->Const )
			x.a = -x.a - 1;
		else
		{
			_this->load(x);
			_this->Put1(_this->Xor, x.r, x.r, -1);
		}
	}
	// END
}

/*  x := x +- y  */
void ORG::AddOp(int op, Item& x, Item& y)
{
	// BEGIN
	ORG* _this = _inst();
	if( op == ORS::_inst()->plus )
	{
		if( (x.mode == ORB::_inst()->Const) && (y.mode == ORB::_inst()->Const) )
			x.a = x.a + y.a;
		else if( y.mode == ORB::_inst()->Const )
		{
			_this->load(x);
			if( y.a != 0 )
				_this->Put1a(_this->Add, x.r, x.r, y.a);
			
		}else
		{
			_this->load(x);
			_this->load(y);
			_this->Put0(_this->Add, _this->RH - 2, x.r, y.r);
			_this->RH--;
			x.r = _this->RH - 1;
		}
	}else
	{
		/* op = ORS.minus */
		if( (x.mode == ORB::_inst()->Const) && (y.mode == ORB::_inst()->Const) )
			x.a = x.a - y.a;
		else if( y.mode == ORB::_inst()->Const )
		{
			_this->load(x);
			if( y.a != 0 )
				_this->Put1a(_this->Sub, x.r, x.r, y.a);
			
		}else
		{
			_this->load(x);
			_this->load(y);
			_this->Put0(_this->Sub, _this->RH - 2, x.r, y.r);
			_this->RH--;
			x.r = _this->RH - 1;
		}
	}
	// END
}

int ORG::log2(int m, int& e)
{
	// BEGIN
	ORG* _this = _inst();
	e = 0;
	while( !m % 2 == 1 )
	{
		m = DIV(m,2);
		e++;
	}
	return m;
	// END
}

/*  x := x * y  */
void ORG::MulOp(Item& x, Item& y)
{
	// VAR
	int e;

	// BEGIN
	ORG* _this = _inst();
	if( (x.mode == ORB::_inst()->Const) && (y.mode == ORB::_inst()->Const) )
		x.a = x.a * y.a;
	else if( (y.mode == ORB::_inst()->Const) && (y.a >= 2) && (_this->log2(y.a, e) == 1) )
	{
		_this->load(x);
		_this->Put1(_this->Lsl, x.r, x.r, e);
	}else if( y.mode == ORB::_inst()->Const )
	{
		_this->load(x);
		_this->Put1a(_this->Mul, x.r, x.r, y.a);
	}else if( (x.mode == ORB::_inst()->Const) && (x.a >= 2) && (_this->log2(x.a, e) == 1) )
	{
		_this->load(y);
		_this->Put1(_this->Lsl, y.r, y.r, e);
		x.mode = _this->Reg;
		x.r = y.r;
	}else if( x.mode == ORB::_inst()->Const )
	{
		_this->load(y);
		_this->Put1a(_this->Mul, y.r, y.r, x.a);
		x.mode = _this->Reg;
		x.r = y.r;
	}else
	{
		_this->load(x);
		_this->load(y);
		_this->Put0(_this->Mul, _this->RH - 2, x.r, y.r);
		_this->RH--;
		x.r = _this->RH - 1;
	}
	// END
}

/*  x := x op y  */
void ORG::DivOp(int op, Item& x, Item& y)
{
	// VAR
	int e;

	// BEGIN
	ORG* _this = _inst();
	if( op == ORS::_inst()->div )
	{
		if( (x.mode == ORB::_inst()->Const) && (y.mode == ORB::_inst()->Const) )
		{
			if( y.a > 0 )
				x.a = DIV(x.a,y.a);
			else
				ORS::_inst()->Mark("bad divisor");

		}else if( (y.mode == ORB::_inst()->Const) && (y.a >= 2) && (_this->log2(y.a, e) == 1) )
		{
			_this->load(x);
			_this->Put1(_this->Asr, x.r, x.r, e);
		}else if( y.mode == ORB::_inst()->Const )
		{
			if( y.a > 0 )
			{
				_this->load(x);
				_this->Put1a(_this->Div, x.r, x.r, y.a);
			}else
				ORS::_inst()->Mark("bad divisor");

		}else
		{
			_this->load(y);
			if( _this->check )
				_this->Trap(_this->LE, 6);
			
			_this->load(x);
			_this->Put0(_this->Div, _this->RH - 2, x.r, y.r);
			_this->RH--;
			x.r = _this->RH - 1;
		}
	}else
	{
		/* op = ORS.mod */
		if( (x.mode == ORB::_inst()->Const) && (y.mode == ORB::_inst()->Const) )
		{
			if( y.a > 0 )
				x.a = MOD(x.a,y.a);
			else
				ORS::_inst()->Mark("bad modulus");

		}else if( (y.mode == ORB::_inst()->Const) && (y.a >= 2) && (_this->log2(y.a, e) == 1) )
		{
			_this->load(x);
			if( e <= 16 )
				_this->Put1(_this->And, x.r, x.r, y.a - 1);
			else
			{
				_this->Put1(_this->Lsl, x.r, x.r, 32 - e);
				_this->Put1(_this->Ror, x.r, x.r, 32 - e);
			}
		}else if( y.mode == ORB::_inst()->Const )
		{
			if( y.a > 0 )
			{
				_this->load(x);
				_this->Put1a(_this->Div, x.r, x.r, y.a);
				_this->Put0(_this->Mov + _this->U, x.r, 0, 0);
			}else
				ORS::_inst()->Mark("bad modulus");

		}else
		{
			_this->load(y);
			if( _this->check )
				_this->Trap(_this->LE, 6);
			
			_this->load(x);
			_this->Put0(_this->Div, _this->RH - 2, x.r, y.r);
			_this->Put0(_this->Mov + _this->U, _this->RH - 2, 0, 0);
			_this->RH--;
			x.r = _this->RH - 1;
		}
	}
	// END
}

/*  Code generation for REAL operators  */
/*  x := x op y  */
void ORG::RealOp(int op, Item& x, Item& y)
{
	// BEGIN
	ORG* _this = _inst();
	_this->load(x);
	_this->load(y);
	if( op == ORS::_inst()->plus )
		_this->Put0(_this->Fad, _this->RH - 2, x.r, y.r);
	else if( op == ORS::_inst()->minus )
		_this->Put0(_this->Fsb, _this->RH - 2, x.r, y.r);
	else if( op == ORS::_inst()->times )
		_this->Put0(_this->Fml, _this->RH - 2, x.r, y.r);
	else if( op == ORS::_inst()->rdiv )
		_this->Put0(_this->Fdv, _this->RH - 2, x.r, y.r);
	
	_this->RH--;
	x.r = _this->RH - 1;
	// END
}

/*  Code generation for set operators  */
/*  x := {x}  */
void ORG::Singleton(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	if( x.mode == ORB::_inst()->Const )
		x.a = LSL(1, x.a);
	else
	{
		_this->load(x);
		_this->Put1(_this->Mov, _this->RH, 0, 1);
		_this->Put0(_this->Lsl, x.r, _this->RH, x.r);
	}
	// END
}

/*  x := {x .. y}  */
void ORG::Set(Item& x, Item& y)
{
	// BEGIN
	ORG* _this = _inst();
	if( (x.mode == ORB::_inst()->Const) && (y.mode == ORB::_inst()->Const) )
	{
		if( x.a <= y.a )
			x.a = LSL(2, y.a) - LSL(1, x.a);
		else
			x.a = 0;

	}else
	{
		if( (x.mode == ORB::_inst()->Const) && (x.a <= 16) )
			x.a = LSL(-1, x.a);
		else
		{
			_this->load(x);
			_this->Put1(_this->Mov, _this->RH, 0, -1);
			_this->Put0(_this->Lsl, x.r, _this->RH, x.r);
		}
		if( (y.mode == ORB::_inst()->Const) && (y.a < 16) )
		{
			_this->Put1(_this->Mov, _this->RH, 0, LSL(-2, y.a));
			y.mode = _this->Reg;
			y.r = _this->RH;
			_this->incR();
		}else
		{
			_this->load(y);
			_this->Put1(_this->Mov, _this->RH, 0, -2);
			_this->Put0(_this->Lsl, y.r, _this->RH, y.r);
		}
		if( x.mode == ORB::_inst()->Const )
		{
			if( x.a != 0 )
			{
				_this->Put1(_this->Xor, y.r, y.r, -1);
				_this->Put1a(_this->And, _this->RH - 1, y.r, x.a);
			}
			x.mode = _this->Reg;
			x.r = _this->RH - 1;
		}else
		{
			_this->RH--;
			_this->Put0(_this->Ann, _this->RH - 1, x.r, y.r);
		}
	}
	// END
}

/*  x := x IN y  */
void ORG::In(Item& x, Item& y)
{
	// BEGIN
	ORG* _this = _inst();
	_this->load(y);
	if( x.mode == ORB::_inst()->Const )
	{
		_this->Put1(_this->Ror, y.r, y.r, MOD((x.a + 1),0x20));
		_this->RH--;
	}else
	{
		_this->load(x);
		_this->Put1(_this->Add, x.r, x.r, 1);
		_this->Put0(_this->Ror, y.r, y.r, x.r);
		_this->RH -= 2;
	}
	_this->SetCC(x, _this->MI);
	// END
}

/*  x := x op y  */
void ORG::SetOp(int op, Item& x, Item& y)
{
	// VAR
	/* x.type.form = Set */
	_Set xset;
	_Set yset;

	// BEGIN
	ORG* _this = _inst();
	if( (x.mode == ORB::_inst()->Const) && (y.mode == ORB::_inst()->Const) )
	{
		xset = SYSTEM::_inst()->VAL(SET, x.a);
		yset = SYSTEM::_inst()->VAL(SET, y.a);
		if( op == ORS::_inst()->plus )
			xset = xset + yset;
		else if( op == ORS::_inst()->minus )
			xset = xset - yset;
		else if( op == ORS::_inst()->times )
			xset = xset * yset;
		else if( op == ORS::_inst()->rdiv )
			xset = xset / yset;
		
		x.a = SYSTEM::_inst()->VAL(INTEGER, xset);
	}else if( y.mode == ORB::_inst()->Const )
	{
		_this->load(x);
		if( op == ORS::_inst()->plus )
			_this->Put1a(_this->Ior, x.r, x.r, y.a);
		else if( op == ORS::_inst()->minus )
			_this->Put1a(_this->Ann, x.r, x.r, y.a);
		else if( op == ORS::_inst()->times )
			_this->Put1a(_this->And, x.r, x.r, y.a);
		else if( op == ORS::_inst()->rdiv )
			_this->Put1a(_this->Xor, x.r, x.r, y.a);
		
	}else
	{
		_this->load(x);
		_this->load(y);
		if( op == ORS::_inst()->plus )
			_this->Put0(_this->Ior, _this->RH - 2, x.r, y.r);
		else if( op == ORS::_inst()->minus )
			_this->Put0(_this->Ann, _this->RH - 2, x.r, y.r);
		else if( op == ORS::_inst()->times )
			_this->Put0(_this->And, _this->RH - 2, x.r, y.r);
		else if( op == ORS::_inst()->rdiv )
			_this->Put0(_this->Xor, _this->RH - 2, x.r, y.r);
		
		_this->RH--;
		x.r = _this->RH - 1;
	}
	// END
}

/*  Code generation for relations  */
/*  x := x < y  */
void ORG::IntRelation(int op, Item& x, Item& y)
{
	// BEGIN
	ORG* _this = _inst();
	if( (y.mode == ORB::_inst()->Const) && (y.type->form_ != ORB::_inst()->Proc) )
	{
		_this->load(x);
		if( (y.a != 0) || !(( _Set() + (ORS::_inst()->eql) + (ORS::_inst()->neq) ).contains( op )) || (DIV(_this->code[_this->pc - 1],0x40000000) != -2) )
			_this->Put1a(_this->Cmp, x.r, x.r, y.a);
		
		_this->RH--;
	}else
	{
		if( (x.mode == _this->Cond) || (y.mode == _this->Cond) )
			ORS::_inst()->Mark("not implemented");
		
		_this->load(x);
		_this->load(y);
		_this->Put0(_this->Cmp, x.r, x.r, y.r);
		_this->RH -= 2;
	}
	_this->SetCC(x, _this->relmap[op - ORS::_inst()->eql]);
	// END
}

/*  x := x < y  */
void ORG::RealRelation(int op, Item& x, Item& y)
{
	// BEGIN
	ORG* _this = _inst();
	_this->load(x);
	if( (y.mode == ORB::_inst()->Const) && (y.a == 0) )
		_this->RH--;
	else
	{
		_this->load(y);
		_this->Put0(_this->Fsb, x.r, x.r, y.r);
		_this->RH -= 2;
	}
	_this->SetCC(x, _this->relmap[op - ORS::_inst()->eql]);
	// END
}

/*  x := x < y  */
void ORG::StringRelation(int op, Item& x, Item& y)
{
	// BEGIN
	ORG* _this = _inst();
	/* x, y are char arrays or strings */
	if( x.type->form_ == ORB::_inst()->String )
		_this->loadStringAdr(x);
	else
		_this->loadAdr(x);

	if( y.type->form_ == ORB::_inst()->String )
		_this->loadStringAdr(y);
	else
		_this->loadAdr(y);

	_this->Put2(_this->Ldr + 1, _this->RH, x.r, 0);
	_this->Put1(_this->Add, x.r, x.r, 1);
	_this->Put2(_this->Ldr + 1, _this->RH + 1, y.r, 0);
	_this->Put1(_this->Add, y.r, y.r, 1);
	_this->Put0(_this->Cmp, _this->RH + 2, _this->RH, _this->RH + 1);
	_this->Put3(_this->BC, _this->NE, 2);
	_this->Put1(_this->Cmp, _this->RH + 2, _this->RH, 0);
	_this->Put3(_this->BC, _this->NE, -8);
	_this->RH -= 2;
	_this->SetCC(x, _this->relmap[op - ORS::_inst()->eql]);
	// END
}

/*  Code generation of Assignments  */
void ORG::StrToChar(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	x.type = ORB::_inst()->charType_;
	_this->strx -= 4;
	x.a = int( _this->str[x.a] );
	// END
}

/*  x := y  */
void ORG::Store(Item& x, Item& y)
{
	// VAR
	int op;

	// BEGIN
	ORG* _this = _inst();
	_this->load(y);
	if( x.type->size == 1 )
		op = _this->Str + 1;
	else
		op = _this->Str;

	if( x.mode == ORB::_inst()->Var )
	{
		/* local */
		if( x.r > 0 )
			_this->Put2(op, y.r, _this->SP, x.a + _this->frame);
		else
		{
			_this->GetSB(x.r);
			_this->Put2(op, y.r, _this->RH, x.a);
		}
	}else if( x.mode == ORB::_inst()->Par )
	{
		_this->Put2(_this->Ldr, _this->RH, _this->SP, x.a + _this->frame);
		_this->Put2(op, y.r, _this->RH, x.b);
	}else if( x.mode == _this->RegI )
	{
		_this->Put2(op, y.r, x.r, x.a);
		_this->RH--;
	}else
		ORS::_inst()->Mark("bad mode in Store");

	_this->RH--;
	// END
}

/*  x := y, frame = 0  */
void ORG::StoreStruct(Item& x, Item& y)
{
	// VAR
	int s;
	int pc0;

	// BEGIN
	ORG* _this = _inst();
	if( y.type->size != 0 )
	{
		_this->loadAdr(x);
		_this->loadAdr(y);
		if( (x.type->form_ == ORB::_inst()->Array) && (x.type->len > 0) )
		{
			if( y.type->len >= 0 )
			{
				if( x.type->size == y.type->size )
					_this->Put1a(_this->Mov, _this->RH, 0, DIV((y.type->size + 3),4));
				else
					ORS::_inst()->Mark("different length/size, not implemented");

			}else
			{
				/* y  open array */
				/* element size */
				_this->Put2(_this->Ldr, _this->RH, _this->SP, y.a + 4);
				s = y.type->base->size;
				pc0 = _this->pc;
				_this->Put3(_this->BC, _this->EQ, 0);
				if( s == 1 )
				{
					_this->Put1(_this->Add, _this->RH, _this->RH, 3);
					_this->Put1(_this->Asr, _this->RH, _this->RH, 2);
				}else if( s != 4 )
					_this->Put1a(_this->Mul, _this->RH, _this->RH, DIV(s,4));
				
				if( _this->check )
				{
					_this->Put1a(_this->Mov, _this->RH + 1, 0, DIV((x.type->size + 3),4));
					_this->Put0(_this->Cmp, _this->RH + 1, _this->RH, _this->RH + 1);
					_this->Trap(_this->GT, 3);
				}
				_this->fix(pc0, _this->pc + 5 - pc0);
			}
		}else if( x.type->form_ == ORB::_inst()->Record )
			_this->Put1a(_this->Mov, _this->RH, 0, DIV(x.type->size,4));
		else
			ORS::_inst()->Mark("inadmissible assignment");

		_this->Put2(_this->Ldr, _this->RH + 1, y.r, 0);
		_this->Put1(_this->Add, y.r, y.r, 4);
		_this->Put2(_this->Str, _this->RH + 1, x.r, 0);
		_this->Put1(_this->Add, x.r, x.r, 4);
		_this->Put1(_this->Sub, _this->RH, _this->RH, 1);
		_this->Put3(_this->BC, _this->NE, -6);
	}
	_this->RH = 0;
	// END
}

/*  x := y  */
void ORG::CopyString(Item& x, Item& y)
{
	// VAR
	int len;

	// BEGIN
	ORG* _this = _inst();
	_this->loadAdr(x);
	len = x.type->len;
	if( len >= 0 )
	{
		if( len < y.b )
			ORS::_inst()->Mark("string too long");
		
	}else if( _this->check )
	{
		/* open array len, frame = 0 */
		_this->Put2(_this->Ldr, _this->RH, _this->SP, x.a + 4);
		_this->Put1(_this->Cmp, _this->RH, _this->RH, y.b);
		_this->Trap(_this->LT, 3);
	}
	_this->loadStringAdr(y);
	_this->Put2(_this->Ldr, _this->RH, y.r, 0);
	_this->Put1(_this->Add, y.r, y.r, 4);
	_this->Put2(_this->Str, _this->RH, x.r, 0);
	_this->Put1(_this->Add, x.r, x.r, 4);
	_this->Put1(_this->Asr, _this->RH, _this->RH, 24);
	_this->Put3(_this->BC, _this->NE, -6);
	_this->RH = 0;
	// END
}

/*  Code generation for parameters  */
void ORG::OpenArrayParam(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	_this->loadAdr(x);
	if( x.type->len >= 0 )
		_this->Put1a(_this->Mov, _this->RH, 0, x.type->len);
	else
		_this->Put2(_this->Ldr, _this->RH, _this->SP, x.a + 4 + _this->frame);

	_this->incR();
	// END
}

void ORG::VarParam(Item& x, ORB::Type ftype)
{
	// VAR
	int xmd;

	// BEGIN
	ORG* _this = _inst();
	xmd = x.mode;
	_this->loadAdr(x);
	/* open array */
	if( (ftype->form_ == ORB::_inst()->Array) && (ftype->len < 0) )
	{
		if( x.type->len >= 0 )
			_this->Put1a(_this->Mov, _this->RH, 0, x.type->len);
		else
			_this->Put2(_this->Ldr, _this->RH, _this->SP, x.a + 4 + _this->frame);

		_this->incR();
	}else if( ftype->form_ == ORB::_inst()->Record )
	{
		if( xmd == ORB::_inst()->Par )
		{
			_this->Put2(_this->Ldr, _this->RH, _this->SP, x.a + 4 + _this->frame);
			_this->incR();
		}else
			_this->loadTypTagAdr(x.type);

	}
	// END
}

void ORG::ValueParam(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	_this->load(x);
	// END
}

void ORG::StringParam(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	/* len */
	_this->loadStringAdr(x);
	_this->Put1(_this->Mov, _this->RH, 0, x.b);
	_this->incR();
	// END
}

/* For Statements */
void ORG::For0(Item& x, Item& y)
{
	// BEGIN
	ORG* _this = _inst();
	_this->load(y);
	// END
}

void ORG::For1(Item& x, Item& y, Item& z, Item& w, int& L)
{
	// BEGIN
	ORG* _this = _inst();
	if( z.mode == ORB::_inst()->Const )
		_this->Put1a(_this->Cmp, _this->RH, y.r, z.a);
	else
	{
		_this->load(z);
		_this->Put0(_this->Cmp, _this->RH - 1, y.r, z.r);
		_this->RH--;
	}
	L = _this->pc;
	if( w.a > 0 )
		_this->Put3(_this->BC, _this->GT, 0);
	else if( w.a < 0 )
		_this->Put3(_this->BC, _this->LT, 0);
	else
	{
		ORS::_inst()->Mark("zero increment");
		_this->Put3(_this->BC, _this->MI, 0);
	}
	_this->Store(x, y);
	// END
}

void ORG::For2(Item& x, Item& y, Item& w)
{
	// BEGIN
	ORG* _this = _inst();
	_this->load(x);
	_this->RH--;
	_this->Put1a(_this->Add, x.r, x.r, w.a);
	// END
}

/*  Branches, procedure calls, procedure prolog and epilog  */
int ORG::Here()
{
	// BEGIN
	ORG* _this = _inst();
	return _this->pc;
	// END
}

void ORG::FJump(int& L)
{
	// BEGIN
	ORG* _this = _inst();
	_this->Put3(_this->BC, 7, L);
	L = _this->pc - 1;
	// END
}

void ORG::CFJump(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	if( x.mode != _this->Cond )
		_this->loadCond(x);
	
	_this->Put3(_this->BC, _this->negated(x.r), x.a);
	_this->FixLink(x.b);
	x.a = _this->pc - 1;
	// END
}

void ORG::BJump(int L)
{
	// BEGIN
	ORG* _this = _inst();
	_this->Put3(_this->BC, 7, L - _this->pc - 1);
	// END
}

void ORG::CBJump(Item& x, int L)
{
	// BEGIN
	ORG* _this = _inst();
	if( x.mode != _this->Cond )
		_this->loadCond(x);
	
	_this->Put3(_this->BC, _this->negated(x.r), L - _this->pc - 1);
	_this->FixLink(x.b);
	_this->FixLinkWith(x.a, L);
	// END
}

void ORG::Fixup(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	_this->FixLink(x.a);
	// END
}

/*  R[0 .. r-1] */
void ORG::SaveRegs(int r)
{
	// VAR
	int r0;

	// BEGIN
	ORG* _this = _inst();
	/* r > 0 */
	r0 = 0;
	_this->Put1(_this->Sub, _this->SP, _this->SP, r * 4);
	_this->frame += 4 * r;
	do 
	{
		_this->Put2(_this->Str, r0, _this->SP, (r - r0 - 1) * 4);
		r0++;
	} while( !( r0 == r ) );
	// END
}

/* R[0 .. r-1] */
void ORG::RestoreRegs(int r)
{
	// VAR
	int r0;

	// BEGIN
	ORG* _this = _inst();
	/* r > 0 */
	r0 = r;
	do 
	{
		r0--;
		_this->Put2(_this->Ldr, r0, _this->SP, (r - r0 - 1) * 4);
	} while( !( r0 == 0 ) );
	_this->Put1(_this->Add, _this->SP, _this->SP, r * 4);
	_this->frame -= 4 * r;
	// END
}

void ORG::PrepCall(Item& x, int& r)
{
	// BEGIN
	ORG* _this = _inst();
	/* x.type.form = ORB.Proc */
	if( x.mode > ORB::_inst()->Par )
		_this->load(x);
	
	r = _this->RH;
	if( _this->RH > 0 )
	{
		_this->SaveRegs(_this->RH);
		_this->RH = 0;
	}
	// END
}

void ORG::Call(Item& x, int r)
{
	// BEGIN
	ORG* _this = _inst();
	/* x.type.form = ORB.Proc */
	if( x.mode == ORB::_inst()->Const )
	{
		if( x.r >= 0 )
			_this->Put3(_this->BL, 7, (DIV(x.a,4)) - _this->pc - 1);
		else
		{
			/* imported */
			if( _this->pc - _this->fixorgP < 0x1000 )
			{
				_this->Put3(_this->BL, 7, ((-x.r) * 0x100 + x.a) * 0x1000 + _this->pc - _this->fixorgP);
				_this->fixorgP = _this->pc - 1;
			}else
				ORS::_inst()->Mark("fixup impossible");

		}
	}else
	{
		if( x.mode <= ORB::_inst()->Par )
		{
			_this->load(x);
			_this->RH--;
		}else
		{
			_this->Put2(_this->Ldr, _this->RH, _this->SP, 0);
			_this->Put1(_this->Add, _this->SP, _this->SP, 4);
			r--;
			_this->frame -= 4;
		}
		if( _this->check )
			_this->Trap(_this->EQ, 5);
		
		_this->Put3(_this->BLR, 7, _this->RH);
	}
	/* procedure */
	if( x.type->base->form_ == ORB::_inst()->NoTyp )
		_this->RH = 0;
	else
	{
		/* function */
		if( r > 0 )
		{
			_this->Put0(_this->Mov, r, 0, 0);
			_this->RestoreRegs(r);
		}
		x.mode = _this->Reg;
		x.r = r;
		_this->RH = r + 1;
	}
	// END
}

void ORG::Enter(int parblksize, int locblksize, bool int_)
{
	// VAR
	int a;
	int r;

	// BEGIN
	ORG* _this = _inst();
	_this->frame = 0;
	/* procedure prolog */
	if( !int_ )
	{
		if( locblksize >= 0x10000 )
			ORS::_inst()->Mark("too many locals");
		
		a = 4;
		r = 0;
		_this->Put1(_this->Sub, _this->SP, _this->SP, locblksize);
		_this->Put2(_this->Str, _this->LNK, _this->SP, 0);
		while( a < parblksize )
		{
			_this->Put2(_this->Str, r, _this->SP, a);
			r++;
			a += 4;
		}
	}else
	{
		/* interrupt procedure */
		_this->Put1(_this->Sub, _this->SP, _this->SP, locblksize);
		_this->Put2(_this->Str, 0, _this->SP, 0);
		_this->Put2(_this->Str, 1, _this->SP, 4);
		_this->Put2(_this->Str, 2, _this->SP, 8);
	}
	// END
}

/* R0, R1, R2 saved on stack */
void ORG::Return(int form_, Item& x, int size, bool int_)
{
	// BEGIN
	ORG* _this = _inst();
	if( form_ != ORB::_inst()->NoTyp )
		_this->load(x);
	
	/* procedure epilog */
	if( !int_ )
	{
		_this->Put2(_this->Ldr, _this->LNK, _this->SP, 0);
		_this->Put1(_this->Add, _this->SP, _this->SP, size);
		_this->Put3(_this->BR, 7, _this->LNK);
	}else
	{
		/* interrupt return, restore R2, R1, R0 */
		_this->Put2(_this->Ldr, 2, _this->SP, 8);
		_this->Put2(_this->Ldr, 1, _this->SP, 4);
		_this->Put2(_this->Ldr, 0, _this->SP, 0);
		_this->Put1(_this->Add, _this->SP, _this->SP, size);
		/* RTI */
		_this->Put3(_this->BR, 7, 0x10);
	}
	_this->RH = 0;
	// END
}

/*  In-line code procedures */
void ORG::Increment(int upordown, Item& x, Item& y)
{
	// VAR
	int op;
	int zr;
	int v;

	// BEGIN
	ORG* _this = _inst();
	/* frame = 0 */
	if( upordown == 0 )
		op = _this->Add;
	else
		op = _this->Sub;

	if( x.type == ORB::_inst()->byteType )
		v = 1;
	else
		v = 0;

	if( y.type->form_ == ORB::_inst()->NoTyp )
	{
		y.mode = ORB::_inst()->Const;
		y.a = 1;
	}
	if( (x.mode == ORB::_inst()->Var) && (x.r > 0) )
	{
		zr = _this->RH;
		_this->Put2(_this->Ldr + v, zr, _this->SP, x.a);
		_this->incR();
		if( y.mode == ORB::_inst()->Const )
			_this->Put1a(op, zr, zr, y.a);
		else
		{
			_this->load(y);
			_this->Put0(op, zr, zr, y.r);
			_this->RH--;
		}
		_this->Put2(_this->Str + v, zr, _this->SP, x.a);
		_this->RH--;
	}else
	{
		_this->loadAdr(x);
		zr = _this->RH;
		_this->Put2(_this->Ldr + v, _this->RH, x.r, 0);
		_this->incR();
		if( y.mode == ORB::_inst()->Const )
			_this->Put1a(op, zr, zr, y.a);
		else
		{
			_this->load(y);
			_this->Put0(op, zr, zr, y.r);
			_this->RH--;
		}
		_this->Put2(_this->Str + v, zr, x.r, 0);
		_this->RH -= 2;
	}
	// END
}

void ORG::Include(int inorex, Item& x, Item& y)
{
	// VAR
	int op;
	int zr;

	// BEGIN
	ORG* _this = _inst();
	_this->loadAdr(x);
	zr = _this->RH;
	_this->Put2(_this->Ldr, _this->RH, x.r, 0);
	_this->incR();
	if( inorex == 0 )
		op = _this->Ior;
	else
		op = _this->Ann;

	if( y.mode == ORB::_inst()->Const )
		_this->Put1a(op, zr, zr, LSL(1, y.a));
	else
	{
		_this->load(y);
		_this->Put1(_this->Mov, _this->RH, 0, 1);
		_this->Put0(_this->Lsl, y.r, _this->RH, y.r);
		_this->Put0(op, zr, zr, y.r);
		_this->RH--;
	}
	_this->Put2(_this->Str, zr, x.r, 0);
	_this->RH -= 2;
	// END
}

void ORG::Assert(Item& x)
{
	// VAR
	int cond;

	// BEGIN
	ORG* _this = _inst();
	if( x.mode != _this->Cond )
		_this->loadCond(x);
	
	if( x.a == 0 )
		cond = _this->negated(x.r);
	else
	{
		_this->Put3(_this->BC, x.r, x.b);
		_this->FixLink(x.a);
		x.b = _this->pc - 1;
		cond = 7;
	}
	_this->Trap(cond, 7);
	_this->FixLink(x.b);
	// END
}

void ORG::New(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	_this->loadAdr(x);
	_this->loadTypTagAdr(x.type->base);
	_this->Trap(7, 0);
	_this->RH = 0;
	// END
}

void ORG::Pack(Item& x, Item& y)
{
	// VAR
	Item z;

	// BEGIN
	ORG* _this = _inst();
	z = x;
	_this->load(x);
	_this->load(y);
	_this->Put1(_this->Lsl, y.r, y.r, 23);
	_this->Put0(_this->Add, x.r, x.r, y.r);
	_this->RH--;
	_this->Store(z, x);
	// END
}

void ORG::Unpk(Item& x, Item& y)
{
	// VAR
	Item z;
	Item e0;

	// BEGIN
	ORG* _this = _inst();
	z = x;
	_this->load(x);
	e0.mode = _this->Reg;
	e0.r = _this->RH;
	e0.type = ORB::_inst()->intType_;
	_this->Put1(_this->Asr, _this->RH, x.r, 23);
	_this->Put1(_this->Sub, _this->RH, _this->RH, 127);
	_this->Store(y, e0);
	_this->incR();
	_this->Put1(_this->Lsl, _this->RH, _this->RH, 23);
	_this->Put0(_this->Sub, x.r, x.r, _this->RH);
	_this->Store(z, x);
	// END
}

void ORG::Led(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	_this->load(x);
	_this->Put1(_this->Mov, _this->RH, 0, -60);
	_this->Put2(_this->Str, x.r, _this->RH, 0);
	_this->RH--;
	// END
}

void ORG::Get(Item& x, Item& y)
{
	// BEGIN
	ORG* _this = _inst();
	_this->load(x);
	x.type = y.type;
	x.mode = _this->RegI;
	x.a = 0;
	_this->Store(y, x);
	// END
}

void ORG::Put(Item& x, Item& y)
{
	// BEGIN
	ORG* _this = _inst();
	_this->load(x);
	x.type = y.type;
	x.mode = _this->RegI;
	x.a = 0;
	_this->Store(x, y);
	// END
}

void ORG::Copy(Item& x, Item& y, Item& z)
{
	// BEGIN
	ORG* _this = _inst();
	_this->load(x);
	_this->load(y);
	if( z.mode == ORB::_inst()->Const )
	{
		if( z.a > 0 )
			_this->load(z);
		else
			ORS::_inst()->Mark("bad count");

	}else
	{
		_this->load(z);
		if( _this->check )
			_this->Trap(_this->LT, 3);
		
		_this->Put3(_this->BC, _this->EQ, 6);
	}
	_this->Put2(_this->Ldr, _this->RH, x.r, 0);
	_this->Put1(_this->Add, x.r, x.r, 4);
	_this->Put2(_this->Str, _this->RH, y.r, 0);
	_this->Put1(_this->Add, y.r, y.r, 4);
	_this->Put1(_this->Sub, z.r, z.r, 1);
	_this->Put3(_this->BC, _this->NE, -6);
	_this->RH -= 3;
	// END
}

void ORG::LDPSR(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	/* x.mode = Const */
	_this->Put3(0, 15, x.a + 0x20);
	// END
}

void ORG::LDREG(Item& x, Item& y)
{
	// BEGIN
	ORG* _this = _inst();
	if( y.mode == ORB::_inst()->Const )
		_this->Put1a(_this->Mov, x.a, 0, y.a);
	else
	{
		_this->load(y);
		_this->Put0(_this->Mov, x.a, 0, y.r);
		_this->RH--;
	}
	// END
}

/* In-line code functions */
void ORG::Abs(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	if( x.mode == ORB::_inst()->Const )
		x.a = ABS(x.a);
	else
	{
		_this->load(x);
		if( x.type->form_ == ORB::_inst()->Real )
		{
			_this->Put1(_this->Lsl, x.r, x.r, 1);
			_this->Put1(_this->Ror, x.r, x.r, 1);
		}else
		{
			_this->Put1(_this->Cmp, x.r, x.r, 0);
			_this->Put3(_this->BC, _this->GE, 2);
			_this->Put1(_this->Mov, _this->RH, 0, 0);
			_this->Put0(_this->Sub, x.r, _this->RH, x.r);
		}
	}
	// END
}

void ORG::Odd(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	_this->load(x);
	_this->Put1(_this->And, x.r, x.r, 1);
	_this->SetCC(x, _this->NE);
	_this->RH--;
	// END
}

void ORG::Floor(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	_this->load(x);
	_this->Put1(_this->Mov + _this->U, _this->RH, 0, 0x4B00);
	_this->Put0(_this->Fad + _this->V, x.r, x.r, _this->RH);
	// END
}

void ORG::Float(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	_this->load(x);
	_this->Put1(_this->Mov + _this->U, _this->RH, 0, 0x4B00);
	_this->Put0(_this->Fad + _this->U, x.r, x.r, _this->RH);
	// END
}

void ORG::Ord(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	if( ( _Set() + (ORB::_inst()->Var) + (ORB::_inst()->Par) + (_this->RegI) + (_this->Cond) ).contains( x.mode ) )
		_this->load(x);
	
	// END
}

void ORG::Len(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	if( x.type->len >= 0 )
	{
		if( x.mode == _this->RegI )
			_this->RH--;
		
		x.mode = ORB::_inst()->Const;
		x.a = x.type->len;
	}else
	{
		/* open array */
		_this->Put2(_this->Ldr, _this->RH, _this->SP, x.a + 4 + _this->frame);
		x.mode = _this->Reg;
		x.r = _this->RH;
		_this->incR();
	}
	// END
}

void ORG::Shift(int fct, Item& x, Item& y)
{
	// VAR
	int op;

	// BEGIN
	ORG* _this = _inst();
	_this->load(x);
	if( fct == 0 )
		op = _this->Lsl;
	else if( fct == 1 )
		op = _this->Asr;
	else
		op = _this->Ror;

	if( y.mode == ORB::_inst()->Const )
		_this->Put1(op, x.r, x.r, MOD(y.a,0x20));
	else
	{
		_this->load(y);
		_this->Put0(op, _this->RH - 2, x.r, y.r);
		_this->RH--;
		x.r = _this->RH - 1;
	}
	// END
}

void ORG::ADC(Item& x, Item& y)
{
	// BEGIN
	ORG* _this = _inst();
	_this->load(x);
	_this->load(y);
	_this->Put0(_this->Add + 0x2000, x.r, x.r, y.r);
	_this->RH--;
	// END
}

void ORG::SBC(Item& x, Item& y)
{
	// BEGIN
	ORG* _this = _inst();
	_this->load(x);
	_this->load(y);
	_this->Put0(_this->Sub + 0x2000, x.r, x.r, y.r);
	_this->RH--;
	// END
}

void ORG::UML(Item& x, Item& y)
{
	// BEGIN
	ORG* _this = _inst();
	_this->load(x);
	_this->load(y);
	_this->Put0(_this->Mul + 0x2000, x.r, x.r, y.r);
	_this->RH--;
	// END
}

void ORG::Bit(Item& x, Item& y)
{
	// BEGIN
	ORG* _this = _inst();
	_this->load(x);
	_this->Put2(_this->Ldr, x.r, x.r, 0);
	if( y.mode == ORB::_inst()->Const )
	{
		_this->Put1(_this->Ror, x.r, x.r, y.a + 1);
		_this->RH--;
	}else
	{
		_this->load(y);
		_this->Put1(_this->Add, y.r, y.r, 1);
		_this->Put0(_this->Ror, x.r, x.r, y.r);
		_this->RH -= 2;
	}
	_this->SetCC(x, _this->MI);
	// END
}

void ORG::Register(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	/* x.mode = Const */
	_this->Put0(_this->Mov, _this->RH, 0, MOD(x.a,0x10));
	x.mode = _this->Reg;
	x.r = _this->RH;
	_this->incR();
	// END
}

void ORG::H(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	/* x.mode = Const */
	_this->Put0(_this->Mov + _this->U + MOD(x.a,2) * _this->V, _this->RH, 0, 0);
	x.mode = _this->Reg;
	x.r = _this->RH;
	_this->incR();
	// END
}

void ORG::Adr(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	if( ( _Set() + (ORB::_inst()->Var) + (ORB::_inst()->Par) + (_this->RegI) ).contains( x.mode ) )
		_this->loadAdr(x);
	else if( (x.mode == ORB::_inst()->Const) && (x.type->form_ == ORB::_inst()->Proc) )
		_this->load(x);
	else if( (x.mode == ORB::_inst()->Const) && (x.type->form_ == ORB::_inst()->String) )
		_this->loadStringAdr(x);
	else
		ORS::_inst()->Mark("not addressable");

	// END
}

void ORG::Condition(Item& x)
{
	// BEGIN
	ORG* _this = _inst();
	/* x.mode = Const */
	_this->SetCC(x, x.a);
	// END
}

void ORG::Open(int v)
{
	// BEGIN
	ORG* _this = _inst();
	_this->pc = 0;
	_this->tdx = 0;
	_this->strx = 0;
	_this->RH = 0;
	_this->fixorgP = 0;
	_this->fixorgD = 0;
	_this->fixorgT = 0;
	_this->check = v != 0;
	_this->version = v;
	if( v == 0 )
	{
		_this->pc = 1;
		do 
		{
			_this->code[_this->pc] = 0;
			_this->pc++;
		} while( !( _this->pc == 8 ) );
	}
	// END
}

void ORG::SetDataSize(int dc)
{
	// BEGIN
	ORG* _this = _inst();
	_this->varsize = dc;
	// END
}

void ORG::Header()
{
	// BEGIN
	ORG* _this = _inst();
	_this->entry = _this->pc * 4;
	/* RISC-0 */
	if( _this->version == 0 )
	{
		_this->code[0] = 0x0E7000000 - 1 + _this->pc;
		_this->Put1a(_this->Mov, _this->SP, 0, _this->StkOrg0);
	}else
	{
		_this->Put1(_this->Sub, _this->SP, _this->SP, 4);
		_this->Put2(_this->Str, _this->LNK, _this->SP, 0);
	}
	// END
}

int ORG::NofPtrs(ORB::Type typ)
{
	// VAR
	ORB::Object fld;
	int n;

	// BEGIN
	ORG* _this = _inst();
	if( (typ->form_ == ORB::_inst()->Pointer) || (typ->form_ == ORB::_inst()->NilTyp) )
		n = 1;
	else if( typ->form_ == ORB::_inst()->Record )
	{
		fld = typ->dsc;
		n = 0;
		while( fld != 0 )
		{
			n = _this->NofPtrs(fld->type) + n;
			fld = fld->next;
		}
	}else if( typ->form_ == ORB::_inst()->Array )
		n = _this->NofPtrs(typ->base) * typ->len;
	else
		n = 0;

	return n;
	// END
}

void ORG::FindPtrs(Files::Rider& R, ORB::Type typ, int adr)
{
	// VAR
	ORB::Object fld;
	int i;
	int s;

	// BEGIN
	ORG* _this = _inst();
	if( (typ->form_ == ORB::_inst()->Pointer) || (typ->form_ == ORB::_inst()->NilTyp) )
		Files::_inst()->WriteInt(R, adr);
	else if( typ->form_ == ORB::_inst()->Record )
	{
		fld = typ->dsc;
		while( fld != 0 )
		{
			_this->FindPtrs(R, fld->type, fld->val + adr);
			fld = fld->next;
		}
	}else if( typ->form_ == ORB::_inst()->Array )
	{
		s = typ->base->size;
		for( i = 0; i <= typ->len - 1; i++ )
			_this->FindPtrs(R, typ->base, i * s + adr);
	}
	// END
}

void ORG::Close(_VarArray<char> modid, int key, int nofent)
{
	// VAR
	ORB::Object obj;
	int i;
	int comsize;
	int nofimps;
	int nofptrs;
	int size;
	ORS::Ident name;
	Files::File F;
	Files::Rider R;

	// BEGIN
	ORG* _this = _inst();
	/* exit code */
	/* RISC-0 */
	if( _this->version == 0 )
	{
		_this->Put1(_this->Mov, 0, 0, 0);
		_this->Put3(_this->BR, 7, 0);
	}else
	{
		_this->Put2(_this->Ldr, _this->LNK, _this->SP, 0);
		_this->Put1(_this->Add, _this->SP, _this->SP, 4);
		_this->Put3(_this->BR, 7, _this->LNK);
	}
	obj = ORB::_inst()->topScope->next;
	nofimps = 0;
	comsize = 4;
	nofptrs = 0;
	while( obj != 0 )
	{
		/* count imports */
		if( (obj->class_ == ORB::_inst()->Mod) && (obj->dsc != ORB::_inst()->system) )
			nofimps++;
		else if( (obj->exno != 0) && (obj->class_ == ORB::_inst()->Const) && (obj->type->form_ == ORB::_inst()->Proc) && (obj->type->nofpar == 0) && (obj->type->base == ORB::_inst()->noType) )
		{
			/* count commands */
			i = 0;
			while( obj->name[i] != 0x0 )
				i++;
			
			i = DIV((i + 4),4) * 4;
			comsize += i + 4;
		}else if( obj->class_ == ORB::_inst()->Var )
			/* count pointers */
			nofptrs += _this->NofPtrs(obj->type);
		
		obj = obj->next;
	}
	/* varsize includes type descriptors */
	size = _this->varsize + _this->strx + comsize + (_this->pc + nofimps + nofent + nofptrs + 1) * 4;
	/* write code file */
	ORB::_inst()->MakeFileName(name, modid, ".rsc");
	F = Files::_inst()->New(name);
	Files::_inst()->Set(R, F, 0);
	Files::_inst()->WriteString(R, modid);
	Files::_inst()->WriteInt(R, key);
	Files::_inst()->Write(R, char( _this->version ));
	Files::_inst()->WriteInt(R, size);
	obj = ORB::_inst()->topScope->next;
	/* imports */
	while( (obj != 0) && (obj->class_ == ORB::_inst()->Mod) )
	{
		if( obj->dsc != ORB::_inst()->system )
		{
			Files::_inst()->WriteString(R, obj->_to<ORB::Module>()->orgname_);
			Files::_inst()->WriteInt(R, obj->val);
		}
		obj = obj->next;
	}
	Files::_inst()->Write(R, 0x0);
	Files::_inst()->WriteInt(R, _this->tdx * 4);
	i = 0;
	/* type descriptors */
	while( i < _this->tdx )
	{
		Files::_inst()->WriteInt(R, _this->data[i]);
		i++;
	}
	/* data */
	Files::_inst()->WriteInt(R, _this->varsize - _this->tdx * 4);
	Files::_inst()->WriteInt(R, _this->strx);
	/* strings */
	for( i = 0; i <= _this->strx - 1; i++ )
		Files::_inst()->Write(R, _this->str[i]);
	/* code len */
	Files::_inst()->WriteInt(R, _this->pc);
	/* program */
	for( i = 0; i <= _this->pc - 1; i++ )
		Files::_inst()->WriteInt(R, _this->code[i]);
	obj = ORB::_inst()->topScope->next;
	/* commands */
	while( obj != 0 )
	{
		if( (obj->exno != 0) && (obj->class_ == ORB::_inst()->Const) && (obj->type->form_ == ORB::_inst()->Proc) && (obj->type->nofpar == 0) && (obj->type->base == ORB::_inst()->noType) )
		{
			Files::_inst()->WriteString(R, obj->name);
			Files::_inst()->WriteInt(R, obj->val);
		}
		obj = obj->next;
	}
	Files::_inst()->Write(R, 0x0);
	Files::_inst()->WriteInt(R, nofent);
	Files::_inst()->WriteInt(R, _this->entry);
	obj = ORB::_inst()->topScope->next;
	/* entries */
	while( obj != 0 )
	{
		if( obj->exno != 0 )
		{
			if( (obj->class_ == ORB::_inst()->Const) && (obj->type->form_ == ORB::_inst()->Proc) || (obj->class_ == ORB::_inst()->Var) )
				Files::_inst()->WriteInt(R, obj->val);
			else if( obj->class_ == ORB::_inst()->Typ )
			{
				if( obj->type->form_ == ORB::_inst()->Record )
					Files::_inst()->WriteInt(R, MOD(obj->type->len,0x10000));
				else if( (obj->type->form_ == ORB::_inst()->Pointer) && ((obj->type->base->typobj == 0) || (obj->type->base->typobj->exno == 0)) )
					Files::_inst()->WriteInt(R, MOD(obj->type->base->len,0x10000));
				
			}
		}
		obj = obj->next;
	}
	obj = ORB::_inst()->topScope->next;
	/* pointer variables */
	while( obj != 0 )
	{
		if( obj->class_ == ORB::_inst()->Var )
			_this->FindPtrs(R, obj->type, obj->val);
		
		obj = obj->next;
	}
	Files::_inst()->WriteInt(R, -1);
	Files::_inst()->WriteInt(R, _this->fixorgP);
	Files::_inst()->WriteInt(R, _this->fixorgD);
	Files::_inst()->WriteInt(R, _this->fixorgT);
	Files::_inst()->WriteInt(R, _this->entry);
	Files::_inst()->Write(R, 'O');
	Files::_inst()->Register(F);
	// END
}

ORG::ORG()
{
	// BEGIN
	relmap[0] = 1;
	relmap[1] = 9;
	relmap[2] = 5;
	relmap[3] = 6;
	relmap[4] = 14;
	relmap[5] = 13;
	// END
}

ORG::~ORG()
{
	s_inst.release();
}

