#ifndef __ObORG_H__
#define __ObORG_H__

// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17

#include <OberonSystem/Ob_Global.h>
#include <OberonSystem/ObSYSTEM.h>
#include <OberonSystem/ObFiles.h>
#include <OberonSystem/ObORS.h>
#include <OberonSystem/ObORB.h>

namespace Ob
{
	class ORG : public _Root
	{
	public:
		/*  N.Wirth, 16.4.2016 / 4.4.2017 / 17.9.2018  Oberon compiler; code generator for RISC */
		static ORG* _inst();
		ORG();
		~ORG();

		// CONST
		/* Code generator for Oberon compiler for RISC processor.
     Procedural interface to Parser OSAP; result in array "code".
     Procedure Close writes code-files */
		static const int WordSize = 4;
		/* for RISC-0 only */
		static const int StkOrg0 = -64;
		static const int VarOrg0 = 0;
		/* dedicated registers */
		static const int MT = 12;
		static const int SP = 14;
		static const int LNK = 15;
		static const int maxCode = 8000;
		static const int maxStrx = 2400;
		static const int maxTD = 160;
		static const int C24 = 0x1000000;
		/* internal item modes */
		static const int Reg = 10;
		static const int RegI = 11;
		static const int Cond = 12;
		/* frequently used opcodes */
		static const int U = 0x2000;
		static const int V = 0x1000;
		static const int Mov = 0;
		static const int Lsl = 1;
		static const int Asr = 2;
		static const int Ror = 3;
		static const int And = 4;
		static const int Ann = 5;
		static const int Ior = 6;
		static const int Xor = 7;
		static const int Add = 8;
		static const int Sub = 9;
		static const int Cmp = 9;
		static const int Mul = 10;
		static const int Div = 11;
		static const int Fad = 12;
		static const int Fsb = 13;
		static const int Fml = 14;
		static const int Fdv = 15;
		static const int Ldr = 8;
		static const int Str = 10;
		static const int BR = 0;
		static const int BLR = 1;
		static const int BC = 2;
		static const int BL = 3;
		static const int MI = 0;
		static const int PL = 8;
		static const int EQ = 1;
		static const int NE = 9;
		static const int LT = 5;
		static const int GE = 13;
		static const int LE = 6;
		static const int GT = 14;

		// TYPE
		struct Item;

		struct Item : public _Root {
			int a;
			int b;
			int mode;
			int r;
			bool rdo;
			ORB::Type type;
		};

		// VAR
		/* read only */
		/*  Item forms and meaning of fields:
    mode    r      a       b
    --------------------------------
    Const   -     value (proc adr)  (immediate value)
    Var     base   off     -               (direct adr)
    Par      -     off0     off1         (indirect adr)
    Reg    regno
    RegI   regno   off     -
    Cond  cond   Fchain  Tchain   */
		/* program counter, data index */
		int pc;
		int varsize;
		int tdx;
		int strx;
		/* main entry point */
		int entry;
		/* available registers R[0] ... R[H-1] */
		int RH;
		/* frame offset changed in SaveRegs and RestoreRegs */
		int frame;
		/* origins of lists of locations to be fixed up by loader */
		int fixorgP;
		int fixorgD;
		int fixorgT;
		/* emit run-time checks */
		bool check;
		/*  0 = RISC-0, 1 = RISC-5  */
		int version;
		/* condition codes for relations */
		_FxArray<int,6> relmap;
		_FxArray<int,maxCode> code;
		/* type descriptors */
		_FxArray<int,maxTD> data;
		_FxArray<char,maxStrx> str;

		// PROC
		static void Put0(int op, int a, int b, int c);
		static void Put1(int op, int a, int b, int im);
		static void Put1a(int op, int a, int b, int im);
		static void Put2(int op, int a, int b, int off);
		static void Put3(int op, int cond, int off);
		static void incR();
		static void CheckRegs();
		static void SetCC(Item& x, int n);
		static void Trap(int cond, int num);
		int negated(int cond);
		static void fix(int at, int with);
		static void FixOne(int at);
		static void FixLink(int L);
		static void FixLinkWith(int L0, int dst);
		int merged(int L0, int L1);
		static void GetSB(int base);
		static void NilCheck();
		static void load(Item& x);
		static void loadAdr(Item& x);
		static void loadCond(Item& x);
		static void loadTypTagAdr(ORB::Type T);
		static void loadStringAdr(Item& x);
		static void MakeConstItem(Item& x, ORB::Type typ, int val);
		static void MakeRealItem(Item& x, float val);
		static void MakeStringItem(Item& x, int len);
		static void MakeItem(Item& x, ORB::Object y, int curlev);
		static void Field(Item& x, ORB::Object y);
		static void Index(Item& x, Item& y);
		static void DeRef(Item& x);
		static void Q(ORB::Type T, int& dcw);
		static void FindPtrFlds(ORB::Type typ, int off, int& dcw);
		static void BuildTD(ORB::Type T, int& dc);
		static void TypeTest(Item& x, ORB::Type T, bool varpar, bool isguard);
		static void Not(Item& x);
		static void And1(Item& x);
		static void And2(Item& x, Item& y);
		static void Or1(Item& x);
		static void Or2(Item& x, Item& y);
		static void Neg(Item& x);
		static void AddOp(int op, Item& x, Item& y);
		int log2(int m, int& e);
		static void MulOp(Item& x, Item& y);
		static void DivOp(int op, Item& x, Item& y);
		static void RealOp(int op, Item& x, Item& y);
		static void Singleton(Item& x);
		static void Set(Item& x, Item& y);
		static void In(Item& x, Item& y);
		static void SetOp(int op, Item& x, Item& y);
		static void IntRelation(int op, Item& x, Item& y);
		static void RealRelation(int op, Item& x, Item& y);
		static void StringRelation(int op, Item& x, Item& y);
		static void StrToChar(Item& x);
		static void Store(Item& x, Item& y);
		static void StoreStruct(Item& x, Item& y);
		static void CopyString(Item& x, Item& y);
		static void OpenArrayParam(Item& x);
		static void VarParam(Item& x, ORB::Type ftype);
		static void ValueParam(Item& x);
		static void StringParam(Item& x);
		static void For0(Item& x, Item& y);
		static void For1(Item& x, Item& y, Item& z, Item& w, int& L);
		static void For2(Item& x, Item& y, Item& w);
		int Here();
		static void FJump(int& L);
		static void CFJump(Item& x);
		static void BJump(int L);
		static void CBJump(Item& x, int L);
		static void Fixup(Item& x);
		static void SaveRegs(int r);
		static void RestoreRegs(int r);
		static void PrepCall(Item& x, int& r);
		static void Call(Item& x, int r);
		static void Enter(int parblksize, int locblksize, bool int_);
		static void Return(int form_, Item& x, int size, bool int_);
		static void Increment(int upordown, Item& x, Item& y);
		static void Include(int inorex, Item& x, Item& y);
		static void Assert(Item& x);
		static void New(Item& x);
		static void Pack(Item& x, Item& y);
		static void Unpk(Item& x, Item& y);
		static void Led(Item& x);
		static void Get(Item& x, Item& y);
		static void Put(Item& x, Item& y);
		static void Copy(Item& x, Item& y, Item& z);
		static void LDPSR(Item& x);
		static void LDREG(Item& x, Item& y);
		static void Abs(Item& x);
		static void Odd(Item& x);
		static void Floor(Item& x);
		static void Float(Item& x);
		static void Ord(Item& x);
		static void Len(Item& x);
		static void Shift(int fct, Item& x, Item& y);
		static void ADC(Item& x, Item& y);
		static void SBC(Item& x, Item& y);
		static void UML(Item& x, Item& y);
		static void Bit(Item& x, Item& y);
		static void Register(Item& x);
		static void H(Item& x);
		static void Adr(Item& x);
		static void Condition(Item& x);
		static void Open(int v);
		static void SetDataSize(int dc);
		static void Header();
		int NofPtrs(ORB::Type typ);
		static void FindPtrs(Files::Rider& R, ORB::Type typ, int adr);
		static void Close(_VarArray<char> modid, int key, int nofent);

	};
}

#endif // __ObORG_H__