// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObORP.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<ORP> s_inst;


ORP* ORP::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new ORP() );
	return s_inst.get();
}

void ORP::Check(int s, _ValArray<char> msg)
{
	// BEGIN
	ORP* _this = _inst();
	if( _this->sym == s )
		ORS::_inst()->Get(_this->sym);
	else
		ORS::_inst()->Mark(msg);

	// END
}

void ORP::qualident(ORB::Object& obj)
{
	// BEGIN
	ORP* _this = _inst();
	obj = ORB::_inst()->thisObj_();
	ORS::_inst()->Get(_this->sym);
	if( obj == 0 )
	{
		ORS::_inst()->Mark("undef");
		obj = _this->dummy;
	}
	if( (_this->sym == ORS::_inst()->period) && (obj->class_ == ORB::_inst()->Mod) )
	{
		ORS::_inst()->Get(_this->sym);
		if( _this->sym == ORS::_inst()->ident )
		{
			obj = ORB::_inst()->thisimport_(obj);
			ORS::_inst()->Get(_this->sym);
			if( obj == 0 )
			{
				ORS::_inst()->Mark("undef");
				obj = _this->dummy;
			}
		}else
		{
			ORS::_inst()->Mark("identifier expected");
			obj = _this->dummy;
		}
	}
	// END
}

void ORP::CheckBool(ORG::Item& x)
{
	// BEGIN
	ORP* _this = _inst();
	if( x.type->form_ != ORB::_inst()->Bool )
	{
		ORS::_inst()->Mark("not Boolean");
		x.type = ORB::_inst()->boolType_;
	}
	// END
}

void ORP::CheckInt(ORG::Item& x)
{
	// BEGIN
	ORP* _this = _inst();
	if( x.type->form_ != ORB::_inst()->Int )
	{
		ORS::_inst()->Mark("not Integer");
		x.type = ORB::_inst()->intType_;
	}
	// END
}

void ORP::CheckReal(ORG::Item& x)
{
	// BEGIN
	ORP* _this = _inst();
	if( x.type->form_ != ORB::_inst()->Real )
	{
		ORS::_inst()->Mark("not Real");
		x.type = ORB::_inst()->realType;
	}
	// END
}

void ORP::CheckSet(ORG::Item& x)
{
	// BEGIN
	ORP* _this = _inst();
	if( x.type->form_ != ORB::_inst()->Set )
	{
		ORS::_inst()->Mark("not Set");
		x.type = ORB::_inst()->setType;
	}
	// END
}

void ORP::CheckSetVal(ORG::Item& x)
{
	// BEGIN
	ORP* _this = _inst();
	if( x.type->form_ != ORB::_inst()->Int )
	{
		ORS::_inst()->Mark("not Int");
		x.type = ORB::_inst()->setType;
	}else if( x.mode == ORB::_inst()->Const )
	{
		if( (x.a < 0) || (x.a >= 32) )
			ORS::_inst()->Mark("invalid set");
		
	}
	// END
}

void ORP::CheckConst(ORG::Item& x)
{
	// BEGIN
	ORP* _this = _inst();
	if( x.mode != ORB::_inst()->Const )
	{
		ORS::_inst()->Mark("not a constant");
		x.mode = ORB::_inst()->Const;
	}
	// END
}

void ORP::CheckReadOnly(ORG::Item& x)
{
	// BEGIN
	ORP* _this = _inst();
	if( x.rdo )
		ORS::_inst()->Mark("read-only");
	
	// END
}

void ORP::CheckExport(bool& expo)
{
	// BEGIN
	ORP* _this = _inst();
	if( _this->sym == ORS::_inst()->times )
	{
		expo = TRUE;
		ORS::_inst()->Get(_this->sym);
		if( _this->level != 0 )
			ORS::_inst()->Mark("remove asterisk");
		
	}else
		expo = FALSE;

	// END
}

bool ORP::IsExtension(ORB::Type t0, ORB::Type t1)
{
	// BEGIN
	ORP* _this = _inst();
	/* t1 is an extension of t0 */
	return (t0 == t1) || (t1 != 0) && _this->IsExtension(t0, t1->base);
	// END
}

/*  expressions  */
void ORP::TypeTest(ORG::Item& x, ORB::Type T, bool guard)
{
	// VAR
	ORB::Type xt;

	// BEGIN
	ORP* _this = _inst();
	xt = x.type;
	if( (T->form_ == xt->form_) && ((T->form_ == ORB::_inst()->Pointer) || (T->form_ == ORB::_inst()->Record) && (x.mode == ORB::_inst()->Par)) )
	{
		while( (xt != T) && (xt != 0) )
			xt = xt->base;
		
		if( xt != T )
		{
			xt = x.type;
			if( xt->form_ == ORB::_inst()->Pointer )
			{
				if( _this->IsExtension(xt->base, T->base) )
				{
					ORG::_inst()->TypeTest(x, T->base, FALSE, guard);
					x.type = T;
				}else
					ORS::_inst()->Mark("not an extension");

			}else if( (xt->form_ == ORB::_inst()->Record) && (x.mode == ORB::_inst()->Par) )
			{
				if( _this->IsExtension(xt, T) )
				{
					ORG::_inst()->TypeTest(x, T, TRUE, guard);
					x.type = T;
				}else
					ORS::_inst()->Mark("not an extension");

			}else
				ORS::_inst()->Mark("incompatible types");

		}else if( !guard )
			ORG::_inst()->MakeConstItem(x, ORB::_inst()->boolType_, 1);
		
	}else
		ORS::_inst()->Mark("type mismatch");

	if( !guard )
		x.type = ORB::_inst()->boolType_;
	
	// END
}

void ORP::selector(ORG::Item& x)
{
	// VAR
	ORG::Item y;
	ORB::Object obj;

	// BEGIN
	ORP* _this = _inst();
	while( (_this->sym == ORS::_inst()->lbrak) || (_this->sym == ORS::_inst()->period) || (_this->sym == ORS::_inst()->arrow) || (_this->sym == ORS::_inst()->lparen) && (( _Set() + (ORB::_inst()->Record) + (ORB::_inst()->Pointer) ).contains( x.type->form_ )) )
		if( _this->sym == ORS::_inst()->lbrak )
		{
			do 
			{
				ORS::_inst()->Get(_this->sym);
				_this->expression(y);
				if( x.type->form_ == ORB::_inst()->Array )
				{
					_this->CheckInt(y);
					ORG::_inst()->Index(x, y);
					x.type = x.type->base;
				}else
					ORS::_inst()->Mark("not an array");

			} while( !( _this->sym != ORS::_inst()->comma ) );
			_this->Check(ORS::_inst()->rbrak, "no ]");
		}else if( _this->sym == ORS::_inst()->period )
		{
			ORS::_inst()->Get(_this->sym);
			if( _this->sym == ORS::_inst()->ident )
			{
				if( x.type->form_ == ORB::_inst()->Pointer )
				{
					ORG::_inst()->DeRef(x);
					x.type = x.type->base;
				}
				if( x.type->form_ == ORB::_inst()->Record )
				{
					obj = ORB::_inst()->thisfield_(x.type);
					ORS::_inst()->Get(_this->sym);
					if( obj != 0 )
					{
						ORG::_inst()->Field(x, obj);
						x.type = obj->type;
					}else
						ORS::_inst()->Mark("undef");

				}else
					ORS::_inst()->Mark("not a record");

			}else
				ORS::_inst()->Mark("ident?");

		}else if( _this->sym == ORS::_inst()->arrow )
		{
			ORS::_inst()->Get(_this->sym);
			if( x.type->form_ == ORB::_inst()->Pointer )
			{
				ORG::_inst()->DeRef(x);
				x.type = x.type->base;
			}else
				ORS::_inst()->Mark("not a pointer");

		}else if( (_this->sym == ORS::_inst()->lparen) && (( _Set() + (ORB::_inst()->Record) + (ORB::_inst()->Pointer) ).contains( x.type->form_ )) )
		{
			/* type guard */
			ORS::_inst()->Get(_this->sym);
			if( _this->sym == ORS::_inst()->ident )
			{
				_this->qualident(obj);
				if( obj->class_ == ORB::_inst()->Typ )
					_this->TypeTest(x, obj->type, TRUE);
				else
					ORS::_inst()->Mark("guard type expected");

			}else
				ORS::_inst()->Mark("not an identifier");

			_this->Check(ORS::_inst()->rparen, " ) missing");
		}
	
	// END
}

bool ORP::EqualSignatures(ORB::Type t0, ORB::Type t1)
{
	// VAR
	ORB::Object p0;
	ORB::Object p1;
	bool com;

	// BEGIN
	ORP* _this = _inst();
	com = TRUE;
	if( (t0->base == t1->base) && (t0->nofpar == t1->nofpar) )
	{
		p0 = t0->dsc;
		p1 = t1->dsc;
		while( p0 != 0 )
			if( (p0->class_ == p1->class_) && (p0->rdo == p1->rdo) && ((p0->type == p1->type) || (p0->type->form_ == ORB::_inst()->Array) && (p1->type->form_ == ORB::_inst()->Array) && (p0->type->len == p1->type->len) && (p0->type->base == p1->type->base) || (p0->type->form_ == ORB::_inst()->Proc) && (p1->type->form_ == ORB::_inst()->Proc) && _this->EqualSignatures(p0->type, p1->type)) )
			{
				p0 = p0->next;
				p1 = p1->next;
			}else
			{
				p0 = 0;
				com = FALSE;
			}
		
	}else
		com = FALSE;

	return com;
	// END
}

bool ORP::CompTypes(ORB::Type t0, ORB::Type t1, bool varpar)
{
	// BEGIN
	ORP* _this = _inst();
	/* check for assignment compatibility */
	/* openarray assignment disallowed in ORG */
	return (t0 == t1) || (t0->form_ == ORB::_inst()->Array) && (t1->form_ == ORB::_inst()->Array) && (t0->base == t1->base) && (t0->len == t1->len) || (t0->form_ == ORB::_inst()->Record) && (t1->form_ == ORB::_inst()->Record) && _this->IsExtension(t0, t1) || !varpar && ((t0->form_ == ORB::_inst()->Pointer) && (t1->form_ == ORB::_inst()->Pointer) && _this->IsExtension(t0->base, t1->base) || (t0->form_ == ORB::_inst()->Proc) && (t1->form_ == ORB::_inst()->Proc) && _this->EqualSignatures(t0, t1) || (( _Set() + (ORB::_inst()->Pointer) + (ORB::_inst()->Proc) ).contains( t0->form_ )) && (t1->form_ == ORB::_inst()->NilTyp));
	// END
}

void ORP::Parameter(ORB::Object par)
{
	// VAR
	ORG::Item x;
	bool varpar;

	// BEGIN
	ORP* _this = _inst();
	_this->expression(x);
	if( par != 0 )
	{
		varpar = par->class_ == ORB::_inst()->Par;
		if( _this->CompTypes(par->type, x.type, varpar) )
		{
			if( !varpar )
				ORG::_inst()->ValueParam(x);
			else
			{
				/* par.class = Par */
				if( !par->rdo )
					_this->CheckReadOnly(x);
				
				ORG::_inst()->VarParam(x, par->type);
			}
		}else if( (x.type->form_ == ORB::_inst()->Array) && (par->type->form_ == ORB::_inst()->Array) && (x.type->base == par->type->base) && (par->type->len < 0) )
		{
			if( !par->rdo )
				_this->CheckReadOnly(x);
			
			ORG::_inst()->OpenArrayParam(x);
		}else if( (x.type->form_ == ORB::_inst()->String) && varpar && par->rdo && (par->type->form_ == ORB::_inst()->Array) && (par->type->base->form_ == ORB::_inst()->Char) && (par->type->len < 0) )
			ORG::_inst()->StringParam(x);
		else if( !varpar && (par->type->form_ == ORB::_inst()->Int) && (x.type->form_ == ORB::_inst()->Int) )
			/* BYTE */
			ORG::_inst()->ValueParam(x);
		else if( (x.type->form_ == ORB::_inst()->String) && (x.b == 2) && (par->class_ == ORB::_inst()->Var) && (par->type->form_ == ORB::_inst()->Char) )
		{
			ORG::_inst()->StrToChar(x);
			ORG::_inst()->ValueParam(x);
		}else if( (par->type->form_ == ORB::_inst()->Array) && (par->type->base == ORB::_inst()->byteType) && (par->type->len >= 0) && (par->type->size == x.type->size) )
			ORG::_inst()->VarParam(x, par->type);
		else
			ORS::_inst()->Mark("incompatible parameters");

	}
	// END
}

void ORP::ParamList(ORG::Item& x)
{
	// VAR
	int n;
	ORB::Object par;

	// BEGIN
	ORP* _this = _inst();
	par = x.type->dsc;
	n = 0;
	if( _this->sym != ORS::_inst()->rparen )
	{
		_this->Parameter(par);
		n = 1;
		while( _this->sym <= ORS::_inst()->comma )
		{
			_this->Check(_this->sym, "comma?");
			if( par != 0 )
				par = par->next;
			
			n++;
			_this->Parameter(par);
		}
		_this->Check(ORS::_inst()->rparen, ") missing");
	}else
		ORS::_inst()->Get(_this->sym);

	if( n < x.type->nofpar )
		ORS::_inst()->Mark("too few params");
	else if( n > x.type->nofpar )
		ORS::_inst()->Mark("too many params");
	
	// END
}

void ORP::StandFunc(ORG::Item& x, int fct, ORB::Type restyp)
{
	// VAR
	ORG::Item y;
	int n;
	int npar;

	// BEGIN
	ORP* _this = _inst();
	_this->Check(ORS::_inst()->lparen, "no (");
	npar = MOD(fct,10);
	fct = DIV(fct,10);
	_this->expression(x);
	n = 1;
	while( _this->sym == ORS::_inst()->comma )
	{
		ORS::_inst()->Get(_this->sym);
		_this->expression(y);
		n++;
	}
	_this->Check(ORS::_inst()->rparen, "no )");
	if( n == npar )
	{
		/* ABS */
		if( fct == 0 )
		{
			if( ( _Set() + (ORB::_inst()->Int) + (ORB::_inst()->Real) ).contains( x.type->form_ ) )
			{
				ORG::_inst()->Abs(x);
				restyp = x.type;
			}else
				ORS::_inst()->Mark("bad type");

		}else if( fct == 1 )
		{
			/* ODD */
			_this->CheckInt(x);
			ORG::_inst()->Odd(x);
		}else if( fct == 2 )
		{
			/* FLOOR */
			_this->CheckReal(x);
			ORG::_inst()->Floor(x);
		}else if( fct == 3 )
		{
			/* FLT */
			_this->CheckInt(x);
			ORG::_inst()->Float(x);
		}else if( fct == 4 )
		{
			/* ORD */
			if( x.type->form_ <= ORB::_inst()->Proc )
				ORG::_inst()->Ord(x);
			else if( (x.type->form_ == ORB::_inst()->String) && (x.b == 2) )
				ORG::_inst()->StrToChar(x);
			else
				ORS::_inst()->Mark("bad type");

		}else if( fct == 5 )
		{
			/* CHR */
			_this->CheckInt(x);
			ORG::_inst()->Ord(x);
		}else if( fct == 6 )
		{
			/* LEN */
			if( x.type->form_ == ORB::_inst()->Array )
				ORG::_inst()->Len(x);
			else
				ORS::_inst()->Mark("not an array");

		}else if( ( _Set() + (7) + (8) + (9) ).contains( fct ) )
		{
			/* LSL, ASR, ROR */
			_this->CheckInt(y);
			if( ( _Set() + (ORB::_inst()->Int) + (ORB::_inst()->Set) ).contains( x.type->form_ ) )
			{
				ORG::_inst()->Shift(fct - 7, x, y);
				restyp = x.type;
			}else
				ORS::_inst()->Mark("bad type");

		}else if( fct == 11 )
			/* ADC */
			ORG::_inst()->ADC(x, y);
		else if( fct == 12 )
			/* SBC */
			ORG::_inst()->SBC(x, y);
		else if( fct == 13 )
			/* UML */
			ORG::_inst()->UML(x, y);
		else if( fct == 14 )
		{
			/* BIT */
			_this->CheckInt(x);
			_this->CheckInt(y);
			ORG::_inst()->Bit(x, y);
		}else if( fct == 15 )
		{
			/* REG */
			_this->CheckConst(x);
			_this->CheckInt(x);
			ORG::_inst()->Register(x);
		}else if( fct == 16 )
		{
			/* VAL */
			if( (x.mode == ORB::_inst()->Typ) && (x.type->size <= y.type->size) )
			{
				restyp = x.type;
				x = y;
			}else
				ORS::_inst()->Mark("casting not allowed");

		}else if( fct == 17 )
			/* ADR */
			ORG::_inst()->Adr(x);
		else if( fct == 18 )
		{
			/* SIZE */
			if( x.mode == ORB::_inst()->Typ )
				ORG::_inst()->MakeConstItem(x, ORB::_inst()->intType_, x.type->size);
			else
				ORS::_inst()->Mark("must be a type");

		}else if( fct == 19 )
		{
			/* COND */
			_this->CheckConst(x);
			_this->CheckInt(x);
			ORG::_inst()->Condition(x);
		}else if( fct == 20 )
		{
			/* H */
			_this->CheckConst(x);
			_this->CheckInt(x);
			ORG::_inst()->H(x);
		}
		x.type = restyp;
	}else
		ORS::_inst()->Mark("wrong nof params");

	// END
}

void ORP::element(ORG::Item& x)
{
	// VAR
	ORG::Item y;

	// BEGIN
	ORP* _this = _inst();
	_this->expression(x);
	_this->CheckSetVal(x);
	if( _this->sym == ORS::_inst()->upto )
	{
		ORS::_inst()->Get(_this->sym);
		_this->expression(y);
		_this->CheckSetVal(y);
		ORG::_inst()->Set(x, y);
	}else
		ORG::_inst()->Singleton(x);

	x.type = ORB::_inst()->setType;
	// END
}

void ORP::set(ORG::Item& x)
{
	// VAR
	ORG::Item y;

	// BEGIN
	ORP* _this = _inst();
	if( _this->sym >= ORS::_inst()->if_ )
	{
		if( _this->sym != ORS::_inst()->rbrace )
			ORS::_inst()->Mark(" } missing");
		
		/* empty set */
		ORG::_inst()->MakeConstItem(x, ORB::_inst()->setType, 0);
	}else
	{
		_this->element(x);
		while( (_this->sym < ORS::_inst()->rparen) || (_this->sym > ORS::_inst()->rbrace) )
		{
			if( _this->sym == ORS::_inst()->comma )
				ORS::_inst()->Get(_this->sym);
			else if( _this->sym != ORS::_inst()->rbrace )
				ORS::_inst()->Mark("missing comma");
			
			_this->element(y);
			ORG::_inst()->SetOp(ORS::_inst()->plus, x, y);
		}
	}
	// END
}

void ORP::factor(ORG::Item& x)
{
	// VAR
	ORB::Object obj;
	int rx;

	// BEGIN
	ORP* _this = _inst();
	/* sync */
	if( (_this->sym < ORS::_inst()->char_) || (_this->sym > ORS::_inst()->ident) )
	{
		ORS::_inst()->Mark("expression expected");
		do 
		{
			ORS::_inst()->Get(_this->sym);
		} while( !( (_this->sym >= ORS::_inst()->char_) && (_this->sym <= ORS::_inst()->for_) || (_this->sym >= ORS::_inst()->then) ) );
	}
	if( _this->sym == ORS::_inst()->ident )
	{
		_this->qualident(obj);
		if( obj->class_ == ORB::_inst()->SFunc )
			_this->StandFunc(x, obj->val, obj->type);
		else
		{
			ORG::_inst()->MakeItem(x, obj, _this->level);
			_this->selector(x);
			if( _this->sym == ORS::_inst()->lparen )
			{
				ORS::_inst()->Get(_this->sym);
				if( (x.type->form_ == ORB::_inst()->Proc) && (x.type->base->form_ != ORB::_inst()->NoTyp) )
				{
					ORG::_inst()->PrepCall(x, rx);
					_this->ParamList(x);
					ORG::_inst()->Call(x, rx);
					x.type = x.type->base;
				}else
				{
					ORS::_inst()->Mark("not a function");
					_this->ParamList(x);
				}
			}
		}
	}else if( _this->sym == ORS::_inst()->int_ )
	{
		ORG::_inst()->MakeConstItem(x, ORB::_inst()->intType_, ORS::_inst()->ival);
		ORS::_inst()->Get(_this->sym);
	}else if( _this->sym == ORS::_inst()->real )
	{
		ORG::_inst()->MakeRealItem(x, ORS::_inst()->rval);
		ORS::_inst()->Get(_this->sym);
	}else if( _this->sym == ORS::_inst()->char_ )
	{
		ORG::_inst()->MakeConstItem(x, ORB::_inst()->charType_, ORS::_inst()->ival);
		ORS::_inst()->Get(_this->sym);
	}else if( _this->sym == ORS::_inst()->nil )
	{
		ORS::_inst()->Get(_this->sym);
		ORG::_inst()->MakeConstItem(x, ORB::_inst()->nilType, 0);
	}else if( _this->sym == ORS::_inst()->string )
	{
		ORG::_inst()->MakeStringItem(x, ORS::_inst()->slen);
		ORS::_inst()->Get(_this->sym);
	}else if( _this->sym == ORS::_inst()->lparen )
	{
		ORS::_inst()->Get(_this->sym);
		_this->expression(x);
		_this->Check(ORS::_inst()->rparen, "no )");
	}else if( _this->sym == ORS::_inst()->lbrace )
	{
		ORS::_inst()->Get(_this->sym);
		_this->set(x);
		_this->Check(ORS::_inst()->rbrace, "no }");
	}else if( _this->sym == ORS::_inst()->not_ )
	{
		ORS::_inst()->Get(_this->sym);
		_this->factor(x);
		_this->CheckBool(x);
		ORG::_inst()->Not(x);
	}else if( _this->sym == ORS::_inst()->false_ )
	{
		ORS::_inst()->Get(_this->sym);
		ORG::_inst()->MakeConstItem(x, ORB::_inst()->boolType_, 0);
	}else if( _this->sym == ORS::_inst()->true_ )
	{
		ORS::_inst()->Get(_this->sym);
		ORG::_inst()->MakeConstItem(x, ORB::_inst()->boolType_, 1);
	}else
	{
		ORS::_inst()->Mark("not a factor");
		ORG::_inst()->MakeConstItem(x, ORB::_inst()->intType_, 0);
	}
	// END
}

void ORP::term(ORG::Item& x)
{
	// VAR
	ORG::Item y;
	int op;
	int f;

	// BEGIN
	ORP* _this = _inst();
	_this->factor(x);
	f = x.type->form_;
	while( (_this->sym >= ORS::_inst()->times) && (_this->sym <= ORS::_inst()->and_) )
	{
		op = _this->sym;
		ORS::_inst()->Get(_this->sym);
		if( op == ORS::_inst()->times )
		{
			if( f == ORB::_inst()->Int )
			{
				_this->factor(y);
				_this->CheckInt(y);
				ORG::_inst()->MulOp(x, y);
			}else if( f == ORB::_inst()->Real )
			{
				_this->factor(y);
				_this->CheckReal(y);
				ORG::_inst()->RealOp(op, x, y);
			}else if( f == ORB::_inst()->Set )
			{
				_this->factor(y);
				_this->CheckSet(y);
				ORG::_inst()->SetOp(op, x, y);
			}else
				ORS::_inst()->Mark("bad type");

		}else if( (op == ORS::_inst()->div) || (op == ORS::_inst()->mod) )
		{
			_this->CheckInt(x);
			_this->factor(y);
			_this->CheckInt(y);
			ORG::_inst()->DivOp(op, x, y);
		}else if( op == ORS::_inst()->rdiv )
		{
			if( f == ORB::_inst()->Real )
			{
				_this->factor(y);
				_this->CheckReal(y);
				ORG::_inst()->RealOp(op, x, y);
			}else if( f == ORB::_inst()->Set )
			{
				_this->factor(y);
				_this->CheckSet(y);
				ORG::_inst()->SetOp(op, x, y);
			}else
				ORS::_inst()->Mark("bad type");

		}else
		{
			/* op = and */
			_this->CheckBool(x);
			ORG::_inst()->And1(x);
			_this->factor(y);
			_this->CheckBool(y);
			ORG::_inst()->And2(x, y);
		}
	}
	// END
}

void ORP::SimpleExpression(ORG::Item& x)
{
	// VAR
	ORG::Item y;
	int op;

	// BEGIN
	ORP* _this = _inst();
	if( _this->sym == ORS::_inst()->minus )
	{
		ORS::_inst()->Get(_this->sym);
		_this->term(x);
		if( ( _Set() + (ORB::_inst()->Int) + (ORB::_inst()->Real) + (ORB::_inst()->Set) ).contains( x.type->form_ ) )
			ORG::_inst()->Neg(x);
		else
			_this->CheckInt(x);

	}else if( _this->sym == ORS::_inst()->plus )
	{
		ORS::_inst()->Get(_this->sym);
		_this->term(x);
	}else
		_this->term(x);

	while( (_this->sym >= ORS::_inst()->plus) && (_this->sym <= ORS::_inst()->or_) )
	{
		op = _this->sym;
		ORS::_inst()->Get(_this->sym);
		if( op == ORS::_inst()->or_ )
		{
			ORG::_inst()->Or1(x);
			_this->CheckBool(x);
			_this->term(y);
			_this->CheckBool(y);
			ORG::_inst()->Or2(x, y);
		}else if( x.type->form_ == ORB::_inst()->Int )
		{
			_this->term(y);
			_this->CheckInt(y);
			ORG::_inst()->AddOp(op, x, y);
		}else if( x.type->form_ == ORB::_inst()->Real )
		{
			_this->term(y);
			_this->CheckReal(y);
			ORG::_inst()->RealOp(op, x, y);
		}else
		{
			_this->CheckSet(x);
			_this->term(y);
			_this->CheckSet(y);
			ORG::_inst()->SetOp(op, x, y);
		}
	}
	// END
}

void ORP::expression0(ORG::Item& x)
{
	// VAR
	ORG::Item y;
	ORB::Object obj;
	int rel;
	int xf;
	int yf;

	// BEGIN
	ORP* _this = _inst();
	_this->SimpleExpression(x);
	if( (_this->sym >= ORS::_inst()->eql) && (_this->sym <= ORS::_inst()->geq) )
	{
		rel = _this->sym;
		ORS::_inst()->Get(_this->sym);
		_this->SimpleExpression(y);
		xf = x.type->form_;
		yf = y.type->form_;
		if( x.type == y.type )
		{
			if( (( _Set() + (ORB::_inst()->Char) + (ORB::_inst()->Int) ).contains( xf )) )
				ORG::_inst()->IntRelation(rel, x, y);
			else if( xf == ORB::_inst()->Real )
				ORG::_inst()->RealRelation(rel, x, y);
			else if( (( _Set() + (ORB::_inst()->Set) + (ORB::_inst()->Pointer) + (ORB::_inst()->Proc) + (ORB::_inst()->NilTyp) + (ORB::_inst()->Bool) ).contains( xf )) )
			{
				if( rel <= ORS::_inst()->neq )
					ORG::_inst()->IntRelation(rel, x, y);
				else
					ORS::_inst()->Mark("only = or #");

			}else if( (xf == ORB::_inst()->Array) && (x.type->base->form_ == ORB::_inst()->Char) || (xf == ORB::_inst()->String) )
				ORG::_inst()->StringRelation(rel, x, y);
			else
				ORS::_inst()->Mark("illegal comparison");

		}else if( (( _Set() + (ORB::_inst()->Pointer) + (ORB::_inst()->Proc) ).contains( xf )) && (yf == ORB::_inst()->NilTyp) || (( _Set() + (ORB::_inst()->Pointer) + (ORB::_inst()->Proc) ).contains( yf )) && (xf == ORB::_inst()->NilTyp) )
		{
			if( rel <= ORS::_inst()->neq )
				ORG::_inst()->IntRelation(rel, x, y);
			else
				ORS::_inst()->Mark("only = or #");

		}else if( (xf == ORB::_inst()->Pointer) && (yf == ORB::_inst()->Pointer) && (_this->IsExtension(x.type->base, y.type->base) || _this->IsExtension(y.type->base, x.type->base)) || (xf == ORB::_inst()->Proc) && (yf == ORB::_inst()->Proc) && _this->EqualSignatures(x.type, y.type) )
		{
			if( rel <= ORS::_inst()->neq )
				ORG::_inst()->IntRelation(rel, x, y);
			else
				ORS::_inst()->Mark("only = or #");

		}else if( (xf == ORB::_inst()->Array) && (x.type->base->form_ == ORB::_inst()->Char) && ((yf == ORB::_inst()->String) || (yf == ORB::_inst()->Array) && (y.type->base->form_ == ORB::_inst()->Char)) || (yf == ORB::_inst()->Array) && (y.type->base->form_ == ORB::_inst()->Char) && (xf == ORB::_inst()->String) )
			ORG::_inst()->StringRelation(rel, x, y);
		else if( (xf == ORB::_inst()->Char) && (yf == ORB::_inst()->String) && (y.b == 2) )
		{
			ORG::_inst()->StrToChar(y);
			ORG::_inst()->IntRelation(rel, x, y);
		}else if( (yf == ORB::_inst()->Char) && (xf == ORB::_inst()->String) && (x.b == 2) )
		{
			ORG::_inst()->StrToChar(x);
			ORG::_inst()->IntRelation(rel, x, y);
		}else if( (xf == ORB::_inst()->Int) && (yf == ORB::_inst()->Int) )
			/* BYTE */
			ORG::_inst()->IntRelation(rel, x, y);
		else
			ORS::_inst()->Mark("illegal comparison");

		x.type = ORB::_inst()->boolType_;
	}else if( _this->sym == ORS::_inst()->in )
	{
		ORS::_inst()->Get(_this->sym);
		_this->CheckInt(x);
		_this->SimpleExpression(y);
		_this->CheckSet(y);
		ORG::_inst()->In(x, y);
		x.type = ORB::_inst()->boolType_;
	}else if( _this->sym == ORS::_inst()->is )
	{
		ORS::_inst()->Get(_this->sym);
		_this->qualident(obj);
		_this->TypeTest(x, obj->type, FALSE);
		x.type = ORB::_inst()->boolType_;
	}
	// END
}

/*  statements  */
void ORP::StandProc(int pno)
{
	// VAR
	/* nof actual/formal parameters */
	int nap;
	int npar;
	ORG::Item x;
	ORG::Item y;
	ORG::Item z;

	// BEGIN
	ORP* _this = _inst();
	_this->Check(ORS::_inst()->lparen, "no (");
	npar = MOD(pno,10);
	pno = DIV(pno,10);
	_this->expression(x);
	nap = 1;
	if( _this->sym == ORS::_inst()->comma )
	{
		ORS::_inst()->Get(_this->sym);
		_this->expression(y);
		nap = 2;
		z.type = ORB::_inst()->noType;
		while( _this->sym == ORS::_inst()->comma )
		{
			ORS::_inst()->Get(_this->sym);
			_this->expression(z);
			nap++;
		}
	}else
		y.type = ORB::_inst()->noType;

	_this->Check(ORS::_inst()->rparen, "no )");
	if( (npar == nap) || (( _Set() + (0) + (1) ).contains( pno )) )
	{
		/* INC, DEC */
		if( ( _Set() + (0) + (1) ).contains( pno ) )
		{
			_this->CheckInt(x);
			_this->CheckReadOnly(x);
			if( y.type != ORB::_inst()->noType )
				_this->CheckInt(y);
			
			ORG::_inst()->Increment(pno, x, y);
		}else if( ( _Set() + (2) + (3) ).contains( pno ) )
		{
			/* INCL, EXCL */
			_this->CheckSet(x);
			_this->CheckReadOnly(x);
			_this->CheckInt(y);
			ORG::_inst()->Include(pno - 2, x, y);
		}else if( pno == 4 )
		{
			_this->CheckBool(x);
			ORG::_inst()->Assert(x);
		}else if( pno == 5 )
		{
			/* NEW */
			_this->CheckReadOnly(x);
			if( (x.type->form_ == ORB::_inst()->Pointer) && (x.type->base->form_ == ORB::_inst()->Record) )
				ORG::_inst()->New(x);
			else
				ORS::_inst()->Mark("not a pointer to record");

		}else if( pno == 6 )
		{
			_this->CheckReal(x);
			_this->CheckInt(y);
			_this->CheckReadOnly(x);
			ORG::_inst()->Pack(x, y);
		}else if( pno == 7 )
		{
			_this->CheckReal(x);
			_this->CheckInt(y);
			_this->CheckReadOnly(x);
			ORG::_inst()->Unpk(x, y);
		}else if( pno == 8 )
		{
			if( x.type->form_ <= ORB::_inst()->Set )
				ORG::_inst()->Led(x);
			else
				ORS::_inst()->Mark("bad type");

		}else if( pno == 10 )
		{
			_this->CheckInt(x);
			ORG::_inst()->Get(x, y);
		}else if( pno == 11 )
		{
			_this->CheckInt(x);
			ORG::_inst()->Put(x, y);
		}else if( pno == 12 )
		{
			_this->CheckInt(x);
			_this->CheckInt(y);
			_this->CheckInt(z);
			ORG::_inst()->Copy(x, y, z);
		}else if( pno == 13 )
		{
			_this->CheckConst(x);
			_this->CheckInt(x);
			ORG::_inst()->LDPSR(x);
		}else if( pno == 14 )
		{
			_this->CheckInt(x);
			ORG::_inst()->LDREG(x, y);
		}
	}else
		ORS::_inst()->Mark("wrong nof parameters");

	// END
}

void ORP::TypeCase(ORB::Object obj, ORG::Item& x)
{
	// VAR
	ORB::Object typobj;

	// BEGIN
	ORP* _this = _inst();
	if( _this->sym == ORS::_inst()->ident )
	{
		_this->qualident(typobj);
		ORG::_inst()->MakeItem(x, obj, _this->level);
		if( typobj->class_ != ORB::_inst()->Typ )
			ORS::_inst()->Mark("not a type");
		
		_this->TypeTest(x, typobj->type, FALSE);
		obj->type = typobj->type;
		ORG::_inst()->CFJump(x);
		_this->Check(ORS::_inst()->colon, ": expected");
		_this->StatSequence();
	}else
	{
		ORG::_inst()->CFJump(x);
		ORS::_inst()->Mark("type id expected");
	}
	// END
}

void ORP::SkipCase()
{
	// BEGIN
	ORP* _this = _inst();
	while( _this->sym != ORS::_inst()->colon )
		ORS::_inst()->Get(_this->sym);
	
	ORS::_inst()->Get(_this->sym);
	_this->StatSequence();
	// END
}

void ORP::StatSequence()
{
	// VAR
	ORB::Object obj;
	/* original type of case var */
	ORB::Type orgtype_;
	ORG::Item x;
	ORG::Item y;
	ORG::Item z;
	ORG::Item w;
	int L0;
	int L1;
	int rx;

	// BEGIN
	ORP* _this = _inst();
	/*  StatSequence  */
	/* sync */
	do 
	{
		obj = 0;
		if( !((_this->sym >= ORS::_inst()->ident) && (_this->sym <= ORS::_inst()->for_) || (_this->sym >= ORS::_inst()->semicolon)) )
		{
			ORS::_inst()->Mark("statement expected");
			do 
			{
				ORS::_inst()->Get(_this->sym);
			} while( !( (_this->sym >= ORS::_inst()->ident) ) );
		}
		if( _this->sym == ORS::_inst()->ident )
		{
			_this->qualident(obj);
			ORG::_inst()->MakeItem(x, obj, _this->level);
			if( x.mode == ORB::_inst()->SProc )
				_this->StandProc(obj->val);
			else
			{
				_this->selector(x);
				/* assignment */
				if( _this->sym == ORS::_inst()->becomes )
				{
					ORS::_inst()->Get(_this->sym);
					_this->CheckReadOnly(x);
					_this->expression(y);
					if( _this->CompTypes(x.type, y.type, FALSE) )
					{
						if( (x.type->form_ <= ORB::_inst()->Pointer) || (x.type->form_ == ORB::_inst()->Proc) )
							ORG::_inst()->Store(x, y);
						else
							ORG::_inst()->StoreStruct(x, y);

					}else if( (x.type->form_ == ORB::_inst()->Array) && (y.type->form_ == ORB::_inst()->Array) && (x.type->base == y.type->base) && (y.type->len < 0) )
						ORG::_inst()->StoreStruct(x, y);
					else if( (x.type->form_ == ORB::_inst()->Array) && (x.type->base->form_ == ORB::_inst()->Char) && (y.type->form_ == ORB::_inst()->String) )
						ORG::_inst()->CopyString(x, y);
					else if( (x.type->form_ == ORB::_inst()->Int) && (y.type->form_ == ORB::_inst()->Int) )
						/* BYTE */
						ORG::_inst()->Store(x, y);
					else if( (x.type->form_ == ORB::_inst()->Char) && (y.type->form_ == ORB::_inst()->String) && (y.b == 2) )
					{
						ORG::_inst()->StrToChar(y);
						ORG::_inst()->Store(x, y);
					}else
						ORS::_inst()->Mark("illegal assignment");

				}else if( _this->sym == ORS::_inst()->eql )
				{
					ORS::_inst()->Mark("should be :=");
					ORS::_inst()->Get(_this->sym);
					_this->expression(y);
				}else if( _this->sym == ORS::_inst()->lparen )
				{
					/* procedure call */
					ORS::_inst()->Get(_this->sym);
					if( (x.type->form_ == ORB::_inst()->Proc) && (x.type->base->form_ == ORB::_inst()->NoTyp) )
					{
						ORG::_inst()->PrepCall(x, rx);
						_this->ParamList(x);
						ORG::_inst()->Call(x, rx);
					}else
					{
						ORS::_inst()->Mark("not a procedure");
						_this->ParamList(x);
					}
				}else if( x.type->form_ == ORB::_inst()->Proc )
				{
					/* procedure call without parameters */
					if( x.type->nofpar > 0 )
						ORS::_inst()->Mark("missing parameters");
					
					if( x.type->base->form_ == ORB::_inst()->NoTyp )
					{
						ORG::_inst()->PrepCall(x, rx);
						ORG::_inst()->Call(x, rx);
					}else
						ORS::_inst()->Mark("not a procedure");

				}else if( x.mode == ORB::_inst()->Typ )
					ORS::_inst()->Mark("illegal assignment");
				else
					ORS::_inst()->Mark("not a procedure");

			}
		}else if( _this->sym == ORS::_inst()->if_ )
		{
			ORS::_inst()->Get(_this->sym);
			_this->expression(x);
			_this->CheckBool(x);
			ORG::_inst()->CFJump(x);
			_this->Check(ORS::_inst()->then, "no THEN");
			_this->StatSequence();
			L0 = 0;
			while( _this->sym == ORS::_inst()->elsif )
			{
				ORS::_inst()->Get(_this->sym);
				ORG::_inst()->FJump(L0);
				ORG::_inst()->Fixup(x);
				_this->expression(x);
				_this->CheckBool(x);
				ORG::_inst()->CFJump(x);
				_this->Check(ORS::_inst()->then, "no THEN");
				_this->StatSequence();
			}
			if( _this->sym == ORS::_inst()->else_ )
			{
				ORS::_inst()->Get(_this->sym);
				ORG::_inst()->FJump(L0);
				ORG::_inst()->Fixup(x);
				_this->StatSequence();
			}else
				ORG::_inst()->Fixup(x);

			ORG::_inst()->FixLink(L0);
			_this->Check(ORS::_inst()->end, "no END");
		}else if( _this->sym == ORS::_inst()->while_ )
		{
			ORS::_inst()->Get(_this->sym);
			L0 = ORG::_inst()->Here();
			_this->expression(x);
			_this->CheckBool(x);
			ORG::_inst()->CFJump(x);
			_this->Check(ORS::_inst()->do_, "no DO");
			_this->StatSequence();
			ORG::_inst()->BJump(L0);
			while( _this->sym == ORS::_inst()->elsif )
			{
				ORS::_inst()->Get(_this->sym);
				ORG::_inst()->Fixup(x);
				_this->expression(x);
				_this->CheckBool(x);
				ORG::_inst()->CFJump(x);
				_this->Check(ORS::_inst()->do_, "no DO");
				_this->StatSequence();
				ORG::_inst()->BJump(L0);
			}
			ORG::_inst()->Fixup(x);
			_this->Check(ORS::_inst()->end, "no END");
		}else if( _this->sym == ORS::_inst()->repeat )
		{
			ORS::_inst()->Get(_this->sym);
			L0 = ORG::_inst()->Here();
			_this->StatSequence();
			if( _this->sym == ORS::_inst()->until )
			{
				ORS::_inst()->Get(_this->sym);
				_this->expression(x);
				_this->CheckBool(x);
				ORG::_inst()->CBJump(x, L0);
			}else
				ORS::_inst()->Mark("missing UNTIL");

		}else if( _this->sym == ORS::_inst()->for_ )
		{
			ORS::_inst()->Get(_this->sym);
			if( _this->sym == ORS::_inst()->ident )
			{
				_this->qualident(obj);
				ORG::_inst()->MakeItem(x, obj, _this->level);
				_this->CheckInt(x);
				_this->CheckReadOnly(x);
				if( _this->sym == ORS::_inst()->becomes )
				{
					ORS::_inst()->Get(_this->sym);
					_this->expression(y);
					_this->CheckInt(y);
					ORG::_inst()->For0(x, y);
					L0 = ORG::_inst()->Here();
					_this->Check(ORS::_inst()->to, "no TO");
					_this->expression(z);
					_this->CheckInt(z);
					obj->rdo = TRUE;
					if( _this->sym == ORS::_inst()->by )
					{
						ORS::_inst()->Get(_this->sym);
						_this->expression(w);
						_this->CheckConst(w);
						_this->CheckInt(w);
					}else
						ORG::_inst()->MakeConstItem(w, ORB::_inst()->intType_, 1);

					_this->Check(ORS::_inst()->do_, "no DO");
					ORG::_inst()->For1(x, y, z, w, L1);
					_this->StatSequence();
					_this->Check(ORS::_inst()->end, "no END");
					ORG::_inst()->For2(x, y, w);
					ORG::_inst()->BJump(L0);
					ORG::_inst()->FixLink(L1);
					obj->rdo = FALSE;
				}else
					ORS::_inst()->Mark(":= expected");

			}else
				ORS::_inst()->Mark("identifier expected");

		}else if( _this->sym == ORS::_inst()->case_ )
		{
			ORS::_inst()->Get(_this->sym);
			if( _this->sym == ORS::_inst()->ident )
			{
				_this->qualident(obj);
				orgtype_ = obj->type;
				if( (orgtype_->form_ == ORB::_inst()->Pointer) || (orgtype_->form_ == ORB::_inst()->Record) && (obj->class_ == ORB::_inst()->Par) )
				{
					_this->Check(ORS::_inst()->of, "OF expected");
					_this->TypeCase(obj, x);
					L0 = 0;
					while( _this->sym == ORS::_inst()->bar )
					{
						ORS::_inst()->Get(_this->sym);
						ORG::_inst()->FJump(L0);
						ORG::_inst()->Fixup(x);
						obj->type = orgtype_;
						_this->TypeCase(obj, x);
					}
					ORG::_inst()->Fixup(x);
					ORG::_inst()->FixLink(L0);
					obj->type = orgtype_;
				}else
				{
					ORS::_inst()->Mark("numeric case not implemented");
					_this->Check(ORS::_inst()->of, "OF expected");
					_this->SkipCase();
					while( _this->sym == ORS::_inst()->bar )
						_this->SkipCase();
					
				}
			}else
				ORS::_inst()->Mark("ident expected");

			_this->Check(ORS::_inst()->end, "no END");
		}
		ORG::_inst()->CheckRegs();
		if( _this->sym == ORS::_inst()->semicolon )
			ORS::_inst()->Get(_this->sym);
		else if( _this->sym < ORS::_inst()->semicolon )
			ORS::_inst()->Mark("missing semicolon?");
		
	} while( !( _this->sym > ORS::_inst()->semicolon ) );
	// END
}

/*  Types and declarations  */
void ORP::IdentList(int class_, ORB::Object& first)
{
	// VAR
	ORB::Object obj;

	// BEGIN
	ORP* _this = _inst();
	if( _this->sym == ORS::_inst()->ident )
	{
		ORB::_inst()->NewObj(first, ORS::_inst()->id, class_);
		ORS::_inst()->Get(_this->sym);
		_this->CheckExport(first->expo);
		while( _this->sym == ORS::_inst()->comma )
		{
			ORS::_inst()->Get(_this->sym);
			if( _this->sym == ORS::_inst()->ident )
			{
				ORB::_inst()->NewObj(obj, ORS::_inst()->id, class_);
				ORS::_inst()->Get(_this->sym);
				_this->CheckExport(obj->expo);
			}else
				ORS::_inst()->Mark("ident?");

		}
		if( _this->sym == ORS::_inst()->colon )
			ORS::_inst()->Get(_this->sym);
		else
			ORS::_inst()->Mark(":?");

	}else
		first = 0;

	// END
}

void ORP::ArrayType(ORB::Type& type)
{
	// VAR
	ORG::Item x;
	ORB::Type typ;
	int len;

	// BEGIN
	ORP* _this = _inst();
	typ = new ORB::TypeDesc();
	typ->form_ = ORB::_inst()->NoTyp;
	_this->expression(x);
	if( (x.mode == ORB::_inst()->Const) && (x.type->form_ == ORB::_inst()->Int) && (x.a >= 0) )
		len = x.a;
	else
	{
		len = 1;
		ORS::_inst()->Mark("not a valid length");
	}
	if( _this->sym == ORS::_inst()->of )
	{
		ORS::_inst()->Get(_this->sym);
		_this->Type(typ->base);
		if( (typ->base->form_ == ORB::_inst()->Array) && (typ->base->len < 0) )
			ORS::_inst()->Mark("dyn array not allowed");
		
	}else if( _this->sym == ORS::_inst()->comma )
	{
		ORS::_inst()->Get(_this->sym);
		_this->ArrayType(typ->base);
	}else
	{
		ORS::_inst()->Mark("missing OF");
		typ->base = ORB::_inst()->intType_;
	}
	typ->size = DIV((len * typ->base->size + 3),4) * 4;
	typ->form_ = ORB::_inst()->Array;
	typ->len = len;
	type = typ;
	// END
}

void ORP::RecordType(ORB::Type& type)
{
	// VAR
	ORB::Object obj;
	ORB::Object obj0;
	ORB::Object new_;
	ORB::Object bot;
	ORB::Object base;
	ORB::Type typ;
	ORB::Type tp;
	int offset;
	int off;
	int n;

	// BEGIN
	ORP* _this = _inst();
	typ = new ORB::TypeDesc();
	typ->form_ = ORB::_inst()->NoTyp;
	typ->base = 0;
	typ->mno = -_this->level;
	typ->nofpar = 0;
	offset = 0;
	bot = 0;
	if( _this->sym == ORS::_inst()->lparen )
	{
		/* record extension */
		ORS::_inst()->Get(_this->sym);
		if( _this->level != 0 )
			ORS::_inst()->Mark("extension of local types not implemented");
		
		if( _this->sym == ORS::_inst()->ident )
		{
			_this->qualident(base);
			if( base->class_ == ORB::_inst()->Typ )
			{
				if( base->type->form_ == ORB::_inst()->Record )
					typ->base = base->type;
				else
				{
					typ->base = ORB::_inst()->intType_;
					ORS::_inst()->Mark("invalid extension");
				}
				/* "nofpar" here abused for extension level */
				typ->nofpar = typ->base->nofpar + 1;
				bot = typ->base->dsc;
				offset = typ->base->size;
			}else
				ORS::_inst()->Mark("type expected");

		}else
			ORS::_inst()->Mark("ident expected");

		_this->Check(ORS::_inst()->rparen, "no )");
	}
	/* fields */
	while( _this->sym == ORS::_inst()->ident )
	{
		n = 0;
		obj = bot;
		while( _this->sym == ORS::_inst()->ident )
		{
			obj0 = obj;
			while( (obj0 != 0) && (obj0->name != ORS::_inst()->id) )
				obj0 = obj0->next;
			
			if( obj0 != 0 )
				ORS::_inst()->Mark("mult def");
			
			new_ = new ORB::ObjDesc();
			ORS::_inst()->CopyId(new_->name);
			new_->class_ = ORB::_inst()->Fld;
			new_->next = obj;
			obj = new_;
			n++;
			ORS::_inst()->Get(_this->sym);
			_this->CheckExport(new_->expo);
			if( (_this->sym != ORS::_inst()->comma) && (_this->sym != ORS::_inst()->colon) )
				ORS::_inst()->Mark("comma expected");
			else if( _this->sym == ORS::_inst()->comma )
				ORS::_inst()->Get(_this->sym);
			
		}
		_this->Check(ORS::_inst()->colon, "colon expected");
		_this->Type(tp);
		if( (tp->form_ == ORB::_inst()->Array) && (tp->len < 0) )
			ORS::_inst()->Mark("dyn array not allowed");
		
		if( tp->size > 1 )
			offset = DIV((offset + 3),4) * 4;
		
		offset = offset + n * tp->size;
		off = offset;
		obj0 = obj;
		while( obj0 != bot )
		{
			obj0->type = tp;
			obj0->lev = 0;
			off = off - tp->size;
			obj0->val = off;
			obj0 = obj0->next;
		}
		bot = obj;
		if( _this->sym == ORS::_inst()->semicolon )
			ORS::_inst()->Get(_this->sym);
		else if( _this->sym != ORS::_inst()->end )
			ORS::_inst()->Mark(" ; or END");
		
	}
	typ->form_ = ORB::_inst()->Record;
	typ->dsc = bot;
	typ->size = DIV((offset + 3),4) * 4;
	type = typ;
	// END
}

void ORP::FPSection(int& adr, int& nofpar)
{
	// VAR
	ORB::Object obj;
	ORB::Object first;
	ORB::Type tp;
	int parsize;
	int cl;
	bool rdo;

	// BEGIN
	ORP* _this = _inst();
	if( _this->sym == ORS::_inst()->var )
	{
		ORS::_inst()->Get(_this->sym);
		cl = ORB::_inst()->Par;
	}else
		cl = ORB::_inst()->Var;

	_this->IdentList(cl, first);
	_this->FormalType(tp, 0);
	rdo = FALSE;
	if( (cl == ORB::_inst()->Var) && (tp->form_ >= ORB::_inst()->Array) )
	{
		cl = ORB::_inst()->Par;
		rdo = TRUE;
	}
	if( (tp->form_ == ORB::_inst()->Array) && (tp->len < 0) || (tp->form_ == ORB::_inst()->Record) )
		/* open array or record, needs second word for length or type tag */
		parsize = 2 * ORG::_inst()->WordSize;
	else
		parsize = ORG::_inst()->WordSize;

	obj = first;
	while( obj != 0 )
	{
		nofpar++;
		obj->class_ = cl;
		obj->type = tp;
		obj->rdo = rdo;
		obj->lev = _this->level;
		obj->val = adr;
		adr = adr + parsize;
		obj = obj->next;
	}
	if( adr >= 52 )
		ORS::_inst()->Mark("too many parameters");
	
	// END
}

void ORP::ProcedureType(ORB::Type ptype, int& parblksize)
{
	// VAR
	ORB::Object obj;
	int size;
	int nofpar;

	// BEGIN
	ORP* _this = _inst();
	ptype->base = ORB::_inst()->noType;
	size = parblksize;
	nofpar = 0;
	ptype->dsc = 0;
	if( _this->sym == ORS::_inst()->lparen )
	{
		ORS::_inst()->Get(_this->sym);
		if( _this->sym == ORS::_inst()->rparen )
			ORS::_inst()->Get(_this->sym);
		else
		{
			_this->FPSection(size, nofpar);
			while( _this->sym == ORS::_inst()->semicolon )
			{
				ORS::_inst()->Get(_this->sym);
				_this->FPSection(size, nofpar);
			}
			_this->Check(ORS::_inst()->rparen, "no )");
		}
		/* function */
		if( _this->sym == ORS::_inst()->colon )
		{
			ORS::_inst()->Get(_this->sym);
			if( _this->sym == ORS::_inst()->ident )
			{
				_this->qualident(obj);
				ptype->base = obj->type;
				if( !((obj->class_ == ORB::_inst()->Typ) && (( _Set() + _Set( ORB::_inst()->Byte, ORB::_inst()->Pointer) + (ORB::_inst()->Proc) ).contains( obj->type->form_ ))) )
					ORS::_inst()->Mark("illegal function type");
				
			}else
				ORS::_inst()->Mark("type identifier expected");

		}
	}
	ptype->nofpar = nofpar;
	parblksize = size;
	// END
}

void ORP::FormalType0(ORB::Type& typ, int dim)
{
	// VAR
	ORB::Object obj;
	int dmy;

	// BEGIN
	ORP* _this = _inst();
	if( _this->sym == ORS::_inst()->ident )
	{
		_this->qualident(obj);
		if( obj->class_ == ORB::_inst()->Typ )
			typ = obj->type;
		else
		{
			ORS::_inst()->Mark("not a type");
			typ = ORB::_inst()->intType_;
		}
	}else if( _this->sym == ORS::_inst()->array )
	{
		ORS::_inst()->Get(_this->sym);
		_this->Check(ORS::_inst()->of, "OF ?");
		if( dim >= 1 )
			ORS::_inst()->Mark("multi-dimensional open arrays not implemented");
		
		typ = new ORB::TypeDesc();
		typ->form_ = ORB::_inst()->Array;
		typ->len = -1;
		typ->size = 2 * ORG::_inst()->WordSize;
		_this->FormalType(typ->base, dim + 1);
	}else if( _this->sym == ORS::_inst()->procedure )
	{
		ORS::_inst()->Get(_this->sym);
		ORB::_inst()->OpenScope();
		typ = new ORB::TypeDesc();
		typ->form_ = ORB::_inst()->Proc;
		typ->size = ORG::_inst()->WordSize;
		dmy = 0;
		_this->ProcedureType(typ, dmy);
		typ->dsc = ORB::_inst()->topScope->next;
		ORB::_inst()->CloseScope();
	}else
	{
		ORS::_inst()->Mark("identifier expected");
		typ = ORB::_inst()->noType;
	}
	// END
}

void ORP::CheckRecLevel(int lev)
{
	// BEGIN
	ORP* _this = _inst();
	if( lev != 0 )
		ORS::_inst()->Mark("ptr base must be global");
	
	// END
}

void ORP::Type0(ORB::Type& type)
{
	// VAR
	int dmy;
	ORB::Object obj;
	PtrBase ptbase;

	// BEGIN
	ORP* _this = _inst();
	/* sync */
	type = ORB::_inst()->intType_;
	if( (_this->sym != ORS::_inst()->ident) && (_this->sym < ORS::_inst()->array) )
	{
		ORS::_inst()->Mark("not a type");
		do 
		{
			ORS::_inst()->Get(_this->sym);
		} while( !( (_this->sym == ORS::_inst()->ident) || (_this->sym >= ORS::_inst()->array) ) );
	}
	if( _this->sym == ORS::_inst()->ident )
	{
		_this->qualident(obj);
		if( obj->class_ == ORB::_inst()->Typ )
		{
			if( (obj->type != 0) && (obj->type->form_ != ORB::_inst()->NoTyp) )
				type = obj->type;
			
		}else
			ORS::_inst()->Mark("not a type or undefined");

	}else if( _this->sym == ORS::_inst()->array )
	{
		ORS::_inst()->Get(_this->sym);
		_this->ArrayType(type);
	}else if( _this->sym == ORS::_inst()->record )
	{
		ORS::_inst()->Get(_this->sym);
		_this->RecordType(type);
		_this->Check(ORS::_inst()->end, "no END");
	}else if( _this->sym == ORS::_inst()->pointer )
	{
		ORS::_inst()->Get(_this->sym);
		_this->Check(ORS::_inst()->to, "no TO");
		type = new ORB::TypeDesc();
		type->form_ = ORB::_inst()->Pointer;
		type->size = ORG::_inst()->WordSize;
		type->base = ORB::_inst()->intType_;
		if( _this->sym == ORS::_inst()->ident )
		{
			obj = ORB::_inst()->thisObj_();
			if( obj != 0 )
			{
				if( (obj->class_ == ORB::_inst()->Typ) && (( _Set() + (ORB::_inst()->Record) + (ORB::_inst()->NoTyp) ).contains( obj->type->form_ )) )
				{
					_this->CheckRecLevel(obj->lev);
					type->base = obj->type;
				}else if( obj->class_ == ORB::_inst()->Mod )
					ORS::_inst()->Mark("external base type not implemented");
				else
					ORS::_inst()->Mark("no valid base type");

			}else
			{
				/* enter into list of forward references to be fixed in Declarations */
				_this->CheckRecLevel(_this->level);
				ptbase = new ORP::PtrBaseDesc();
				ORS::_inst()->CopyId(ptbase->name);
				ptbase->type = type;
				ptbase->next = _this->pbsList;
				_this->pbsList = ptbase;
			}
			ORS::_inst()->Get(_this->sym);
		}else
		{
			_this->Type(type->base);
			if( (type->base->form_ != ORB::_inst()->Record) || (type->base->typobj == 0) )
				ORS::_inst()->Mark("must point to named record");
			
			_this->CheckRecLevel(_this->level);
		}
	}else if( _this->sym == ORS::_inst()->procedure )
	{
		ORS::_inst()->Get(_this->sym);
		ORB::_inst()->OpenScope();
		type = new ORB::TypeDesc();
		type->form_ = ORB::_inst()->Proc;
		type->size = ORG::_inst()->WordSize;
		dmy = 0;
		_this->ProcedureType(type, dmy);
		type->dsc = ORB::_inst()->topScope->next;
		ORB::_inst()->CloseScope();
	}else
		ORS::_inst()->Mark("illegal type");

	// END
}

void ORP::Declarations(int& varsize)
{
	// VAR
	ORB::Object obj;
	ORB::Object first;
	ORG::Item x;
	ORB::Type tp;
	PtrBase ptbase;
	bool expo;
	ORS::Ident id;

	// BEGIN
	ORP* _this = _inst();
	/* sync */
	_this->pbsList = 0;
	if( (_this->sym < ORS::_inst()->const_) && (_this->sym != ORS::_inst()->end) && (_this->sym != ORS::_inst()->return_) )
	{
		ORS::_inst()->Mark("declaration?");
		do 
		{
			ORS::_inst()->Get(_this->sym);
		} while( !( (_this->sym >= ORS::_inst()->const_) || (_this->sym == ORS::_inst()->end) || (_this->sym == ORS::_inst()->return_) ) );
	}
	if( _this->sym == ORS::_inst()->const_ )
	{
		ORS::_inst()->Get(_this->sym);
		while( _this->sym == ORS::_inst()->ident )
		{
			ORS::_inst()->CopyId(id);
			ORS::_inst()->Get(_this->sym);
			_this->CheckExport(expo);
			if( _this->sym == ORS::_inst()->eql )
				ORS::_inst()->Get(_this->sym);
			else
				ORS::_inst()->Mark("= ?");

			_this->expression(x);
			if( (x.type->form_ == ORB::_inst()->String) && (x.b == 2) )
				ORG::_inst()->StrToChar(x);
			
			ORB::_inst()->NewObj(obj, id, ORB::_inst()->Const);
			obj->expo = expo;
			if( x.mode == ORB::_inst()->Const )
			{
				obj->val = x.a;
				obj->lev = x.b;
				obj->type = x.type;
			}else
			{
				ORS::_inst()->Mark("expression not constant");
				obj->type = ORB::_inst()->intType_;
			}
			_this->Check(ORS::_inst()->semicolon, "; missing");
		}
	}
	if( _this->sym == ORS::_inst()->type )
	{
		ORS::_inst()->Get(_this->sym);
		while( _this->sym == ORS::_inst()->ident )
		{
			ORS::_inst()->CopyId(id);
			ORS::_inst()->Get(_this->sym);
			_this->CheckExport(expo);
			if( _this->sym == ORS::_inst()->eql )
				ORS::_inst()->Get(_this->sym);
			else
				ORS::_inst()->Mark("=?");

			_this->Type(tp);
			ORB::_inst()->NewObj(obj, id, ORB::_inst()->Typ);
			obj->type = tp;
			obj->expo = expo;
			obj->lev = _this->level;
			if( tp->typobj == 0 )
				tp->typobj = obj;
			
			if( expo && (obj->type->form_ == ORB::_inst()->Record) )
			{
				obj->exno = _this->exno;
				_this->exno++;
			}else
				obj->exno = 0;

			if( tp->form_ == ORB::_inst()->Record )
			{
				/* check whether this is base of a pointer type; search and fixup */
				ptbase = _this->pbsList;
				while( ptbase != 0 )
				{
					if( obj->name == ptbase->name )
						ptbase->type->base = obj->type;
					
					ptbase = ptbase->next;
				}
				/* type descriptor; len used as its address */
				if( _this->level == 0 )
					ORG::_inst()->BuildTD(tp, _this->dc);
				
			}
			_this->Check(ORS::_inst()->semicolon, "; missing");
		}
	}
	if( _this->sym == ORS::_inst()->var )
	{
		ORS::_inst()->Get(_this->sym);
		while( _this->sym == ORS::_inst()->ident )
		{
			_this->IdentList(ORB::_inst()->Var, first);
			_this->Type(tp);
			obj = first;
			while( obj != 0 )
			{
				obj->type = tp;
				obj->lev = _this->level;
				/* align */
				if( tp->size > 1 )
					varsize = DIV((varsize + 3),4) * 4;
				
				obj->val = varsize;
				varsize = varsize + obj->type->size;
				if( obj->expo )
				{
					obj->exno = _this->exno;
					_this->exno++;
				}
				obj = obj->next;
			}
			_this->Check(ORS::_inst()->semicolon, "; missing");
		}
	}
	varsize = DIV((varsize + 3),4) * 4;
	ptbase = _this->pbsList;
	while( ptbase != 0 )
	{
		if( ptbase->type->base->form_ == ORB::_inst()->Int )
			ORS::_inst()->Mark("undefined pointer base of");
		
		ptbase = ptbase->next;
	}
	if( (_this->sym >= ORS::_inst()->const_) && (_this->sym <= ORS::_inst()->var) )
		ORS::_inst()->Mark("declaration in bad order");
	
	// END
}

void ORP::ProcedureDecl()
{
	// VAR
	ORB::Object proc;
	ORB::Type type;
	ORS::Ident procid;
	ORG::Item x;
	int locblksize;
	int parblksize;
	int L;
	bool int_;

	// BEGIN
	ORP* _this = _inst();
	/*  ProcedureDecl  */
	int_ = FALSE;
	ORS::_inst()->Get(_this->sym);
	if( _this->sym == ORS::_inst()->times )
	{
		ORS::_inst()->Get(_this->sym);
		int_ = TRUE;
	}
	if( _this->sym == ORS::_inst()->ident )
	{
		ORS::_inst()->CopyId(procid);
		ORS::_inst()->Get(_this->sym);
		ORB::_inst()->NewObj(proc, ORS::_inst()->id, ORB::_inst()->Const);
		if( int_ )
			parblksize = 12;
		else
			parblksize = 4;

		type = new ORB::TypeDesc();
		type->form_ = ORB::_inst()->Proc;
		type->size = ORG::_inst()->WordSize;
		proc->type = type;
		proc->val = -1;
		proc->lev = _this->level;
		_this->CheckExport(proc->expo);
		if( proc->expo )
		{
			proc->exno = _this->exno;
			_this->exno++;
		}
		ORB::_inst()->OpenScope();
		_this->level++;
		type->base = ORB::_inst()->noType;
		/* formal parameter list */
		_this->ProcedureType(type, parblksize);
		_this->Check(ORS::_inst()->semicolon, "no ;");
		locblksize = parblksize;
		_this->Declarations(locblksize);
		proc->val = ORG::_inst()->Here() * 4;
		proc->type->dsc = ORB::_inst()->topScope->next;
		if( _this->sym == ORS::_inst()->procedure )
		{
			L = 0;
			ORG::_inst()->FJump(L);
			do 
			{
				_this->ProcedureDecl();
				_this->Check(ORS::_inst()->semicolon, "no ;");
			} while( !( _this->sym != ORS::_inst()->procedure ) );
			ORG::_inst()->FixOne(L);
			proc->val = ORG::_inst()->Here() * 4;
			proc->type->dsc = ORB::_inst()->topScope->next;
		}
		ORG::_inst()->Enter(parblksize, locblksize, int_);
		if( _this->sym == ORS::_inst()->begin )
		{
			ORS::_inst()->Get(_this->sym);
			_this->StatSequence();
		}
		if( _this->sym == ORS::_inst()->return_ )
		{
			ORS::_inst()->Get(_this->sym);
			_this->expression(x);
			if( type->base == ORB::_inst()->noType )
				ORS::_inst()->Mark("this is not a function");
			else if( !_this->CompTypes(type->base, x.type, FALSE) )
				ORS::_inst()->Mark("wrong result type");
			
		}else if( type->base->form_ != ORB::_inst()->NoTyp )
		{
			ORS::_inst()->Mark("function without result");
			type->base = ORB::_inst()->noType;
		}
		ORG::_inst()->Return(type->base->form_, x, locblksize, int_);
		ORB::_inst()->CloseScope();
		_this->level--;
		_this->Check(ORS::_inst()->end, "no END");
		if( _this->sym == ORS::_inst()->ident )
		{
			if( ORS::_inst()->id != procid )
				ORS::_inst()->Mark("no match");
			
			ORS::_inst()->Get(_this->sym);
		}else
			ORS::_inst()->Mark("no proc id");

	}
	// END
}

void ORP::Module()
{
	// VAR
	int key;
	ORS::Ident impid;
	ORS::Ident impid1;

	// BEGIN
	ORP* _this = _inst();
	Texts::_inst()->WriteString(_this->W, "  compiling ");
	ORS::_inst()->Get(_this->sym);
	if( _this->sym == ORS::_inst()->module )
	{
		ORS::_inst()->Get(_this->sym);
		if( _this->sym == ORS::_inst()->times )
		{
			_this->version = 0;
			Texts::_inst()->Write(_this->W, '*');
			ORS::_inst()->Get(_this->sym);
		}else
			_this->version = 1;

		ORB::_inst()->Init();
		ORB::_inst()->OpenScope();
		if( _this->sym == ORS::_inst()->ident )
		{
			ORS::_inst()->CopyId(_this->modid);
			ORS::_inst()->Get(_this->sym);
			Texts::_inst()->WriteString(_this->W, _this->modid);
			Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
		}else
			ORS::_inst()->Mark("identifier expected");

		_this->Check(ORS::_inst()->semicolon, "no ;");
		_this->level = 0;
		_this->dc = 0;
		_this->exno = 1;
		key = 0;
		if( _this->sym == ORS::_inst()->import )
		{
			ORS::_inst()->Get(_this->sym);
			while( _this->sym == ORS::_inst()->ident )
			{
				ORS::_inst()->CopyId(impid);
				ORS::_inst()->Get(_this->sym);
				if( _this->sym == ORS::_inst()->becomes )
				{
					ORS::_inst()->Get(_this->sym);
					if( _this->sym == ORS::_inst()->ident )
					{
						ORS::_inst()->CopyId(impid1);
						ORS::_inst()->Get(_this->sym);
					}else
						ORS::_inst()->Mark("id expected");

				}else
					impid1 = impid;

				ORB::_inst()->Import(impid, impid1);
				if( _this->sym == ORS::_inst()->comma )
					ORS::_inst()->Get(_this->sym);
				else if( _this->sym == ORS::_inst()->ident )
					ORS::_inst()->Mark("comma missing");
				
			}
			_this->Check(ORS::_inst()->semicolon, "no ;");
		}
		ORG::_inst()->Open(_this->version);
		_this->Declarations(_this->dc);
		ORG::_inst()->SetDataSize(DIV((_this->dc + 3),4) * 4);
		while( _this->sym == ORS::_inst()->procedure )
		{
			_this->ProcedureDecl();
			_this->Check(ORS::_inst()->semicolon, "no ;");
		}
		ORG::_inst()->Header();
		if( _this->sym == ORS::_inst()->begin )
		{
			ORS::_inst()->Get(_this->sym);
			_this->StatSequence();
		}
		_this->Check(ORS::_inst()->end, "no END");
		if( _this->sym == ORS::_inst()->ident )
		{
			if( ORS::_inst()->id != _this->modid )
				ORS::_inst()->Mark("no match");
			
			ORS::_inst()->Get(_this->sym);
		}else
			ORS::_inst()->Mark("identifier missing");

		if( _this->sym != ORS::_inst()->period )
			ORS::_inst()->Mark("period missing");
		
		if( (ORS::_inst()->errcnt == 0) && (_this->version != 0) )
		{
			ORB::_inst()->Export(_this->modid, _this->newSF_, key);
			if( _this->newSF_ )
				Texts::_inst()->WriteString(_this->W, " new symbol file");
			
		}
		if( ORS::_inst()->errcnt == 0 )
		{
			ORG::_inst()->Close(_this->modid, key, _this->exno);
			Texts::_inst()->WriteInt(_this->W, ORG::_inst()->pc, 6);
			Texts::_inst()->WriteInt(_this->W, _this->dc, 6);
			Texts::_inst()->WriteHex(_this->W, key);
		}else
		{
			Texts::_inst()->WriteLn(_this->W);
			Texts::_inst()->WriteString(_this->W, "compilation FAILED");
		}
		Texts::_inst()->WriteLn(_this->W);
		Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
		ORB::_inst()->CloseScope();
		_this->pbsList = 0;
	}else
		ORS::_inst()->Mark("must start with MODULE");

	// END
}

void ORP::Option(Texts::Scanner& S)
{
	// BEGIN
	ORP* _this = _inst();
	_this->newSF_ = FALSE;
	if( S.nextCh == '/' )
	{
		Texts::_inst()->Scan(S);
		Texts::_inst()->Scan(S);
		if( (S.class_ == Texts::_inst()->Name) && (S.s[0] == 's') )
			_this->newSF_ = TRUE;
		
	}
	// END
}

/*  modified by Rochus  */
void ORP::Compile(_ValArray<char> file)
{
	// VAR
	Texts::Text T;

	// BEGIN
	ORP* _this = _inst();
	T = new Texts::TextDesc();
	Texts::_inst()->Open(T, file);
	ORS::_inst()->Init(T, 0);
	_this->Module();
	// END
}

ORP::ORP()
{
	// BEGIN
	/*  Original
  PROCEDURE Compile*;
    VAR beg, end, time: INTEGER;
      T: Texts.Text;
      S: Texts.Scanner;
  BEGIN Texts.OpenScanner(S, Oberon.Par.text, Oberon.Par.pos); Texts.Scan(S);
    IF S.class = Texts.Char THEN
      IF S.c = "@" THEN
        Option(S); Oberon.GetSelection(T, beg, end, time);
        IF time >= 0 THEN ORS.Init(T, beg); Module END
      ELSIF S.c = "^" THEN
        Option(S); Oberon.GetSelection(T, beg, end, time);
        IF time >= 0 THEN
          Texts.OpenScanner(S, T, beg); Texts.Scan(S);
          IF S.class = Texts.Name THEN
            Texts.WriteString(W, S.s); NEW(T); Texts.Open(T, S.s);
            IF T.len > 0 THEN ORS.Init(T, 0); Module END
          END
        END
      END
    ELSE 
      WHILE S.class = Texts.Name DO
        NEW(T); Texts.Open(T, S.s);
        IF T.len > 0 THEN Option(S); ORS.Init(T, 0); Module
        ELSE Texts.WriteString(W, S.s); Texts.WriteString(W, " not found");
          Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf)
        END ;
        IF (T.len # 0) & (ORS.errcnt = 0) THEN Texts.Scan(S) ELSE S.class := 0 END
      END
    END ;
    Oberon.Collect(0)
  END Compile;
   */
	Texts::_inst()->OpenWriter(W);
	Texts::_inst()->WriteString(W, "OR Compiler  17.9.2018");
	Texts::_inst()->WriteLn(W);
	Texts::_inst()->Append(Oberon::_inst()->Log, W.buf);
	dummy = new ORB::ObjDesc();
	dummy->class_ = ORB::_inst()->Var;
	dummy->type = ORB::_inst()->intType_;
	expression = expression0;
	Type = Type0;
	FormalType = FormalType0;
	// END
}

ORP::~ORP()
{
	s_inst.release();
}

