#ifndef __ObORP_H__
#define __ObORP_H__

// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17

#include <OberonSystem/Ob_Global.h>
#include <OberonSystem/ObTexts.h>
#include <OberonSystem/ObOberon.h>
#include <OberonSystem/ObORS.h>
#include <OberonSystem/ObORB.h>
#include <OberonSystem/ObORG.h>

namespace Ob
{
	class ORP : public _Root
	{
	public:
		/* N. Wirth 1.7.97 / 17.9.2018  Oberon compiler for RISC in Oberon-07 */
		static ORP* _inst();
		ORP();
		~ORP();

		// TYPE
		struct PtrBaseDesc;

		/* Author: Niklaus Wirth, 2014.
    Parser of Oberon-RISC compiler. Uses Scanner ORS to obtain symbols (tokens),
    ORB for definition of data structures and for handling import and export, and
    ORG to produce binary code. ORP performs type checking and data allocation.
    Parser is target-independent, except for part of the handling of allocations. */
		typedef PtrBaseDesc* PtrBase;
		/* list of names of pointer base types */
		struct PtrBaseDesc : public _Root {
			ORS::Ident name;
			PtrBase next;
			ORB::Type type;
		};

		// VAR
		/* last symbol read */
		int sym;
		/* data counter */
		int dc;
		int level;
		int exno;
		int version;
		/* option flag */
		bool newSF_;
		/* to avoid forward reference */
		void (*expression)(ORG::Item&);
		void (*Type)(ORB::Type&);
		void (*FormalType)(ORB::Type&,int);
		ORS::Ident modid;
		/* list of names of pointer base types */
		PtrBase pbsList;
		ORB::Object dummy;
		Texts::Writer W;

		// PROC
		static void Check(int s, _ValArray<char> msg);
		static void qualident(ORB::Object& obj);
		static void CheckBool(ORG::Item& x);
		static void CheckInt(ORG::Item& x);
		static void CheckReal(ORG::Item& x);
		static void CheckSet(ORG::Item& x);
		static void CheckSetVal(ORG::Item& x);
		static void CheckConst(ORG::Item& x);
		static void CheckReadOnly(ORG::Item& x);
		static void CheckExport(bool& expo);
		bool IsExtension(ORB::Type t0, ORB::Type t1);
		static void TypeTest(ORG::Item& x, ORB::Type T, bool guard);
		static void selector(ORG::Item& x);
		bool EqualSignatures(ORB::Type t0, ORB::Type t1);
		bool CompTypes(ORB::Type t0, ORB::Type t1, bool varpar);
		static void Parameter(ORB::Object par);
		static void ParamList(ORG::Item& x);
		static void StandFunc(ORG::Item& x, int fct, ORB::Type restyp);
		static void element(ORG::Item& x);
		static void set(ORG::Item& x);
		static void factor(ORG::Item& x);
		static void term(ORG::Item& x);
		static void SimpleExpression(ORG::Item& x);
		static void expression0(ORG::Item& x);
		static void StandProc(int pno);
		static void TypeCase(ORB::Object obj, ORG::Item& x);
		static void SkipCase();
		static void StatSequence();
		static void IdentList(int class_, ORB::Object& first);
		static void ArrayType(ORB::Type& type);
		static void RecordType(ORB::Type& type);
		static void FPSection(int& adr, int& nofpar);
		static void ProcedureType(ORB::Type ptype, int& parblksize);
		static void FormalType0(ORB::Type& typ, int dim);
		static void CheckRecLevel(int lev);
		static void Type0(ORB::Type& type);
		static void Declarations(int& varsize);
		static void ProcedureDecl();
		static void Module();
		static void Option(Texts::Scanner& S);
		static void Compile(_ValArray<char> file);

	};
}

#endif // __ObORP_H__