// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObORS.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<ORS> s_inst;

const int ORS::IdLen;
const int ORS::NKW;
const int ORS::maxExp;
const int ORS::stringBufSize;
const int ORS::null;
const int ORS::times;
const int ORS::rdiv;
const int ORS::div;
const int ORS::mod;
const int ORS::and_;
const int ORS::plus;
const int ORS::minus;
const int ORS::or_;
const int ORS::eql;
const int ORS::neq;
const int ORS::lss;
const int ORS::leq;
const int ORS::gtr;
const int ORS::geq;
const int ORS::in;
const int ORS::is;
const int ORS::arrow;
const int ORS::period;
const int ORS::char_;
const int ORS::int_;
const int ORS::real;
const int ORS::false_;
const int ORS::true_;
const int ORS::nil;
const int ORS::string;
const int ORS::not_;
const int ORS::lparen;
const int ORS::lbrak;
const int ORS::lbrace;
const int ORS::ident;
const int ORS::if_;
const int ORS::while_;
const int ORS::repeat;
const int ORS::case_;
const int ORS::for_;
const int ORS::comma;
const int ORS::colon;
const int ORS::becomes;
const int ORS::upto;
const int ORS::rparen;
const int ORS::rbrak;
const int ORS::rbrace;
const int ORS::then;
const int ORS::of;
const int ORS::do_;
const int ORS::to;
const int ORS::by;
const int ORS::semicolon;
const int ORS::end;
const int ORS::bar;
const int ORS::else_;
const int ORS::elsif;
const int ORS::until;
const int ORS::return_;
const int ORS::array;
const int ORS::record;
const int ORS::pointer;
const int ORS::const_;
const int ORS::type;
const int ORS::var;
const int ORS::procedure;
const int ORS::begin;
const int ORS::import;
const int ORS::module;
const int ORS::eot;

ORS* ORS::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new ORS() );
	return s_inst.get();
}

void ORS::CopyId(_VarArray<char> ident)
{
	// BEGIN
	ORS* _this = _inst();
	ident = _this->id;
	// END
}

int ORS::Pos()
{
	// BEGIN
	ORS* _this = _inst();
	return Texts::_inst()->Pos(_this->R) - 1;
	// END
}

void ORS::Mark(_ValArray<char> msg)
{
	// VAR
	int p;

	// BEGIN
	ORS* _this = _inst();
	p = _this->Pos();
	if( (p > _this->errpos) && (_this->errcnt < 25) )
	{
		Texts::_inst()->WriteLn(_this->W);
		Texts::_inst()->WriteString(_this->W, "  pos ");
		Texts::_inst()->WriteInt(_this->W, p, 1);
		Texts::_inst()->Write(_this->W, ' ');
		Texts::_inst()->WriteString(_this->W, msg);
		Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
	}
	_this->errcnt++;
	_this->errpos = p + 4;
	// END
}

void ORS::Identifier(int& sym)
{
	// VAR
	int i;
	int k;

	// BEGIN
	ORS* _this = _inst();
	i = 0;
	do 
	{
		if( i < _this->IdLen - 1 )
		{
			_this->id[i] = _this->ch;
			i++;
		}
		Texts::_inst()->Read(_this->R, _this->ch);
	} while( !( (_this->ch < '0') || (_this->ch > '9') && (_this->ch < 'A') || (_this->ch > 'Z') && (_this->ch < 'a') || (_this->ch > 'z') ) );
	_this->id[i] = 0x0;
	/* search for keyword */
	if( i < 10 )
	{
		k = _this->KWX[i - 1];
		while( (_this->id != _this->keyTab[k].id) && (k < _this->KWX[i]) )
			k++;
		
		if( k < _this->KWX[i] )
			sym = _this->keyTab[k].sym;
		else
			sym = _this->ident;

	}else
		sym = _this->ident;

	// END
}

void ORS::String()
{
	// VAR
	int i;

	// BEGIN
	ORS* _this = _inst();
	i = 0;
	Texts::_inst()->Read(_this->R, _this->ch);
	while( !_this->R.eot && (_this->ch != 0x22) )
	{
		if( _this->ch >= ' ' )
		{
			if( i < _this->stringBufSize - 1 )
			{
				_this->str[i] = _this->ch;
				i++;
			}else
				_this->Mark("string too long");

		}
		Texts::_inst()->Read(_this->R, _this->ch);
	}
	_this->str[i] = 0x0;
	i++;
	Texts::_inst()->Read(_this->R, _this->ch);
	_this->slen = i;
	// END
}

void ORS::HexString()
{
	// VAR
	int i;
	int m;
	int n;

	// BEGIN
	ORS* _this = _inst();
	i = 0;
	Texts::_inst()->Read(_this->R, _this->ch);
	while( !_this->R.eot && (_this->ch != '$') )
	{
		/* skip */
		while( !_this->R.eot && (_this->ch <= ' ') )
			Texts::_inst()->Read(_this->R, _this->ch);
		
		if( ('0' <= _this->ch) && (_this->ch <= '9') )
			m = int( _this->ch ) - 0x30;
		else if( ('A' <= _this->ch) && (_this->ch <= 'F') )
			m = int( _this->ch ) - 0x37;
		else
		{
			m = 0;
			_this->Mark("hexdig expected");
		}
		Texts::_inst()->Read(_this->R, _this->ch);
		if( ('0' <= _this->ch) && (_this->ch <= '9') )
			n = int( _this->ch ) - 0x30;
		else if( ('A' <= _this->ch) && (_this->ch <= 'F') )
			n = int( _this->ch ) - 0x37;
		else
		{
			n = 0;
			_this->Mark("hexdig expected");
		}
		if( i < _this->stringBufSize )
		{
			_this->str[i] = char( m * 0x10 + n );
			i++;
		}else
			_this->Mark("string too long");

		Texts::_inst()->Read(_this->R, _this->ch);
	}
	/* no 0X appended! */
	Texts::_inst()->Read(_this->R, _this->ch);
	_this->slen = i;
	// END
}

float ORS::Ten(int e)
{
	// VAR
	float x;
	float t;

	// BEGIN
	ORS* _this = _inst();
	x = 1.0;
	t = 10.0;
	while( e > 0 )
	{
		if( e % 2 == 1 )
			x = t * x;
		
		t = t * t;
		e = DIV(e,2);
	}
	return x;
	// END
}

void ORS::Number(int& sym)
{
	// CONST
	/* 2^31 - 1 */
	static const int max = 2147483647;

	// VAR
	int i;
	int k;
	int e;
	int n;
	int s;
	int h;
	float x;
	_FxArray<int,16> d;
	bool negE;

	// BEGIN
	ORS* _this = _inst();
	_this->ival = 0;
	i = 0;
	n = 0;
	k = 0;
	do 
	{
		if( n < 16 )
		{
			d[n] = int( _this->ch ) - 0x30;
			n++;
		}else
		{
			_this->Mark("too many digits");
			n = 0;
		}
		Texts::_inst()->Read(_this->R, _this->ch);
	} while( !( (_this->ch < '0') || (_this->ch > '9') && (_this->ch < 'A') || (_this->ch > 'F') ) );
	/* hex */
	if( (_this->ch == 'H') || (_this->ch == 'R') || (_this->ch == 'X') )
	{
		do 
		{
			h = d[i];
			if( h >= 10 )
				h = h - 7;
			
			/* no overflow check */
			k = k * 0x10 + h;
			i++;
		} while( !( i == n ) );
		if( _this->ch == 'X' )
		{
			sym = _this->char_;
			if( k < 0x100 )
				_this->ival = k;
			else
			{
				_this->Mark("illegal value");
				_this->ival = 0;
			}
		}else if( _this->ch == 'R' )
		{
			sym = _this->real;
			_this->rval = SYSTEM::_inst()->VAL(REAL, k);
		}else
		{
			sym = _this->int_;
			_this->ival = k;
		}
		Texts::_inst()->Read(_this->R, _this->ch);
	}else if( _this->ch == '.' )
	{
		Texts::_inst()->Read(_this->R, _this->ch);
		/* double dot */
		/* decimal integer */
		if( _this->ch == '.' )
		{
			_this->ch = 0x7F;
			do 
			{
				if( d[i] < 10 )
				{
					if( k <= DIV((max - d[i]),10) )
						k = k * 10 + d[i];
					else
					{
						_this->Mark("too large");
						k = 0;
					}
				}else
					_this->Mark("bad integer");

				i++;
			} while( !( i == n ) );
			sym = _this->int_;
			_this->ival = k;
		}else
		{
			/* real number */
			x = 0.0;
			e = 0;
			/* integer part */
			do 
			{
				x = x * 10.0 + FLT(d[i]);
				i++;
			} while( !( i == n ) );
			/* fraction */
			while( (_this->ch >= '0') && (_this->ch <= '9') )
			{
				x = x * 10.0 + FLT(int( _this->ch ) - 0x30);
				e--;
				Texts::_inst()->Read(_this->R, _this->ch);
			}
			/* scale factor */
			if( (_this->ch == 'E') || (_this->ch == 'D') )
			{
				Texts::_inst()->Read(_this->R, _this->ch);
				s = 0;
				if( _this->ch == '-' )
				{
					negE = TRUE;
					Texts::_inst()->Read(_this->R, _this->ch);
				}else
				{
					negE = FALSE;
					if( _this->ch == '+' )
						Texts::_inst()->Read(_this->R, _this->ch);
					
				}
				if( (_this->ch >= '0') && (_this->ch <= '9') )
				{
					do 
					{
						s = s * 10 + int( _this->ch ) - 0x30;
						Texts::_inst()->Read(_this->R, _this->ch);
					} while( !( (_this->ch < '0') || (_this->ch > '9') ) );
					if( negE )
						e = e - s;
					else
						e = e + s;

				}else
					_this->Mark("digit?");

			}
			if( e < 0 )
			{
				if( e >= -_this->maxExp )
					x = x / _this->Ten(-e);
				else
					x = 0.0;

			}else if( e > 0 )
			{
				if( e <= _this->maxExp )
					x = _this->Ten(e) * x;
				else
				{
					x = 0.0;
					_this->Mark("too large");
				}
			}
			sym = _this->real;
			_this->rval = x;
		}
	}else
	{
		/* decimal integer */
		do 
		{
			if( d[i] < 10 )
			{
				if( k <= DIV((max - d[i]),10) )
					k = k * 10 + d[i];
				else
				{
					_this->Mark("too large");
					k = 0;
				}
			}else
				_this->Mark("bad integer");

			i++;
		} while( !( i == n ) );
		sym = _this->int_;
		_this->ival = k;
	}
	// END
}

void ORS::comment()
{
	// BEGIN
	ORS* _this = _inst();
	Texts::_inst()->Read(_this->R, _this->ch);
	do 
	{
		while( !_this->R.eot && (_this->ch != '*') )
			if( _this->ch == '(' )
			{
				Texts::_inst()->Read(_this->R, _this->ch);
				if( _this->ch == '*' )
					_this->comment();
				
			}else
				Texts::_inst()->Read(_this->R, _this->ch);

		
		while( _this->ch == '*' )
			Texts::_inst()->Read(_this->R, _this->ch);
		
	} while( !( (_this->ch == ')') || _this->R.eot ) );
	if( !_this->R.eot )
		Texts::_inst()->Read(_this->R, _this->ch);
	else
		_this->Mark("unterminated comment");

	// END
}

void ORS::Get(int& sym)
{
	// BEGIN
	ORS* _this = _inst();
	do 
	{
		while( !_this->R.eot && (_this->ch <= ' ') )
			Texts::_inst()->Read(_this->R, _this->ch);
		
		if( _this->R.eot )
			sym = _this->eot;
		else if( _this->ch < 'A' )
		{
			if( _this->ch < '0' )
			{
				if( _this->ch == 0x22 )
				{
					_this->String();
					sym = _this->string;
				}else if( _this->ch == '#' )
				{
					Texts::_inst()->Read(_this->R, _this->ch);
					sym = _this->neq;
				}else if( _this->ch == '$' )
				{
					_this->HexString();
					sym = _this->string;
				}else if( _this->ch == '&' )
				{
					Texts::_inst()->Read(_this->R, _this->ch);
					sym = _this->and_;
				}else if( _this->ch == '(' )
				{
					Texts::_inst()->Read(_this->R, _this->ch);
					if( _this->ch == '*' )
					{
						sym = _this->null;
						_this->comment();
					}else
						sym = _this->lparen;

				}else if( _this->ch == ')' )
				{
					Texts::_inst()->Read(_this->R, _this->ch);
					sym = _this->rparen;
				}else if( _this->ch == '*' )
				{
					Texts::_inst()->Read(_this->R, _this->ch);
					sym = _this->times;
				}else if( _this->ch == '+' )
				{
					Texts::_inst()->Read(_this->R, _this->ch);
					sym = _this->plus;
				}else if( _this->ch == ',' )
				{
					Texts::_inst()->Read(_this->R, _this->ch);
					sym = _this->comma;
				}else if( _this->ch == '-' )
				{
					Texts::_inst()->Read(_this->R, _this->ch);
					sym = _this->minus;
				}else if( _this->ch == '.' )
				{
					Texts::_inst()->Read(_this->R, _this->ch);
					if( _this->ch == '.' )
					{
						Texts::_inst()->Read(_this->R, _this->ch);
						sym = _this->upto;
					}else
						sym = _this->period;

				}else if( _this->ch == '/' )
				{
					Texts::_inst()->Read(_this->R, _this->ch);
					sym = _this->rdiv;
				}else
				{
					/*  ! % '  */
					Texts::_inst()->Read(_this->R, _this->ch);
					sym = _this->null;
				}
			}else if( _this->ch < ':' )
				_this->Number(sym);
			else if( _this->ch == ':' )
			{
				Texts::_inst()->Read(_this->R, _this->ch);
				if( _this->ch == '=' )
				{
					Texts::_inst()->Read(_this->R, _this->ch);
					sym = _this->becomes;
				}else
					sym = _this->colon;

			}else if( _this->ch == ';' )
			{
				Texts::_inst()->Read(_this->R, _this->ch);
				sym = _this->semicolon;
			}else if( _this->ch == '<' )
			{
				Texts::_inst()->Read(_this->R, _this->ch);
				if( _this->ch == '=' )
				{
					Texts::_inst()->Read(_this->R, _this->ch);
					sym = _this->leq;
				}else
					sym = _this->lss;

			}else if( _this->ch == '=' )
			{
				Texts::_inst()->Read(_this->R, _this->ch);
				sym = _this->eql;
			}else if( _this->ch == '>' )
			{
				Texts::_inst()->Read(_this->R, _this->ch);
				if( _this->ch == '=' )
				{
					Texts::_inst()->Read(_this->R, _this->ch);
					sym = _this->geq;
				}else
					sym = _this->gtr;

			}else
			{
				/*  ? @  */
				Texts::_inst()->Read(_this->R, _this->ch);
				sym = _this->null;
			}
		}else if( _this->ch < '[' )
			_this->Identifier(sym);
		else if( _this->ch < 'a' )
		{
			if( _this->ch == '[' )
				sym = _this->lbrak;
			else if( _this->ch == ']' )
				sym = _this->rbrak;
			else if( _this->ch == '^' )
				sym = _this->arrow;
			else
				/*  _ `  */
				sym = _this->null;

			Texts::_inst()->Read(_this->R, _this->ch);
		}else if( _this->ch < '{' )
			_this->Identifier(sym);
		else
		{
			if( _this->ch == '{' )
				sym = _this->lbrace;
			else if( _this->ch == '}' )
				sym = _this->rbrace;
			else if( _this->ch == '|' )
				sym = _this->bar;
			else if( _this->ch == '~' )
				sym = _this->not_;
			else if( _this->ch == 0x7F )
				sym = _this->upto;
			else
				sym = _this->null;

			Texts::_inst()->Read(_this->R, _this->ch);
		}
	} while( !( sym != _this->null ) );
	// END
}

void ORS::Init(Texts::Text T, int pos)
{
	// BEGIN
	ORS* _this = _inst();
	_this->errpos = pos;
	_this->errcnt = 0;
	Texts::_inst()->OpenReader(_this->R, T, pos);
	Texts::_inst()->Read(_this->R, _this->ch);
	// END
}

void ORS::EnterKW(int sym, _ValArray<char> name)
{
	// BEGIN
	ORS* _this = _inst();
	_this->keyTab[_this->k].id = name;
	_this->keyTab[_this->k].sym = sym;
	_this->k++;
	// END
}

ORS::ORS()
{
	// BEGIN
	Texts::_inst()->OpenWriter(W);
	k = 0;
	KWX[0] = 0;
	KWX[1] = 0;
	EnterKW(if_, "IF");
	EnterKW(do_, "DO");
	EnterKW(of, "OF");
	EnterKW(or_, "OR");
	EnterKW(to, "TO");
	EnterKW(in, "IN");
	EnterKW(is, "IS");
	EnterKW(by, "BY");
	KWX[2] = k;
	EnterKW(end, "END");
	EnterKW(nil, "NIL");
	EnterKW(var, "VAR");
	EnterKW(div, "DIV");
	EnterKW(mod, "MOD");
	EnterKW(for_, "FOR");
	KWX[3] = k;
	EnterKW(else_, "ELSE");
	EnterKW(then, "THEN");
	EnterKW(true_, "TRUE");
	EnterKW(type, "TYPE");
	EnterKW(case_, "CASE");
	KWX[4] = k;
	EnterKW(elsif, "ELSIF");
	EnterKW(false_, "FALSE");
	EnterKW(array, "ARRAY");
	EnterKW(begin, "BEGIN");
	EnterKW(const_, "CONST");
	EnterKW(until, "UNTIL");
	EnterKW(while_, "WHILE");
	KWX[5] = k;
	EnterKW(record, "RECORD");
	EnterKW(repeat, "REPEAT");
	EnterKW(return_, "RETURN");
	EnterKW(import, "IMPORT");
	EnterKW(module, "MODULE");
	KWX[6] = k;
	EnterKW(pointer, "POINTER");
	KWX[7] = k;
	KWX[8] = k;
	EnterKW(procedure, "PROCEDURE");
	KWX[9] = k;
	// END
}

ORS::~ORS()
{
	s_inst.release();
}

