#ifndef __ObORS_H__
#define __ObORS_H__

// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17

#include <OberonSystem/Ob_Global.h>
#include <OberonSystem/ObSYSTEM.h>
#include <OberonSystem/ObTexts.h>
#include <OberonSystem/ObOberon.h>

namespace Ob
{
	class ORS : public _Root
	{
	public:
		/*  NW 19.9.93 / 15.3.2017  Scanner in Oberon-07 */
		static ORS* _inst();
		ORS();
		~ORS();

		// CONST
		/*  Oberon Scanner does lexical analysis. Input is Oberon-Text, output is
  sequence of symbols, i.e identifiers, numbers, strings, and special symbols.
  Recognises all Oberon keywords and skips comments. The keywords are
  recorded in a table.
  Get(sym) delivers next symbol from input text with Reader R.
  Mark(msg) records error and delivers error message with Writer W.
  If Get delivers ident, then the identifier (a string) is in variable id, if int or char
  in ival, if real in rval, and if string in str (and slen)  */
		static const int IdLen = 32;
		/* nof keywords */
		static const int NKW = 34;
		static const int maxExp = 38;
		static const int stringBufSize = 256;
		/* lexical symbols */
		static const int null = 0;
		static const int times = 1;
		static const int rdiv = 2;
		static const int div = 3;
		static const int mod = 4;
		static const int and_ = 5;
		static const int plus = 6;
		static const int minus = 7;
		static const int or_ = 8;
		static const int eql = 9;
		static const int neq = 10;
		static const int lss = 11;
		static const int leq = 12;
		static const int gtr = 13;
		static const int geq = 14;
		static const int in = 15;
		static const int is = 16;
		static const int arrow = 17;
		static const int period = 18;
		static const int char_ = 20;
		static const int int_ = 21;
		static const int real = 22;
		static const int false_ = 23;
		static const int true_ = 24;
		static const int nil = 25;
		static const int string = 26;
		static const int not_ = 27;
		static const int lparen = 28;
		static const int lbrak = 29;
		static const int lbrace = 30;
		static const int ident = 31;
		static const int if_ = 32;
		static const int while_ = 34;
		static const int repeat = 35;
		static const int case_ = 36;
		static const int for_ = 37;
		static const int comma = 40;
		static const int colon = 41;
		static const int becomes = 42;
		static const int upto = 43;
		static const int rparen = 44;
		static const int rbrak = 45;
		static const int rbrace = 46;
		static const int then = 47;
		static const int of = 48;
		static const int do_ = 49;
		static const int to = 50;
		static const int by = 51;
		static const int semicolon = 52;
		static const int end = 53;
		static const int bar = 54;
		static const int else_ = 55;
		static const int elsif = 56;
		static const int until = 57;
		static const int return_ = 58;
		static const int array = 60;
		static const int record = 61;
		static const int pointer = 62;
		static const int const_ = 63;
		static const int type = 64;
		static const int var = 65;
		static const int procedure = 66;
		static const int begin = 67;
		static const int import = 68;
		static const int module = 69;
		static const int eot = 70;

		// TYPE
		typedef _FxArray<char,IdLen> Ident;

		// VAR
		/* results of Get */
		int ival;
		int slen;
		float rval;
		/* for identifiers */
		Ident id;
		_FxArray<char,stringBufSize> str;
		int errcnt;
		/* last character read */
		char ch;
		int errpos;
		Texts::Reader R;
		Texts::Writer W;
		int k;
		_FxArray<int,10> KWX;
		_FxArray<_Type1,NKW> keyTab;

		// PROC
		static void CopyId(_VarArray<char> ident);
		int Pos();
		static void Mark(_ValArray<char> msg);
		static void Identifier(int& sym);
		static void String();
		static void HexString();
		float Ten(int e);
		static void Number(int& sym);
		static void comment();
		static void Get(int& sym);
		static void Init(Texts::Text T, int pos);
		static void EnterKW(int sym, _ValArray<char> name);

	};
}

#endif // __ObORS_H__