// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObORTool.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<ORTool> s_inst;


ORTool* ORTool::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new ORTool() );
	return s_inst.get();
}

void ORTool::Read(Files::Rider& R, int& n)
{
	// VAR
	uint8_t b;

	// BEGIN
	ORTool* _this = _inst();
	Files::_inst()->ReadByte(R, b);
	if( b < 0x80 )
		n = b;
	else
		n = b - 0x100;

	// END
}

void ORTool::ReadType(Files::Rider& R)
{
	// VAR
	int key;
	int len;
	int lev;
	int size;
	int off;
	int ref;
	int mno;
	int class_;
	int form_;
	int readonly;
	_FxArray<char,32> name;
	_FxArray<char,32> modname;

	// BEGIN
	ORTool* _this = _inst();
	_this->Read(R, ref);
	Texts::_inst()->Write(_this->W, ' ');
	Texts::_inst()->Write(_this->W, '[');
	if( ref < 0 )
	{
		Texts::_inst()->Write(_this->W, '^');
		Texts::_inst()->WriteInt(_this->W, -ref, 1);
	}else
	{
		Texts::_inst()->WriteInt(_this->W, ref, 1);
		_this->Read(R, form_);
		Texts::_inst()->WriteString(_this->W, "  form = ");
		Texts::_inst()->WriteInt(_this->W, form_, 1);
		if( form_ == ORB::_inst()->Pointer )
			_this->ReadType(R);
		else if( form_ == ORB::_inst()->Array )
		{
			_this->ReadType(R);
			Files::_inst()->ReadNum(R, len);
			Files::_inst()->ReadNum(R, size);
			Texts::_inst()->WriteString(_this->W, "  len = ");
			Texts::_inst()->WriteInt(_this->W, len, 1);
			Texts::_inst()->WriteString(_this->W, "  size = ");
			Texts::_inst()->WriteInt(_this->W, size, 1);
		}else if( form_ == ORB::_inst()->Record )
		{
			/* base type */
			_this->ReadType(R);
			Files::_inst()->ReadNum(R, off);
			Texts::_inst()->WriteString(_this->W, "  exno = ");
			Texts::_inst()->WriteInt(_this->W, off, 1);
			Files::_inst()->ReadNum(R, off);
			Texts::_inst()->WriteString(_this->W, "  extlev = ");
			Texts::_inst()->WriteInt(_this->W, off, 1);
			Files::_inst()->ReadNum(R, size);
			Texts::_inst()->WriteString(_this->W, "  size = ");
			Texts::_inst()->WriteInt(_this->W, size, 1);
			Texts::_inst()->Write(_this->W, ' ');
			Texts::_inst()->Write(_this->W, '{');
			_this->Read(R, class_);
			/* fields */
			while( class_ != 0 )
			{
				Files::_inst()->ReadString(R, name);
				if( name[0] != 0x0 )
				{
					Texts::_inst()->Write(_this->W, ' ');
					Texts::_inst()->WriteString(_this->W, name);
					_this->ReadType(R);
				}else
					Texts::_inst()->WriteString(_this->W, " --");

				Files::_inst()->ReadNum(R, off);
				Texts::_inst()->WriteInt(_this->W, off, 4);
				_this->Read(R, class_);
			}
			Texts::_inst()->Write(_this->W, '}');
		}else if( form_ == ORB::_inst()->Proc )
		{
			_this->ReadType(R);
			Texts::_inst()->Write(_this->W, '(');
			_this->Read(R, class_);
			while( class_ != 0 )
			{
				Texts::_inst()->WriteString(_this->W, " class = ");
				Texts::_inst()->WriteInt(_this->W, class_, 1);
				_this->Read(R, readonly);
				if( readonly == 1 )
					Texts::_inst()->Write(_this->W, '#');
				
				_this->ReadType(R);
				_this->Read(R, class_);
			}
			Texts::_inst()->Write(_this->W, ')');
		}
		Files::_inst()->ReadString(R, modname);
		if( modname[0] != 0x0 )
		{
			Files::_inst()->ReadInt(R, key);
			Files::_inst()->ReadString(R, name);
			Texts::_inst()->Write(_this->W, ' ');
			Texts::_inst()->WriteString(_this->W, modname);
			Texts::_inst()->Write(_this->W, '.');
			Texts::_inst()->WriteString(_this->W, name);
			Texts::_inst()->WriteHex(_this->W, key);
		}
	}
	_this->Form = form_;
	Texts::_inst()->Write(_this->W, ']');
	// END
}

/* decode symbol file */
void ORTool::DecSym()
{
	// VAR
	int class_;
	int typno;
	int k;
	_FxArray<char,32> name;
	Files::File F;
	Files::Rider R;
	Texts::Scanner S;

	// BEGIN
	ORTool* _this = _inst();
	Texts::_inst()->OpenScanner(S, Oberon::_inst()->Par.text, Oberon::_inst()->Par.pos);
	Texts::_inst()->Scan(S);
	if( S.class_ == Texts::_inst()->Name )
	{
		Texts::_inst()->WriteString(_this->W, "OR-decode ");
		Texts::_inst()->WriteString(_this->W, S.s);
		Texts::_inst()->WriteLn(_this->W);
		Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
		F = Files::_inst()->Old(S.s);
		if( F != 0 )
		{
			Files::_inst()->Set(R, F, 0);
			Files::_inst()->ReadInt(R, k);
			Files::_inst()->ReadInt(R, k);
			Files::_inst()->ReadString(R, name);
			Texts::_inst()->WriteString(_this->W, name);
			Texts::_inst()->WriteHex(_this->W, k);
			/* sym file version */
			_this->Read(R, class_);
			Texts::_inst()->WriteInt(_this->W, class_, 3);
			if( class_ == ORB::_inst()->versionkey )
			{
				Texts::_inst()->WriteLn(_this->W);
				_this->Read(R, class_);
				while( class_ != 0 )
				{
					Texts::_inst()->WriteInt(_this->W, class_, 4);
					Files::_inst()->ReadString(R, name);
					Texts::_inst()->Write(_this->W, ' ');
					Texts::_inst()->WriteString(_this->W, name);
					_this->ReadType(R);
					if( class_ == ORB::_inst()->Typ )
					{
						Texts::_inst()->Write(_this->W, '(');
						_this->Read(R, class_);
						/* pointer base fixup */
						while( class_ != 0 )
						{
							Texts::_inst()->WriteString(_this->W, " ->");
							Texts::_inst()->WriteInt(_this->W, class_, 4);
							_this->Read(R, class_);
						}
						Texts::_inst()->Write(_this->W, ')');
					}else if( (class_ == ORB::_inst()->Const) || (class_ == ORB::_inst()->Var) )
					{
						/* Reals, Strings! */
						Files::_inst()->ReadNum(R, k);
						Texts::_inst()->WriteInt(_this->W, k, 5);
					}
					Texts::_inst()->WriteLn(_this->W);
					Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
					_this->Read(R, class_);
				}
			}else
				Texts::_inst()->WriteString(_this->W, " bad symfile version");

		}else
			Texts::_inst()->WriteString(_this->W, " not found");

		Texts::_inst()->WriteLn(_this->W);
		Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
	}
	// END
}

/*  --------------------------------------------------- */
void ORTool::WriteReg(int r)
{
	// BEGIN
	ORTool* _this = _inst();
	Texts::_inst()->Write(_this->W, ' ');
	if( r < 12 )
	{
		Texts::_inst()->WriteString(_this->W, " R");
		Texts::_inst()->WriteInt(_this->W, MOD(r,0x10), 1);
	}else if( r == 12 )
		Texts::_inst()->WriteString(_this->W, "MT");
	else if( r == 13 )
		Texts::_inst()->WriteString(_this->W, "SB");
	else if( r == 14 )
		Texts::_inst()->WriteString(_this->W, "SP");
	else
		Texts::_inst()->WriteString(_this->W, "LNK");

	// END
}

void ORTool::opcode(int w)
{
	// VAR
	int k;
	int op;
	int u;
	int a;
	int b;
	int c;

	// BEGIN
	ORTool* _this = _inst();
	k = MOD(DIV(w,0x40000000),4);
	a = MOD(DIV(w,0x1000000),0x10);
	b = MOD(DIV(w,0x100000),0x10);
	op = MOD(DIV(w,0x10000),0x10);
	u = MOD(DIV(w,0x20000000),2);
	if( k == 0 )
	{
		Texts::_inst()->WriteString(_this->W, _this->mnemo0[op]);
		if( u == 1 )
			Texts::_inst()->Write(_this->W, '\'');
		
		_this->WriteReg(a);
		_this->WriteReg(b);
		_this->WriteReg(MOD(w,0x10));
	}else if( k == 1 )
	{
		Texts::_inst()->WriteString(_this->W, _this->mnemo0[op]);
		if( u == 1 )
			Texts::_inst()->Write(_this->W, '\'');
		
		_this->WriteReg(a);
		_this->WriteReg(b);
		w = MOD(w,0x10000);
		if( w >= 0x8000 )
			w = w - 0x10000;
		
		Texts::_inst()->WriteInt(_this->W, w, 7);
	}else if( k == 2 )
	{
		/* LDR/STR */
		if( u == 1 )
			Texts::_inst()->WriteString(_this->W, "STR ");
		else
			Texts::_inst()->WriteString(_this->W, "LDR");

		_this->WriteReg(a);
		_this->WriteReg(b);
		w = MOD(w,0x100000);
		if( w >= 0x80000 )
			w = w - 0x100000;
		
		Texts::_inst()->WriteInt(_this->W, w, 8);
	}else if( k == 3 )
	{
		/* Branch instr */
		Texts::_inst()->Write(_this->W, 'B');
		if( DIV(w,0x10000000) % 2 == 1 )
			Texts::_inst()->Write(_this->W, 'L');
		
		Texts::_inst()->WriteString(_this->W, _this->mnemo1[a]);
		if( u == 0 )
			_this->WriteReg(MOD(w,0x10));
		else
		{
			w = MOD(w,0x100000);
			if( w >= 0x80000 )
				w = w - 0x100000;
			
			Texts::_inst()->WriteInt(_this->W, w, 8);
		}
	}
	// END
}

void ORTool::Sync(Files::Rider& R)
{
	// VAR
	char ch;

	// BEGIN
	ORTool* _this = _inst();
	Files::_inst()->Read(R, ch);
	Texts::_inst()->WriteString(_this->W, "Sync ");
	Texts::_inst()->Write(_this->W, ch);
	Texts::_inst()->WriteLn(_this->W);
	// END
}

void ORTool::Write(Files::Rider& R, int x)
{
	// BEGIN
	ORTool* _this = _inst();
	/*  -128 <= x < 128  */
	Files::_inst()->WriteByte(R, x);
	// END
}

/* decode object file */
void ORTool::DecObj()
{
	// VAR
	int class_;
	int i;
	int n;
	int key;
	int size;
	int fix;
	int adr;
	int data;
	int len;
	char ch;
	_FxArray<char,32> name;
	Files::File F;
	Files::Rider R;
	Texts::Scanner S;

	// BEGIN
	ORTool* _this = _inst();
	Texts::_inst()->OpenScanner(S, Oberon::_inst()->Par.text, Oberon::_inst()->Par.pos);
	Texts::_inst()->Scan(S);
	if( S.class_ == Texts::_inst()->Name )
	{
		Texts::_inst()->WriteString(_this->W, "decode ");
		Texts::_inst()->WriteString(_this->W, S.s);
		F = Files::_inst()->Old(S.s);
		if( F != 0 )
		{
			Files::_inst()->Set(R, F, 0);
			Files::_inst()->ReadString(R, name);
			Texts::_inst()->WriteLn(_this->W);
			Texts::_inst()->WriteString(_this->W, name);
			/* version */
			Files::_inst()->ReadInt(R, key);
			Texts::_inst()->WriteHex(_this->W, key);
			_this->Read(R, class_);
			Texts::_inst()->WriteInt(_this->W, class_, 4);
			Files::_inst()->ReadInt(R, size);
			Texts::_inst()->WriteInt(_this->W, size, 6);
			Texts::_inst()->WriteLn(_this->W);
			Texts::_inst()->WriteString(_this->W, "imports:");
			Texts::_inst()->WriteLn(_this->W);
			Files::_inst()->ReadString(R, name);
			while( name[0] != 0x0 )
			{
				Texts::_inst()->Write(_this->W, 0x9);
				Texts::_inst()->WriteString(_this->W, name);
				Files::_inst()->ReadInt(R, key);
				Texts::_inst()->WriteHex(_this->W, key);
				Texts::_inst()->WriteLn(_this->W);
				Files::_inst()->ReadString(R, name);
			}
			/*  Sync(R);  */
			Texts::_inst()->WriteString(_this->W, "type descriptors");
			Texts::_inst()->WriteLn(_this->W);
			Files::_inst()->ReadInt(R, n);
			n = DIV(n,4);
			i = 0;
			while( i < n )
			{
				Files::_inst()->ReadInt(R, data);
				Texts::_inst()->WriteHex(_this->W, data);
				i++;
			}
			Texts::_inst()->WriteLn(_this->W);
			Texts::_inst()->WriteString(_this->W, "data");
			Files::_inst()->ReadInt(R, data);
			Texts::_inst()->WriteInt(_this->W, data, 6);
			Texts::_inst()->WriteLn(_this->W);
			Texts::_inst()->WriteString(_this->W, "strings");
			Texts::_inst()->WriteLn(_this->W);
			Files::_inst()->ReadInt(R, n);
			i = 0;
			while( i < n )
			{
				Files::_inst()->Read(R, ch);
				Texts::_inst()->Write(_this->W, ch);
				i++;
			}
			Texts::_inst()->WriteLn(_this->W);
			Texts::_inst()->WriteString(_this->W, "code");
			Texts::_inst()->WriteLn(_this->W);
			Files::_inst()->ReadInt(R, n);
			i = 0;
			while( i < n )
			{
				Files::_inst()->ReadInt(R, data);
				Texts::_inst()->WriteInt(_this->W, i, 4);
				Texts::_inst()->Write(_this->W, 0x9);
				Texts::_inst()->WriteHex(_this->W, data);
				Texts::_inst()->Write(_this->W, 0x9);
				_this->opcode(data);
				Texts::_inst()->WriteLn(_this->W);
				i++;
			}
			/*  Sync(R);  */
			Texts::_inst()->WriteString(_this->W, "commands:");
			Texts::_inst()->WriteLn(_this->W);
			Files::_inst()->ReadString(R, name);
			while( name[0] != 0x0 )
			{
				Texts::_inst()->Write(_this->W, 0x9);
				Texts::_inst()->WriteString(_this->W, name);
				Files::_inst()->ReadInt(R, adr);
				Texts::_inst()->WriteInt(_this->W, adr, 5);
				Texts::_inst()->WriteLn(_this->W);
				Files::_inst()->ReadString(R, name);
			}
			/*  Sync(R);  */
			Texts::_inst()->WriteString(_this->W, "entries");
			Texts::_inst()->WriteLn(_this->W);
			Files::_inst()->ReadInt(R, n);
			i = 0;
			while( i < n )
			{
				Files::_inst()->ReadInt(R, adr);
				Texts::_inst()->WriteInt(_this->W, adr, 6);
				i++;
			}
			Texts::_inst()->WriteLn(_this->W);
			/*  Sync(R);  */
			Texts::_inst()->WriteString(_this->W, "pointer refs");
			Texts::_inst()->WriteLn(_this->W);
			Files::_inst()->ReadInt(R, adr);
			while( adr != -1 )
			{
				Texts::_inst()->WriteInt(_this->W, adr, 6);
				Files::_inst()->ReadInt(R, adr);
			}
			Texts::_inst()->WriteLn(_this->W);
			/*  Sync(R);  */
			Files::_inst()->ReadInt(R, data);
			Texts::_inst()->WriteString(_this->W, "fixP = ");
			Texts::_inst()->WriteInt(_this->W, data, 8);
			Texts::_inst()->WriteLn(_this->W);
			Files::_inst()->ReadInt(R, data);
			Texts::_inst()->WriteString(_this->W, "fixD = ");
			Texts::_inst()->WriteInt(_this->W, data, 8);
			Texts::_inst()->WriteLn(_this->W);
			Files::_inst()->ReadInt(R, data);
			Texts::_inst()->WriteString(_this->W, "fixT = ");
			Texts::_inst()->WriteInt(_this->W, data, 8);
			Texts::_inst()->WriteLn(_this->W);
			Files::_inst()->ReadInt(R, data);
			Texts::_inst()->WriteString(_this->W, "entry = ");
			Texts::_inst()->WriteInt(_this->W, data, 8);
			Texts::_inst()->WriteLn(_this->W);
			Files::_inst()->Read(R, ch);
			if( ch != 'O' )
			{
				Texts::_inst()->WriteString(_this->W, "format eror");
				Texts::_inst()->WriteLn(_this->W);
			}
		}else
		{
			/*  Sync(R);  */
			Texts::_inst()->WriteString(_this->W, " not found");
			Texts::_inst()->WriteLn(_this->W);
		}
		Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
	}
	// END
}

ORTool::ORTool()
{
	// BEGIN
	Texts::_inst()->OpenWriter(W);
	Texts::_inst()->WriteString(W, "ORTool 18.2.2013");
	Texts::_inst()->WriteLn(W);
	Texts::_inst()->Append(Oberon::_inst()->Log, W.buf);
	mnemo0[0] = "MOV";
	mnemo0[1] = "LSL";
	mnemo0[2] = "ASR";
	mnemo0[3] = "ROR";
	mnemo0[4] = "AND";
	mnemo0[5] = "ANN";
	mnemo0[6] = "IOR";
	mnemo0[7] = "XOR";
	mnemo0[8] = "ADD";
	mnemo0[9] = "SUB";
	mnemo0[10] = "MUL";
	mnemo0[11] = "DIV";
	mnemo0[12] = "FAD";
	mnemo0[13] = "FSB";
	mnemo0[14] = "FML";
	mnemo0[15] = "FDV";
	mnemo1[0] = "MI ";
	mnemo1[8] = "PL";
	mnemo1[1] = "EQ ";
	mnemo1[9] = "NE ";
	mnemo1[2] = "LS ";
	mnemo1[10] = "HI ";
	mnemo1[5] = "LT ";
	mnemo1[13] = "GE ";
	mnemo1[6] = "LE ";
	mnemo1[14] = "GT ";
	mnemo1[15] = "NO ";
	// END
}

ORTool::~ORTool()
{
	s_inst.release();
}

