// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObOberon.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<Oberon> s_inst;

const int Oberon::consume;
const int Oberon::track;
const int Oberon::defocus;
const int Oberon::neutralize;
const int Oberon::mark;
const int Oberon::off;
const int Oberon::idle;
const int Oberon::active;
const int Oberon::BasicCycle;
const char Oberon::ESC;
const char Oberon::SETSTAR;

Oberon* Oberon::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new Oberon() );
	return s_inst.get();
}

/* user identification */
int Oberon::Code(_VarArray<char> s)
{
	// VAR
	int i;
	int a;
	int b;
	int c;

	// BEGIN
	Oberon* _this = _inst();
	a = 0;
	b = 0;
	i = 0;
	while( s[i] != 0x0 )
	{
		c = b;
		b = a;
		a = (MOD(c,509) + 1) * 127 + int( s[i] );
		i++;
	}
	if( b >= 32768 )
		b = b - 65536;
	
	return b * 65536 + a;
	// END
}

void Oberon::SetUser(_VarArray<char> user, _VarArray<char> password)
{
	// BEGIN
	Oberon* _this = _inst();
	_this->User = user;
	_this->Password = _this->Code(password);
	// END
}

int Oberon::Clock()
{
	// BEGIN
	Oberon* _this = _inst();
	return Kernel::_inst()->Clock();
	// END
}

void Oberon::SetClock(int d)
{
	// BEGIN
	Oberon* _this = _inst();
	Kernel::_inst()->SetClock(d);
	// END
}

int Oberon::Time()
{
	// BEGIN
	Oberon* _this = _inst();
	return Kernel::_inst()->Time();
	// END
}

/* cursor handling */
void Oberon::FlipArrow(int X, int Y)
{
	// BEGIN
	Oberon* _this = _inst();
	if( X < _this->CL )
	{
		if( X > _this->DW - 15 )
			X = _this->DW - 15;
		
	}else
	{
		if( X > _this->CL + _this->DW - 15 )
			X = _this->CL + _this->DW - 15;
		
	}
	if( Y < 14 )
		Y = 14;
	else if( Y > _this->DH )
		Y = _this->DH;
	
	Display::_inst()->CopyPattern(Display::_inst()->white, Display::_inst()->arrow, X, Y - 14, Display::_inst()->invert);
	// END
}

void Oberon::FlipStar(int X, int Y)
{
	// BEGIN
	Oberon* _this = _inst();
	if( X < _this->CL )
	{
		if( X < 7 )
			X = 7;
		else if( X > _this->DW - 8 )
			X = _this->DW - 8;
		
	}else
	{
		if( X < _this->CL + 7 )
			X = _this->CL + 7;
		else if( X > _this->CL + _this->DW - 8 )
			X = _this->CL + _this->DW - 8;
		
	}
	if( Y < 7 )
		Y = 7;
	else if( Y > _this->DH - 8 )
		Y = _this->DH - 8;
	
	Display::_inst()->CopyPattern(Display::_inst()->white, Display::_inst()->star, X - 7, Y - 7, Display::_inst()->invert);
	// END
}

void Oberon::OpenCursor(Cursor& c)
{
	// BEGIN
	Oberon* _this = _inst();
	c.on = FALSE;
	c.X = 0;
	c.Y = 0;
	// END
}

void Oberon::FadeCursor(Cursor& c)
{
	// BEGIN
	Oberon* _this = _inst();
	if( c.on )
	{
		c.marker.Fade(c.X, c.Y);
		c.on = FALSE;
	}
	// END
}

void Oberon::DrawCursor(Cursor& c, const Marker& m, int x, int y)
{
	// BEGIN
	Oberon* _this = _inst();
	if( c.on && ((x != c.X) || (y != c.Y) || (m.Draw != c.marker.Draw)) )
	{
		c.marker.Fade(c.X, c.Y);
		c.on = FALSE;
	}
	if( !c.on )
	{
		m.Draw(x, y);
		c.marker = m;
		c.X = x;
		c.Y = y;
		c.on = TRUE;
	}
	// END
}

void Oberon::DrawMouse(const Marker& m, int x, int y)
{
	// BEGIN
	Oberon* _this = _inst();
	_this->DrawCursor(_this->Mouse, m, x, y);
	// END
}

void Oberon::DrawMouseArrow(int x, int y)
{
	// BEGIN
	Oberon* _this = _inst();
	_this->DrawCursor(_this->Mouse, _this->Arrow, x, y);
	// END
}

void Oberon::FadeMouse()
{
	// BEGIN
	Oberon* _this = _inst();
	_this->FadeCursor(_this->Mouse);
	// END
}

void Oberon::DrawPointer(int x, int y)
{
	// BEGIN
	Oberon* _this = _inst();
	_this->DrawCursor(_this->Pointer, _this->Star, x, y);
	// END
}

/* display management */
void Oberon::RemoveMarks(int X, int Y, int W, int H)
{
	// BEGIN
	Oberon* _this = _inst();
	if( (_this->Mouse.X > X - 16) && (_this->Mouse.X < X + W + 16) && (_this->Mouse.Y > Y - 16) && (_this->Mouse.Y < Y + H + 16) )
		_this->FadeCursor(_this->Mouse);
	
	if( (_this->Pointer.X > X - 8) && (_this->Pointer.X < X + W + 8) && (_this->Pointer.Y > Y - 8) && (_this->Pointer.Y < Y + H + 8) )
		_this->FadeCursor(_this->Pointer);
	
	// END
}

void Oberon::HandleFiller(Display::Frame V, Display::FrameMsg& M)
{
	// BEGIN
	Oberon* _this = _inst();
	if( dynamic_cast<>(M) != 0  ){
		if( M.id == _this->track )
			_this->DrawCursor(_this->Mouse, _this->Arrow, M.X, M.Y);
		
	} else if( dynamic_cast<>(M) != 0  ){
		if( M.id == _this->mark )
			_this->DrawCursor(_this->Pointer, _this->Star, M.X, M.Y);
		
	} else if( dynamic_cast<>(M) != 0  ){
		if( (M.id == Viewers::_inst()->restore) && (V->W > 0) && (V->H > 0) )
		{
			_this->RemoveMarks(V->X, V->Y, V->W, V->H);
			Display::_inst()->ReplConst(Display::_inst()->black, V->X, V->Y, V->W, V->H, Display::_inst()->replace);
		}else if( (M.id == Viewers::_inst()->modify) && (M.Y < V->Y) )
		{
			_this->RemoveMarks(V->X, M.Y, V->W, V->Y - M.Y);
			Display::_inst()->ReplConst(Display::_inst()->black, V->X, M.Y, V->W, V->Y - M.Y, Display::_inst()->replace);
		}
	} 
	// END
}

void Oberon::OpenDisplay(int UW, int SW, int H)
{
	// VAR
	Viewers::Viewer Filler;

	// BEGIN
	Oberon* _this = _inst();
	Input::_inst()->SetMouseLimits(Viewers::_inst()->curW + UW + SW, H);
	Display::_inst()->ReplConst(Display::_inst()->black, Viewers::_inst()->curW, 0, UW + SW, H, Display::_inst()->replace);
	Filler = new Viewers::ViewerDesc();
	Filler->handle = _this->HandleFiller;
	/* init user track */
	Viewers::_inst()->InitTrack(UW, H, Filler);
	Filler = new Viewers::ViewerDesc();
	Filler->handle = _this->HandleFiller;
	/* init system track */
	Viewers::_inst()->InitTrack(SW, H, Filler);
	// END
}

int Oberon::DisplayWidth(int X)
{
	// BEGIN
	Oberon* _this = _inst();
	return _this->DW;
	// END
}

int Oberon::DisplayHeight(int X)
{
	// BEGIN
	Oberon* _this = _inst();
	return _this->DH;
	// END
}

void Oberon::OpenTrack(int X, int W)
{
	// VAR
	Viewers::Viewer Filler;

	// BEGIN
	Oberon* _this = _inst();
	Filler = new Viewers::ViewerDesc();
	Filler->handle = _this->HandleFiller;
	Viewers::_inst()->OpenTrack(X, W, Filler);
	// END
}

int Oberon::UserTrack(int X)
{
	// BEGIN
	Oberon* _this = _inst();
	return DIV(X,_this->DW) * _this->DW;
	// END
}

int Oberon::SystemTrack(int X)
{
	// BEGIN
	Oberon* _this = _inst();
	return DIV(X,_this->DW) * _this->DW + DIV(_this->DW,8) * 5;
	// END
}

int Oberon::UY(int X)
{
	// VAR
	int h;
	Display::Frame fil;
	Display::Frame bot;
	Display::Frame alt;
	Display::Frame max;

	// BEGIN
	Oberon* _this = _inst();
	Viewers::_inst()->Locate(X, 0, fil, bot, alt, max);
	if( fil->H >= DIV(_this->DH,8) )
		h = _this->DH;
	else
		h = max->Y + DIV(max->H,2);

	return h;
	// END
}

void Oberon::AllocateUserViewer(int DX, int& X, int& Y)
{
	// BEGIN
	Oberon* _this = _inst();
	if( _this->Pointer.on )
	{
		X = _this->Pointer.X;
		Y = _this->Pointer.Y;
	}else
	{
		X = DIV(DX,_this->DW) * _this->DW;
		Y = _this->UY(X);
	}
	// END
}

int Oberon::SY(int X)
{
	// VAR
	int H0;
	int H1;
	int H2;
	int H3;
	int y;
	Display::Frame fil;
	Display::Frame bot;
	Display::Frame alt;
	Display::Frame max;

	// BEGIN
	Oberon* _this = _inst();
	H3 = _this->DH - DIV(_this->DH,3);
	H2 = H3 - DIV(H3,2);
	H1 = DIV(_this->DH,5);
	H0 = DIV(_this->DH,10);
	Viewers::_inst()->Locate(X, _this->DH, fil, bot, alt, max);
	if( fil->H >= DIV(_this->DH,8) )
		y = _this->DH;
	else if( max->H >= _this->DH - H0 )
		y = max->Y + H3;
	else if( max->H >= H3 - H0 )
		y = max->Y + H2;
	else if( max->H >= H2 - H0 )
		y = max->Y + H1;
	else if( max != bot )
		y = max->Y + DIV(max->H,2);
	else if( bot->H >= H1 )
		y = DIV(bot->H,2);
	else
		y = alt->Y + DIV(alt->H,2);

	return y;
	// END
}

void Oberon::AllocateSystemViewer(int DX, int& X, int& Y)
{
	// BEGIN
	Oberon* _this = _inst();
	if( _this->Pointer.on )
	{
		X = _this->Pointer.X;
		Y = _this->Pointer.Y;
	}else
	{
		X = DIV(DX,_this->DW) * _this->DW + DIV(_this->DW,8) * 5;
		Y = _this->SY(X);
	}
	// END
}

Viewers::Viewer Oberon::MarkedViewer()
{
	// BEGIN
	Oberon* _this = _inst();
	return Viewers::_inst()->This(_this->Pointer.X, _this->Pointer.Y);
	// END
}

void Oberon::PassFocus(Viewers::Viewer V)
{
	// VAR
	ControlMsg M;

	// BEGIN
	Oberon* _this = _inst();
	M.id = _this->defocus;
	_this->FocusViewer->handle(_this->FocusViewer, M);
	_this->FocusViewer = V;
	// END
}

void Oberon::OpenLog(Texts::Text T)
{
	// BEGIN
	Oberon* _this = _inst();
	_this->Log = T;
	// END
}

/* command interpretation */
void Oberon::SetPar(Display::Frame F, Texts::Text T, int pos)
{
	// BEGIN
	Oberon* _this = _inst();
	_this->Par.vwr = Viewers::_inst()->This(F->X, F->Y);
	_this->Par.frame = F;
	_this->Par.text = T;
	_this->Par.pos = pos;
	// END
}

void Oberon::Call(_ValArray<char> name, int& res)
{
	// VAR
	Modules::Module mod;
	Modules::Command P;
	int i;
	int j;
	char ch;
	_FxArray<char,32> Mname;
	_FxArray<char,32> Cname;

	// BEGIN
	Oberon* _this = _inst();
	i = 0;
	ch = name[0];
	while( (ch != '.') && (ch != 0x0) )
	{
		Mname[i] = ch;
		i++;
		ch = name[i];
	}
	if( ch == '.' )
	{
		Mname[i] = 0x0;
		i++;
		Modules::_inst()->Load(Mname, mod);
		res = Modules::_inst()->res;
		if( Modules::_inst()->res == 0 )
		{
			j = 0;
			ch = name[i];
			i++;
			while( ch != 0x0 )
			{
				Cname[j] = ch;
				j++;
				ch = name[i];
				i++;
			}
			Cname[j] = 0x0;
			P = Modules::_inst()->ThisCommand(mod, Cname);
			res = Modules::_inst()->res;
			if( Modules::_inst()->res == 0 )
				P;
			
		}
	}else
		res = 5;

	// END
}

void Oberon::GetSelection(Texts::Text& text, int& beg, int& end, int& time)
{
	// VAR
	SelectionMsg M;

	// BEGIN
	Oberon* _this = _inst();
	M.time = -1;
	Viewers::_inst()->Broadcast(M);
	time = M.time;
	if( time >= 0 )
	{
		text = M.text;
		beg = M.beg;
		end = M.end;
	}
	// END
}

void Oberon::GC()
{
	// VAR
	Modules::Module mod;

	// BEGIN
	Oberon* _this = _inst();
	if( (_this->ActCnt <= 0) || (Kernel::_inst()->allocated >= Kernel::_inst()->heapLim - Kernel::_inst()->heapOrg - 0x10000) )
	{
		mod = Modules::_inst()->root;
		LED(0x21);
		while( mod != 0 )
		{
			if( mod->name[0] != 0x0 )
				Kernel::_inst()->Mark(mod->ptr);
			
			mod = mod->next;
		}
		LED(0x23);
		Files::_inst()->RestoreList();
		LED(0x27);
		Kernel::_inst()->Scan();
		LED(0x20);
		_this->ActCnt = _this->BasicCycle;
	}
	// END
}

Oberon::Task Oberon::NewTask(Handler h, int period)
{
	// VAR
	Task t;

	// BEGIN
	Oberon* _this = _inst();
	t = new Oberon::TaskDesc();
	t->state = _this->off;
	t->next = t;
	t->handle = h;
	t->period = period;
	return t;
	// END
}

void Oberon::Install(Task T)
{
	// BEGIN
	Oberon* _this = _inst();
	if( T->state == _this->off )
	{
		T->next = _this->CurTask->next;
		_this->CurTask->next = T;
		T->state = _this->idle;
		T->nextTime = 0;
		_this->NofTasks++;
	}
	// END
}

void Oberon::Remove(Task T)
{
	// VAR
	Task t;

	// BEGIN
	Oberon* _this = _inst();
	if( T->state != _this->off )
	{
		t = T;
		while( t->next != T )
			t = t->next;
		
		t->next = T->next;
		T->state = _this->off;
		T->next = 0;
		_this->CurTask = t;
		_this->NofTasks--;
	}
	// END
}

void Oberon::Collect(int count)
{
	// BEGIN
	Oberon* _this = _inst();
	_this->ActCnt = count;
	// END
}

void Oberon::SetFont(Fonts::Font fnt)
{
	// BEGIN
	Oberon* _this = _inst();
	_this->CurFnt = fnt;
	// END
}

void Oberon::SetColor(int col)
{
	// BEGIN
	Oberon* _this = _inst();
	_this->CurCol = col;
	// END
}

void Oberon::SetOffset(int voff)
{
	// BEGIN
	Oberon* _this = _inst();
	_this->CurOff = voff;
	// END
}

void Oberon::Loop()
{
	// VAR
	Viewers::Viewer V;
	InputMsg M;
	ControlMsg N;
	int prevX;
	int prevY;
	int X;
	int Y;
	int t;
	_Set keys;
	char ch;

	// BEGIN
	Oberon* _this = _inst();
	do 
	{
		Input::_inst()->Mouse(keys, X, Y);
		if( Input::_inst()->Available() > 0 )
		{
			Input::_inst()->Read(ch);
			if( ch == _this->ESC )
			{
				N.id = _this->neutralize;
				Viewers::_inst()->Broadcast(N);
				_this->FadeCursor(_this->Pointer);
				LED(0);
			}else if( ch == _this->SETSTAR )
			{
				N.id = _this->mark;
				N.X = X;
				N.Y = Y;
				V = Viewers::_inst()->This(X, Y);
				V->handle(V, N);
			}else
			{
				M.id = _this->consume;
				M.ch = ch;
				M.fnt = _this->CurFnt;
				M.col = _this->CurCol;
				M.voff = _this->CurOff;
				_this->FocusViewer->handle(_this->FocusViewer, M);
				_this->ActCnt--;
			}
		}else if( keys != ( _Set() ) )
		{
			M.id = _this->track;
			M.X = X;
			M.Y = Y;
			M.keys = keys;
			do 
			{
				V = Viewers::_inst()->This(M.X, M.Y);
				V->handle(V, M);
				Input::_inst()->Mouse(M.keys, M.X, M.Y);
			} while( !( M.keys == ( _Set() ) ) );
			_this->ActCnt--;
		}else
		{
			if( (X != prevX) || (Y != prevY) || !_this->Mouse.on )
			{
				M.id = _this->track;
				M.X = X;
				if( Y >= Display::_inst()->Height )
					Y = Display::_inst()->Height;
				
				M.Y = Y;
				M.keys = keys;
				V = Viewers::_inst()->This(X, Y);
				V->handle(V, M);
				prevX = X;
				prevY = Y;
			}
			_this->CurTask = _this->CurTask->next;
			t = Kernel::_inst()->Time();
			if( t >= _this->CurTask->nextTime )
			{
				_this->CurTask->nextTime = t + _this->CurTask->period;
				_this->CurTask->state = _this->active;
				_this->CurTask->handle;
				_this->CurTask->state = _this->idle;
			}
		}
	} while( !( FALSE ) );
	// END
}

void Oberon::Reset()
{
	// BEGIN
	Oberon* _this = _inst();
	if( _this->CurTask->state == _this->active )
		_this->Remove(_this->CurTask);
	
	/* reset stack pointer */
	SYSTEM::_inst()->LDREG(14, Kernel::_inst()->stackOrg);
	_this->Loop();
	// END
}

Oberon::Oberon()
{
	// BEGIN
	User[0] = 0x0;
	Arrow.Fade = FlipArrow;
	Arrow.Draw = FlipArrow;
	Star.Fade = FlipStar;
	Star.Draw = FlipStar;
	OpenCursor(Mouse);
	OpenCursor(Pointer);
	DW = Display::_inst()->Width;
	DH = Display::_inst()->Height;
	CL = DW;
	OpenDisplay(DIV(DW,8) * 5, DIV(DW,8) * 3, DH);
	FocusViewer = Viewers::_inst()->This(0, 0);
	CurFnt = Fonts::_inst()->Default;
	CurCol = Display::_inst()->white;
	CurOff = 0;
	ActCnt = 0;
	CurTask = NewTask(GC, 1000);
	Install(CurTask);
	Modules::_inst()->Load("System", Mod);
	Mod = 0;
	Loop();
	// END
}

Oberon::~Oberon()
{
	s_inst.release();
}

