#ifndef __ObOberon_H__
#define __ObOberon_H__

// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17

#include <OberonSystem/Ob_Global.h>
#include <OberonSystem/ObSYSTEM.h>
#include <OberonSystem/ObKernel.h>
#include <OberonSystem/ObFiles.h>
#include <OberonSystem/ObModules.h>
#include <OberonSystem/ObInput.h>
#include <OberonSystem/ObDisplay.h>
#include <OberonSystem/ObViewers.h>
#include <OberonSystem/ObFonts.h>
#include <OberonSystem/ObTexts.h>

namespace Ob
{
	class Oberon : public _Root
	{
	public:
		/* JG 6.9.90 / 23.9.93 / 13.8.94 / NW 14.4.2013 / 22.12.2015 */
		static Oberon* _inst();
		Oberon();
		~Oberon();

		// CONST
		/* message ids */
		static const int consume = 0;
		static const int track = 1;
		static const int defocus = 0;
		static const int neutralize = 1;
		static const int mark = 2;
		/* task states */
		static const int off = 0;
		static const int idle = 1;
		static const int active = 2;
		static const int BasicCycle = 20;
		static const char ESC = 0x1B;
		static const char SETSTAR = 0x1A;

		// TYPE
		struct Marker;
		struct Cursor;
		struct InputMsg;
		struct SelectionMsg;
		struct ControlMsg;
		struct CopyMsg;
		struct TaskDesc;

		typedef /* ProcType not supported here */ Painter;
		struct Marker : public _Root {
			Painter Draw;
			Painter Fade;
		};
		struct Cursor : public _Root {
			int X;
			int Y;
			Marker marker;
			bool on;
		};
		struct InputMsg : public Display::FrameMsg {
			int X;
			int Y;
			char ch;
			int col;
			Fonts::Font fnt;
			int id;
			_Set keys;
			int voff;
		};
		struct SelectionMsg : public Display::FrameMsg {
			int beg;
			int end;
			Texts::Text text;
			int time;
		};
		struct ControlMsg : public Display::FrameMsg {
			int X;
			int Y;
			int id;
		};
		struct CopyMsg : public Display::FrameMsg {
			Display::Frame F;
		};
		typedef TaskDesc* Task;
		typedef /* ProcType not supported here */ Handler;
		struct TaskDesc : public _Root {
			Handler handle;
			Task next;
			int nextTime;
			int period;
			int state;
		};

		// VAR
		_FxArray<char,8> User;
		int Password;
		Marker Arrow;
		Marker Star;
		Cursor Mouse;
		Cursor Pointer;
		Viewers::Viewer FocusViewer;
		Texts::Text Log;
		struct : public _Root {
			Display::Frame frame;
			int pos;
			Texts::Text text;
			Viewers::Viewer vwr;
		} Par;
		Fonts::Font CurFnt;
		int CurCol;
		int CurOff;
		int NofTasks;
		Task CurTask;
		int DW;
		int DH;
		int CL;
		/* action count for GC */
		int ActCnt;
		Modules::Module Mod;

		// PROC
		int Code(_VarArray<char> s);
		static void SetUser(_VarArray<char> user, _VarArray<char> password);
		int Clock();
		static void SetClock(int d);
		int Time();
		static void FlipArrow(int X, int Y);
		static void FlipStar(int X, int Y);
		static void OpenCursor(Cursor& c);
		static void FadeCursor(Cursor& c);
		static void DrawCursor(Cursor& c, const Marker& m, int x, int y);
		static void DrawMouse(const Marker& m, int x, int y);
		static void DrawMouseArrow(int x, int y);
		static void FadeMouse();
		static void DrawPointer(int x, int y);
		static void RemoveMarks(int X, int Y, int W, int H);
		static void HandleFiller(Display::Frame V, Display::FrameMsg& M);
		static void OpenDisplay(int UW, int SW, int H);
		int DisplayWidth(int X);
		int DisplayHeight(int X);
		static void OpenTrack(int X, int W);
		int UserTrack(int X);
		int SystemTrack(int X);
		int UY(int X);
		static void AllocateUserViewer(int DX, int& X, int& Y);
		int SY(int X);
		static void AllocateSystemViewer(int DX, int& X, int& Y);
		Viewers::Viewer MarkedViewer();
		static void PassFocus(Viewers::Viewer V);
		static void OpenLog(Texts::Text T);
		static void SetPar(Display::Frame F, Texts::Text T, int pos);
		static void Call(_ValArray<char> name, int& res);
		static void GetSelection(Texts::Text& text, int& beg, int& end, int& time);
		static void GC();
		Task NewTask(Handler h, int period);
		static void Install(Task T);
		static void Remove(Task T);
		static void Collect(int count);
		static void SetFont(Fonts::Font fnt);
		static void SetColor(int col);
		static void SetOffset(int voff);
		static void Loop();
		static void Reset();

	};
}

#endif // __ObOberon_H__