// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObRectangles.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<Rectangles> s_inst;


Rectangles* Rectangles::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new Rectangles() );
	return s_inst.get();
}

void Rectangles::New()
{
	// VAR
	Rectangle r;

	// BEGIN
	Rectangles* _this = _inst();
	r = new Rectangles::RectDesc();
	r->do_ = _this->method;
	Graphics::_inst()->New(r);
	// END
}

void Rectangles::Copy(Graphics::Object src, Graphics::Object dst)
{
	// BEGIN
	Rectangles* _this = _inst();
	dst->x = src->x;
	dst->y = src->y;
	dst->w = src->w;
	dst->h = src->h;
	dst->col = src->col;
	dst->_to<Rectangle>()->lw = src->_to<Rectangle>()->lw;
	dst->_to<Rectangle>()->vers = src->_to<Rectangle>()->vers;
	// END
}

void Rectangles::mark(GraphicFrames::Frame f, int col, int x, int y)
{
	// BEGIN
	Rectangles* _this = _inst();
	GraphicFrames::_inst()->ReplConst(f, col, x + 1, y + 1, 4, 4, 0);
	// END
}

void Rectangles::Draw(Graphics::Object obj, Graphics::Msg& M)
{
	// VAR
	int x;
	int y;
	int w;
	int h;
	int lw;
	int col;
	GraphicFrames::Frame f;

	// BEGIN
	Rectangles* _this = _inst();
	if( dynamic_cast<>(M) != 0  ){
		x = obj->x + M.x;
		y = obj->y + M.y;
		w = obj->w;
		h = obj->h;
		f = M.f;
		lw = obj->_to<Rectangle>()->lw;
		if( (x < f->X1) && (x + w > f->X) && (y < f->Y1) && (y + h > f->Y) )
		{
			if( M.col == Display::_inst()->black )
				col = obj->col;
			else
				col = M.col;

			if( M.mode == 0 )
			{
				draw(f, col, x, y, w, h, lw);
				if( obj->selected )
					_this->mark(f, Display::_inst()->white, x, y);
				
			}else if( M.mode == 1 )
				/* normal -> selected */
				_this->mark(f, Display::_inst()->white, x, y);
			else if( M.mode == 2 )
				/* selected -> normal */
				_this->mark(f, Display::_inst()->black, x, y);
			else if( M.mode == 3 )
			{
				/* erase */
				draw(f, Display::_inst()->black, x, y, w, h, lw);
				_this->mark(f, Display::_inst()->black, x, y);
			}
		}
	} 
	// END
}

bool Rectangles::Selectable(Graphics::Object obj, int x, int y)
{
	// BEGIN
	Rectangles* _this = _inst();
	return (obj->x <= x) && (x <= obj->x + 4) && (obj->y <= y) && (y <= obj->y + 4);
	// END
}

void Rectangles::Change(Graphics::Object obj, Graphics::Msg& M)
{
	// VAR
	int x0;
	int y0;
	int x1;
	int y1;
	int dx;
	int dy;
	_Set k;

	// BEGIN
	Rectangles* _this = _inst();
	if( dynamic_cast<>(M) != 0  ){
		obj->_to<Rectangle>()->lw = M.w;
	} else if( dynamic_cast<>(M) != 0  ){
		obj->col = M.col;
	} 
	// END
}

void Rectangles::Read(Graphics::Object obj, Files::Rider& R, Graphics::Context& C)
{
	// VAR
	uint8_t b;
	int len;

	// BEGIN
	Rectangles* _this = _inst();
	/* len */
	Files::_inst()->ReadByte(R, b);
	Files::_inst()->ReadByte(R, b);
	obj->_to<Rectangle>()->lw = b;
	Files::_inst()->ReadByte(R, b);
	obj->_to<Rectangle>()->vers = b;
	// END
}

void Rectangles::Write(Graphics::Object obj, int cno, Files::Rider& W, Graphics::Context& C)
{
	// BEGIN
	Rectangles* _this = _inst();
	Graphics::_inst()->WriteObj(W, cno, obj);
	Files::_inst()->WriteByte(W, 2);
	Files::_inst()->WriteByte(W, obj->_to<Rectangle>()->lw);
	Files::_inst()->WriteByte(W, obj->_to<Rectangle>()->vers);
	// END
}

/*  PROCEDURE Print(obj: Graphics.Object; x, y: INTEGER);
    VAR w, h, lw, s: INTEGER;
  BEGIN INC(x, obj.x * 4); INC(y, obj.y * 4); w := obj.w * 4; h := obj.h * 4;
    lw := obj(Rectangle).lw * 2; s := obj(Rectangle).vers;
    Printer.ReplConst(x, y, w, lw);
    Printer.ReplConst(x+w-lw, y, lw, h);
    Printer.ReplConst(x, y+h-lw, w, lw);
    Printer.ReplConst(x, y, lw, h);
    IF s > 0 THEN Printer.ReplPattern(x, y, w, h, s) END
  END Print;  */
/* command */
void Rectangles::Make()
{
	// VAR
	int x0;
	int x1;
	int y0;
	int y1;
	Rectangle R;
	GraphicFrames::Frame G;

	// BEGIN
	Rectangles* _this = _inst();
	G = GraphicFrames::_inst()->Focus();
	if( (G != 0) && (G->mark.next != 0) )
	{
		GraphicFrames::_inst()->Deselect(G);
		x0 = G->mark.x;
		y0 = G->mark.y;
		x1 = G->mark.next->x;
		y1 = G->mark.next->y;
		R = new Rectangles::RectDesc();
		R->col = Oberon::_inst()->CurCol;
		R->w = ABS(x1 - x0);
		R->h = ABS(y1 - y0);
		if( x1 < x0 )
			x0 = x1;
		
		if( y1 < y0 )
			y0 = y1;
		
		R->x = x0 - G->x;
		R->y = y0 - G->y;
		R->lw = Graphics::_inst()->width;
		R->vers = 0;
		R->do_ = _this->method;
		Graphics::_inst()->Add(G->graph, R);
		GraphicFrames::_inst()->Defocus(G);
		GraphicFrames::_inst()->DrawObj(G, R);
	}
	// END
}

Rectangles::Rectangles()
{
	// BEGIN
	method = new Graphics::MethodDesc();
	method->module = "Rectangles";
	method->allocator = "New";
	method->new_ = New;
	method->copy = Copy;
	method->draw = Draw;
	method->selectable = Selectable;
	method->change = Change;
	/* method.print := Print */
	method->read = Read;
	method->write = Write;
	tack = SYSTEM::_inst()->ADR("07074122140814224100");
	grey = SYSTEM::_inst()->ADR("2004000011111111000000004444444400000000");
	// END
}

Rectangles::~Rectangles()
{
	s_inst.release();
}

