// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObSCC.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<SCC> s_inst;

const int SCC::swi;
const int SCC::spiData;
const int SCC::spiCtrl;
const int SCC::netSelect;
const int SCC::spiFast;
const int SCC::netEnable;
const int SCC::HdrSize;
const int SCC::MaxPayload;
const int SCC::SubPacket;
const int SCC::Wait;
const int SCC::SendTries;
const int SCC::MaxPacket;

SCC* SCC::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new SCC() );
	return s_inst.get();
}

void SCC::SPICtrl(_Set s)
{
	// BEGIN
	SCC* _this = _inst();
	SYSTEM::_inst()->PUT(_this->spiCtrl, s);
	if( s.contains( _this->netEnable ) )
		LED(0x55);
	else
		LED(0);

	// END
}

void SCC::SPI(int n)
{
	// BEGIN
	SCC* _this = _inst();
	/* send (& rcv into shift reg) one byte or word, at current speed */
	/* wait until done */
	SYSTEM::_inst()->PUT(_this->spiData, n);
	do 
	{
		; // empty statement
	} while( !( SYSTEM::_inst()->BIT(_this->spiCtrl, 0) ) );
	// END
}

void SCC::StartCmd(int cmd)
{
	// BEGIN
	SCC* _this = _inst();
	_this->SPICtrl(( _Set() + (_this->netSelect) ));
	_this->SPI(cmd);
	// END
}

/* disables radio! */
void SCC::WriteReg1(int reg, int dat)
{
	// BEGIN
	SCC* _this = _inst();
	/* W_REGISTER */
	_this->StartCmd(reg + 0x20);
	_this->SPI(dat);
	_this->SPICtrl(( _Set() ));
	// END
}

void SCC::SubRcv(int dst)
{
	// VAR
	int i;
	int dat;

	// BEGIN
	SCC* _this = _inst();
	/* R_RX_PAYLOAD, disables radio */
	_this->StartCmd(0x061);
	_this->SPICtrl(( _Set() + (_this->netSelect) + (_this->spiFast) ));
	for( i = 0; 4 > 0 ? i <= _this->SubPacket - 4 : i >= _this->SubPacket - 4; i += 4 )
	{
		_this->SPI(-1);
		SYSTEM::_inst()->GET(_this->spiData, dat);
		SYSTEM::_inst()->PUT(dst + i, dat);
	}
	/* done; STATUS <= clear RX_DR */
	_this->SPICtrl(( _Set() ));
	_this->WriteReg1(7, 0x40);
	/* enable radio */
	_this->SPICtrl(( _Set() + (_this->netEnable) ));
	// END
}

void SCC::SubSnd(int src, bool& timeout)
{
	// VAR
	int i;
	int dat;
	int res;
	int t1;
	int try_;
	uint8_t x;
	uint8_t status;

	// BEGIN
	SCC* _this = _inst();
	/* already in xmit mode */
	/* W_TX_PAYLOAD */
	_this->StartCmd(0x0A0);
	_this->SPICtrl(( _Set() + (_this->netSelect) + (_this->spiFast) ));
	for( i = 0; 4 > 0 ? i <= _this->SubPacket - 4 : i >= _this->SubPacket - 4; i += 4 )
	{
		SYSTEM::_inst()->GET(src + i, dat);
		_this->SPI(dat);
	}
	/* end W_TX_PAYLOAD command */
	_this->SPICtrl(( _Set() ));
	try_ = 0;
	/* start xmit pulse, start NOP cmd */
	_this->SPICtrl(( _Set() + (_this->netEnable) + (_this->netSelect) ));
	do 
	{
		t1 = Kernel::_inst()->Time() + _this->Wait;
		/* wait for sent or retransmits exceeded */
		do 
		{
			/* NOP */
			_this->SPI(0x0FF);
			SYSTEM::_inst()->GET(_this->spiData, status);
			res = MOD(DIV(status,0x10),4);
			/* end & restart NOP cmd, end =10us pulse on enable */
			_this->SPICtrl(( _Set() ));
			_this->SPICtrl(( _Set() + (_this->netSelect) ));
		} while( !( res != 0 ) );
		/* TX_DS: sent, ack received; reset it */
		if( res == 2 )
			_this->WriteReg1(7, 0x20);
		else if( res == 1 )
		{
			/* MAX_RT: retransmits exceeded; reset it */
			_this->WriteReg1(7, 0x10);
			try_++;
			if( try_ == _this->SendTries )
				res = 0;
			else
			{
				do 
				{
					; // empty statement
				} while( !( Kernel::_inst()->Time() >= t1 ) );
				/* start xmit pulse, start NOP cmd again */
				_this->SPICtrl(( _Set() + (_this->netEnable) + (_this->netSelect) ));
			}
		}
	} while( !( res != 1 ) );
	timeout = (res != 2);
	// END
}

void SCC::Flush()
{
	// BEGIN
	SCC* _this = _inst();
	_this->StartCmd(0x0E1);
	_this->SPICtrl(( _Set() ));
	_this->StartCmd(0x0E2);
	_this->SPICtrl(( _Set() ));
	// END
}

/* FLUSH_TX, FLUSH_RX */
void SCC::ResetRcv()
{
	// BEGIN
	SCC* _this = _inst();
	SYSTEM::_inst()->PUT(SYSTEM::_inst()->ADR(_this->rx), 0);
	_this->rx.hd.len = 0;
	_this->rcvd = 0;
	// END
}

void SCC::Listen(bool b)
{
	// BEGIN
	SCC* _this = _inst();
	/* CONFIG <= mask ints; EN_CRC(2 byte), PWR_UP, PRX/PTX */
	_this->WriteReg1(0, 0x07E + int( b ));
	/* STATUS <= clear ints */
	_this->WriteReg1(7, 0x70);
	/* turn radio on */
	if( b )
		_this->SPICtrl(( _Set() + (_this->netEnable) ));
	
	// END
}

void SCC::Start(bool filt)
{
	// VAR
	int n;

	// BEGIN
	SCC* _this = _inst();
	_this->filter = filt;
	_this->Adr = 0;
	SYSTEM::_inst()->GET(_this->swi, n);
	n = MOD(DIV(n,4),0x10) * 10 + 5;
	/* RF_CH <= channel: 5, 15, 25... */
	_this->WriteReg1(5, n);
	/* RF_SETUP <= 1Mb for better range, 0dBm */
	_this->WriteReg1(6, 0x07);
	/* RX_PW_P0 <= pipe 0 payload width */
	_this->WriteReg1(0x11, _this->SubPacket);
	_this->Flush();
	_this->Listen(TRUE);
	_this->ResetRcv();
	// END
}

void SCC::SendPacket(Header& head, _ValArray<uint8_t> dat)
{
	// VAR
	int len;
	int i;
	int off;
	bool timeout;
	_FxArray<uint8_t,_this->SubPacket> payload;

	// BEGIN
	SCC* _this = _inst();
	/* let any receive ack finish before turning radio off */
	i = Kernel::_inst()->Time() + _this->Wait;
	/* NOP */
	do 
	{
		_this->SPICtrl(( _Set() + (_this->netEnable) + (_this->netSelect) ));
		_this->SPI(0x0FF);
		_this->SPICtrl(( _Set() + (_this->netEnable) ));
	} while( !( Kernel::_inst()->Time() >= i ) );
	if( _this->Adr == 0 )
		_this->Adr = MOD(i,0x100);
	
	_this->Listen(FALSE);
	head.sadr = _this->Adr;
	head.valid = TRUE;
	SYSTEM::_inst()COPY(SYSTEM::_inst()->ADR(head), SYSTEM::_inst()->ADR(payload), DIV(_this->HdrSize,4));
	i = _this->HdrSize;
	off = 0;
	len = head.len;
	while( (len > 0) && (i < _this->SubPacket) )
	{
		payload[i] = dat[off];
		i++;
		off++;
		len--;
	}
	while( i < _this->SubPacket )
	{
		payload[i] = 0;
		i++;
	}
	_this->SubSnd(SYSTEM::_inst()->ADR(payload), timeout);
	/* send the rest */
	while( !timeout && (len != 0) )
	{
		i = 0;
		while( (len > 0) && (i < _this->SubPacket) )
		{
			payload[i] = dat[off];
			i++;
			off++;
			len--;
		}
		while( i < _this->SubPacket )
		{
			payload[i] = 0;
			i++;
		}
		_this->SubSnd(SYSTEM::_inst()->ADR(payload), timeout);
	}
	_this->Listen(TRUE);
	// END
}

int SCC::Available()
{
	// BEGIN
	SCC* _this = _inst();
	/* packet already rcvd */
	return _this->rx.hd.len - _this->rcvd;
	// END
}

void SCC::Receive(uint8_t& x)
{
	// BEGIN
	SCC* _this = _inst();
	/* packet already rcvd */
	if( _this->rcvd < _this->rx.hd.len )
	{
		x = _this->rx.dat[_this->rcvd];
		_this->rcvd++;
	}else
		x = 0;

	// END
}

bool SCC::Rcvd(int time)
{
	// VAR
	uint8_t status;
	uint8_t fifoStatus;
	bool rcvd;

	// BEGIN
	SCC* _this = _inst();
	time = time + Kernel::_inst()->Time();
	do 
	{
		/* R_REGISTER FIFO_STATUS */
		_this->SPICtrl(( _Set() + (_this->netEnable) + (_this->netSelect) ));
		_this->SPI(0x17);
		SYSTEM::_inst()->GET(_this->spiData, status);
		_this->SPI(-1);
		SYSTEM::_inst()->GET(_this->spiData, fifoStatus);
		_this->SPICtrl(( _Set() + (_this->netEnable) ));
		/* RX_DR (data ready) or RX FIFO not empty */
		rcvd = DIV(status,0x40) % 2 == 1 || !fifoStatus % 2 == 1;
	} while( !( rcvd || (Kernel::_inst()->Time() >= time) ) );
	return rcvd;
	// END
}

/* actually, recv whole packet */
void SCC::ReceiveHead(Header& head)
{
	// VAR
	int adr;
	int n;

	// BEGIN
	SCC* _this = _inst();
	head.valid = FALSE;
	if( _this->Rcvd(0) )
	{
		_this->ResetRcv();
		adr = SYSTEM::_inst()->ADR(_this->rx);
		_this->SubRcv(adr);
		n = DIV((_this->rx.hd.len + _this->HdrSize - 1),_this->SubPacket);
		if( (_this->rx.hd.len <= _this->MaxPayload) && ((_this->rx.hd.dadr == 0x0FF) || !_this->filter || (_this->Adr == 0) || (_this->rx.hd.dadr == _this->Adr)) )
		{
			while( (n > 0) && _this->Rcvd(_this->Wait) )
			{
				adr += _this->SubPacket;
				_this->SubRcv(adr);
				n--;
			}
			_this->rx.hd.valid = (n == 0);
		}else
		{
			/* discard packet */
			while( _this->Rcvd(_this->Wait) )
				_this->SubRcv(adr);
			
			_this->ResetRcv();
		}
		head = _this->rx.hd;
	}
	// END
}

void SCC::Skip(int m)
{
	// VAR
	uint8_t dmy;

	// BEGIN
	SCC* _this = _inst();
	while( m != 0 )
	{
		_this->Receive(dmy);
		m--;
	}
	// END
}

void SCC::Stop()
{
	// BEGIN
	SCC* _this = _inst();
	_this->SPICtrl(( _Set() ));
	_this->Flush();
	_this->ResetRcv();
	// END
}

SCC::SCC()
{
	// BEGIN
	Start(TRUE);
	// END
}

SCC::~SCC()
{
	s_inst.release();
}

