#ifndef __ObSCC_H__
#define __ObSCC_H__

// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17

#include <OberonSystem/Ob_Global.h>
#include <OberonSystem/ObSYSTEM.h>
#include <OberonSystem/ObKernel.h>

namespace Ob
{
	class SCC : public _Root
	{
	public:
		/* NW 13.11.87 / 22.8.90 Ceres-2; nRF24L01+ version PR 21.7.13 / 23.12.13 */
		static SCC* _inst();
		SCC();
		~SCC();

		// CONST
		static const int swi = -60;
		static const int spiData = -48;
		static const int spiCtrl = -44;
		static const int netSelect = 1;
		static const int spiFast = 2;
		static const int netEnable = 3;
		static const int HdrSize = 8;
		static const int MaxPayload = 512;
		static const int SubPacket = 32;
		static const int Wait = 50;
		static const int SendTries = 50;
		static const int MaxPacket = DIV((HdrSize + MaxPayload + SubPacket - 1),SubPacket) * SubPacket;

		// TYPE
		struct Header;

		struct Header : public _Root {
			uint8_t dadr;
			int len;
			uint8_t sadr;
			uint8_t typ;
			bool valid;
		};

		// VAR
		/* of data following header */
		bool filter;
		uint8_t Adr;
		int rcvd;
		struct : public _Root {
			_FxArray<uint8_t,MaxPacket - HdrSize> dat;
			Header hd;
		} rx;

		// PROC
		static void SPICtrl(_Set s);
		static void SPI(int n);
		static void StartCmd(int cmd);
		static void WriteReg1(int reg, int dat);
		static void SubRcv(int dst);
		static void SubSnd(int src, bool& timeout);
		static void Flush();
		static void ResetRcv();
		static void Listen(bool b);
		static void Start(bool filt);
		static void SendPacket(Header& head, _ValArray<uint8_t> dat);
		int Available();
		static void Receive(uint8_t& x);
		bool Rcvd(int time);
		static void ReceiveHead(Header& head);
		static void Skip(int m);
		static void Stop();

	};
}

#endif // __ObSCC_H__