// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:17
#include "ObSystem.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<System> s_inst;

const _ValArray<char> System::StandardMenu;
const _ValArray<char> System::LogMenu;

System* System::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new System() );
	return s_inst.get();
}

void System::GetArg(Texts::Scanner& S)
{
	// VAR
	Texts::Text T;
	int beg;
	int end;
	int time;

	// BEGIN
	System* _this = _inst();
	Texts::_inst()->OpenScanner(S, Oberon::_inst()->Par.text, Oberon::_inst()->Par.pos);
	Texts::_inst()->Scan(S);
	if( (S.class_ == Texts::_inst()->Char) && (S.c == '^') )
	{
		Oberon::_inst()->GetSelection(T, beg, end, time);
		if( time >= 0 )
		{
			Texts::_inst()->OpenScanner(S, T, beg);
			Texts::_inst()->Scan(S);
		}
	}
	// END
}

void System::EndLine()
{
	// BEGIN
	System* _this = _inst();
	Texts::_inst()->WriteLn(_this->W);
	Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
	// END
}

/*  ------------- Toolbox for system control --------------- */
void System::SetUser()
{
	// VAR
	int i;
	char ch;
	_FxArray<char,8> user;
	_FxArray<char,16> password;

	// BEGIN
	System* _this = _inst();
	i = 0;
	Input::_inst()->Read(ch);
	while( (ch != '/') && (i < 7) )
	{
		user[i] = ch;
		i++;
		Input::_inst()->Read(ch);
	}
	user[i] = 0x0;
	i = 0;
	Input::_inst()->Read(ch);
	while( (ch > ' ') && (i < 15) )
	{
		password[i] = ch;
		i++;
		Input::_inst()->Read(ch);
	}
	password[i] = 0x0;
	Oberon::_inst()->SetUser(user, password);
	// END
}

void System::SetFont()
{
	// VAR
	Texts::Scanner S;

	// BEGIN
	System* _this = _inst();
	_this->GetArg(S);
	if( S.class_ == Texts::_inst()->Name )
		Oberon::_inst()->SetFont(Fonts::_inst()->This(S.s));
	
	// END
}

void System::SetColor()
{
	// VAR
	Texts::Scanner S;

	// BEGIN
	System* _this = _inst();
	_this->GetArg(S);
	if( S.class_ == Texts::_inst()->Int )
		Oberon::_inst()->SetColor(S.i);
	
	// END
}

void System::SetOffset()
{
	// VAR
	Texts::Scanner S;

	// BEGIN
	System* _this = _inst();
	_this->GetArg(S);
	if( S.class_ == Texts::_inst()->Int )
		Oberon::_inst()->SetOffset(S.i);
	
	// END
}

void System::Date()
{
	// VAR
	Texts::Scanner S;
	int dt;
	int hr;
	int min;
	int sec;
	int yr;
	int mo;
	int day;

	// BEGIN
	System* _this = _inst();
	Texts::_inst()->OpenScanner(S, Oberon::_inst()->Par.text, Oberon::_inst()->Par.pos);
	Texts::_inst()->Scan(S);
	/* set clock */
	if( S.class_ == Texts::_inst()->Int )
	{
		day = S.i;
		Texts::_inst()->Scan(S);
		mo = S.i;
		Texts::_inst()->Scan(S);
		yr = S.i;
		Texts::_inst()->Scan(S);
		hr = S.i;
		Texts::_inst()->Scan(S);
		min = S.i;
		Texts::_inst()->Scan(S);
		sec = S.i;
		dt = ((((yr * 16 + mo) * 32 + day) * 32 + hr) * 64 + min) * 64 + sec;
		Kernel::_inst()->SetClock(dt);
	}else
	{
		/* read clock */
		Texts::_inst()->WriteString(_this->W, "System.Clock");
		dt = Oberon::_inst()->Clock();
		Texts::_inst()->WriteClock(_this->W, dt);
		_this->EndLine();
	}
	// END
}

void System::Collect()
{
	// BEGIN
	System* _this = _inst();
	Oberon::_inst()->Collect(0);
	// END
}

/*  ------------- Toolbox for standard display --------------- */
/* open viewer in system track */
void System::Open()
{
	// VAR
	int X;
	int Y;
	Viewers::Viewer V;
	Texts::Scanner S;

	// BEGIN
	System* _this = _inst();
	_this->GetArg(S);
	if( S.class_ == Texts::_inst()->Name )
	{
		Oberon::_inst()->AllocateSystemViewer(Oberon::_inst()->Par.vwr->X, X, Y);
		V = MenuViewers::_inst()->New(TextFrames::_inst()->NewMenu(S.s, _this->StandardMenu), TextFrames::_inst()->NewText(TextFrames::_inst()->Text(S.s), 0), TextFrames::_inst()->menuH, X, Y);
	}
	// END
}

/* clear Log */
void System::Clear()
{
	// VAR
	Texts::Text T;
	Display::Frame F;
	Texts::Buffer buf;

	// BEGIN
	System* _this = _inst();
	F = Oberon::_inst()->Par.frame;
	if( (F != 0) && (dynamic_cast<TextFrames::Frame>(F->next) != 0 ) && (F == Oberon::_inst()->Par.vwr->dsc) )
	{
		buf = new Texts::BufDesc();
		Texts::_inst()->OpenBuf(buf);
		T = F->next->_to<TextFrames::Frame>()->text;
		Texts::_inst()->Delete(T, 0, T->len, buf);
	}
	// END
}

void System::Close()
{
	// VAR
	Viewers::Viewer V;

	// BEGIN
	System* _this = _inst();
	if( Oberon::_inst()->Par.frame == Oberon::_inst()->Par.vwr->dsc )
		V = Oberon::_inst()->Par.vwr;
	else
		V = Oberon::_inst()->MarkedViewer();

	Viewers::_inst()->Close(V);
	// END
}

void System::CloseTrack()
{
	// VAR
	Viewers::Viewer V;

	// BEGIN
	System* _this = _inst();
	V = Oberon::_inst()->MarkedViewer();
	Viewers::_inst()->CloseTrack(V->X);
	// END
}

void System::Recall()
{
	// VAR
	Viewers::Viewer V;
	Viewers::ViewerMsg M;

	// BEGIN
	System* _this = _inst();
	Viewers::_inst()->Recall(V);
	if( (V != 0) && (V->state == 0) )
	{
		Viewers::_inst()->Open(V, V->X, V->Y + V->H);
		M.id = Viewers::_inst()->restore;
		V->handle(V, M);
	}
	// END
}

void System::Copy()
{
	// VAR
	Viewers::Viewer V;
	Viewers::Viewer V1;
	Oberon::CopyMsg M;
	Viewers::ViewerMsg N;

	// BEGIN
	System* _this = _inst();
	V = Oberon::_inst()->Par.vwr;
	V->handle(V, M);
	V1 = M.F->_to<Viewers::Viewer>();
	Viewers::_inst()->Open(V1, V->X, V->Y + DIV(V->H,2));
	N.id = Viewers::_inst()->restore;
	V1->handle(V1, N);
	// END
}

void System::Grow()
{
	// VAR
	Viewers::Viewer V;
	Viewers::Viewer V1;
	Oberon::CopyMsg M;
	Viewers::ViewerMsg N;
	int DW;
	int DH;

	// BEGIN
	System* _this = _inst();
	V = Oberon::_inst()->Par.vwr;
	DW = Oberon::_inst()->DisplayWidth(V->X);
	DH = Oberon::_inst()->DisplayHeight(V->X);
	if( V->H < DH - Viewers::_inst()->minH )
		Oberon::_inst()->OpenTrack(V->X, V->W);
	else if( V->W < DW )
		Oberon::_inst()->OpenTrack(Oberon::_inst()->UserTrack(V->X), DW);
	
	if( (V->H < DH - Viewers::_inst()->minH) || (V->W < DW) )
	{
		V->handle(V, M);
		V1 = M.F->_to<Viewers::Viewer>();
		Viewers::_inst()->Open(V1, V->X, DH);
		N.id = Viewers::_inst()->restore;
		V1->handle(V1, N);
	}
	// END
}

/*  ------------- Toolbox for module management --------------- */
void System::Free1(Texts::Scanner& S)
{
	// BEGIN
	System* _this = _inst();
	Texts::_inst()->WriteString(_this->W, S.s);
	Texts::_inst()->WriteString(_this->W, " unloading");
	Modules::_inst()->Free(S.s);
	if( Modules::_inst()->res != 0 )
		Texts::_inst()->WriteString(_this->W, " failed");
	
	_this->EndLine();
	// END
}

void System::Free()
{
	// VAR
	Texts::Text T;
	int beg;
	int end;
	int time;
	Texts::Scanner S;

	// BEGIN
	System* _this = _inst();
	Texts::_inst()->WriteString(_this->W, "System.Free");
	_this->EndLine();
	Texts::_inst()->OpenScanner(S, Oberon::_inst()->Par.text, Oberon::_inst()->Par.pos);
	Texts::_inst()->Scan(S);
	if( (S.class_ == Texts::_inst()->Char) && (S.c == '^') )
	{
		Oberon::_inst()->GetSelection(T, beg, end, time);
		if( time >= 0 )
		{
			Texts::_inst()->OpenScanner(S, T, beg);
			Texts::_inst()->Scan(S);
			if( S.class_ == Texts::_inst()->Name )
				_this->Free1(S);
			
		}
	}else
		while( S.class_ == Texts::_inst()->Name )
		{
			_this->Free1(S);
			Texts::_inst()->Scan(S);
		}

	Oberon::_inst()->Collect(0);
	// END
}

void System::FreeFonts()
{
	// BEGIN
	System* _this = _inst();
	Texts::_inst()->WriteString(_this->W, "System.FreeFonts");
	Fonts::_inst()->Free();
	_this->EndLine();
	// END
}

/*  ------------- Toolbox of file system --------------- */
void System::List(_ValArray<char> name, int adr, bool& cont)
{
	// VAR
	int i0;
	int i;
	int j0;
	int j;
	FileDir::FileHeader hp;

	// BEGIN
	System* _this = _inst();
	i = 0;
	while( (_this->pat[i] > '*') && (_this->pat[i] == name[i]) )
		i++;
	
	if( (_this->pat[i] == 0x0) && (name[i] == 0x0) )
	{
		i0 = i;
		j0 = i;
	}else if( _this->pat[i] == '*' )
	{
		i0 = i;
		j0 = i + 1;
		while( name[i0] != 0x0 )
		{
			i = i0;
			j = j0;
			while( (name[i] != 0x0) && (name[i] == _this->pat[j]) )
			{
				i++;
				j++;
			}
			if( _this->pat[j] == 0x0 )
			{
				/* match */
				if( name[i] == 0x0 )
					j0 = j;
				else
					i0++;

			}else if( _this->pat[j] == '*' )
			{
				i0 = i;
				j0 = j + 1;
			}else
				i0++;

		}
	}
	/* found */
	if( (name[i0] == 0x0) && (_this->pat[j0] == 0x0) )
	{
		Texts::_inst()->WriteString(_this->W, name);
		/* option */
		if( _this->pat[j0 + 1] == '!' )
		{
			Kernel::_inst()->GetSector(adr, hp);
			Texts::_inst()->Write(_this->W, 0x9);
			Texts::_inst()->WriteClock(_this->W, hp.date);
			/* length */
			Texts::_inst()->WriteInt(_this->W, hp.aleng * FileDir::_inst()->SectorSize + hp.bleng - FileDir::_inst()->HeaderSize, 8);
		}
		/* Texts.WriteHex(W, adr) */
		Texts::_inst()->WriteLn(_this->W);
	}
	// END
}

void System::Directory()
{
	// VAR
	int X;
	int Y;
	int i;
	char ch;
	Texts::Reader R;
	Texts::Text T;
	Texts::Text t;
	Viewers::Viewer V;
	int beg;
	int end;
	int time;
	_FxArray<char,32> pre;

	// BEGIN
	System* _this = _inst();
	Texts::_inst()->OpenReader(R, Oberon::_inst()->Par.text, Oberon::_inst()->Par.pos);
	Texts::_inst()->Read(R, ch);
	while( ch == ' ' )
		Texts::_inst()->Read(R, ch);
	
	if( (ch == '^') || (ch == 0x0D) )
	{
		Oberon::_inst()->GetSelection(T, beg, end, time);
		if( time >= 0 )
		{
			Texts::_inst()->OpenReader(R, T, beg);
			Texts::_inst()->Read(R, ch);
			while( ch <= ' ' )
				Texts::_inst()->Read(R, ch);
			
		}
	}
	i = 0;
	while( ch > '!' )
	{
		_this->pat[i] = ch;
		i++;
		Texts::_inst()->Read(R, ch);
	}
	_this->pat[i] = 0x0;
	/* directory option */
	if( ch == '!' )
		_this->pat[i + 1] = '!';
	
	i = 0;
	while( _this->pat[i] > '*' )
	{
		pre[i] = _this->pat[i];
		i++;
	}
	pre[i] = 0x0;
	Oberon::_inst()->AllocateSystemViewer(Oberon::_inst()->Par.vwr->X, X, Y);
	t = TextFrames::_inst()->Text("");
	V = MenuViewers::_inst()->New(TextFrames::_inst()->NewMenu("System.Directory", _this->StandardMenu), TextFrames::_inst()->NewText(t, 0), TextFrames::_inst()->menuH, X, Y);
	FileDir::_inst()->Enumerate(pre, _this->List);
	Texts::_inst()->Append(t, _this->W.buf);
	// END
}

void System::CopyFiles()
{
	// VAR
	Files::File f;
	Files::File g;
	Files::Rider Rf;
	Files::Rider Rg;
	char ch;
	_FxArray<char,32> name;
	Texts::Scanner S;

	// BEGIN
	System* _this = _inst();
	_this->GetArg(S);
	Texts::_inst()->WriteString(_this->W, "System.CopyFiles");
	_this->EndLine();
	while( S.class_ == Texts::_inst()->Name )
	{
		name = S.s;
		Texts::_inst()->Scan(S);
		if( (S.class_ == Texts::_inst()->Char) && (S.c == '=') )
		{
			Texts::_inst()->Scan(S);
			if( (S.class_ == Texts::_inst()->Char) && (S.c == '>') )
			{
				Texts::_inst()->Scan(S);
				if( S.class_ == Texts::_inst()->Name )
				{
					Texts::_inst()->WriteString(_this->W, name);
					Texts::_inst()->WriteString(_this->W, " => ");
					Texts::_inst()->WriteString(_this->W, S.s);
					Texts::_inst()->WriteString(_this->W, " copying");
					Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
					f = Files::_inst()->Old(name);
					if( f != 0 )
					{
						g = Files::_inst()->New(S.s);
						Files::_inst()->Set(Rf, f, 0);
						Files::_inst()->Set(Rg, g, 0);
						Files::_inst()->Read(Rf, ch);
						while( !Rf.eof )
						{
							Files::_inst()->Write(Rg, ch);
							Files::_inst()->Read(Rf, ch);
						}
						Files::_inst()->Register(g);
					}else
						Texts::_inst()->WriteString(_this->W, " failed");

					_this->EndLine();
				}
			}
		}
		Texts::_inst()->Scan(S);
	}
	// END
}

void System::RenameFiles()
{
	// VAR
	int res;
	_FxArray<char,32> name;
	Texts::Scanner S;

	// BEGIN
	System* _this = _inst();
	_this->GetArg(S);
	Texts::_inst()->WriteString(_this->W, "System.RenameFiles");
	_this->EndLine();
	while( S.class_ == Texts::_inst()->Name )
	{
		name = S.s;
		Texts::_inst()->Scan(S);
		if( (S.class_ == Texts::_inst()->Char) && (S.c == '=') )
		{
			Texts::_inst()->Scan(S);
			if( (S.class_ == Texts::_inst()->Char) && (S.c == '>') )
			{
				Texts::_inst()->Scan(S);
				if( S.class_ == Texts::_inst()->Name )
				{
					Texts::_inst()->WriteString(_this->W, name);
					Texts::_inst()->WriteString(_this->W, " => ");
					Texts::_inst()->WriteString(_this->W, S.s);
					Texts::_inst()->WriteString(_this->W, " renaming");
					Files::_inst()->Rename(name, S.s, res);
					if( res > 1 )
						Texts::_inst()->WriteString(_this->W, " failed");
					
					_this->EndLine();
				}
			}
		}
		Texts::_inst()->Scan(S);
	}
	// END
}

void System::DeleteFiles()
{
	// VAR
	int res;
	Texts::Scanner S;

	// BEGIN
	System* _this = _inst();
	_this->GetArg(S);
	Texts::_inst()->WriteString(_this->W, "System.DeleteFiles");
	_this->EndLine();
	while( S.class_ == Texts::_inst()->Name )
	{
		Texts::_inst()->WriteString(_this->W, S.s);
		Texts::_inst()->WriteString(_this->W, " deleting");
		Files::_inst()->Delete(S.s, res);
		if( res != 0 )
			Texts::_inst()->WriteString(_this->W, " failed");
		
		_this->EndLine();
		Texts::_inst()->Scan(S);
	}
	// END
}

/*  ------------- Toolbox for system inspection --------------- */
void System::Watch()
{
	// BEGIN
	System* _this = _inst();
	Texts::_inst()->WriteString(_this->W, "System.Watch");
	Texts::_inst()->WriteLn(_this->W);
	Texts::_inst()->WriteString(_this->W, "  Modules space (bytes)");
	Texts::_inst()->WriteInt(_this->W, Modules::_inst()->AllocPtr, 8);
	Texts::_inst()->WriteInt(_this->W, DIV(Modules::_inst()->AllocPtr * 100,Kernel::_inst()->heapOrg), 4);
	Texts::_inst()->Write(_this->W, '%');
	_this->EndLine();
	Texts::_inst()->WriteString(_this->W, "  Heap speace");
	Texts::_inst()->WriteInt(_this->W, Kernel::_inst()->allocated, 8);
	Texts::_inst()->WriteInt(_this->W, DIV(Kernel::_inst()->allocated * 100,(Kernel::_inst()->heapLim - Kernel::_inst()->heapOrg)), 4);
	Texts::_inst()->Write(_this->W, '%');
	_this->EndLine();
	Texts::_inst()->WriteString(_this->W, "  Disk sectors ");
	Texts::_inst()->WriteInt(_this->W, Kernel::_inst()->NofSectors, 4);
	Texts::_inst()->WriteInt(_this->W, DIV(Kernel::_inst()->NofSectors * 100,0x10000), 4);
	Texts::_inst()->Write(_this->W, '%');
	_this->EndLine();
	Texts::_inst()->WriteString(_this->W, "  Tasks");
	Texts::_inst()->WriteInt(_this->W, Oberon::_inst()->NofTasks, 4);
	_this->EndLine();
	// END
}

void System::ShowModules()
{
	// VAR
	Texts::Text T;
	Viewers::Viewer V;
	Modules::Module M;
	int X;
	int Y;

	// BEGIN
	System* _this = _inst();
	T = TextFrames::_inst()->Text("");
	Oberon::_inst()->AllocateSystemViewer(Oberon::_inst()->Par.vwr->X, X, Y);
	V = MenuViewers::_inst()->New(TextFrames::_inst()->NewMenu("System.ShowModules", _this->StandardMenu), TextFrames::_inst()->NewText(T, 0), TextFrames::_inst()->menuH, X, Y);
	M = Modules::_inst()->root;
	while( M != 0 )
	{
		if( M->name[0] != 0x0 )
		{
			Texts::_inst()->WriteString(_this->W, M->name);
			Texts::_inst()->Write(_this->W, 0x9);
			Texts::_inst()->WriteHex(_this->W, int( M ));
			Texts::_inst()->WriteHex(_this->W, M->code);
			Texts::_inst()->WriteInt(_this->W, M->refcnt, 4);
		}else
			Texts::_inst()->WriteString(_this->W, "---");

		Texts::_inst()->WriteLn(_this->W);
		M = M->next;
	}
	Texts::_inst()->Append(T, _this->W.buf);
	// END
}

void System::ShowCommands()
{
	// VAR
	Modules::Module M;
	int comadr;
	char ch;
	Texts::Text T;
	Texts::Scanner S;
	Viewers::Viewer V;
	int X;
	int Y;

	// BEGIN
	System* _this = _inst();
	_this->GetArg(S);
	if( S.class_ == Texts::_inst()->Name )
	{
		Modules::_inst()->Load(S.s, M);
		if( M != 0 )
		{
			Oberon::_inst()->AllocateSystemViewer(Oberon::_inst()->Par.vwr->X, X, Y);
			T = TextFrames::_inst()->Text("");
			V = MenuViewers::_inst()->New(TextFrames::_inst()->NewMenu("System.Commands", _this->StandardMenu), TextFrames::_inst()->NewText(T, 0), TextFrames::_inst()->menuH, X, Y);
			comadr = M->cmd;
			SYSTEM::_inst()->GET(comadr, ch);
			comadr++;
			while( ch != 0x0 )
			{
				Texts::_inst()->WriteString(_this->W, S.s);
				Texts::_inst()->Write(_this->W, '.');
				do 
				{
					Texts::_inst()->Write(_this->W, ch);
					SYSTEM::_inst()->GET(comadr, ch);
					comadr++;
				} while( !( ch == 0x0 ) );
				while( MOD(comadr,4) != 0 )
					comadr++;
				
				Texts::_inst()->WriteLn(_this->W);
				comadr += 4;
				SYSTEM::_inst()->GET(comadr, ch);
				comadr++;
			}
			Texts::_inst()->Append(T, _this->W.buf);
		}
	}
	// END
}

void System::ShowFonts()
{
	// VAR
	Fonts::Font fnt;

	// BEGIN
	System* _this = _inst();
	Texts::_inst()->WriteString(_this->W, "System.ShowFonts");
	Texts::_inst()->WriteLn(_this->W);
	fnt = Fonts::_inst()->root;
	while( fnt != 0 )
	{
		Texts::_inst()->Write(_this->W, 0x9);
		Texts::_inst()->WriteString(_this->W, fnt->name);
		Texts::_inst()->WriteLn(_this->W);
		fnt = fnt->next;
	}
	Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
	// END
}

void System::OpenViewers()
{
	// VAR
	Viewers::Viewer logV;
	Viewers::Viewer toolV;
	Display::Frame menu;
	Display::Frame main;
	int d;
	int X;
	int Y;

	// BEGIN
	System* _this = _inst();
	d = Kernel::_inst()->Clock();
	Texts::_inst()->WriteString(_this->W, "Oberon V5  NW 14.4.2013");
	_this->EndLine();
	Oberon::_inst()->AllocateSystemViewer(0, X, Y);
	menu = TextFrames::_inst()->NewMenu("System.Log", _this->LogMenu);
	main = TextFrames::_inst()->NewText(Oberon::_inst()->Log, 0);
	logV = MenuViewers::_inst()->New(menu, main, TextFrames::_inst()->menuH, X, Y);
	Oberon::_inst()->AllocateSystemViewer(0, X, Y);
	menu = TextFrames::_inst()->NewMenu("System.Tool", _this->StandardMenu);
	main = TextFrames::_inst()->NewText(TextFrames::_inst()->Text("System.Tool"), 0);
	toolV = MenuViewers::_inst()->New(menu, main, TextFrames::_inst()->menuH, X, Y);
	// END
}

void System::ExtendDisplay()
{
	// VAR
	Viewers::Viewer V;
	int X;
	int Y;
	int DX;
	int DW;
	int DH;
	Texts::Scanner S;

	// BEGIN
	System* _this = _inst();
	_this->GetArg(S);
	if( S.class_ == Texts::_inst()->Name )
	{
		DX = Viewers::_inst()->curW;
		DW = Oberon::_inst()->DisplayWidth(DX);
		DH = Oberon::_inst()->DisplayHeight(DX);
		Oberon::_inst()->OpenDisplay(DIV(DW,8) * 5, DIV(DW,8) * 3, DH);
		Oberon::_inst()->AllocateSystemViewer(DX, X, Y);
		V = MenuViewers::_inst()->New(TextFrames::_inst()->NewMenu(S.s, _this->StandardMenu), TextFrames::_inst()->NewText(TextFrames::_inst()->Text(S.s), 0), TextFrames::_inst()->menuH, X, Y);
	}
	// END
}

void System::Trap(int& a, int b)
{
	// VAR
	int u;
	int v;
	int w;
	Modules::Module mod;

	// BEGIN
	System* _this = _inst();
	/* trap number */
	u = SYSTEM::_inst()->REG(15);
	SYSTEM::_inst()->GET(u - 4, v);
	w = MOD(DIV(v,0x10),0x10);
	if( w == 0 )
		Kernel::_inst()->New(a, b);
	else
	{
		/* trap */
		Texts::_inst()->WriteLn(_this->W);
		Texts::_inst()->WriteString(_this->W, "  pos ");
		Texts::_inst()->WriteInt(_this->W, MOD(DIV(v,0x100),0x10000), 4);
		Texts::_inst()->WriteString(_this->W, "  TRAP");
		Texts::_inst()->WriteInt(_this->W, w, 4);
		mod = Modules::_inst()->root;
		while( (mod != 0) && ((u < mod->code) || (u >= mod->imp)) )
			mod = mod->next;
		
		if( mod != 0 )
		{
			Texts::_inst()->WriteString(_this->W, " in ");
			Texts::_inst()->WriteString(_this->W, mod->name);
		}
		Texts::_inst()->WriteString(_this->W, " at");
		Texts::_inst()->WriteHex(_this->W, u);
		Texts::_inst()->WriteLn(_this->W);
		Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
		Oberon::_inst()->Reset();
	}
	// END
}

void System::Abort()
{
	// VAR
	int n;

	// BEGIN
	System* _this = _inst();
	n = SYSTEM::_inst()->REG(15);
	Texts::_inst()->WriteString(_this->W, "  ABORT  ");
	Texts::_inst()->WriteHex(_this->W, n);
	Texts::_inst()->WriteLn(_this->W);
	Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
	Oberon::_inst()->Reset();
	// END
}

System::System()
{
	// BEGIN
	Texts::_inst()->OpenWriter(W);
	Oberon::_inst()->OpenLog(TextFrames::_inst()->Text(""));
	OpenViewers();
	Kernel::_inst()->Install(SYSTEM::_inst()->ADR(Trap), 0x20);
	Kernel::_inst()->Install(SYSTEM::_inst()->ADR(Abort), 0);
	// END
}

System::~System()
{
	s_inst.release();
}

