// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:18
#include "ObTextFrames.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<TextFrames> s_inst;

const int TextFrames::replace;
const int TextFrames::insert;
const int TextFrames::delete_;
const int TextFrames::unmark;
const char TextFrames::BS;
const char TextFrames::TAB;
const char TextFrames::CR;
const char TextFrames::DEL;

TextFrames* TextFrames::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new TextFrames() );
	return s_inst.get();
}

int TextFrames::Min(int i, int j)
{
	// BEGIN
	TextFrames* _this = _inst();
	if( i < j )
		j = i;
	
	return j;
	// END
}

/* ------------------display support------------------------ */
void TextFrames::ReplConst(int col, Frame F, int X, int Y, int W, int H, int mode)
{
	// BEGIN
	TextFrames* _this = _inst();
	if( X + W <= F->X + F->W )
		Display::_inst()->ReplConst(col, X, Y, W, H, mode);
	else if( X < F->X + F->W )
		Display::_inst()->ReplConst(col, X, Y, F->X + F->W - X, H, mode);
	
	// END
}

void TextFrames::FlipSM(int X, int Y)
{
	// VAR
	int DW;
	int DH;
	int CL;

	// BEGIN
	TextFrames* _this = _inst();
	DW = Display::_inst()->Width;
	DH = Display::_inst()->Height;
	CL = DW;
	if( X < CL )
	{
		if( X < 3 )
			X = 3;
		else if( X > DW - 4 )
			X = DW - 4;
		
	}else
	{
		if( X < CL + 3 )
			X = CL + 4;
		else if( X > CL + DW - 4 )
			X = CL + DW - 4;
		
	}
	if( Y < 6 )
		Y = 6;
	else if( Y > DH - 6 )
		Y = DH - 6;
	
	Display::_inst()->CopyPattern(Display::_inst()->white, Display::_inst()->updown, X - 4, Y - 4, Display::_inst()->invert);
	// END
}

/* in scroll bar */
void TextFrames::UpdateMark(Frame F)
{
	// VAR
	int oldH;

	// BEGIN
	TextFrames* _this = _inst();
	oldH = F->markH;
	F->markH = DIV(F->org_ * F->H,(F->text->len + 1));
	if( F->hasMark && (F->left >= _this->barW) && (F->markH != oldH) )
	{
		Display::_inst()->ReplConst(Display::_inst()->white, F->X + 1, F->Y + F->H - 1 - oldH, _this->markW, 1, Display::_inst()->invert);
		Display::_inst()->ReplConst(Display::_inst()->white, F->X + 1, F->Y + F->H - 1 - F->markH, _this->markW, 1, Display::_inst()->invert);
	}
	// END
}

/* in corner */
void TextFrames::SetChangeMark(Frame F, bool on)
{
	// BEGIN
	TextFrames* _this = _inst();
	if( F->H > _this->menuH )
	{
		if( on )
			Display::_inst()->CopyPattern(Display::_inst()->white, Display::_inst()->block, F->X + F->W - 12, F->Y + F->H - 12, Display::_inst()->paint);
		else
			Display::_inst()->ReplConst(F->col, F->X + F->W - 12, F->Y + F->H - 12, 8, 8, Display::_inst()->replace);

	}
	// END
}

int TextFrames::Width(Texts::Reader& R, int len)
{
	// VAR
	int patadr;
	int pos;
	int ox;
	int dx;
	int x;
	int y;
	int w;
	int h;

	// BEGIN
	TextFrames* _this = _inst();
	pos = 0;
	ox = 0;
	while( pos < len )
	{
		Fonts::_inst()->GetPat(R.fnt, _this->nextCh, dx, x, y, w, h, patadr);
		ox = ox + dx;
		pos++;
		Texts::_inst()->Read(R, _this->nextCh);
	}
	return ox;
	// END
}

void TextFrames::DisplayLine(Frame F, Line L, Texts::Reader& R, int X, int Y, int len)
{
	// VAR
	int patadr;
	int NX;
	int dx;
	int x;
	int y;
	int w;
	int h;

	// BEGIN
	TextFrames* _this = _inst();
	NX = F->X + F->W;
	while( (_this->nextCh != _this->CR) && (R.fnt != 0) )
	{
		Fonts::_inst()->GetPat(R.fnt, _this->nextCh, dx, x, y, w, h, patadr);
		if( (X + x + w <= NX) && (h != 0) )
			Display::_inst()->CopyPattern(R.col, patadr, X + x, Y + y, Display::_inst()->invert);
		
		X = X + dx;
		len++;
		Texts::_inst()->Read(R, _this->nextCh);
	}
	L->len = len + 1;
	L->wid = X + _this->eolW - (F->X + F->left);
	L->eot = R.fnt == 0;
	Texts::_inst()->Read(R, _this->nextCh);
	// END
}

void TextFrames::Validate(Texts::Text T, int& pos)
{
	// VAR
	Texts::Reader R;

	// BEGIN
	TextFrames* _this = _inst();
	if( pos > T->len )
		pos = T->len;
	else if( pos > 0 )
	{
		pos--;
		Texts::_inst()->OpenReader(R, T, pos);
		do 
		{
			Texts::_inst()->Read(R, _this->nextCh);
			pos++;
		} while( !( R.eot || (_this->nextCh == _this->CR) ) );
	}else
		pos = 0;

	// END
}

void TextFrames::Mark(Frame F, bool on)
{
	// BEGIN
	TextFrames* _this = _inst();
	if( (F->H > 0) && (F->left >= _this->barW) && ((F->hasMark && !on) || (!F->hasMark && on)) )
		Display::_inst()->ReplConst(Display::_inst()->white, F->X + 1, F->Y + F->H - 1 - F->markH, _this->markW, 1, Display::_inst()->invert);
	
	F->hasMark = on;
	// END
}

void TextFrames::Restore(Frame F)
{
	// VAR
	Texts::Reader R;
	Line L;
	Line l;
	int curY;
	int botY;

	// BEGIN
	TextFrames* _this = _inst();
	Display::_inst()->ReplConst(F->col, F->X, F->Y, F->W, F->H, Display::_inst()->replace);
	if( F->left >= _this->barW )
		Display::_inst()->ReplConst(Display::_inst()->white, F->X + _this->barW - 1, F->Y, 1, F->H, Display::_inst()->invert);
	
	_this->Validate(F->text, F->org_);
	botY = F->Y + F->bot + _this->dsr;
	Texts::_inst()->OpenReader(R, F->text, F->org_);
	Texts::_inst()->Read(R, _this->nextCh);
	L = F->trailer;
	curY = F->Y + F->H - F->top - _this->asr;
	while( !L->eot && (curY >= botY) )
	{
		l = new TextFrames::LineDesc();
		_this->DisplayLine(F, l, R, F->X + F->left, curY, 0);
		L->next = l;
		L = l;
		curY = curY - _this->lsp;
	}
	L->next = F->trailer;
	F->markH = DIV(F->org_ * F->H,(F->text->len + 1));
	// END
}

void TextFrames::Suspend(Frame F)
{
	// BEGIN
	TextFrames* _this = _inst();
	F->trailer->next = F->trailer;
	// END
}

void TextFrames::Extend(Frame F, int newY_)
{
	// VAR
	Texts::Reader R;
	Line L;
	Line l;
	int org_;
	int curY;
	int botY;

	// BEGIN
	TextFrames* _this = _inst();
	Display::_inst()->ReplConst(F->col, F->X, newY_, F->W, F->Y - newY_, Display::_inst()->replace);
	if( F->left >= _this->barW )
		Display::_inst()->ReplConst(Display::_inst()->white, F->X + _this->barW - 1, newY_, 1, F->Y - newY_, Display::_inst()->invert);
	
	botY = F->Y + F->bot + _this->dsr;
	F->H = F->H + F->Y - newY_;
	F->Y = newY_;
	if( F->trailer->next == F->trailer )
		_this->Validate(F->text, F->org_);
	
	L = F->trailer;
	org_ = F->org_;
	curY = F->Y + F->H - F->top - _this->asr;
	while( (L->next != F->trailer) && (curY >= botY) )
	{
		L = L->next;
		org_ = org_ + L->len;
		curY = curY - _this->lsp;
	}
	botY = F->Y + F->bot + _this->dsr;
	Texts::_inst()->OpenReader(R, F->text, org_);
	Texts::_inst()->Read(R, _this->nextCh);
	while( !L->eot && (curY >= botY) )
	{
		l = new TextFrames::LineDesc();
		_this->DisplayLine(F, l, R, F->X + F->left, curY, 0);
		L->next = l;
		L = l;
		curY = curY - _this->lsp;
	}
	L->next = F->trailer;
	F->markH = DIV(F->org_ * F->H,(F->text->len + 1));
	// END
}

void TextFrames::Reduce(Frame F, int newY_)
{
	// VAR
	Line L;
	int curY;
	int botY;

	// BEGIN
	TextFrames* _this = _inst();
	F->H = F->H + F->Y - newY_;
	F->Y = newY_;
	botY = F->Y + F->bot + _this->dsr;
	L = F->trailer;
	curY = F->Y + F->H - F->top - _this->asr;
	while( (L->next != F->trailer) && (curY >= botY) )
	{
		L = L->next;
		curY = curY - _this->lsp;
	}
	L->next = F->trailer;
	if( curY + _this->asr > F->Y )
		Display::_inst()->ReplConst(F->col, F->X + F->left, F->Y, F->W - F->left, curY + _this->asr - F->Y, Display::_inst()->replace);
	
	F->markH = DIV(F->org_ * F->H,(F->text->len + 1));
	_this->Mark(F, TRUE);
	// END
}

void TextFrames::Show(Frame F, int pos)
{
	// VAR
	Texts::Reader R;
	Line L;
	Line L0;
	int org_;
	int curY;
	int botY;
	int Y0;

	// BEGIN
	TextFrames* _this = _inst();
	if( F->trailer->next != F->trailer )
	{
		_this->Validate(F->text, pos);
		if( pos < F->org_ )
		{
			_this->Mark(F, FALSE);
			Display::_inst()->ReplConst(F->col, F->X + F->left, F->Y, F->W - F->left, F->H, Display::_inst()->replace);
			botY = F->Y;
			F->Y = F->Y + F->H;
			F->H = 0;
			F->org_ = pos;
			F->trailer->next = F->trailer;
			_this->Extend(F, botY);
			_this->Mark(F, TRUE);
		}else if( pos > F->org_ )
		{
			org_ = F->org_;
			L = F->trailer->next;
			curY = F->Y + F->H - F->top - _this->asr;
			while( (L->next != F->trailer) && (org_ != pos) )
			{
				org_ = org_ + L->len;
				L = L->next;
				curY = curY - _this->lsp;
			}
			if( org_ == pos )
			{
				F->org_ = org_;
				F->trailer->next = L;
				Y0 = curY;
				/* ! */
				while( L->next != F->trailer )
				{
					org_ = org_ + L->len;
					L = L->next;
					curY = curY - _this->lsp;
				}
				Display::_inst()->CopyBlock(F->X + F->left, curY - _this->dsr, F->W - F->left, Y0 + _this->asr - (curY - _this->dsr), F->X + F->left, curY - _this->dsr + F->Y + F->H - F->top - _this->asr - Y0, 0);
				curY = curY + F->Y + F->H - F->top - _this->asr - Y0;
				Display::_inst()->ReplConst(F->col, F->X + F->left, F->Y, F->W - F->left, curY - _this->dsr - F->Y, Display::_inst()->replace);
				botY = F->Y + F->bot + _this->dsr;
				org_ = org_ + L->len;
				curY = curY - _this->lsp;
				Texts::_inst()->OpenReader(R, F->text, org_);
				Texts::_inst()->Read(R, _this->nextCh);
				while( !L->eot && (curY >= botY) )
				{
					L0 = new TextFrames::LineDesc();
					_this->DisplayLine(F, L0, R, F->X + F->left, curY, 0);
					L->next = L0;
					L = L0;
					curY = curY - _this->lsp;
				}
				L->next = F->trailer;
				_this->UpdateMark(F);
			}else
			{
				_this->Mark(F, FALSE);
				Display::_inst()->ReplConst(F->col, F->X + F->left, F->Y, F->W - F->left, F->H, Display::_inst()->replace);
				botY = F->Y;
				F->Y = F->Y + F->H;
				F->H = 0;
				F->org_ = pos;
				F->trailer->next = F->trailer;
				_this->Extend(F, botY);
				_this->Mark(F, TRUE);
			}
		}
	}
	_this->SetChangeMark(F, F->text->changed);
	// END
}

void TextFrames::LocateLine(Frame F, int y, Location& loc)
{
	// VAR
	Line L;
	int org_;
	int cury;

	// BEGIN
	TextFrames* _this = _inst();
	org_ = F->org_;
	L = F->trailer->next;
	cury = F->H - F->top - _this->asr;
	while( (L->next != F->trailer) && (cury > y + _this->dsr) )
	{
		org_ = org_ + L->len;
		L = L->next;
		cury = cury - _this->lsp;
	}
	loc.org_ = org_;
	loc.lin = L;
	loc.y = cury;
	// END
}

void TextFrames::LocateString(Frame F, int x, int y, Location& loc)
{
	// VAR
	Texts::Reader R;
	int patadr;
	int bpos;
	int pos;
	int lim;
	int bx;
	int ex;
	int ox;
	int dx;
	int u;
	int v;
	int w;
	int h;

	// BEGIN
	TextFrames* _this = _inst();
	_this->LocateLine(F, y, loc);
	lim = loc.org_ + loc.lin->len - 1;
	bpos = loc.org_;
	bx = F->left;
	pos = loc.org_;
	ox = F->left;
	Texts::_inst()->OpenReader(R, F->text, loc.org_);
	Texts::_inst()->Read(R, _this->nextCh);
	do 
	{
		/* scan string */
		while( (pos != lim) && (_this->nextCh > ' ') )
		{
			Fonts::_inst()->GetPat(R.fnt, _this->nextCh, dx, u, v, w, h, patadr);
			pos++;
			ox = ox + dx;
			Texts::_inst()->Read(R, _this->nextCh);
		}
		ex = ox;
		/* scan gap */
		while( (pos != lim) && (_this->nextCh <= ' ') )
		{
			Fonts::_inst()->GetPat(R.fnt, _this->nextCh, dx, u, v, w, h, patadr);
			pos++;
			ox = ox + dx;
			Texts::_inst()->Read(R, _this->nextCh);
		}
		if( (pos != lim) && (ox <= x) )
		{
			Fonts::_inst()->GetPat(R.fnt, _this->nextCh, dx, u, v, w, h, patadr);
			bpos = pos;
			bx = ox;
			pos++;
			ox = ox + dx;
			Texts::_inst()->Read(R, _this->nextCh);
		}else
			pos = lim;

	} while( !( pos == lim ) );
	loc.pos = bpos;
	loc.dx = ex - bx;
	loc.x = bx;
	// END
}

void TextFrames::LocateChar(Frame F, int x, int y, Location& loc)
{
	// VAR
	Texts::Reader R;
	int patadr;
	int pos;
	int lim;
	int ox;
	int dx;
	int u;
	int v;
	int w;
	int h;

	// BEGIN
	TextFrames* _this = _inst();
	_this->LocateLine(F, y, loc);
	lim = loc.org_ + loc.lin->len - 1;
	pos = loc.org_;
	ox = F->left;
	dx = _this->eolW;
	Texts::_inst()->OpenReader(R, F->text, loc.org_);
	while( pos != lim )
	{
		Texts::_inst()->Read(R, _this->nextCh);
		Fonts::_inst()->GetPat(R.fnt, _this->nextCh, dx, u, v, w, h, patadr);
		if( ox + dx <= x )
		{
			pos++;
			ox = ox + dx;
			if( pos == lim )
				dx = _this->eolW;
			
		}else
			lim = pos;

	}
	loc.pos = pos;
	loc.dx = dx;
	loc.x = ox;
	// END
}

void TextFrames::LocatePos(Frame F, int pos, Location& loc)
{
	// VAR
	Texts::Text T;
	Texts::Reader R;
	Line L;
	int org_;
	int cury;

	// BEGIN
	TextFrames* _this = _inst();
	T = F->text;
	org_ = F->org_;
	L = F->trailer->next;
	cury = F->H - F->top - _this->asr;
	if( pos < org_ )
		pos = org_;
	
	while( (L->next != F->trailer) && (pos >= org_ + L->len) )
	{
		org_ = org_ + L->len;
		L = L->next;
		cury = cury - _this->lsp;
	}
	if( pos >= org_ + L->len )
		pos = org_ + L->len - 1;
	
	Texts::_inst()->OpenReader(R, T, org_);
	Texts::_inst()->Read(R, _this->nextCh);
	loc.org_ = org_;
	loc.pos = pos;
	loc.lin = L;
	loc.x = F->left + _this->Width(R, pos - org_);
	loc.y = cury;
	// END
}

int TextFrames::Pos(Frame F, int X, int Y)
{
	// VAR
	Location loc;

	// BEGIN
	TextFrames* _this = _inst();
	_this->LocateChar(F, X - F->X, Y - F->Y, loc);
	return loc.pos;
	// END
}

void TextFrames::FlipCaret(Frame F)
{
	// BEGIN
	TextFrames* _this = _inst();
	if( (F->carloc.x < F->W) && (F->carloc.y >= 10) && (F->carloc.x + 12 < F->W) )
		Display::_inst()->CopyPattern(Display::_inst()->white, Display::_inst()->hook, F->X + F->carloc.x, F->Y + F->carloc.y - 10, Display::_inst()->invert);
	
	// END
}

void TextFrames::SetCaret(Frame F, int pos)
{
	// BEGIN
	TextFrames* _this = _inst();
	_this->LocatePos(F, pos, F->carloc);
	_this->FlipCaret(F);
	F->hasCar = TRUE;
	// END
}

void TextFrames::TrackCaret(Frame F, int X, int Y, _Set& keysum)
{
	// VAR
	Location loc;
	_Set keys;

	// BEGIN
	TextFrames* _this = _inst();
	if( F->trailer->next != F->trailer )
	{
		_this->LocateChar(F, X - F->X, Y - F->Y, F->carloc);
		_this->FlipCaret(F);
		keysum = ( _Set() );
		do 
		{
			Input::_inst()->Mouse(keys, X, Y);
			keysum = keysum + keys;
			Oberon::_inst()->DrawMouseArrow(X, Y);
			_this->LocateChar(F, X - F->X, Y - F->Y, loc);
			if( loc.pos != F->carloc.pos )
			{
				_this->FlipCaret(F);
				F->carloc = loc;
				_this->FlipCaret(F);
			}
		} while( !( keys == ( _Set() ) ) );
		F->hasCar = TRUE;
	}
	// END
}

void TextFrames::RemoveCaret(Frame F)
{
	// BEGIN
	TextFrames* _this = _inst();
	if( F->hasCar )
	{
		_this->FlipCaret(F);
		F->hasCar = FALSE;
	}
	// END
}

void TextFrames::FlipSelection(Frame F, Location& beg, Location& end)
{
	// VAR
	Line L;
	int Y;

	// BEGIN
	TextFrames* _this = _inst();
	L = beg.lin;
	Y = F->Y + beg.y - 2;
	if( L == end.lin )
		_this->ReplConst(Display::_inst()->white, F, F->X + beg.x, Y, end.x - beg.x, _this->selH, Display::_inst()->invert);
	else
	{
		_this->ReplConst(Display::_inst()->white, F, F->X + beg.x, Y, F->left + L->wid - beg.x, _this->selH, Display::_inst()->invert);
		L = L->next;
		Y = Y - _this->lsp;
		while( L != end.lin )
		{
			_this->ReplConst(Display::_inst()->white, F, F->X + F->left, Y, L->wid, _this->selH, Display::_inst()->invert);
			L = L->next;
			Y = Y - _this->lsp;
		}
		_this->ReplConst(Display::_inst()->white, F, F->X + F->left, Y, end.x - F->left, _this->selH, Display::_inst()->invert);
	}
	// END
}

void TextFrames::SetSelection(Frame F, int beg, int end)
{
	// BEGIN
	TextFrames* _this = _inst();
	if( F->hasSel )
		_this->FlipSelection(F, F->selbeg, F->selend);
	
	_this->LocatePos(F, beg, F->selbeg);
	_this->LocatePos(F, end, F->selend);
	if( F->selbeg.pos < F->selend.pos )
	{
		_this->FlipSelection(F, F->selbeg, F->selend);
		F->time = Oberon::_inst()->Time();
		F->hasSel = TRUE;
	}
	// END
}

void TextFrames::TrackSelection(Frame F, int X, int Y, _Set& keysum)
{
	// VAR
	Location loc;
	_Set keys;

	// BEGIN
	TextFrames* _this = _inst();
	if( F->trailer->next != F->trailer )
	{
		if( F->hasSel )
			_this->FlipSelection(F, F->selbeg, F->selend);
		
		_this->LocateChar(F, X - F->X, Y - F->Y, loc);
		if( F->hasSel && (loc.pos == F->selbeg.pos) && (F->selend.pos == F->selbeg.pos + 1) )
			_this->LocateChar(F, F->left, Y - F->Y, F->selbeg);
		else
			F->selbeg = loc;

		loc.pos++;
		loc.x = loc.x + loc.dx;
		F->selend = loc;
		_this->FlipSelection(F, F->selbeg, F->selend);
		keysum = ( _Set() );
		do 
		{
			Input::_inst()->Mouse(keys, X, Y);
			keysum = keysum + keys;
			Oberon::_inst()->DrawMouseArrow(X, Y);
			_this->LocateChar(F, X - F->X, Y - F->Y, loc);
			if( loc.pos < F->selbeg.pos )
				loc = F->selbeg;
			
			loc.pos++;
			loc.x = loc.x + loc.dx;
			if( loc.pos < F->selend.pos )
			{
				_this->FlipSelection(F, loc, F->selend);
				F->selend = loc;
			}else if( loc.pos > F->selend.pos )
			{
				_this->FlipSelection(F, F->selend, loc);
				F->selend = loc;
			}
		} while( !( keys == ( _Set() ) ) );
		F->time = Oberon::_inst()->Time();
		F->hasSel = TRUE;
	}
	// END
}

void TextFrames::RemoveSelection(Frame F)
{
	// BEGIN
	TextFrames* _this = _inst();
	if( F->hasSel )
	{
		_this->FlipSelection(F, F->selbeg, F->selend);
		F->hasSel = FALSE;
	}
	// END
}

void TextFrames::TrackLine(Frame F, int X, int Y, int& org_, _Set& keysum)
{
	// VAR
	Location old;
	Location new_;
	_Set keys;

	// BEGIN
	TextFrames* _this = _inst();
	if( F->trailer->next != F->trailer )
	{
		_this->LocateLine(F, Y - F->Y, old);
		_this->ReplConst(Display::_inst()->white, F, F->X + F->left, F->Y + old.y - _this->dsr, old.lin->wid, 2, Display::_inst()->invert);
		keysum = ( _Set() );
		do 
		{
			Input::_inst()->Mouse(keys, X, Y);
			keysum = keysum + keys;
			Oberon::_inst()->DrawMouse(_this->ScrollMarker, X, Y);
			_this->LocateLine(F, Y - F->Y, new_);
			if( new_.org_ != old.org_ )
			{
				_this->ReplConst(Display::_inst()->white, F, F->X + F->left, F->Y + old.y - _this->dsr, old.lin->wid, 2, Display::_inst()->invert);
				_this->ReplConst(Display::_inst()->white, F, F->X + F->left, F->Y + new_.y - _this->dsr, new_.lin->wid, 2, Display::_inst()->invert);
				old = new_;
			}
		} while( !( keys == ( _Set() ) ) );
		_this->ReplConst(Display::_inst()->white, F, F->X + F->left, F->Y + new_.y - _this->dsr, new_.lin->wid, 2, Display::_inst()->invert);
		org_ = new_.org_;
	}else
		/* <---- */
		org_ = 0;

	// END
}

void TextFrames::TrackWord(Frame F, int X, int Y, int& pos, _Set& keysum)
{
	// VAR
	Location old;
	Location new_;
	_Set keys;

	// BEGIN
	TextFrames* _this = _inst();
	if( F->trailer->next != F->trailer )
	{
		_this->LocateString(F, X - F->X, Y - F->Y, old);
		_this->ReplConst(Display::_inst()->white, F, F->X + old.x, F->Y + old.y - _this->dsr, old.dx, 2, Display::_inst()->invert);
		keysum = ( _Set() );
		do 
		{
			Input::_inst()->Mouse(keys, X, Y);
			keysum = keysum + keys;
			Oberon::_inst()->DrawMouseArrow(X, Y);
			_this->LocateString(F, X - F->X, Y - F->Y, new_);
			if( new_.pos != old.pos )
			{
				_this->ReplConst(Display::_inst()->white, F, F->X + old.x, F->Y + old.y - _this->dsr, old.dx, 2, Display::_inst()->invert);
				_this->ReplConst(Display::_inst()->white, F, F->X + new_.x, F->Y + new_.y - _this->dsr, new_.dx, 2, Display::_inst()->invert);
				old = new_;
			}
		} while( !( keys == ( _Set() ) ) );
		_this->ReplConst(Display::_inst()->white, F, F->X + new_.x, F->Y + new_.y - _this->dsr, new_.dx, 2, Display::_inst()->invert);
		pos = new_.pos;
	}else
		/* <---- */
		pos = 0;

	// END
}

void TextFrames::Replace(Frame F, int beg, int end)
{
	// VAR
	Texts::Reader R;
	Line L;
	int org_;
	int len;
	int curY;
	int wid;

	// BEGIN
	TextFrames* _this = _inst();
	if( end > F->org_ )
	{
		if( beg < F->org_ )
			beg = F->org_;
		
		org_ = F->org_;
		L = F->trailer->next;
		curY = F->Y + F->H - F->top - _this->asr;
		while( (L != F->trailer) && (org_ + L->len <= beg) )
		{
			org_ = org_ + L->len;
			L = L->next;
			curY = curY - _this->lsp;
		}
		if( L != F->trailer )
		{
			Texts::_inst()->OpenReader(R, F->text, org_);
			Texts::_inst()->Read(R, _this->nextCh);
			len = beg - org_;
			wid = _this->Width(R, len);
			_this->ReplConst(F->col, F, F->X + F->left + wid, curY - _this->dsr, L->wid - wid, _this->lsp, Display::_inst()->replace);
			_this->DisplayLine(F, L, R, F->X + F->left + wid, curY, len);
			org_ = org_ + L->len;
			L = L->next;
			curY = curY - _this->lsp;
			while( (L != F->trailer) && (org_ <= end) )
			{
				Display::_inst()->ReplConst(F->col, F->X + F->left, curY - _this->dsr, F->W - F->left, _this->lsp, Display::_inst()->replace);
				_this->DisplayLine(F, L, R, F->X + F->left, curY, 0);
				org_ = org_ + L->len;
				L = L->next;
				curY = curY - _this->lsp;
			}
		}
	}
	_this->UpdateMark(F);
	// END
}

void TextFrames::Insert(Frame F, int beg, int end)
{
	// VAR
	Texts::Reader R;
	Line L;
	Line L0;
	Line l;
	int org_;
	int len;
	int curY;
	int botY;
	int Y0;
	int Y1;
	int Y2;
	int dY;
	int wid;

	// BEGIN
	TextFrames* _this = _inst();
	if( beg < F->org_ )
		F->org_ = F->org_ + (end - beg);
	else
	{
		org_ = F->org_;
		L = F->trailer->next;
		curY = F->Y + F->H - F->top - _this->asr;
		while( (L != F->trailer) && (org_ + L->len <= beg) )
		{
			org_ = org_ + L->len;
			L = L->next;
			curY = curY - _this->lsp;
		}
		if( L != F->trailer )
		{
			botY = F->Y + F->bot + _this->dsr;
			Texts::_inst()->OpenReader(R, F->text, org_);
			Texts::_inst()->Read(R, _this->nextCh);
			len = beg - org_;
			wid = _this->Width(R, len);
			_this->ReplConst(F->col, F, F->X + F->left + wid, curY - _this->dsr, L->wid - wid, _this->lsp, Display::_inst()->replace);
			_this->DisplayLine(F, L, R, F->X + F->left + wid, curY, len);
			org_ = org_ + L->len;
			curY = curY - _this->lsp;
			Y0 = curY;
			L0 = L->next;
			while( (org_ <= end) && (curY >= botY) )
			{
				l = new TextFrames::LineDesc();
				Display::_inst()->ReplConst(F->col, F->X + F->left, curY - _this->dsr, F->W - F->left, _this->lsp, Display::_inst()->replace);
				_this->DisplayLine(F, l, R, F->X + F->left, curY, 0);
				L->next = l;
				L = l;
				org_ = org_ + L->len;
				curY = curY - _this->lsp;
			}
			if( L0 != L->next )
			{
				Y1 = curY;
				L->next = L0;
				while( (L->next != F->trailer) && (curY >= botY) )
				{
					L = L->next;
					curY = curY - _this->lsp;
				}
				L->next = F->trailer;
				dY = Y0 - Y1;
				if( Y1 > curY + dY )
				{
					Display::_inst()->CopyBlock(F->X + F->left, curY + dY + _this->lsp - _this->dsr, F->W - F->left, Y1 - curY - dY, F->X + F->left, curY + _this->lsp - _this->dsr, 0);
					Y2 = Y1 - dY;
				}else
					Y2 = curY;

				curY = Y1;
				L = L0;
				while( curY != Y2 )
				{
					Display::_inst()->ReplConst(F->col, F->X + F->left, curY - _this->dsr, F->W - F->left, _this->lsp, Display::_inst()->replace);
					_this->DisplayLine(F, L, R, F->X + F->left, curY, 0);
					L = L->next;
					curY = curY - _this->lsp;
				}
			}
		}
	}
	_this->UpdateMark(F);
	// END
}

void TextFrames::Delete(Frame F, int beg, int end)
{
	// VAR
	Texts::Reader R;
	Line L;
	Line L0;
	Line l;
	int org_;
	int org0_;
	int len;
	int curY;
	int botY;
	int Y0;
	int Y1;
	int wid;

	// BEGIN
	TextFrames* _this = _inst();
	if( end <= F->org_ )
		F->org_ = F->org_ - (end - beg);
	else
	{
		if( beg < F->org_ )
		{
			F->trailer->next->len = F->trailer->next->len + (F->org_ - beg);
			F->org_ = beg;
		}
		org_ = F->org_;
		L = F->trailer->next;
		curY = F->Y + F->H - F->top - _this->asr;
		while( (L != F->trailer) && (org_ + L->len <= beg) )
		{
			org_ = org_ + L->len;
			L = L->next;
			curY = curY - _this->lsp;
		}
		if( L != F->trailer )
		{
			botY = F->Y + F->bot + _this->dsr;
			org0_ = org_;
			L0 = L;
			Y0 = curY;
			while( (L != F->trailer) && (org_ <= end) )
			{
				org_ = org_ + L->len;
				L = L->next;
				curY = curY - _this->lsp;
			}
			Y1 = curY;
			Texts::_inst()->OpenReader(R, F->text, org0_);
			Texts::_inst()->Read(R, _this->nextCh);
			len = beg - org0_;
			wid = _this->Width(R, len);
			_this->ReplConst(F->col, F, F->X + F->left + wid, Y0 - _this->dsr, L0->wid - wid, _this->lsp, Display::_inst()->replace);
			_this->DisplayLine(F, L0, R, F->X + F->left + wid, Y0, len);
			Y0 = Y0 - _this->lsp;
			if( L != L0->next )
			{
				L0->next = L;
				L = L0;
				org_ = org0_ + L0->len;
				while( L->next != F->trailer )
				{
					L = L->next;
					org_ = org_ + L->len;
					curY = curY - _this->lsp;
				}
				Display::_inst()->CopyBlock(F->X + F->left, curY + _this->lsp - _this->dsr, F->W - F->left, Y1 - curY, F->X + F->left, curY + _this->lsp - _this->dsr + (Y0 - Y1), 0);
				curY = curY + (Y0 - Y1);
				Display::_inst()->ReplConst(F->col, F->X + F->left, F->Y, F->W - F->left, curY + _this->lsp - (F->Y + _this->dsr), Display::_inst()->replace);
				Texts::_inst()->OpenReader(R, F->text, org_);
				Texts::_inst()->Read(R, _this->nextCh);
				while( !L->eot && (curY >= botY) )
				{
					l = new TextFrames::LineDesc();
					_this->DisplayLine(F, l, R, F->X + F->left, curY, 0);
					L->next = l;
					L = l;
					curY = curY - _this->lsp;
				}
				L->next = F->trailer;
			}
		}
	}
	_this->UpdateMark(F);
	// END
}

void TextFrames::Recall(Texts::Buffer& B)
{
	// BEGIN
	TextFrames* _this = _inst();
	B = _this->TBuf;
	_this->TBuf = new Texts::BufDesc();
	Texts::_inst()->OpenBuf(_this->TBuf);
	// END
}

/* ------------------message handling------------------------ */
void TextFrames::RemoveMarks(Frame F)
{
	// BEGIN
	TextFrames* _this = _inst();
	_this->RemoveCaret(F);
	_this->RemoveSelection(F);
	// END
}

void TextFrames::NotifyDisplay(Texts::Text T, int op, int beg, int end)
{
	// VAR
	UpdateMsg M;

	// BEGIN
	TextFrames* _this = _inst();
	M.id = op;
	M.text = T;
	M.beg = beg;
	M.end = end;
	Viewers::_inst()->Broadcast(M);
	// END
}

void TextFrames::Call(Frame F, int pos, bool new_)
{
	// VAR
	Texts::Scanner S;
	int res;

	// BEGIN
	TextFrames* _this = _inst();
	Texts::_inst()->OpenScanner(S, F->text, pos);
	Texts::_inst()->Scan(S);
	if( (S.class_ == Texts::_inst()->Name) && (S.line == 0) )
	{
		Oberon::_inst()->SetPar(F, F->text, pos + S.len);
		Oberon::_inst()->Call(S.s, res);
		if( res > 0 )
		{
			Texts::_inst()->WriteString(_this->W, "Call error: ");
			Texts::_inst()->WriteString(_this->W, Modules::_inst()->importing);
			if( res == 1 )
				Texts::_inst()->WriteString(_this->W, " module not found");
			else if( res == 2 )
				Texts::_inst()->WriteString(_this->W, " bad version");
			else if( res == 3 )
			{
				Texts::_inst()->WriteString(_this->W, " imports ");
				Texts::_inst()->WriteString(_this->W, Modules::_inst()->imported);
				Texts::_inst()->WriteString(_this->W, " with bad key");
			}else if( res == 4 )
				Texts::_inst()->WriteString(_this->W, " corrupted obj file");
			else if( res == 5 )
				Texts::_inst()->WriteString(_this->W, " command not found");
			else if( res == 7 )
				Texts::_inst()->WriteString(_this->W, " insufficient space");
			
			Texts::_inst()->WriteLn(_this->W);
			Texts::_inst()->Append(Oberon::_inst()->Log, _this->W.buf);
		}
	}
	// END
}

void TextFrames::Write(Frame F, char ch, Fonts::Font fnt, int col, int voff)
{
	// VAR
	Texts::Buffer buf;

	// BEGIN
	TextFrames* _this = _inst();
	/* F.hasCar */
	/* backspace */
	if( ch == _this->BS )
	{
		if( F->carloc.pos > F->org_ )
		{
			Texts::_inst()->Delete(F->text, F->carloc.pos - 1, F->carloc.pos, _this->DelBuf);
			_this->SetCaret(F, F->carloc.pos - 1);
		}
	}else if( ch == 0x3 )
	{
		/*  ctrl-c  copy */
		if( F->hasSel )
		{
			_this->TBuf = new Texts::BufDesc();
			Texts::_inst()->OpenBuf(_this->TBuf);
			Texts::_inst()->Save(F->text, F->selbeg.pos, F->selend.pos, _this->TBuf);
		}
	}else if( ch == 0x16 )
	{
		/* ctrl-v  paste */
		buf = new Texts::BufDesc();
		Texts::_inst()->OpenBuf(buf);
		Texts::_inst()->Copy(_this->TBuf, buf);
		Texts::_inst()->Insert(F->text, F->carloc.pos, buf);
		_this->SetCaret(F, F->carloc.pos + _this->TBuf->len);
	}else if( ch == 0x18 )
	{
		/* ctrl-x,  cut */
		if( F->hasSel )
		{
			_this->TBuf = new Texts::BufDesc();
			Texts::_inst()->OpenBuf(_this->TBuf);
			Texts::_inst()->Delete(F->text, F->selbeg.pos, F->selend.pos, _this->TBuf);
		}
	}else if( (0x20 <= ch) && (ch <= _this->DEL) || (ch == _this->CR) || (ch == _this->TAB) )
	{
		_this->KW.fnt = fnt;
		_this->KW.col = col;
		_this->KW.voff = voff;
		Texts::_inst()->Write(_this->KW, ch);
		Texts::_inst()->Insert(F->text, F->carloc.pos, _this->KW.buf);
		_this->SetCaret(F, F->carloc.pos + 1);
	}
	// END
}

void TextFrames::Defocus(Frame F)
{
	// BEGIN
	TextFrames* _this = _inst();
	_this->RemoveCaret(F);
	// END
}

void TextFrames::Neutralize(Frame F)
{
	// BEGIN
	TextFrames* _this = _inst();
	_this->RemoveMarks(F);
	// END
}

void TextFrames::Modify(Frame F, int id, int dY, int Y, int H)
{
	// BEGIN
	TextFrames* _this = _inst();
	_this->Mark(F, FALSE);
	_this->RemoveMarks(F);
	_this->SetChangeMark(F, FALSE);
	if( id == MenuViewers::_inst()->extend )
	{
		if( dY > 0 )
		{
			Display::_inst()->CopyBlock(F->X, F->Y, F->W, F->H, F->X, F->Y + dY, 0);
			F->Y = F->Y + dY;
		}
		_this->Extend(F, Y);
	}else if( id == MenuViewers::_inst()->reduce )
	{
		_this->Reduce(F, Y + dY);
		if( dY > 0 )
		{
			Display::_inst()->CopyBlock(F->X, F->Y, F->W, F->H, F->X, Y, 0);
			F->Y = Y;
		}
	}
	if( F->H > 0 )
	{
		_this->Mark(F, TRUE);
		_this->SetChangeMark(F, F->text->changed);
	}
	// END
}

void TextFrames::Open(Frame F, Display::Handler H, Texts::Text T, int org_, int col, int left, int right, int top, int bot, int lsp)
{
	// VAR
	Line L;

	// BEGIN
	TextFrames* _this = _inst();
	L = new TextFrames::LineDesc();
	L->len = 0;
	L->wid = 0;
	L->eot = FALSE;
	L->next = L;
	F->handle = H;
	F->text = T;
	F->org_ = org_;
	F->trailer = L;
	F->left = left;
	F->right = right;
	F->top = top;
	F->bot = bot;
	F->lsp = lsp;
	F->col = col;
	F->hasMark = FALSE;
	F->hasCar = FALSE;
	F->hasSel = FALSE;
	// END
}

void TextFrames::Copy(Frame F, Frame& F1)
{
	// BEGIN
	TextFrames* _this = _inst();
	F1 = new TextFrames::FrameDesc();
	_this->Open(F1, F->handle, F->text, F->org_, F->col, F->left, F->right, F->top, F->bot, F->lsp);
	// END
}

void TextFrames::CopyOver(Frame F, Texts::Text text, int beg, int end)
{
	// VAR
	Texts::Buffer buf;

	// BEGIN
	TextFrames* _this = _inst();
	if( F->hasCar )
	{
		buf = new Texts::BufDesc();
		Texts::_inst()->OpenBuf(buf);
		Texts::_inst()->Save(text, beg, end, buf);
		Texts::_inst()->Insert(F->text, F->carloc.pos, buf);
		_this->SetCaret(F, F->carloc.pos + (end - beg));
	}
	// END
}

void TextFrames::GetSelection(Frame F, Texts::Text& text, int& beg, int& end, int& time)
{
	// BEGIN
	TextFrames* _this = _inst();
	if( F->hasSel )
	{
		if( F->text == text )
		{
			/* leftmost */
			if( F->selbeg.pos < beg )
				beg = F->selbeg.pos;
			
			/* last selected */
			if( F->time > time )
			{
				end = F->selend.pos;
				time = F->time;
			}
		}else if( F->time > time )
		{
			text = F->text;
			beg = F->selbeg.pos;
			end = F->selend.pos;
			time = F->time;
		}
	}
	// END
}

void TextFrames::Update(Frame F, UpdateMsg& M)
{
	// BEGIN
	TextFrames* _this = _inst();
	/* F.text = M.text */
	_this->SetChangeMark(F, FALSE);
	_this->RemoveMarks(F);
	Oberon::_inst()->RemoveMarks(F->X, F->Y, F->W, F->H);
	if( M.id == _this->replace )
		_this->Replace(F, M.beg, M.end);
	else if( M.id == _this->insert )
		_this->Insert(F, M.beg, M.end);
	else if( M.id == _this->delete_ )
		_this->Delete(F, M.beg, M.end);
	
	_this->SetChangeMark(F, F->text->changed);
	// END
}

void TextFrames::Edit(Frame F, int X, int Y, _Set Keys)
{
	// VAR
	CopyOverMsg M;
	Texts::Text text;
	Texts::Buffer buf;
	Viewers::Viewer v;
	int beg;
	int end;
	int time;
	int pos;
	_Set keysum;
	Fonts::Font fnt;
	int col;
	int voff;

	// BEGIN
	TextFrames* _this = _inst();
	/* scroll bar */
	if( X < F->X + _this->Min(F->left, _this->barW) )
	{
		Oberon::_inst()->DrawMouse(_this->ScrollMarker, X, Y);
		keysum = Keys;
		/* ML, scroll up */
		if( Keys == ( _Set() + (2) ) )
		{
			_this->TrackLine(F, X, Y, pos, keysum);
			if( (pos >= 0) && (keysum == ( _Set() + (2) )) )
			{
				_this->SetChangeMark(F, FALSE);
				_this->RemoveMarks(F);
				Oberon::_inst()->RemoveMarks(F->X, F->Y, F->W, F->H);
				_this->Show(F, pos);
			}
		}else if( Keys == ( _Set() + (1) ) )
		{
			/* MM */
			keysum = Keys;
			do 
			{
				Input::_inst()->Mouse(Keys, X, Y);
				keysum = keysum + Keys;
				Oberon::_inst()->DrawMouse(_this->ScrollMarker, X, Y);
			} while( !( Keys == ( _Set() ) ) );
			if( keysum != ( _Set() + (0) + (1) + (2) ) )
			{
				if( keysum.contains( 0 ) )
					pos = 0;
				else if( keysum.contains( 2 ) )
					pos = F->text->len - 100;
				else
					pos = DIV((F->Y + F->H - Y) * (F->text->len),F->H);

				_this->SetChangeMark(F, FALSE);
				_this->RemoveMarks(F);
				Oberon::_inst()->RemoveMarks(F->X, F->Y, F->W, F->H);
				_this->Show(F, pos);
			}
		}else if( Keys == ( _Set() + (0) ) )
		{
			/* MR, scroll down */
			_this->TrackLine(F, X, Y, pos, keysum);
			if( keysum == ( _Set() + (0) ) )
			{
				_this->SetChangeMark(F, FALSE);
				_this->RemoveMarks(F);
				Oberon::_inst()->RemoveMarks(F->X, F->Y, F->W, F->H);
				_this->Show(F, F->org_ * 2 - pos - 100);
			}
		}
	}else
	{
		/* text area */
		Oberon::_inst()->DrawMouseArrow(X, Y);
		/* MR: select */
		if( Keys.contains( 0 ) )
		{
			_this->TrackSelection(F, X, Y, keysum);
			if( F->hasSel )
			{
				/* MR, ML: delete text */
				if( keysum == ( _Set() + (0) + (2) ) )
				{
					Oberon::_inst()->GetSelection(text, beg, end, time);
					Texts::_inst()->Delete(text, beg, end, _this->TBuf);
					Oberon::_inst()->PassFocus(Viewers::_inst()->This(F->X, F->Y));
					_this->SetCaret(F, beg);
				}else if( keysum == ( _Set() + (0) + (1) ) )
				{
					/* MR, MM: copy to caret */
					Oberon::_inst()->GetSelection(text, beg, end, time);
					M.text = text;
					M.beg = beg;
					M.end = end;
					Oberon::_inst()->FocusViewer->handle(Oberon::_inst()->FocusViewer, M);
				}
			}
		}else if( Keys.contains( 1 ) )
		{
			/* MM: call */
			_this->TrackWord(F, X, Y, pos, keysum);
			if( (pos >= 0) && !(keysum.contains( 0 )) )
				_this->Call(F, pos, keysum.contains( 2 ));
			
		}else if( Keys.contains( 2 ) )
		{
			/* ML: set caret */
			Oberon::_inst()->PassFocus(Viewers::_inst()->This(F->X, F->Y));
			_this->TrackCaret(F, X, Y, keysum);
			/* ML, MM: copy from selection to caret */
			if( keysum == ( _Set() + (2) + (1) ) )
			{
				Oberon::_inst()->GetSelection(text, beg, end, time);
				if( time >= 0 )
				{
					_this->TBuf = new Texts::BufDesc();
					Texts::_inst()->OpenBuf(_this->TBuf);
					Texts::_inst()->Save(text, beg, end, _this->TBuf);
					Texts::_inst()->Insert(F->text, F->carloc.pos, _this->TBuf);
					_this->SetSelection(F, F->carloc.pos, F->carloc.pos + (end - beg));
					_this->SetCaret(F, F->carloc.pos + (end - beg));
				}else if( _this->TBuf != 0 )
				{
					buf = new Texts::BufDesc();
					Texts::_inst()->OpenBuf(buf);
					Texts::_inst()->Copy(_this->TBuf, buf);
					Texts::_inst()->Insert(F->text, F->carloc.pos, buf);
					_this->SetCaret(F, F->carloc.pos + buf->len);
				}
			}else if( keysum == ( _Set() + (2) + (0) ) )
			{
				/* ML, MR: copy looks */
				Oberon::_inst()->GetSelection(text, beg, end, time);
				if( time >= 0 )
				{
					Texts::_inst()->Attributes(F->text, F->carloc.pos, fnt, col, voff);
					if( fnt != 0 )
						Texts::_inst()->ChangeLooks(text, beg, end, ( _Set() + (0) + (1) + (2) ), fnt, col, voff);
					
				}
			}
		}
	}
	// END
}

void TextFrames::Handle(Display::Frame F, Display::FrameMsg& M)
{
	// VAR
	Frame F1;
	Texts::Buffer buf;

	// BEGIN
	TextFrames* _this = _inst();
	if( dynamic_cast<>(F) != 0  ){
		if( dynamic_cast<>(M) != 0  ){
			if( M.id == Oberon::_inst()->track )
				_this->Edit(F, M.X, M.Y, M.keys);
			else if( M.id == Oberon::_inst()->consume )
			{
				if( F.hasCar )
					_this->Write(F, M.ch, M.fnt, M.col, M.voff);
				
			}
		} else if( dynamic_cast<>(M) != 0  ){
			if( M.id == Oberon::_inst()->defocus )
				_this->Defocus(F);
			else if( M.id == Oberon::_inst()->neutralize )
				_this->Neutralize(F);
			
		} else if( dynamic_cast<>(M) != 0  ){
			_this->GetSelection(F, M.text, M.beg, M.end, M.time);
		} else if( dynamic_cast<>(M) != 0  ){
			_this->Copy(F, F1);
			M.F = F1;
		} else if( dynamic_cast<>(M) != 0  ){
			_this->Modify(F, M.id, M.dY, M.Y, M.H);
		} else if( dynamic_cast<>(M) != 0  ){
			_this->CopyOver(F, M.text, M.beg, M.end);
		} else if( dynamic_cast<>(M) != 0  ){
			if( F.text == M.text )
				_this->Update(F, M);
			
		} 
	} 
	// END
}

/* creation */
Texts::Text TextFrames::Menu(_ValArray<char> name, _ValArray<char> commands)
{
	// VAR
	Texts::Text T;

	// BEGIN
	TextFrames* _this = _inst();
	T = new Texts::TextDesc();
	T->notify_ = _this->NotifyDisplay;
	Texts::_inst()->Open(T, "");
	Texts::_inst()->WriteString(_this->W, name);
	Texts::_inst()->WriteString(_this->W, " | ");
	Texts::_inst()->WriteString(_this->W, commands);
	Texts::_inst()->Append(T, _this->W.buf);
	return T;
	// END
}

Texts::Text TextFrames::Text(_ValArray<char> name)
{
	// VAR
	Texts::Text T;

	// BEGIN
	TextFrames* _this = _inst();
	T = new Texts::TextDesc();
	T->notify_ = _this->NotifyDisplay;
	Texts::_inst()->Open(T, name);
	return T;
	// END
}

TextFrames::Frame TextFrames::NewMenu(_ValArray<char> name, _ValArray<char> commands)
{
	// VAR
	Frame F;
	Texts::Text T;

	// BEGIN
	TextFrames* _this = _inst();
	F = new TextFrames::FrameDesc();
	T = _this->Menu(name, commands);
	_this->Open(F, _this->Handle, T, 0, Display::_inst()->white, DIV(_this->left,4), 0, 0, 0, _this->lsp);
	return F;
	// END
}

TextFrames::Frame TextFrames::NewText(Texts::Text text, int pos)
{
	// VAR
	Frame F;

	// BEGIN
	TextFrames* _this = _inst();
	F = new TextFrames::FrameDesc();
	_this->Open(F, _this->Handle, text, pos, Display::_inst()->black, _this->left, _this->right, _this->top, _this->bot, _this->lsp);
	return F;
	// END
}

TextFrames::TextFrames()
{
	// BEGIN
	TBuf = new Texts::BufDesc();
	DelBuf = new Texts::BufDesc();
	Texts::_inst()->OpenBuf(TBuf);
	Texts::_inst()->OpenBuf(DelBuf);
	lsp = Fonts::_inst()->Default->height;
	menuH = lsp + 2;
	barW = menuH;
	left = barW + DIV(lsp,2);
	right = DIV(lsp,2);
	top = DIV(lsp,2);
	bot = DIV(lsp,2);
	asr = Fonts::_inst()->Default->maxY;
	dsr = -Fonts::_inst()->Default->minY;
	selH = lsp;
	markW = DIV(lsp,2);
	eolW = DIV(lsp,2);
	ScrollMarker.Fade = FlipSM;
	ScrollMarker.Draw = FlipSM;
	Texts::_inst()->OpenWriter(W);
	Texts::_inst()->OpenWriter(KW);
	// END
}

TextFrames::~TextFrames()
{
	s_inst.release();
}

