#ifndef __ObTextFrames_H__
#define __ObTextFrames_H__

// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:18

#include <OberonSystem/Ob_Global.h>
#include <OberonSystem/ObModules.h>
#include <OberonSystem/ObInput.h>
#include <OberonSystem/ObDisplay.h>
#include <OberonSystem/ObViewers.h>
#include <OberonSystem/ObFonts.h>
#include <OberonSystem/ObTexts.h>
#include <OberonSystem/ObOberon.h>
#include <OberonSystem/ObMenuViewers.h>

namespace Ob
{
	class TextFrames : public _Root
	{
	public:
		/* JG 8.10.90 / NW 10.5.2013 / 11.2.2017 */
		static TextFrames* _inst();
		TextFrames();
		~TextFrames();

		// CONST
		/* message id */
		static const int replace = 0;
		static const int insert = 1;
		static const int delete_ = 2;
		static const int unmark = 3;
		static const char BS = 0x8;
		static const char TAB = 0x9;
		static const char CR = 0x0D;
		static const char DEL = 0x7F;

		// TYPE
		struct LineDesc;
		struct Location;
		struct FrameDesc;
		struct UpdateMsg;
		struct CopyOverMsg;

		typedef LineDesc* Line;
		struct LineDesc : public _Root {
			bool eot;
			int len;
			Line next;
			int wid;
		};
		struct Location : public _Root {
			int dx;
			Line lin;
			int org_;
			int pos;
			int x;
			int y;
		};
		typedef FrameDesc* Frame;
		struct FrameDesc : public Display::FrameDesc {
			int bot;
			Location carloc;
			int col;
			bool hasCar;
			bool hasMark;
			bool hasSel;
			int left;
			int lsp;
			int markH;
			int org_;
			int right;
			Location selbeg;
			Location selend;
			Texts::Text text;
			int time;
			int top;
			Line trailer;
		};
		struct UpdateMsg : public Display::FrameMsg {
			int beg;
			int end;
			int id;
			Texts::Text text;
		};
		struct CopyOverMsg : public Display::FrameMsg {
			int beg;
			int end;
			Texts::Text text;
		};

		// VAR
		Texts::Buffer TBuf;
		Texts::Buffer DelBuf;
		/* standard sizes */
		int menuH;
		int barW;
		int left;
		int right;
		int top;
		int bot;
		int lsp;
		int asr;
		int dsr;
		int selH;
		int markW;
		int eolW;
		char nextCh;
		Oberon::Marker ScrollMarker;
		/* keyboard writer */
		Texts::Writer W;
		Texts::Writer KW;

		// PROC
		int Min(int i, int j);
		static void ReplConst(int col, Frame F, int X, int Y, int W, int H, int mode);
		static void FlipSM(int X, int Y);
		static void UpdateMark(Frame F);
		static void SetChangeMark(Frame F, bool on);
		int Width(Texts::Reader& R, int len);
		static void DisplayLine(Frame F, Line L, Texts::Reader& R, int X, int Y, int len);
		static void Validate(Texts::Text T, int& pos);
		static void Mark(Frame F, bool on);
		static void Restore(Frame F);
		static void Suspend(Frame F);
		static void Extend(Frame F, int newY_);
		static void Reduce(Frame F, int newY_);
		static void Show(Frame F, int pos);
		static void LocateLine(Frame F, int y, Location& loc);
		static void LocateString(Frame F, int x, int y, Location& loc);
		static void LocateChar(Frame F, int x, int y, Location& loc);
		static void LocatePos(Frame F, int pos, Location& loc);
		int Pos(Frame F, int X, int Y);
		static void FlipCaret(Frame F);
		static void SetCaret(Frame F, int pos);
		static void TrackCaret(Frame F, int X, int Y, _Set& keysum);
		static void RemoveCaret(Frame F);
		static void FlipSelection(Frame F, Location& beg, Location& end);
		static void SetSelection(Frame F, int beg, int end);
		static void TrackSelection(Frame F, int X, int Y, _Set& keysum);
		static void RemoveSelection(Frame F);
		static void TrackLine(Frame F, int X, int Y, int& org_, _Set& keysum);
		static void TrackWord(Frame F, int X, int Y, int& pos, _Set& keysum);
		static void Replace(Frame F, int beg, int end);
		static void Insert(Frame F, int beg, int end);
		static void Delete(Frame F, int beg, int end);
		static void Recall(Texts::Buffer& B);
		static void RemoveMarks(Frame F);
		static void NotifyDisplay(Texts::Text T, int op, int beg, int end);
		static void Call(Frame F, int pos, bool new_);
		static void Write(Frame F, char ch, Fonts::Font fnt, int col, int voff);
		static void Defocus(Frame F);
		static void Neutralize(Frame F);
		static void Modify(Frame F, int id, int dY, int Y, int H);
		static void Open(Frame F, Display::Handler H, Texts::Text T, int org_, int col, int left, int right, int top, int bot, int lsp);
		static void Copy(Frame F, Frame& F1);
		static void CopyOver(Frame F, Texts::Text text, int beg, int end);
		static void GetSelection(Frame F, Texts::Text& text, int& beg, int& end, int& time);
		static void Update(Frame F, UpdateMsg& M);
		static void Edit(Frame F, int X, int Y, _Set Keys);
		static void Handle(Display::Frame F, Display::FrameMsg& M);
		Texts::Text Menu(_ValArray<char> name, _ValArray<char> commands);
		Texts::Text Text(_ValArray<char> name);
		Frame NewMenu(_ValArray<char> name, _ValArray<char> commands);
		Frame NewText(Texts::Text text, int pos);

	};
}

#endif // __ObTextFrames_H__