// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:18
#include "ObTexts.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<Texts> s_inst;

const int Texts::Inval;
const int Texts::Name;
const int Texts::String;
const int Texts::Int;
const int Texts::Real;
const int Texts::Char;
const char Texts::TAB;
const char Texts::CR;
const int Texts::maxD;
const char Texts::TextTag;
const int Texts::replace;
const int Texts::insert;
const int Texts::delete_;
const int Texts::unmark;

Texts* Texts::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new Texts() );
	return s_inst.get();
}

/*  -------------------- Filing ------------------------ */
Texts::Piece Texts::Trailer()
{
	// VAR
	Piece Q;

	// BEGIN
	Texts* _this = _inst();
	Q = new Texts::PieceDesc();
	Q->f = _this->TrailerFile;
	Q->off = -1;
	Q->len = 1;
	Q->fnt = 0;
	Q->col = 0;
	Q->voff = 0;
	return Q;
	// END
}

void Texts::Load(Files::Rider& R, Text T)
{
	// VAR
	Piece Q;
	Piece q;
	Piece p;
	int off;
	int N;
	int fno;
	uint8_t bt;
	Files::File f;
	_FxArray<char,32> FName;
	_FxArray<Fonts::Font,32> Dict;

	// BEGIN
	Texts* _this = _inst();
	f = Files::_inst()->Base(R);
	N = 1;
	Q = _this->Trailer();
	p = Q;
	Files::_inst()->ReadInt(R, off);
	Files::_inst()->ReadByte(R, bt);
	fno = bt;
	while( fno != 0 )
	{
		if( fno == N )
		{
			Files::_inst()->ReadString(R, FName);
			Dict[N] = Fonts::_inst()->This(FName);
			N++;
		}
		q = new Texts::PieceDesc();
		q->fnt = Dict[fno];
		Files::_inst()->ReadByte(R, bt);
		q->col = bt;
		Files::_inst()->ReadByte(R, bt);
		q->voff = ASR(LSL(bt, -24), 24);
		Files::_inst()->ReadInt(R, q->len);
		Files::_inst()->ReadByte(R, bt);
		fno = bt;
		q->f = f;
		q->off = off;
		off = off + q->len;
		p->next = q;
		q->prev = p;
		p = q;
	}
	p->next = Q;
	Q->prev = p;
	/* Files.Set(R, f, Files.Pos(R) + T.len) */
	T->trailer = Q;
	Files::_inst()->ReadInt(R, T->len);
	// END
}

void Texts::Open(Text T, _ValArray<char> name)
{
	// VAR
	Files::File f;
	Files::Rider R;
	Piece Q;
	Piece q;
	char tag;
	int len;

	// BEGIN
	Texts* _this = _inst();
	f = Files::_inst()->Old(name);
	if( f != 0 )
	{
		Files::_inst()->Set(R, f, 0);
		Files::_inst()->Read(R, tag);
		if( tag == _this->TextTag )
			_this->Load(R, T);
		else
		{
			/* Ascii file */
			len = Files::_inst()->Length(f);
			Q = _this->Trailer();
			q = new Texts::PieceDesc();
			q->fnt = Fonts::_inst()->Default;
			q->col = 1;
			q->voff = 0;
			q->f = f;
			q->off = 0;
			q->len = len;
			Q->next = q;
			q->prev = Q;
			q->next = Q;
			Q->prev = q;
			T->trailer = Q;
			T->len = len;
		}
	}else
	{
		/* create new text */
		Q = _this->Trailer();
		Q->next = Q;
		Q->prev = Q;
		T->trailer = Q;
		T->len = 0;
	}
	/* init cache */
	T->changed = FALSE;
	T->org_ = -1;
	T->pce = T->trailer;
	// END
}

void Texts::Store(Files::Rider& W, Text T)
{
	// VAR
	Piece p;
	Piece q;
	Files::Rider R;
	int off;
	int rlen;
	int pos;
	int N;
	int n;
	char ch;
	_FxArray<_FxArray<char,32>,32> Dict;

	// BEGIN
	Texts* _this = _inst();
	/* place holder */
	pos = Files::_inst()->Pos(W);
	Files::_inst()->WriteInt(W, 0);
	N = 1;
	p = T->trailer->next;
	while( p != T->trailer )
	{
		rlen = p->len;
		q = p->next;
		while( (q != T->trailer) && (q->fnt == p->fnt) && (q->col == p->col) && (q->voff == p->voff) )
		{
			rlen = rlen + q->len;
			q = q->next;
		}
		Dict[N] = p->fnt->name;
		n = 1;
		while( Dict[n] != p->fnt->name )
			n++;
		
		Files::_inst()->WriteByte(W, n);
		if( n == N )
		{
			Files::_inst()->WriteString(W, p->fnt->name);
			N++;
		}
		Files::_inst()->WriteByte(W, p->col);
		Files::_inst()->WriteByte(W, p->voff);
		Files::_inst()->WriteInt(W, rlen);
		p = q;
	}
	Files::_inst()->WriteByte(W, 0);
	Files::_inst()->WriteInt(W, T->len);
	off = Files::_inst()->Pos(W);
	p = T->trailer->next;
	while( p != T->trailer )
	{
		rlen = p->len;
		Files::_inst()->Set(R, p->f, p->off);
		while( rlen > 0 )
		{
			Files::_inst()->Read(R, ch);
			Files::_inst()->Write(W, ch);
			rlen--;
		}
		p = p->next;
	}
	/* fixup */
	Files::_inst()->Set(W, Files::_inst()->Base(W), pos);
	Files::_inst()->WriteInt(W, off);
	T->changed = FALSE;
	if( T->notify_ != 0 )
		T->notify_(T, _this->unmark, 0, 0);
	
	// END
}

void Texts::Close(Text T, _ValArray<char> name)
{
	// VAR
	Files::File f;
	Files::Rider w;

	// BEGIN
	Texts* _this = _inst();
	f = Files::_inst()->New(name);
	Files::_inst()->Set(w, f, 0);
	Files::_inst()->Write(w, _this->TextTag);
	_this->Store(w, T);
	Files::_inst()->Register(f);
	// END
}

/*  -------------------- Editing -----------------------  */
void Texts::OpenBuf(Buffer B)
{
	// BEGIN
	Texts* _this = _inst();
	/* null piece */
	B->header = new Texts::PieceDesc();
	B->last = B->header;
	B->len = 0;
	// END
}

void Texts::FindPiece(Text T, int pos, int& org_, Piece& pce)
{
	// VAR
	Piece p;
	int porg;

	// BEGIN
	Texts* _this = _inst();
	p = T->pce;
	porg = T->org_;
	if( pos >= porg )
		while( pos >= porg + p->len )
		{
			porg += p->len;
			p = p->next;
		}
	else
	{
		p = p->prev;
		porg -= p->len;
		while( pos < porg )
		{
			p = p->prev;
			porg -= p->len;
		}
	}
	/* update cache */
	T->pce = p;
	T->org_ = porg;
	pce = p;
	org_ = porg;
	// END
}

void Texts::SplitPiece(Piece p, int off, Piece& pr)
{
	// VAR
	Piece q;

	// BEGIN
	Texts* _this = _inst();
	if( off > 0 )
	{
		q = new Texts::PieceDesc();
		q->fnt = p->fnt;
		q->col = p->col;
		q->voff = p->voff;
		q->len = p->len - off;
		q->f = p->f;
		q->off = p->off + off;
		p->len = off;
		q->next = p->next;
		p->next = q;
		q->prev = p;
		q->next->prev = q;
		pr = q;
	}else
		pr = p;

	// END
}

void Texts::Save(Text T, int beg, int end, Buffer B)
{
	// VAR
	Piece p;
	Piece q;
	Piece qb;
	Piece qe;
	int org_;

	// BEGIN
	Texts* _this = _inst();
	if( end > T->len )
		end = T->len;
	
	_this->FindPiece(T, beg, org_, p);
	qb = new Texts::PieceDesc();
	qb = p;
	qb->len = qb->len - (beg - org_);
	qb->off = qb->off + (beg - org_);
	qe = qb;
	while( end > org_ + p->len )
	{
		org_ = org_ + p->len;
		p = p->next;
		q = new Texts::PieceDesc();
		q = p;
		qe->next = q;
		q->prev = qe;
		qe = q;
	}
	qe->next = 0;
	qe->len = qe->len - (org_ + p->len - end);
	B->last->next = qb;
	qb->prev = B->last;
	B->last = qe;
	B->len = B->len + (end - beg);
	// END
}

void Texts::Copy(Buffer SB, Buffer DB)
{
	// VAR
	Piece Q;
	Piece q;
	Piece p;

	// BEGIN
	Texts* _this = _inst();
	p = SB->header;
	Q = DB->last;
	while( p != SB->last )
	{
		p = p->next;
		q = new Texts::PieceDesc();
		q = p;
		Q->next = q;
		q->prev = Q;
		Q = q;
	}
	DB->last = Q;
	DB->len = DB->len + SB->len;
	// END
}

void Texts::Insert(Text T, int pos, Buffer B)
{
	// VAR
	Piece pl;
	Piece pr;
	Piece p;
	Piece qb;
	Piece qe;
	int org_;
	int end;

	// BEGIN
	Texts* _this = _inst();
	_this->FindPiece(T, pos, org_, p);
	_this->SplitPiece(p, pos - org_, pr);
	if( T->org_ >= org_ )
	{
		T->org_ = org_ - p->prev->len;
		T->pce = p->prev;
	}
	pl = pr->prev;
	qb = B->header->next;
	if( (qb != 0) && (qb->f == pl->f) && (qb->off == pl->off + pl->len) && (qb->fnt == pl->fnt) && (qb->col == pl->col) && (qb->voff == pl->voff) )
	{
		pl->len = pl->len + qb->len;
		qb = qb->next;
	}
	if( qb != 0 )
	{
		qe = B->last;
		qb->prev = pl;
		pl->next = qb;
		qe->next = pr;
		pr->prev = qe;
	}
	T->len = T->len + B->len;
	end = pos + B->len;
	B->last = B->header;
	B->last->next = 0;
	B->len = 0;
	T->changed = TRUE;
	T->notify_(T, _this->insert, pos, end);
	// END
}

void Texts::Append(Text T, Buffer B)
{
	// BEGIN
	Texts* _this = _inst();
	_this->Insert(T, T->len, B);
	// END
}

void Texts::Delete(Text T, int beg, int end, Buffer B)
{
	// VAR
	Piece pb;
	Piece pe;
	Piece pbr;
	Piece per;
	int orgb_;
	int orge_;

	// BEGIN
	Texts* _this = _inst();
	if( end > T->len )
		end = T->len;
	
	_this->FindPiece(T, beg, orgb_, pb);
	_this->SplitPiece(pb, beg - orgb_, pbr);
	_this->FindPiece(T, end, orge_, pe);
	_this->SplitPiece(pe, end - orge_, per);
	/* adjust cache */
	if( T->org_ >= orgb_ )
	{
		T->org_ = orgb_ - pb->prev->len;
		T->pce = pb->prev;
	}
	B->header->next = pbr;
	B->last = per->prev;
	B->last->next = 0;
	B->len = end - beg;
	per->prev = pbr->prev;
	pbr->prev->next = per;
	T->len = T->len - B->len;
	T->changed = TRUE;
	T->notify_(T, _this->delete_, beg, end);
	// END
}

void Texts::ChangeLooks(Text T, int beg, int end, _Set sel, Fonts::Font fnt, int col, int voff)
{
	// VAR
	Piece pb;
	Piece pe;
	Piece p;
	int org_;

	// BEGIN
	Texts* _this = _inst();
	if( end > T->len )
		end = T->len;
	
	_this->FindPiece(T, beg, org_, p);
	_this->SplitPiece(p, beg - org_, pb);
	_this->FindPiece(T, end, org_, p);
	_this->SplitPiece(p, end - org_, pe);
	p = pb;
	do 
	{
		if( sel.contains( 0 ) )
			p->fnt = fnt;
		
		if( sel.contains( 1 ) )
			p->col = col;
		
		if( sel.contains( 2 ) )
			p->voff = voff;
		
		p = p->next;
	} while( !( p == pe ) );
	T->changed = TRUE;
	T->notify_(T, _this->replace, beg, end);
	// END
}

void Texts::Attributes(Text T, int pos, Fonts::Font& fnt, int& col, int& voff)
{
	// VAR
	Piece p;
	int org_;

	// BEGIN
	Texts* _this = _inst();
	_this->FindPiece(T, pos, org_, p);
	fnt = p->fnt;
	col = p->col;
	voff = p->voff;
	// END
}

/*  ------------------ Access: Readers -------------------------  */
void Texts::OpenReader(Reader& R, Text T, int pos)
{
	// VAR
	Piece p;
	int org_;

	// BEGIN
	Texts* _this = _inst();
	_this->FindPiece(T, pos, org_, p);
	R.ref = p;
	R.org_ = org_;
	R.off = pos - org_;
	Files::_inst()->Set(R.rider, p->f, p->off + R.off);
	R.eot = FALSE;
	// END
}

void Texts::Read(Reader& R, char& ch)
{
	// BEGIN
	Texts* _this = _inst();
	Files::_inst()->Read(R.rider, ch);
	R.fnt = R.ref->fnt;
	R.col = R.ref->col;
	R.voff = R.ref->voff;
	R.off++;
	if( R.off == R.ref->len )
	{
		if( R.ref->f == _this->TrailerFile )
			R.eot = TRUE;
		
		R.org_ = R.org_ + R.off;
		R.off = 0;
		R.ref = R.ref->next;
		R.org_ = R.org_ + R.off;
		R.off = 0;
		Files::_inst()->Set(R.rider, R.ref->f, R.ref->off);
	}
	// END
}

int Texts::Pos(Reader& R)
{
	// BEGIN
	Texts* _this = _inst();
	return R.org_ + R.off;
	// END
}

/*  ------------------ Access: Scanners (NW) -------------------------  */
void Texts::OpenScanner(Scanner& S, Text T, int pos)
{
	// BEGIN
	Texts* _this = _inst();
	_this->OpenReader(S, T, pos);
	S.line = 0;
	S.nextCh = ' ';
	// END
}

/* floating point formats:
    x = 1.m * 2^(e-127)   bit 0: sign, bits 1- 8: e, bits  9-31: m
    x = 1.m * 2^(e-1023)  bit 0: sign, bits 1-11: e, bits 12-63: m  */
float Texts::Ten(int n)
{
	// VAR
	float t;
	float p;

	// BEGIN
	Texts* _this = _inst();
	/* compute 10^n  */
	t = 1.0;
	p = 10.0;
	while( n > 0 )
	{
		if( n % 2 == 1 )
			t = p * t;
		
		p = p * p;
		n = DIV(n,2);
	}
	return t;
	// END
}

void Texts::Scan(Scanner& S)
{
	// CONST
	/* 2^24 */
	static const int maxExp = 38;
	static const int maxM = 16777216;

	// VAR
	char ch;
	char term;
	bool neg;
	bool negE;
	bool hex;
	int i;
	int j;
	int h;
	int d;
	int e;
	int n;
	int s;
	int k;
	float x;

	// BEGIN
	Texts* _this = _inst();
	ch = S.nextCh;
	i = 0;
	while( !S.eot && (ch <= ' ') )
	{
		if( ch == _this->CR )
			S.line++;
		
		_this->Read(S, ch);
	}
	/* name */
	if( ('A' <= ch) && (ch <= 'Z') || ('a' <= ch) && (ch <= 'z') )
	{
		do 
		{
			S.s[i] = ch;
			i++;
			_this->Read(S, ch);
		} while( !( ((ch < '0') && (ch != '.') || ('9' < ch) && (ch < 'A') || ('Z' < ch) && (ch < 'a') || ('z' < ch)) || (i == 31) ) );
		S.s[i] = 0x0;
		S.len = i;
		S.class_ = _this->Name;
	}else if( ch == 0x22 )
	{
		/* string */
		_this->Read(S, ch);
		while( (ch != 0x22) && (ch >= ' ') && (i != 31) )
		{
			S.s[i] = ch;
			i++;
			_this->Read(S, ch);
		}
		S.s[i] = 0x0;
		S.len = i + 1;
		_this->Read(S, ch);
		S.class_ = _this->String;
	}else
	{
		hex = FALSE;
		if( ch == '-' )
		{
			neg = TRUE;
			_this->Read(S, ch);
		}else
			neg = FALSE;

		/* number */
		if( ('0' <= ch) && (ch <= '9') )
		{
			n = int( ch ) - 0x30;
			h = n;
			_this->Read(S, ch);
			while( ('0' <= ch) && (ch <= '9') || ('A' <= ch) && (ch <= 'F') )
			{
				if( ch <= '9' )
					d = int( ch ) - 0x30;
				else
				{
					d = int( ch ) - 0x37;
					hex = TRUE;
				}
				n = 10 * n + d;
				h = 0x10 * h + d;
				_this->Read(S, ch);
			}
			/* hex integer */
			/* neg? */
			if( ch == 'H' )
			{
				_this->Read(S, ch);
				S.i = h;
				S.class_ = _this->Int;
			}else if( ch == '.' )
			{
				/* real number */
				_this->Read(S, ch);
				x = 0.0;
				e = 0;
				j = 0;
				/* fraction */
				while( ('0' <= ch) && (ch <= '9') )
				{
					h = 10 * n + (int( ch ) - 0x30);
					if( h < maxM )
					{
						n = h;
						j++;
					}
					_this->Read(S, ch);
				}
				/* scale factor */
				if( ch == 'E' )
				{
					s = 0;
					_this->Read(S, ch);
					if( ch == '-' )
					{
						negE = TRUE;
						_this->Read(S, ch);
					}else
					{
						negE = FALSE;
						if( ch == '+' )
							_this->Read(S, ch);
						
					}
					while( ('0' <= ch) && (ch <= '9') )
					{
						s = s * 10 + int( ch ) - 0x30;
						_this->Read(S, ch);
					}
					if( negE )
						e -= s;
					else
						e += s;

				}
				x = FLT(n);
				e -= j;
				if( e < 0 )
				{
					if( e >= -maxExp )
						x = x / _this->Ten(-e);
					else
						x = 0.0;

				}else if( e > 0 )
				{
					if( e <= maxExp )
						x = _this->Ten(e) * x;
					else
						x = 0.0;

				}
				if( neg )
					S.x = -x;
				else
					S.x = x;

				if( hex )
					S.class_ = 0;
				else
					S.class_ = _this->Real;

			}else
			{
				/* decimal integer */
				if( neg )
					S.i = -n;
				else
					S.i = n;

				if( hex )
					S.class_ = _this->Inval;
				else
					S.class_ = _this->Int;

			}
		}else
		{
			/* spectal character */
			S.class_ = _this->Char;
			if( neg )
				S.c = '-';
			else
			{
				S.c = ch;
				_this->Read(S, ch);
			}
		}
	}
	S.nextCh = ch;
	// END
}

/*  --------------- Access: Writers (NW) ------------------  */
void Texts::OpenWriter(Writer& W)
{
	// BEGIN
	Texts* _this = _inst();
	W.buf = new Texts::BufDesc();
	_this->OpenBuf(W.buf);
	W.fnt = Fonts::_inst()->Default;
	W.col = 15;
	W.voff = 0;
	Files::_inst()->Set(W.rider, Files::_inst()->New(""), 0);
	// END
}

void Texts::SetFont(Writer& W, Fonts::Font fnt)
{
	// BEGIN
	Texts* _this = _inst();
	W.fnt = fnt;
	// END
}

void Texts::SetColor(Writer& W, int col)
{
	// BEGIN
	Texts* _this = _inst();
	W.col = col;
	// END
}

void Texts::SetOffset(Writer& W, int voff)
{
	// BEGIN
	Texts* _this = _inst();
	W.voff = voff;
	// END
}

void Texts::Write(Writer& W, char ch)
{
	// VAR
	Piece p;

	// BEGIN
	Texts* _this = _inst();
	if( (W.buf->last->fnt != W.fnt) || (W.buf->last->col != W.col) || (W.buf->last->voff != W.voff) )
	{
		p = new Texts::PieceDesc();
		p->f = Files::_inst()->Base(W.rider);
		p->off = Files::_inst()->Pos(W.rider);
		p->len = 0;
		p->fnt = W.fnt;
		p->col = W.col;
		p->voff = W.voff;
		p->next = 0;
		W.buf->last->next = p;
		p->prev = W.buf->last;
		W.buf->last = p;
	}
	Files::_inst()->Write(W.rider, ch);
	W.buf->last->len++;
	W.buf->len++;
	// END
}

void Texts::WriteLn(Writer& W)
{
	// BEGIN
	Texts* _this = _inst();
	_this->Write(W, _this->CR);
	// END
}

void Texts::WriteString(Writer& W, _ValArray<char> s)
{
	// VAR
	int i;

	// BEGIN
	Texts* _this = _inst();
	i = 0;
	while( s[i] >= ' ' )
	{
		_this->Write(W, s[i]);
		i++;
	}
	// END
}

void Texts::WriteInt(Writer& W, int x, int n)
{
	// VAR
	int i;
	int x0;
	_FxArray<char,10> a;

	// BEGIN
	Texts* _this = _inst();
	if( ROR(x, 31) == 1 )
		_this->WriteString(W, " -2147483648");
	else
	{
		i = 0;
		if( x < 0 )
		{
			n--;
			x0 = -x;
		}else
			x0 = x;

		do 
		{
			a[i] = char( MOD(x0,10) + 0x30 );
			x0 = DIV(x0,10);
			i++;
		} while( !( x0 == 0 ) );
		while( n > i )
		{
			_this->Write(W, ' ');
			n--;
		}
		if( x < 0 )
			_this->Write(W, '-');
		
		do 
		{
			i--;
			_this->Write(W, a[i]);
		} while( !( i == 0 ) );
	}
	// END
}

void Texts::WriteHex(Writer& W, int x)
{
	// VAR
	int i;
	int y;
	_FxArray<char,10> a;

	// BEGIN
	Texts* _this = _inst();
	i = 0;
	_this->Write(W, ' ');
	do 
	{
		y = MOD(x,0x10);
		if( y < 10 )
			a[i] = char( y + 0x30 );
		else
			a[i] = char( y + 0x37 );

		x = DIV(x,0x10);
		i++;
	} while( !( i == 8 ) );
	do 
	{
		i--;
		_this->Write(W, a[i]);
	} while( !( i == 0 ) );
	// END
}

void Texts::WriteReal(Writer& W, float x, int n)
{
	// VAR
	int e;
	int i;
	int m;
	_FxArray<char,16> d;

	// BEGIN
	Texts* _this = _inst();
	/* binary exponent */
	e = MOD(ASR(int( x ), 23),0x100);
	if( e == 0 )
	{
		_this->WriteString(W, "  0 ");
		while( n >= 3 )
		{
			_this->Write(W, ' ');
			n--;
		}
	}else if( e == 255 )
		_this->WriteString(W, " NaN ");
	else
	{
		_this->Write(W, ' ');
		while( n >= 15 )
		{
			n--;
			_this->Write(W, ' ');
		}
		/*  2 < n < 9 digits to be written */
		if( x < 0.0 )
		{
			_this->Write(W, '-');
			x = -x;
		}else
			_this->Write(W, ' ');

		/* decimal exponent */
		e = DIV((e - 127) * 77,256) - 6;
		if( e >= 0 )
			x = x / _this->Ten(e);
		else
			x = _this->Ten(-e) * x;

		m = FLOOR(x + 0.5);
		i = 0;
		if( m >= 10000000 )
		{
			e++;
			m = DIV(m,10);
		}
		do 
		{
			d[i] = char( MOD(m,10) + 0x30 );
			m = DIV(m,10);
			i++;
		} while( !( m == 0 ) );
		i--;
		_this->Write(W, d[i]);
		_this->Write(W, '.');
		if( i < n - 7 )
			n = 0;
		else
			n = 14 - n;

		while( i > n )
		{
			i--;
			_this->Write(W, d[i]);
		}
		_this->Write(W, 'E');
		e += 6;
		if( e < 0 )
		{
			_this->Write(W, '-');
			e = -e;
		}else
			_this->Write(W, '+');

		_this->Write(W, char( DIV(e,10) + 0x30 ));
		_this->Write(W, char( MOD(e,10) + 0x30 ));
	}
	// END
}

void Texts::WriteRealFix(Writer& W, float x, int n, int k)
{
	// VAR
	int i;
	int m;
	bool neg;
	_FxArray<char,12> d;

	// BEGIN
	Texts* _this = _inst();
	if( x == 0.0 )
		_this->WriteString(W, "  0");
	else
	{
		if( x < 0.0 )
		{
			x = -x;
			neg = TRUE;
		}else
			neg = FALSE;

		if( k > 7 )
			k = 7;
		
		x = _this->Ten(k) * x;
		m = FLOOR(x + 0.5);
		i = 0;
		do 
		{
			d[i] = char( MOD(m,10) + 0x30 );
			m = DIV(m,10);
			i++;
		} while( !( m == 0 ) );
		_this->Write(W, ' ');
		while( n > i + 3 )
		{
			_this->Write(W, ' ');
			n--;
		}
		if( neg )
		{
			_this->Write(W, '-');
			n--;
		}else
			_this->Write(W, ' ');

		while( i > k )
		{
			i--;
			_this->Write(W, d[i]);
		}
		_this->Write(W, '.');
		while( k > i )
		{
			k--;
			_this->Write(W, '0');
		}
		while( i > 0 )
		{
			i--;
			_this->Write(W, d[i]);
		}
	}
	// END
}

void Texts::WritePair(Writer& W, char ch, int x)
{
	// BEGIN
	Texts* _this = _inst();
	_this->Write(W, ch);
	_this->Write(W, char( DIV(x,10) + 0x30 ));
	_this->Write(W, char( MOD(x,10) + 0x30 ));
	// END
}

void Texts::WriteClock(Writer& W, int d)
{
	// BEGIN
	Texts* _this = _inst();
	/* day */
	_this->WritePair(W, ' ', MOD(DIV(d,0x20000),0x20));
	/* month */
	_this->WritePair(W, '.', MOD(DIV(d,0x400000),0x10));
	/* year */
	_this->WritePair(W, '.', MOD(DIV(d,0x4000000),0x40));
	/* hour */
	_this->WritePair(W, ' ', MOD(DIV(d,0x1000),0x20));
	/* min */
	_this->WritePair(W, ':', MOD(DIV(d,0x40),0x40));
	/* sec */
	_this->WritePair(W, ':', MOD(d,0x40));
	// END
}

Texts::Texts()
{
	// BEGIN
	TrailerFile = Files::_inst()->New("");
	// END
}

Texts::~Texts()
{
	s_inst.release();
}

