// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:18
#include "ObViewers.h"
#include <memory>
using namespace Ob;

static std::auto_ptr<Viewers> s_inst;

const int Viewers::restore;
const int Viewers::modify;
const int Viewers::suspend;
const int Viewers::inf;

Viewers* Viewers::_inst()
{
	if( s_inst.get() == 0 )
		s_inst.reset( new Viewers() );
	return s_inst.get();
}

/* last closed viewer */
void Viewers::Open(Viewer V, int X, int Y)
{
	// VAR
	Display::Frame T;
	Display::Frame u;
	Display::Frame v;
	ViewerMsg M;

	// BEGIN
	Viewers* _this = _inst();
	if( (V->state == 0) && (X < _this->inf) )
	{
		if( Y > _this->DH )
			Y = _this->DH;
		
		T = _this->FillerTrack->next;
		while( X >= T->X + T->W )
			T = T->next;
		
		u = T->dsc;
		v = u->next;
		while( Y > v->Y + v->H )
		{
			u = v;
			v = u->next;
		}
		if( Y < v->Y + _this->minH )
			Y = v->Y + _this->minH;
		
		if( (v->next->Y != 0) && (Y > v->Y + v->H - _this->minH) )
		{
			V->X = T->X;
			V->W = T->W;
			V->Y = v->Y;
			V->H = v->H;
			M.id = _this->suspend;
			M.state = 0;
			v->handle(v, M);
			v->_to<Viewer>()->state = 0;
			V->next = v->next;
			u->next = V;
			V->state = 2;
		}else
		{
			V->X = T->X;
			V->W = T->W;
			V->Y = v->Y;
			V->H = Y - v->Y;
			M.id = _this->modify;
			M.Y = Y;
			M.H = v->Y + v->H - Y;
			v->handle(v, M);
			v->Y = M.Y;
			v->H = M.H;
			V->next = v;
			u->next = V;
			V->state = 2;
		}
	}
	// END
}

void Viewers::Change(Viewer V, int Y)
{
	// VAR
	Display::Frame v;
	ViewerMsg M;

	// BEGIN
	Viewers* _this = _inst();
	if( V->state > 1 )
	{
		if( Y > _this->DH )
			Y = _this->DH;
		
		v = V->next;
		if( (v->next->Y != 0) && (Y > v->Y + v->H - _this->minH) )
			Y = v->Y + v->H - _this->minH;
		
		if( Y >= V->Y + _this->minH )
		{
			M.id = _this->modify;
			M.Y = Y;
			M.H = v->Y + v->H - Y;
			v->handle(v, M);
			v->Y = M.Y;
			v->H = M.H;
			V->H = Y - V->Y;
		}
	}
	// END
}

void Viewers::RestoreTrack(Display::Frame S)
{
	// VAR
	Display::Frame T;
	Display::Frame t;
	Display::Frame v;
	ViewerMsg M;

	// BEGIN
	Viewers* _this = _inst();
	t = S->next;
	while( t->next != S )
		t = t->next;
	
	T = S->_to<Track>()->under;
	while( T->next != 0 )
		T = T->next;
	
	t->next = S->_to<Track>()->under;
	T->next = S->next;
	M.id = _this->restore;
	do 
	{
		t = t->next;
		v = t->dsc;
		do 
		{
			v = v->next;
			v->handle(v, M);
			v->_to<Viewer>()->state = -v->_to<Viewer>()->state;
		} while( !( v == t->dsc ) );
	} while( !( t == T ) );
	// END
}

void Viewers::Close(Viewer V)
{
	// VAR
	Display::Frame T;
	Display::Frame U;
	ViewerMsg M;

	// BEGIN
	Viewers* _this = _inst();
	if( V->state > 1 )
	{
		U = V->next;
		T = _this->FillerTrack;
		do 
		{
			T = T->next;
		} while( !( V->X < T->X + T->W ) );
		if( (T->_to<Track>()->under == 0) || (U->next != V) )
		{
			M.id = _this->suspend;
			M.state = 0;
			V->handle(V, M);
			V->state = 0;
			_this->backup = V;
			M.id = _this->modify;
			M.Y = V->Y;
			M.H = V->H + U->H;
			U->handle(U, M);
			U->Y = M.Y;
			U->H = M.H;
			while( U->next != V )
				U = U->next;
			
			U->next = V->next;
		}else
		{
			/* close track */
			M.id = _this->suspend;
			M.state = 0;
			V->handle(V, M);
			V->state = 0;
			_this->backup = V;
			U->handle(U, M);
			U->_to<Viewer>()->state = 0;
			_this->RestoreTrack(T);
		}
	}
	// END
}

void Viewers::Recall(Viewer& V)
{
	// BEGIN
	Viewers* _this = _inst();
	V = _this->backup;
	// END
}

Viewers::Viewer Viewers::This(int X, int Y)
{
	// VAR
	Display::Frame T;
	Display::Frame V;

	// BEGIN
	Viewers* _this = _inst();
	if( (X < _this->inf) && (Y < _this->DH) )
	{
		T = _this->FillerTrack;
		do 
		{
			T = T->next;
		} while( !( X < T->X + T->W ) );
		V = T->dsc;
		do 
		{
			V = V->next;
		} while( !( Y < V->Y + V->H ) );
	}else
		V = 0;

	return V->_to<Viewer>();
	// END
}

Viewers::Viewer Viewers::Next(Viewer V)
{
	// BEGIN
	Viewers* _this = _inst();
	return V->next->_to<Viewer>();
	// END
}

void Viewers::Locate(int X, int H, Display::Frame& fil, Display::Frame& bot, Display::Frame& alt, Display::Frame& max)
{
	// VAR
	Display::Frame T;
	Display::Frame V;

	// BEGIN
	Viewers* _this = _inst();
	if( X < _this->inf )
	{
		T = _this->FillerTrack;
		do 
		{
			T = T->next;
		} while( !( X < T->X + T->W ) );
		fil = T->dsc;
		bot = fil->next;
		if( bot->next != fil )
		{
			alt = bot->next;
			V = alt->next;
			while( (V != fil) && (alt->H < H) )
			{
				if( V->H > alt->H )
					alt = V;
				
				V = V->next;
			}
		}else
			alt = bot;

		max = T->dsc;
		V = max->next;
		while( V != fil )
		{
			if( V->H > max->H )
				max = V;
			
			V = V->next;
		}
	}
	// END
}

void Viewers::InitTrack(int W, int H, Viewer Filler)
{
	// VAR
	Display::Frame S;
	Track T;

	// BEGIN
	Viewers* _this = _inst();
	if( Filler->state == 0 )
	{
		Filler->X = _this->curW;
		Filler->W = W;
		Filler->Y = 0;
		Filler->H = H;
		Filler->state = 1;
		Filler->next = Filler;
		T = new Viewers::TrackDesc();
		T->X = _this->curW;
		T->W = W;
		T->Y = 0;
		T->H = H;
		T->dsc = Filler;
		T->under = 0;
		_this->FillerViewer->X = _this->curW + W;
		_this->FillerViewer->W = _this->inf - _this->FillerViewer->X;
		_this->FillerTrack->X = _this->FillerViewer->X;
		_this->FillerTrack->W = _this->FillerViewer->W;
		S = _this->FillerTrack;
		while( S->next != _this->FillerTrack )
			S = S->next;
		
		S->next = T;
		T->next = _this->FillerTrack;
		_this->curW = _this->curW + W;
	}
	// END
}

void Viewers::OpenTrack(int X, int W, Viewer Filler)
{
	// VAR
	Track newT_;
	Display::Frame S;
	Display::Frame T;
	Display::Frame t;
	Display::Frame v;
	ViewerMsg M;
	Viewer v0;

	// BEGIN
	Viewers* _this = _inst();
	if( (X < _this->inf) && (Filler->state == 0) )
	{
		S = _this->FillerTrack;
		T = S->next;
		while( X >= T->X + T->W )
		{
			S = T;
			T = S->next;
		}
		while( X + W > T->X + T->W )
			T = T->next;
		
		M.id = _this->suspend;
		t = S;
		do 
		{
			t = t->next;
			v = t->dsc;
			do 
			{
				v = v->next;
				M.state = -v->_to<Viewer>()->state;
				v->handle(v, M);
				v->_to<Viewer>()->state = M.state;
			} while( !( v == t->dsc ) );
		} while( !( t == T ) );
		Filler->X = S->next->X;
		Filler->W = T->X + T->W - S->next->X;
		Filler->Y = 0;
		Filler->H = _this->DH;
		Filler->state = 1;
		Filler->next = Filler;
		newT_ = new Viewers::TrackDesc();
		newT_->X = Filler->X;
		newT_->W = Filler->W;
		newT_->Y = 0;
		newT_->H = _this->DH;
		newT_->dsc = Filler;
		newT_->under = S->next;
		S->next = newT_;
		newT_->next = T->next;
		T->next = 0;
	}
	// END
}

void Viewers::CloseTrack(int X)
{
	// VAR
	Display::Frame T;
	Display::Frame V;
	ViewerMsg M;

	// BEGIN
	Viewers* _this = _inst();
	if( X < _this->inf )
	{
		T = _this->FillerTrack;
		do 
		{
			T = T->next;
		} while( !( X < T->X + T->W ) );
		if( T->_to<Track>()->under != 0 )
		{
			M.id = _this->suspend;
			M.state = 0;
			V = T->dsc;
			do 
			{
				V = V->next;
				V->handle(V, M);
				V->_to<Viewer>()->state = 0;
			} while( !( V == T->dsc ) );
			_this->RestoreTrack(T);
		}
	}
	// END
}

void Viewers::Broadcast(Display::FrameMsg& M)
{
	// VAR
	Display::Frame T;
	Display::Frame V;

	// BEGIN
	Viewers* _this = _inst();
	T = _this->FillerTrack->next;
	while( T != _this->FillerTrack )
	{
		V = T->dsc;
		do 
		{
			V = V->next;
			V->handle(V, M);
		} while( !( V == T->dsc ) );
		T = T->next;
	}
	// END
}

Viewers::Viewers()
{
	// BEGIN
	backup = 0;
	curW = 0;
	minH = 1;
	DH = Display::_inst()->Height;
	FillerViewer = new ViewerDesc();
	FillerViewer->X = 0;
	FillerViewer->W = inf;
	FillerViewer->Y = 0;
	FillerViewer->H = DH;
	FillerViewer->next = FillerViewer;
	FillerTrack = new TrackDesc();
	FillerTrack->X = 0;
	FillerTrack->W = inf;
	FillerTrack->Y = 0;
	FillerTrack->H = DH;
	FillerTrack->dsc = FillerViewer;
	FillerTrack->next = FillerTrack;
	// END
}

Viewers::~Viewers()
{
	s_inst.release();
}

