#ifndef __ObViewers_H__
#define __ObViewers_H__

// Generated by OberonViewer 0.8.7 on 2024-05-16T00:44:18

#include <OberonSystem/Ob_Global.h>
#include <OberonSystem/ObDisplay.h>

namespace Ob
{
	class Viewers : public _Root
	{
	public:
		/* JG 14.9.90 / NW 15.9.2013 */
		static Viewers* _inst();
		Viewers();
		~Viewers();

		// CONST
		/* message ids */
		static const int restore = 0;
		static const int modify = 1;
		static const int suspend = 2;
		static const int inf = 65535;

		// TYPE
		struct ViewerDesc;
		struct ViewerMsg;
		struct TrackDesc;

		typedef ViewerDesc* Viewer;
		struct ViewerDesc : public Display::FrameDesc {
			int state;
		};
		/* state > 1: displayed; state = 1: filler; state = 0: closed; state < 0: suspended */
		struct ViewerMsg : public Display::FrameMsg {
			int H;
			int W;
			int X;
			int Y;
			int id;
			int state;
		};
		typedef TrackDesc* Track;
		struct TrackDesc : public ViewerDesc {
			Display::Frame under;
		};

		// VAR
		int curW;
		int minH;
		int DH;
		Track FillerTrack;
		Viewer FillerViewer;
		Viewer backup;

		// PROC
		static void Open(Viewer V, int X, int Y);
		static void Change(Viewer V, int Y);
		static void RestoreTrack(Display::Frame S);
		static void Close(Viewer V);
		static void Recall(Viewer& V);
		Viewer This(int X, int Y);
		Viewer Next(Viewer V);
		static void Locate(int X, int H, Display::Frame& fil, Display::Frame& bot, Display::Frame& alt, Display::Frame& max);
		static void InitTrack(int W, int H, Viewer Filler);
		static void OpenTrack(int X, int W, Viewer Filler);
		static void CloseTrack(int X);
		static void Broadcast(Display::FrameMsg& M);

	};
}

#endif // __ObViewers_H__