(** ARM Semihost. Import to replace runtime functions *)
MODULE Semihost;

IMPORT SYSTEM;

CONST
    (* Semihost functions: https://github.com/ARM-software/abi-aa/blob/main/semihosting/semihosting.rst *)
    SYS_EXIT = 018H;
    SYS_READC = 07H;
    SYS_WRITEC = 03H;
    ADP_Stopped_ApplicationExit = 20026H;
       
TYPE
    ADDRESS = SYSTEM.ADDRESS;

PROCEDURE SemiHost(op : INTEGER; arg : ADDRESS): INTEGER;
VAR ret : INTEGER;
BEGIN
    SYSTEM.ASM("
        mov     r2, r11
        ldr  	r0, [r2, op]
        ldr     r1, [r2, arg]
        bkpt    0xab
        str	    r0, [r2, ret]
    ");
    RETURN ret
END SemiHost;

(* Replace abort function in runtime *)
PROCEDURE Abort ["abort"] ();
VAR args : ARRAY 1 OF ADDRESS;
BEGIN
    args[0] := ADP_Stopped_ApplicationExit;
    IGNORE(SemiHost(SYS_EXIT, SYSTEM.ADR(args)));
END Abort;

(* Replace putchar function in runtime *)
PROCEDURE PutChar ["putchar"] (character: INTEGER): INTEGER;
VAR args : ARRAY 1 OF ADDRESS;
BEGIN
    args[0] := character;
    IGNORE(SemiHost(SYS_WRITEC, SYSTEM.ADR(args)));
    RETURN character
END PutChar;

(* Replace getchar function in runtime *)
PROCEDURE Getchar ["getchar"] (): INTEGER;
VAR args : ARRAY 1 OF ADDRESS;
BEGIN
    args[0] := 0;
    RETURN SemiHost(SYS_READC, SYSTEM.ADR(args))
END Getchar;

END Semihost.