MODULE UI IN Ext;

IMPORT SYSTEM;

CONST
    ForEachContinue* 		        = 0;
    ForEachStop*                    = 1;
    AlignFill*                      = 0;
	AlignStart*                     = 1;
	AlignCenter*                    = 2;
	AlignEnd*                       = 3;
    AtLeading*                      = 0;
	AtTop*                          = 1;
	AtTrailing*                     = 2;
	AtBottom*                       = 3;
    WindowResizeEdgeLeft*           = 0;
	WindowResizeEdgeTop*            = 1;
	WindowResizeEdgeRight*          = 2;
	WindowResizeEdgeBottom*         = 3;
	WindowResizeEdgeTopLeft*        = 4;
	WindowResizeEdgeTopRight*       = 5;
	WindowResizeEdgeBottomLeft*     = 6;
	WindowResizeEdgeBottomRight*    = 7;
    DrawBrushTypeSolid*             = 0;
	DrawBrushTypeLinearGradient*    = 1;
	DrawBrushTypeRadialGradient*    = 2;
	DrawBrushTypeImage*             = 3;
    DrawLineCapFlat*                = 0;
	DrawLineCapRound*               = 1;
	DrawLineCapSquare*              = 2;
    DrawLineJoinMiter*              = 0;
	DrawLineJoinRound*              = 1;
	DrawLineJoinBevel*              = 2;
    DrawFillModeWinding*            = 0;
	DrawFillModeAlternate*          = 1;
    TableValueTypeString*           = 0;
	TableValueTypeImage*            = 1;
	TableValueTypeInt*              = 2;
	TableValueTypeColor*            = 3;
    TableModelColumnNeverEditable*  = -1;
    TableModelColumnAlwaysEditable* = -2;
    TableSelectionModeNone*         = 0;
    TableSelectionModeZeroOrOne*    = 1;
    TableSelectionModeOne*          = 3;
    TableSelectionModeZeroOrMany*   = 4;
    SortIndicatorNone*              = 0;
	SortIndicatorAscending*         = 1;
	SortIndicatorDescending*        = 2;

TYPE
    ADDRESS = SYSTEM.ADDRESS;
    SIZE_T = LENGTH;
    InitOptions* = RECORD-
        size* : SIZE_T;
    END;

    App* = RECORD opts: InitOptions END;
    Control* = RECORD ptr: ADDRESS END;
    Window* = RECORD (Control) END;
    Button* = RECORD (Control) END;

(* Function types *)
PROCEDURE ^ uiInit ["uiInit"] (opts: POINTER TO VAR InitOptions): ADDRESS;
PROCEDURE ^ uiUninit ["uiUninit"] (): ADDRESS;
PROCEDURE ^ uiFreeInitError ["uiFreeInitError"] (err: ADDRESS);
PROCEDURE ^ uiMain ["uiMain"] ();
PROCEDURE ^ uiQuit ["uiQuit"] ();
PROCEDURE ^ uiFreeText ["uiFreeText"] (text: ADDRESS);
(* Control *)
PROCEDURE ^ uiControlDestroy ["uiControlDestroy"] (c: ADDRESS);
PROCEDURE ^ uiControlToplevel ["uiControlToplevel"] (c: ADDRESS): INTEGER;
PROCEDURE ^ uiControlVisible ["uiControlVisible"] (c: ADDRESS): INTEGER;
PROCEDURE ^ uiControlShow ["uiControlShow"] (c: ADDRESS);
PROCEDURE ^ uiControlHide ["uiControlHide"] (c: ADDRESS);
PROCEDURE ^ uiControlEnabled ["uiControlEnabled"] (c: ADDRESS): INTEGER;
PROCEDURE ^ uiControlEnable ["uiControlEnable"] (c: ADDRESS);
PROCEDURE ^ uiControlDisable ["uiControlDisable"] (c: ADDRESS);
(* Window *)
PROCEDURE ^ uiNewWindow ["uiNewWindow"] (title: ADDRESS; width, height, hasMenubar: INTEGER): ADDRESS;
PROCEDURE ^ uiWindowSetChild ["uiWindowSetChild"] (w: ADDRESS; child: ADDRESS);
(* Button *)
PROCEDURE ^ uiNewButton ["uiNewButton"] (text: ADDRESS): ADDRESS;
PROCEDURE ^ uiButtonOnClicked ["uiButtonOnClicked"] (w: ADDRESS; callback, data: ADDRESS);
(* Standard Dialogs *)
PROCEDURE ^ uiOpenFile ["uiOpenFile"] (w: ADDRESS): ADDRESS;
PROCEDURE ^ uiOpenFolder ["uiOpenFolder"] (w: ADDRESS): ADDRESS;
PROCEDURE ^ uiSaveFile ["uiSaveFile"] (w: ADDRESS): ADDRESS;
PROCEDURE ^ uiMsgBox ["uiMsgBox"] (w: ADDRESS; title, description: POINTER TO VAR- CHAR);
PROCEDURE ^ uiMsgBoxError ["uiMsgBoxError"] (w: ADDRESS; title, description: POINTER TO VAR- CHAR);

(** Signal Quit to application *)
PROCEDURE Quit*();
BEGIN uiQuit() END Quit;

(*
   App
*)

(** Start main loop *)
PROCEDURE (VAR this : App) Main*();
BEGIN uiMain()
END Main;

(** Deallocate resources *)
PROCEDURE (VAR this : App) Destroy*();
BEGIN IGNORE(uiUninit());
END Destroy;

(** Initialize App *)
PROCEDURE InitApp*(VAR this : App);
VAR  err : ADDRESS;
BEGIN
    this.opts.size := 0;
    err := uiInit(PTR(this.opts));
    IF err # 0 THEN uiFreeInitError(err) END
END InitApp;

(*
-  Control base class
*)

(** Dispose Control and all allocated resources *)
PROCEDURE (VAR this : Control) Destroy*();
BEGIN uiControlDestroy(this.ptr);
END Destroy;

(** Returns TRUE if control is a top level control.*)
PROCEDURE (VAR this : Control) IsTopLevel*(): BOOLEAN;
BEGIN RETURN uiControlToplevel(this.ptr) # 0;
END IsTopLevel;

(** Returns TRUE if control is visible *)
PROCEDURE (VAR this : Control) IsVisible*(): BOOLEAN;
BEGIN RETURN uiControlVisible(this.ptr) # 0;
END IsVisible;

(** Shows the control *)
PROCEDURE (VAR this : Control) Show*();
BEGIN uiControlShow(this.ptr);
END Show;

(** Hides the control *)
PROCEDURE (VAR this : Control) Hide*();
BEGIN uiControlHide(this.ptr);
END Hide;

(** Returns TRUE if the control is enabled *)
PROCEDURE (VAR this : Control) IsEnabled*(): BOOLEAN;
BEGIN RETURN uiControlEnabled(this.ptr) # 0;
END IsEnabled;

(** Enable control *)
PROCEDURE (VAR this : Control) Enable*();
BEGIN uiControlEnable(this.ptr);
END Enable;

(** Disable control *)
PROCEDURE (VAR this : Control) Disable*();
BEGIN uiControlDisable(this.ptr);
END Disable;

(*
   Window
*)

(** Set child control *)
PROCEDURE (VAR this : Window) SetChild*(child- : Control);
BEGIN
    uiWindowSetChild(this.ptr, child.ptr);
    uiControlShow(this.ptr);
END SetChild;

(** Initialize Window *)
PROCEDURE InitWindow*(VAR w : Window; title- : ARRAY OF CHAR; width, height : INTEGER; hasMenubar : BOOLEAN);
BEGIN
    w.ptr := uiNewWindow(SYSTEM.ADR(title[0]), width, height, INTEGER(hasMenubar));
END InitWindow;

(*
   Button
*)

(** Initialize Button *)
PROCEDURE InitButton*(VAR b : Button; text- : ARRAY OF CHAR);
VAR ret : ADDRESS;
BEGIN
    ret := uiNewButton(SYSTEM.ADR(text[0]));
    b.ptr := ret;
END InitButton;

END UI.